/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion;

import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.InversionState;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.CompletionCriteria;

public class IterationsPerVariableCompletionCriteria
implements CompletionCriteria.EstimationCompletionCriteria {
    private double itersPerVariable;
    private transient long offset = 0L;

    public IterationsPerVariableCompletionCriteria(double itersPerVariable) {
        this(itersPerVariable, 0L);
    }

    public IterationsPerVariableCompletionCriteria(double itersPerVariable, long offset) {
        this.itersPerVariable = itersPerVariable;
        this.offset = offset;
    }

    public double getItersPerVariable() {
        return this.itersPerVariable;
    }

    @Override
    public boolean isSatisfied(InversionState state) {
        long iters = state.iterations - this.offset;
        double itersPer = (double)iters / (double)state.bestSolution.length;
        return itersPer >= this.itersPerVariable;
    }

    public String toString() {
        return "IterationsPerVariableCompletionCriteria(itersPerVar: " + (float)this.itersPerVariable + ")";
    }

    @Override
    public double estimateFractCompleted(InversionState state) {
        long iters = state.iterations - this.offset;
        double itersPer = (double)iters / (double)state.bestSolution.length;
        return Math.min(1.0, itersPer / this.itersPerVariable);
    }
}

