/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion;

import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.ConstraintWeightingType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ConstraintRange;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.InversionState;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.CompletionCriteria;

public class MisfitStdDevCompletionCriteria
implements CompletionCriteria {
    private ConstraintWeightingType weightingType;
    private double targetStdDev;
    private static boolean D = true;

    public MisfitStdDevCompletionCriteria(double targetStdDev) {
        this(null, targetStdDev);
    }

    public MisfitStdDevCompletionCriteria(ConstraintWeightingType weightingType, double targetStdDev) {
        this.weightingType = weightingType;
        this.targetStdDev = targetStdDev;
    }

    @Override
    public boolean isSatisfied(InversionState state) {
        if (D) {
            System.out.println("Evaluating Misfit Std. Dev. criteria, target=" + (float)this.targetStdDev + ", type=" + String.valueOf((Object)this.weightingType));
        }
        boolean pass = true;
        for (int c = 0; c < state.constraintRanges.size(); ++c) {
            ConstraintRange range = state.constraintRanges.get(c);
            if (this.weightingType != null && range.weightingType != this.weightingType) continue;
            double e = state.energy[c + 4];
            if (range.weight != 1.0) {
                e /= range.weight * range.weight;
            }
            double stdDev = Math.sqrt(e / (double)(range.endRow - range.startRow));
            if (D) {
                System.out.println("\t" + range.shortName + "\tE=" + (float)state.energy[c + 4] + "\tunWtE=" + (float)e + "\tstdDev=" + (float)stdDev);
            }
            if (!(stdDev > this.targetStdDev)) continue;
            if (!D) {
                return false;
            }
            pass = false;
        }
        return pass;
    }

    public String toString() {
        return "MisfitStdDev=" + (float)this.targetStdDev;
    }
}

