/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.primitives.Doubles;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.util.modules.ModuleHelper;
import org.opensha.commons.util.modules.helpers.FileBackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchModuleBuilder;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

@ModuleHelper
abstract class AbstractBranchMFDs
implements FileBackedModule {
    IncrementalMagFreqDist refMFD;
    float[][][] branchSectMFDs;
    short[][] branchSectMinMagIndexes;
    double[] weights;
    BiMap<Integer, Integer> parentIDtoIndexMap;
    private static final DecimalFormat rateDF = new DecimalFormat("0.###E0");

    AbstractBranchMFDs() {
    }

    /*
     * WARNING - void declaration
     */
    static void combine(AbstractBranchMFDs ret, List<? extends AbstractBranchMFDs> mfdsList, List<Double> weightsList) {
        void var7_9;
        double sumWeight;
        Preconditions.checkState((mfdsList.size() > 1 ? 1 : 0) != 0);
        if (weightsList == null) {
            void var7_6;
            double weightEach = 1.0 / (double)mfdsList.size();
            weightsList = new ArrayList<Double>(mfdsList.size());
            boolean bl = false;
            while (var7_6 < mfdsList.size()) {
                weightsList.add(weightEach);
                ++var7_6;
            }
            sumWeight = 1.0;
        } else {
            Preconditions.checkState((mfdsList.size() == weightsList.size() ? 1 : 0) != 0);
            sumWeight = weightsList.stream().mapToDouble(D -> D).sum();
        }
        int numCombBranches = 0;
        for (AbstractBranchMFDs abstractBranchMFDs : mfdsList) {
            numCombBranches += abstractBranchMFDs.weights.length;
        }
        AbstractBranchMFDs ref = mfdsList.get(0);
        boolean bl = true;
        while (var7_9 < mfdsList.size()) {
            IncrementalMagFreqDist refMFD = mfdsList.get((int)var7_9).refMFD;
            Preconditions.checkState((ref.refMFD.getMinX() == refMFD.getMinX() ? 1 : 0) != 0);
            Preconditions.checkState((ref.refMFD.size() == refMFD.size() ? 1 : 0) != 0);
            ++var7_9;
        }
        ret.refMFD = ref.refMFD;
        ret.branchSectMFDs = new float[numCombBranches][][];
        ret.branchSectMinMagIndexes = new short[numCombBranches][];
        boolean bl2 = false;
        for (int r = 0; r < mfdsList.size(); ++r) {
            double myWeight = weightsList.get(r) / sumWeight;
            AbstractBranchMFDs mfds = mfdsList.get(r);
            for (int i2 = 0; i2 < mfds.weights.length; ++i2) {
                void var7_11;
                ret.weights[var7_11] = mfds.weights[i2] * myWeight;
                ret.branchSectMFDs[var7_11] = mfds.branchSectMFDs[i2];
                ret.branchSectMinMagIndexes[var7_11] = mfds.branchSectMinMagIndexes[i2];
                ++var7_11;
            }
        }
    }

    @Override
    public void writeToStream(OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        int numBranches = this.branchSectMFDs.length;
        int numSections = this.branchSectMFDs[0].length;
        CSVFile.writeLine((Writer)writer, new String[]{"Num Branches", "Num Sections"});
        CSVFile.writeLine((Writer)writer, new String[]{"" + numBranches, "" + numSections});
        CSVFile.writeLine((Writer)writer, new String[]{"Magnitudes"});
        ArrayList<CallSite> xValsHeader = new ArrayList<CallSite>(this.refMFD.size());
        for (int i = 0; i < this.refMFD.size(); ++i) {
            xValsHeader.add((CallSite)((Object)("" + (float)this.refMFD.getX(i))));
        }
        CSVFile.writeLine((Writer)writer, xValsHeader);
        Object[] commonBranchHeader = new String[]{"Branch Index", "Branch Weight"};
        String indexHeader = this.isParentSections() ? "Parent Section ID" : "Section Index";
        Object[] commonMFDHeader = new String[]{indexHeader, "Min Mag Index", "Rate1", "Rate2", "...", "RateN"};
        for (int b = 0; b < numBranches; ++b) {
            CSVFile.writeLine((Writer)writer, commonBranchHeader);
            CSVFile.writeLine((Writer)writer, new String[]{"" + b, "" + this.weights[b]});
            CSVFile.writeLine((Writer)writer, commonMFDHeader);
            Preconditions.checkState((this.branchSectMFDs[b].length == numSections ? 1 : 0) != 0);
            for (int s = 0; s < numSections; ++s) {
                int sectID;
                float[] mfdVals = this.branchSectMFDs[b][s];
                short minMagIndex = this.branchSectMinMagIndexes[b][s];
                int n = sectID = this.isParentSections() ? (Integer)this.parentIDtoIndexMap.inverse().get((Object)s) : s;
                if (mfdVals == null || mfdVals.length == 0) {
                    CSVFile.writeLine((Writer)writer, new String[]{"" + sectID, "-1"});
                    continue;
                }
                Object[] line = new String[2 + mfdVals.length];
                int cnt = 0;
                line[cnt++] = "" + sectID;
                line[cnt++] = "" + minMagIndex;
                for (int i = 0; i < mfdVals.length; ++i) {
                    line[cnt++] = mfdVals[i] == 0.0f ? "0" : rateDF.format(mfdVals[i]);
                }
                CSVFile.writeLine((Writer)writer, line);
            }
        }
        writer.flush();
    }

    @Override
    public void initFromStream(BufferedInputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        reader.readLine();
        List<String> countsLine = CSVFile.loadLine(reader.readLine());
        Preconditions.checkState((countsLine.size() == 2 ? 1 : 0) != 0);
        int numBranches = Integer.parseInt(countsLine.get(0));
        int numSects = Integer.parseInt(countsLine.get(1));
        reader.readLine();
        List<String> magStrs = CSVFile.loadLine(reader.readLine());
        this.refMFD = new IncrementalMagFreqDist(Double.parseDouble(magStrs.get(0)), Double.parseDouble(magStrs.get(magStrs.size() - 1)), magStrs.size());
        this.branchSectMFDs = new float[numBranches][numSects][];
        this.branchSectMinMagIndexes = new short[numBranches][numSects];
        this.weights = new double[numBranches];
        boolean parents = this.isParentSections();
        if (parents) {
            this.parentIDtoIndexMap = HashBiMap.create((int)numSects);
        }
        for (int b = 0; b < numBranches; ++b) {
            reader.readLine();
            List<String> weightLine = CSVFile.loadLine(reader.readLine());
            Preconditions.checkState((weightLine.size() == 2 ? 1 : 0) != 0);
            Preconditions.checkState((b == Integer.parseInt(weightLine.get(0)) ? 1 : 0) != 0);
            this.weights[b] = Double.parseDouble(weightLine.get(1));
            reader.readLine();
            for (int s = 0; s < numSects; ++s) {
                List<String> mfdLine = CSVFile.loadLine(reader.readLine());
                if (parents) {
                    int parentID = Integer.parseInt(mfdLine.get(0));
                    if (this.parentIDtoIndexMap.containsKey((Object)parentID)) {
                        Preconditions.checkState((s == (Integer)this.parentIDtoIndexMap.get((Object)parentID) ? 1 : 0) != 0);
                    } else {
                        this.parentIDtoIndexMap.put((Object)parentID, (Object)s);
                    }
                } else {
                    Preconditions.checkState((s == Integer.parseInt(mfdLine.get(0)) ? 1 : 0) != 0);
                }
                Preconditions.checkState((mfdLine.size() >= 2 && mfdLine.size() <= 2 + this.refMFD.size() ? 1 : 0) != 0);
                this.branchSectMinMagIndexes[b][s] = Short.parseShort(mfdLine.get(1));
                this.branchSectMFDs[b][s] = new float[mfdLine.size() - 2];
                for (int i = 2; i < mfdLine.size(); ++i) {
                    this.branchSectMFDs[b][s][i - 2] = Float.parseFloat(mfdLine.get(i));
                }
            }
        }
    }

    public abstract boolean isParentSections();

    public int getNumBranches() {
        return this.weights.length;
    }

    public double getBranchWeight(int branchIndex) {
        return this.weights[branchIndex];
    }

    public IncrementalMagFreqDist getSectionMFD(int branchIndex, int sectIndex) {
        if (this.isParentSections()) {
            sectIndex = (Integer)this.parentIDtoIndexMap.get((Object)sectIndex);
        }
        IncrementalMagFreqDist ret = new IncrementalMagFreqDist(this.refMFD.getMinX(), this.refMFD.size(), this.refMFD.getDelta());
        float[] vals = this.branchSectMFDs[branchIndex][sectIndex];
        if (vals == null) {
            return ret;
        }
        for (int i = 0; i < vals.length; ++i) {
            if (!(vals[i] > 0.0f)) continue;
            ret.set(i + this.branchSectMinMagIndexes[branchIndex][sectIndex], (double)vals[i]);
        }
        return ret;
    }

    static class SingleBranchMFDs {
        private short[] sectMinMagIndexes;
        private float[][] sectMFDs;
        private int branchMinIndex;
        private int branchMaxIndex;

        public SingleBranchMFDs(short[] sectMinMagIndexes, float[][] sectMFDs, int branchMinIndex, int branchMaxIndex) {
            this.sectMinMagIndexes = sectMinMagIndexes;
            this.sectMFDs = sectMFDs;
            this.branchMinIndex = branchMinIndex;
            this.branchMaxIndex = branchMaxIndex;
        }

        public SingleBranchMFDs(SingleBranchMFDs branchMFDs) {
            this.sectMinMagIndexes = branchMFDs.sectMinMagIndexes;
            this.sectMFDs = branchMFDs.sectMFDs;
            this.branchMinIndex = branchMFDs.branchMinIndex;
            this.branchMaxIndex = branchMFDs.branchMaxIndex;
        }
    }

    static abstract class Builder<E extends AbstractBranchMFDs>
    implements BranchModuleBuilder<FaultSystemSolution, E> {
        private static final EvenlyDiscretizedFunc refMFD = new EvenlyDiscretizedFunc(0.05, 120, 0.1);
        private static final double refMinMag = refMFD.getX(0) - 0.5 * refMFD.getDelta();
        private static final double refMaxMag = refMFD.getX(refMFD.size() - 1) + 0.5 * refMFD.getDelta();
        private List<float[][]> branchSectMFDs;
        private List<short[]> branchSectMinMagIndexes;
        private List<Double> weights;
        private int minMagIndex = Integer.MAX_VALUE;
        private int maxMagIndex = 0;
        private boolean parents;
        private List<Integer> parentIDs;

        Builder() {
        }

        protected abstract SingleBranchMFDs getCachedMFDs(FaultSystemSolution var1);

        protected abstract void cacheMFDs(FaultSystemSolution var1, SingleBranchMFDs var2);

        protected abstract IncrementalMagFreqDist calcBranchSectMFD(FaultSystemSolution var1, int var2, EvenlyDiscretizedFunc var3);

        @Override
        public synchronized void process(FaultSystemSolution sol, LogicTreeBranch<?> branch, double weight) {
            int numSects;
            if (this.branchSectMFDs == null) {
                this.branchSectMFDs = new ArrayList<float[][]>();
                this.branchSectMinMagIndexes = new ArrayList<short[]>();
                this.weights = new ArrayList<Double>();
                this.parents = ((AbstractBranchMFDs)this.init()).isParentSections();
                if (this.parents) {
                    this.parentIDs = new ArrayList<Integer>();
                    HashSet<Integer> prevParents = new HashSet<Integer>();
                    for (FaultSection faultSection : sol.getRupSet().getFaultSectionDataList()) {
                        int parentID = faultSection.getParentSectionId();
                        Preconditions.checkState((parentID >= 0 ? 1 : 0) != 0);
                        if (prevParents.contains(parentID)) continue;
                        this.parentIDs.add(parentID);
                        prevParents.add(parentID);
                    }
                    Preconditions.checkState((!this.parentIDs.isEmpty() ? 1 : 0) != 0);
                    numSects = this.parentIDs.size();
                } else {
                    numSects = sol.getRupSet().getNumSections();
                }
            } else if (this.parents) {
                numSects = this.branchSectMFDs.get(0).length;
            } else {
                numSects = sol.getRupSet().getNumSections();
                Preconditions.checkState((numSects == this.branchSectMFDs.get(0).length ? 1 : 0) != 0);
            }
            SingleBranchMFDs branchMFDs = this.getCachedMFDs(sol);
            if (branchMFDs == null) {
                double branchMinMag = sol.getRupSet().getMinMag();
                double branchMaxMag = sol.getRupSet().getMaxMag();
                Preconditions.checkState((branchMinMag >= refMinMag ? 1 : 0) != 0, (String)"Branch has extreme magnitudes outside of reference range: min=%s, refRange=[%s,%s]", (Object)branchMinMag, (Object)refMinMag, (Object)refMaxMag);
                Preconditions.checkState((branchMaxMag <= refMaxMag ? 1 : 0) != 0, (String)"Branch has extreme magnitudes outside of reference range: max=%s, refRange=[%s,%s]", (Object)branchMaxMag, (Object)refMinMag, (Object)refMaxMag);
                float[][] sectMFDs = new float[numSects][];
                short[] minMagIndexes = new short[numSects];
                int branchMinIndex = Integer.MAX_VALUE;
                int branchMaxIndex = 0;
                for (int sectIndex = 0; sectIndex < numSects; ++sectIndex) {
                    int i;
                    int sectID = this.parents ? this.parentIDs.get(sectIndex) : sectIndex;
                    IncrementalMagFreqDist mfd = this.calcBranchSectMFD(sol, sectID, refMFD);
                    int myMinIndex = Integer.MAX_VALUE;
                    int myMaxIndex = 0;
                    for (i = 0; i < refMFD.size(); ++i) {
                        if (!(mfd.getY(i) > 0.0)) continue;
                        myMinIndex = Integer.min(myMinIndex, i);
                        myMaxIndex = Integer.max(myMaxIndex, i);
                    }
                    if (myMinIndex > myMaxIndex) continue;
                    sectMFDs[sectIndex] = new float[1 + myMaxIndex - myMinIndex];
                    for (i = 0; i < sectMFDs[sectIndex].length; ++i) {
                        sectMFDs[sectIndex][i] = (float)mfd.getY(i + myMinIndex);
                    }
                    minMagIndexes[sectIndex] = (short)myMinIndex;
                    branchMinIndex = Integer.min(branchMinIndex, myMinIndex);
                    branchMaxIndex = Integer.max(branchMaxIndex, myMaxIndex);
                }
                this.minMagIndex = Integer.min(this.minMagIndex, branchMinIndex);
                this.maxMagIndex = Integer.max(this.maxMagIndex, branchMaxIndex);
                branchMFDs = new SingleBranchMFDs(minMagIndexes, sectMFDs, branchMinIndex, branchMaxIndex);
                this.cacheMFDs(sol, branchMFDs);
            } else {
                this.minMagIndex = Integer.min(this.minMagIndex, branchMFDs.branchMinIndex);
                this.maxMagIndex = Integer.max(this.maxMagIndex, branchMFDs.branchMaxIndex);
            }
            this.branchSectMFDs.add(branchMFDs.sectMFDs);
            this.branchSectMinMagIndexes.add(branchMFDs.sectMinMagIndexes);
            this.weights.add(weight);
        }

        protected abstract E init();

        @Override
        public E build() {
            E ret = this.init();
            int numBranches = this.weights.size();
            Preconditions.checkState((numBranches > 0 ? 1 : 0) != 0);
            ((AbstractBranchMFDs)ret).weights = Doubles.toArray(this.weights);
            int numSects = this.branchSectMFDs.get(0).length;
            Preconditions.checkState((this.minMagIndex <= this.maxMagIndex ? 1 : 0) != 0, (String)"No sections with non-zero rates? minIndex=%s > maxIndex=%s", (int)this.minMagIndex, (int)this.maxMagIndex);
            ((AbstractBranchMFDs)ret).refMFD = new IncrementalMagFreqDist(refMFD.getX(this.minMagIndex), 1 + this.maxMagIndex - this.minMagIndex, refMFD.getDelta());
            ((AbstractBranchMFDs)ret).branchSectMFDs = new float[numBranches][][];
            ((AbstractBranchMFDs)ret).branchSectMinMagIndexes = new short[numBranches][numSects];
            for (int b = 0; b < numBranches; ++b) {
                ((AbstractBranchMFDs)ret).branchSectMFDs[b] = this.branchSectMFDs.get(b);
                for (int s = 0; s < numSects; ++s) {
                    if (((AbstractBranchMFDs)ret).branchSectMFDs[b][s] == null) continue;
                    short origMinMagIndex = this.branchSectMinMagIndexes.get(b)[s];
                    int modMinMagIndex = origMinMagIndex - this.minMagIndex;
                    Preconditions.checkState((modMinMagIndex >= 0 ? 1 : 0) != 0);
                    ((AbstractBranchMFDs)ret).branchSectMinMagIndexes[b][s] = (short)modMinMagIndex;
                }
            }
            if (this.parents) {
                ((AbstractBranchMFDs)ret).parentIDtoIndexMap = HashBiMap.create();
                for (int i = 0; i < this.parentIDs.size(); ++i) {
                    ((AbstractBranchMFDs)ret).parentIDtoIndexMap.put((Object)this.parentIDs.get(i), (Object)i);
                }
            }
            return ret;
        }
    }
}

