/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.opensha.commons.util.ApplicationVersion;
import org.opensha.commons.util.GitVersion;
import org.opensha.commons.util.modules.helpers.JSON_TypeAdapterBackedModule;

public class BuildInfoModule
implements JSON_TypeAdapterBackedModule<BuildInfoModule> {
    private Long buildTime;
    private String buildTimeHuman;
    private String gitHash;
    private String branch;
    private String remoteUrl;
    private ApplicationVersion openshaVersion;
    private Long creationTime;
    private String creationTimeHuman;
    private List<Map<String, String>> extra;

    private BuildInfoModule() {
    }

    public BuildInfoModule(Long buildTime, String gitHash, String branch, String remoteUrl, ApplicationVersion openshaVersion) {
        this.buildTime = buildTime;
        if (buildTime != null) {
            this.buildTimeHuman = new Date(buildTime).toString();
        }
        this.gitHash = gitHash;
        this.branch = branch;
        this.remoteUrl = remoteUrl;
        this.openshaVersion = openshaVersion;
        this.creationTime = System.currentTimeMillis();
        this.creationTimeHuman = new Date(this.creationTime).toString();
    }

    public static BuildInfoModule fromGitVersion(GitVersion git) throws IOException {
        String remoteUrl;
        String branch;
        String gitHash;
        Date date = git.loadBuildDate();
        Long buildTime = date == null ? null : Long.valueOf(date.getTime());
        try {
            gitHash = git.loadGitHash();
        }
        catch (Exception e) {
            gitHash = null;
        }
        try {
            branch = git.loadGitBranch();
        }
        catch (Exception e) {
            branch = null;
        }
        try {
            remoteUrl = git.loadGitRemote();
        }
        catch (Exception e) {
            remoteUrl = null;
        }
        ApplicationVersion openshaVersion = ApplicationVersion.loadBuildVersion();
        return new BuildInfoModule(buildTime, gitHash, branch, remoteUrl, openshaVersion);
    }

    public static BuildInfoModule detect() throws IOException {
        return BuildInfoModule.fromGitVersion(new GitVersion());
    }

    public void addExtra(GitVersion gitVersion) {
        if (this.extra == null) {
            this.extra = new ArrayList<Map<String, String>>();
        }
        this.extra.add(gitVersion.getMap());
    }

    @Override
    public String getFileName() {
        return "build_info.json";
    }

    @Override
    public String getName() {
        return "OpenSHA Build Information";
    }

    @Override
    public Type getType() {
        return BuildInfoModule.class;
    }

    @Override
    public BuildInfoModule get() {
        return this;
    }

    @Override
    public void set(BuildInfoModule value) {
        this.buildTime = value.buildTime;
        if (this.buildTime != null) {
            this.buildTimeHuman = new Date(this.buildTime).toString();
        }
        this.gitHash = value.gitHash;
        this.branch = value.branch;
        this.remoteUrl = value.remoteUrl;
        this.openshaVersion = value.openshaVersion;
        this.creationTime = value.creationTime;
        if (this.creationTime != null) {
            this.creationTimeHuman = new Date(this.creationTime).toString();
        }
        this.extra = value.extra;
    }

    public Long getBuildTime() {
        return this.buildTime;
    }

    public String getGitHash() {
        return this.gitHash;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public ApplicationVersion getOpenshaVersion() {
        return this.openshaVersion;
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public void registerTypeAdapters(GsonBuilder builder) {
    }
}

