/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.google.common.collect.UnmodifiableIterator;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.ArchivableModule;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.commons.util.modules.helpers.FileBackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchAverageableModule;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;

public interface FaultGridAssociations
extends OpenSHA_Module,
BranchAverageableModule<FaultGridAssociations> {
    public static final String ARCHIVE_GRID_REGION_FILE_NAME = "grid_region.geojson";
    public static final String ARCHIVE_NODE_EXTENTS_FILE_NAME = "grid_node_association_fracts.csv";
    public static final String ARCHIVE_SECT_NODE_ASSOCIATIONS_FILE_NAME = "grid_node_sect_associations.csv";

    public Map<Integer, Double> getNodeExtents();

    public double getNodeFraction(int var1);

    public Map<Integer, Double> getScaledNodeFractions(int var1);

    public Map<Integer, Double> getScaledSectFracsOnNode(int var1);

    public Map<Integer, Double> getNodeFractions(int var1);

    public Map<Integer, Double> getSectionFracsOnNode(int var1);

    public GriddedRegion getRegion();

    public Collection<Integer> sectIndices();

    default public double getSectionFractInRegion(int sectIndex) {
        double sum = 0.0;
        for (double val : this.getNodeFractions(sectIndex).values()) {
            sum += val;
        }
        Preconditions.checkState(((float)sum <= 1.01f ? 1 : 0) != 0, (String)"Bad sum when calculation section fraction in region: %s", (Object)sum);
        return sum;
    }

    @Override
    default public AverageableModule.AveragingAccumulator<FaultGridAssociations> averagingAccumulator() {
        return new Averager();
    }

    public static Precomputed getIntersectionAssociations(FaultSystemRupSet rupSet, GriddedRegion region) {
        return FaultGridAssociations.getIntersectionAssociations(rupSet.getFaultSectionDataList(), region);
    }

    public static Precomputed getIntersectionAssociations(List<? extends FaultSection> sects, GriddedRegion region) {
        Precomputed ret = new Precomputed();
        ret.region = region;
        ret.nodeExtents = ImmutableMap.of();
        ImmutableTable.Builder nodeInSectParticBuilder = ImmutableTable.builder();
        ImmutableList.Builder sectIndicesBuilder = ImmutableList.builder();
        HashBasedTable sectAreasInNode = HashBasedTable.create();
        for (int s = 0; s < sects.size(); ++s) {
            FaultSection sect = sects.get(s);
            Preconditions.checkState((sect.getSectionId() == s ? 1 : 0) != 0, (Object)"Section IDs must be 0-based and in order");
            RuptureSurface surf = sect.getFaultSurface(0.25, false, true);
            HashMap<Integer, Integer> nodeAssocCounts = new HashMap<Integer, Integer>();
            for (Location loc : surf.getEvenlyDiscritizedListOfLocsOnSurface()) {
                int nodeIndex = region.indexForLocation(loc);
                if (nodeIndex < 0) continue;
                Integer prevCount = (Integer)nodeAssocCounts.get(nodeIndex);
                if (prevCount == null) {
                    prevCount = 0;
                }
                nodeAssocCounts.put(nodeIndex, prevCount + 1);
            }
            if (nodeAssocCounts.isEmpty()) continue;
            int sectIndex = sect.getSectionId();
            sectIndicesBuilder.add((Object)sectIndex);
            double fractScalar = 1.0 / (double)surf.getEvenlyDiscretizedNumLocs();
            double areaScalar = sect.getArea(true) * fractScalar;
            Iterator iterator = nodeAssocCounts.keySet().iterator();
            while (iterator.hasNext()) {
                int nodeIndex = (Integer)iterator.next();
                double count = ((Integer)nodeAssocCounts.get(nodeIndex)).doubleValue();
                double fractAssoc = count * fractScalar;
                nodeInSectParticBuilder.put((Object)sectIndex, (Object)nodeIndex, (Object)fractAssoc);
                double areaAssoc = count * areaScalar;
                sectAreasInNode.put((Object)sectIndex, (Object)nodeIndex, (Object)areaAssoc);
            }
        }
        ImmutableTable.Builder sectInNodeParticBuilder = ImmutableTable.builder();
        ImmutableMap.Builder nodeExtentsBuilder = ImmutableMap.builder();
        Iterator iterator = sectAreasInNode.columnKeySet().iterator();
        while (iterator.hasNext()) {
            int nodeIndex = (Integer)iterator.next();
            Map nodeSectAreas = sectAreasInNode.column((Object)nodeIndex);
            if (nodeSectAreas.size() == 1) {
                sectInNodeParticBuilder.put((Object)((Integer)nodeSectAreas.keySet().iterator().next()), (Object)nodeIndex, (Object)1.0);
            } else {
                double sum = 0.0;
                for (Double area : nodeSectAreas.values()) {
                    sum += area.doubleValue();
                }
                Iterator<Object> iterator2 = nodeSectAreas.keySet().iterator();
                while (iterator2.hasNext()) {
                    int sectIndex = (Integer)iterator2.next();
                    double fract = (Double)nodeSectAreas.get(sectIndex) / sum;
                    sectInNodeParticBuilder.put((Object)sectIndex, (Object)nodeIndex, (Object)fract);
                }
            }
            nodeExtentsBuilder.put((Object)nodeIndex, (Object)1.0);
        }
        ret.nodeExtents = nodeExtentsBuilder.build();
        ret.sectIndices = sectIndicesBuilder.build();
        ret.sectNodeOrigFracts = nodeInSectParticBuilder.build();
        ret.sectNodeScaledFracts = sectInNodeParticBuilder.build();
        return ret;
    }

    public static class Averager
    implements AverageableModule.AveragingAccumulator<FaultGridAssociations> {
        private FaultGridAssociations ref;
        private boolean identical;
        private GriddedRegion gridReg;
        private double sumWeight = 0.0;
        private HashMap<Integer, Double> nodeExtents;
        private Table<Integer, Integer, Double> sectNodeOrigFracts;
        private Table<Integer, Integer, Double> sectNodeScaledFracts;
        private HashSet<Integer> sectIndices;
        private boolean ID_D = false;

        @Override
        public Class<FaultGridAssociations> getType() {
            return FaultGridAssociations.class;
        }

        @Override
        public void process(FaultGridAssociations module, double relWeight) {
            if (this.ref == null) {
                this.ref = module;
                this.identical = true;
                this.gridReg = this.ref.getRegion();
                this.nodeExtents = new HashMap();
                this.sectNodeOrigFracts = HashBasedTable.create();
                this.sectNodeScaledFracts = HashBasedTable.create();
                this.sectIndices = new HashSet();
            } else {
                Preconditions.checkState((boolean)module.getRegion().equalsRegion(this.ref.getRegion()));
            }
            if (this.ID_D) {
                System.out.println("identical=" + this.identical + " as we begin processing module with relWeight=" + relWeight + " (prevSum=" + this.sumWeight + ", ref == module ? " + (this.ref == module) + ")");
            }
            for (int sectIndex : module.sectIndices()) {
                this.sectIndices.add(sectIndex);
                for (boolean scaled : new boolean[]{false, true}) {
                    Table<Integer, Integer, Double> dest;
                    Map<Integer, Double> refNodeFracts;
                    Map<Integer, Double> nodeFracts;
                    String name;
                    if (scaled) {
                        name = "scaledNodeFracts";
                        nodeFracts = module.getScaledNodeFractions(sectIndex);
                        refNodeFracts = this.ref.getScaledNodeFractions(sectIndex);
                        dest = this.sectNodeScaledFracts;
                    } else {
                        name = "nodeFracts";
                        nodeFracts = module.getNodeFractions(sectIndex);
                        refNodeFracts = this.ref.getNodeFractions(sectIndex);
                        dest = this.sectNodeOrigFracts;
                    }
                    if (this.identical) {
                        boolean bl = this.identical = refNodeFracts != null && nodeFracts.size() == refNodeFracts.size();
                        if (this.ID_D && !this.identical) {
                            System.out.println("Identical fail for " + name + ".size(): " + nodeFracts.size() + " != " + refNodeFracts.size());
                        }
                    }
                    for (int nodeIndex : nodeFracts.keySet()) {
                        double nodeFract = nodeFracts.get(nodeIndex);
                        Double prevFract = (Double)dest.get((Object)sectIndex, (Object)nodeIndex);
                        if (prevFract == null) {
                            prevFract = 0.0;
                        }
                        dest.put((Object)sectIndex, (Object)nodeIndex, (Object)(prevFract + nodeFract * relWeight));
                        if (!this.identical) continue;
                        Double refNodeFract = refNodeFracts.get(nodeIndex);
                        boolean bl = this.identical = refNodeFract != null && refNodeFract == nodeFract;
                        if (!this.ID_D || this.identical) continue;
                        System.out.println("Identical fail for " + name + "[" + nodeIndex + "]=" + nodeFract + " != " + refNodeFract);
                    }
                }
            }
            for (int nodeIndex = 0; nodeIndex < this.gridReg.getNodeCount(); ++nodeIndex) {
                Double prevExtent = this.nodeExtents.get(nodeIndex);
                if (prevExtent == null) {
                    prevExtent = 0.0;
                }
                double extent = module.getNodeFraction(nodeIndex);
                if (this.identical) {
                    boolean bl = this.identical = this.ref.getNodeFraction(nodeIndex) == extent;
                    if (this.ID_D && !this.identical) {
                        System.out.println("Identical fail for extent[" + nodeIndex + "]=" + extent + " != " + this.ref.getNodeFraction(nodeIndex));
                    }
                }
                this.nodeExtents.put(nodeIndex, prevExtent + extent * relWeight);
            }
            if (this.ID_D) {
                System.out.println("identical=" + this.identical + " after processing module with relWeight=" + relWeight);
            }
            this.sumWeight += relWeight;
        }

        public boolean areAllIdentical() {
            return this.identical;
        }

        public void disableIdenticalCheck() {
            this.identical = false;
        }

        @Override
        public Precomputed getAverage() {
            if (this.identical) {
                return this.ref instanceof Precomputed ? (Precomputed)this.ref : new Precomputed(this.ref);
            }
            ImmutableMap.Builder nodeExtentsBuilder = ImmutableMap.builder();
            ImmutableTable.Builder sectNodeOrigFractsBuilder = ImmutableTable.builder();
            ImmutableTable.Builder sectNodeScaledFractsBuilder = ImmutableTable.builder();
            for (int nodeIndex : this.nodeExtents.keySet()) {
                nodeExtentsBuilder.put((Object)nodeIndex, (Object)(this.nodeExtents.get(nodeIndex) / this.sumWeight));
            }
            for (Table.Cell cell : this.sectNodeOrigFracts.cellSet()) {
                sectNodeOrigFractsBuilder.put((Object)((Integer)cell.getRowKey()), (Object)((Integer)cell.getColumnKey()), (Object)((Double)cell.getValue() / this.sumWeight));
            }
            for (Table.Cell cell : this.sectNodeScaledFracts.cellSet()) {
                sectNodeScaledFractsBuilder.put((Object)((Integer)cell.getRowKey()), (Object)((Integer)cell.getColumnKey()), (Object)((Double)cell.getValue() / this.sumWeight));
            }
            Precomputed ret = new Precomputed();
            ret.region = this.ref.getRegion();
            ret.nodeExtents = nodeExtentsBuilder.build();
            ret.sectNodeOrigFracts = sectNodeOrigFractsBuilder.build();
            ret.sectNodeScaledFracts = sectNodeScaledFractsBuilder.build();
            ret.sectIndices = ImmutableList.copyOf(this.sectIndices);
            return ret;
        }
    }

    public static class Precomputed
    implements FaultGridAssociations,
    ArchivableModule {
        protected Feature regionFeature;
        protected GriddedRegion region;
        private ImmutableList<Integer> sectIndices;
        private ImmutableMap<Integer, Double> nodeExtents;
        private ImmutableTable<Integer, Integer, Double> sectNodeOrigFracts;
        private ImmutableTable<Integer, Integer, Double> sectNodeScaledFracts;

        protected Precomputed() {
        }

        public Precomputed(FaultGridAssociations associations) {
            Preconditions.checkNotNull((Object)associations, (Object)"Passed in associations are null");
            this.region = associations.getRegion();
            this.nodeExtents = ImmutableMap.copyOf(associations.getNodeExtents());
            ImmutableTable.Builder nodeInSectParticBuilder = ImmutableTable.builder();
            ImmutableTable.Builder sectInNodeParticBuilder = ImmutableTable.builder();
            this.sectIndices = ImmutableList.copyOf(associations.sectIndices());
            UnmodifiableIterator unmodifiableIterator = this.sectIndices.iterator();
            while (unmodifiableIterator.hasNext()) {
                int sectIndex = (Integer)unmodifiableIterator.next();
                Map<Integer, Double> sectNodeFractions = associations.getNodeFractions(sectIndex);
                Map<Integer, Double> scaledNodeFractions = associations.getScaledNodeFractions(sectIndex);
                if (sectNodeFractions == null) {
                    Preconditions.checkState((scaledNodeFractions == null ? 1 : 0) != 0, (String)"Have scaled node fractions for sect %s but not unscaled?", (int)sectIndex);
                    continue;
                }
                Preconditions.checkNotNull(scaledNodeFractions, (String)"Have un-scaled node fractions but not scaled for sect %s", (int)sectIndex);
                Preconditions.checkState((sectNodeFractions.size() == scaledNodeFractions.size() ? 1 : 0) != 0, (String)"Scaled & un-scaled node fractions maps of different sizes for sect %s", (int)sectIndex);
                for (int nodeIndex : sectNodeFractions.keySet()) {
                    Double nodeFraction = sectNodeFractions.get(nodeIndex);
                    Double scaledFraction = scaledNodeFractions.get(nodeIndex);
                    nodeInSectParticBuilder.put((Object)sectIndex, (Object)nodeIndex, (Object)nodeFraction);
                    sectInNodeParticBuilder.put((Object)sectIndex, (Object)nodeIndex, (Object)scaledFraction);
                }
            }
            this.sectNodeOrigFracts = nodeInSectParticBuilder.build();
            this.sectNodeScaledFracts = sectInNodeParticBuilder.build();
        }

        @Override
        public String getName() {
            return "Fault Grid Associations";
        }

        @Override
        public void writeToArchive(ArchiveOutput output, String entryPrefix) throws IOException {
            FileBackedModule.initEntry(output, entryPrefix, FaultGridAssociations.ARCHIVE_GRID_REGION_FILE_NAME);
            OutputStreamWriter writer = new OutputStreamWriter(output.getOutputStream());
            Feature.write(this.getRegionFeature(), writer);
            writer.flush();
            output.closeEntry();
            CSVFile<String> extentsCSV = new CSVFile<String>(true);
            extentsCSV.addLine("Grid Node Index", "Fraction Associated With Fault");
            GriddedRegion region = this.getRegion();
            for (int nodeIndex = 0; nodeIndex < region.getNodeCount(); ++nodeIndex) {
                extentsCSV.addLine("" + nodeIndex, "" + this.getNodeFraction(nodeIndex));
            }
            CSV_BackedModule.writeToArchive(extentsCSV, output, entryPrefix, FaultGridAssociations.ARCHIVE_NODE_EXTENTS_FILE_NAME);
            CSVFile<String> mappingsCSV = new CSVFile<String>(true);
            mappingsCSV.addLine("Section Index", "Grid Node Index", "Node Fraction", "Scaled Node Fraction");
            ArrayList sectIDs = new ArrayList(this.sectNodeOrigFracts.rowKeySet());
            Collections.sort(sectIDs);
            Iterator iterator = sectIDs.iterator();
            while (iterator.hasNext()) {
                int sectIndex = (Integer)iterator.next();
                ImmutableMap sectNodeFractions = this.sectNodeOrigFracts.row((Object)sectIndex);
                ImmutableMap scaledNodeFractions = this.sectNodeScaledFracts.row((Object)sectIndex);
                ArrayList nodeIndexes = new ArrayList(sectNodeFractions.keySet());
                Collections.sort(nodeIndexes);
                Iterator iterator2 = nodeIndexes.iterator();
                while (iterator2.hasNext()) {
                    int nodeIndex = (Integer)iterator2.next();
                    Double sectFract = (Double)sectNodeFractions.get(nodeIndex);
                    Double scaledFract = (Double)scaledNodeFractions.get(nodeIndex);
                    mappingsCSV.addLine("" + sectIndex, "" + nodeIndex, sectFract.toString(), scaledFract.toString());
                }
            }
            CSV_BackedModule.writeToArchive(mappingsCSV, output, entryPrefix, FaultGridAssociations.ARCHIVE_SECT_NODE_ASSOCIATIONS_FILE_NAME);
        }

        @Override
        public void initFromArchive(ArchiveInput input, String entryPrefix) throws IOException {
            BufferedInputStream regionIS = FileBackedModule.getInputStream(input, entryPrefix, FaultGridAssociations.ARCHIVE_GRID_REGION_FILE_NAME);
            InputStreamReader regionReader = new InputStreamReader(regionIS);
            this.regionFeature = Feature.read(regionReader);
            CSVFile<String> extentsCSV = CSV_BackedModule.loadFromArchive(input, entryPrefix, FaultGridAssociations.ARCHIVE_NODE_EXTENTS_FILE_NAME);
            ImmutableMap.Builder extentsBuilder = ImmutableMap.builderWithExpectedSize((int)(extentsCSV.getNumRows() - 1));
            for (int row = 1; row < extentsCSV.getNumRows(); ++row) {
                extentsBuilder.put((Object)extentsCSV.getInt(row, 0), (Object)extentsCSV.getDouble(row, 1));
            }
            this.nodeExtents = extentsBuilder.build();
            CSVFile<String> mappingsCSV = CSV_BackedModule.loadFromArchive(input, entryPrefix, FaultGridAssociations.ARCHIVE_SECT_NODE_ASSOCIATIONS_FILE_NAME);
            ImmutableTable.Builder nodeInSectParticBuilder = ImmutableTable.builder();
            ImmutableTable.Builder sectInNodeParticBuilder = ImmutableTable.builder();
            for (int row = 1; row < mappingsCSV.getNumRows(); ++row) {
                int sectIndex = mappingsCSV.getInt(row, 0);
                int nodeIndex = mappingsCSV.getInt(row, 1);
                nodeInSectParticBuilder.put((Object)sectIndex, (Object)nodeIndex, (Object)mappingsCSV.getDouble(row, 2));
                sectInNodeParticBuilder.put((Object)sectIndex, (Object)nodeIndex, (Object)mappingsCSV.getDouble(row, 3));
            }
            this.sectNodeOrigFracts = nodeInSectParticBuilder.build();
            this.sectNodeScaledFracts = sectInNodeParticBuilder.build();
            this.sectIndices = ImmutableList.copyOf((Collection)this.sectNodeOrigFracts.rowKeySet());
        }

        @Override
        public Map<Integer, Double> getNodeExtents() {
            return ImmutableMap.copyOf(this.nodeExtents);
        }

        @Override
        public double getNodeFraction(int nodeIdx) {
            Double fraction = (Double)this.nodeExtents.get((Object)nodeIdx);
            return fraction == null ? 0.0 : fraction;
        }

        @Override
        public Map<Integer, Double> getScaledNodeFractions(int sectIdx) {
            return this.sectNodeScaledFracts.row((Object)sectIdx);
        }

        @Override
        public Map<Integer, Double> getScaledSectFracsOnNode(int sectIdx) {
            return this.sectNodeScaledFracts.column((Object)sectIdx);
        }

        @Override
        public Map<Integer, Double> getNodeFractions(int sectIdx) {
            return this.sectNodeOrigFracts.row((Object)sectIdx);
        }

        @Override
        public Map<Integer, Double> getSectionFracsOnNode(int nodeIdx) {
            return this.sectNodeOrigFracts.column((Object)nodeIdx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GriddedRegion getRegion() {
            if (this.region == null) {
                Precomputed precomputed = this;
                synchronized (precomputed) {
                    if (this.region == null) {
                        Preconditions.checkNotNull((Object)this.regionFeature, (Object)"Region is null but we don't have a Feature to load it from");
                        this.region = GriddedRegion.fromFeature(this.regionFeature);
                    }
                }
            }
            return this.region;
        }

        protected Feature getRegionFeature() {
            if (this.regionFeature == null) {
                this.regionFeature = this.getRegion().toFeature();
            }
            return this.regionFeature;
        }

        @Override
        public Collection<Integer> sectIndices() {
            return this.sectIndices;
        }
    }
}

