/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.stat.StatUtils;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.util.modules.SubModule;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;

public class IndividualSolutionRates
implements SubModule<FaultSystemSolution>,
CSV_BackedModule {
    private FaultSystemSolution sol;
    private List<double[]> ratesList;

    private IndividualSolutionRates() {
    }

    public IndividualSolutionRates(FaultSystemSolution sol, List<double[]> ratesList) {
        this.init(sol, ratesList);
    }

    private void init(FaultSystemSolution sol, List<double[]> ratesList) {
        IndividualSolutionRates.validate(sol, ratesList);
        this.sol = sol;
        this.ratesList = ratesList;
    }

    @Override
    public String getFileName() {
        return "individual_rates.csv";
    }

    @Override
    public String getName() {
        return "Individual Solution Rates";
    }

    @Override
    public void setParent(FaultSystemSolution parent) throws IllegalStateException {
        if (this.sol != null) {
            Preconditions.checkState((boolean)this.sol.getRupSet().isEquivalentTo(parent.getRupSet()));
        }
        if (this.ratesList != null) {
            IndividualSolutionRates.validate(parent, this.ratesList);
        }
        this.sol = parent;
    }

    private static void validate(FaultSystemSolution sol, List<double[]> ratesList) {
        int numRups = sol.getRupSet().getNumRuptures();
        double origSum = sol.getTotalRateForAllFaultSystemRups();
        double indvSum = 0.0;
        for (double[] rates : ratesList) {
            Preconditions.checkState((rates.length == numRups ? 1 : 0) != 0);
            indvSum += StatUtils.sum((double[])rates);
        }
        Preconditions.checkState(((float)origSum == (float)(indvSum /= (double)ratesList.size()) ? 1 : 0) != 0, (String)"Sum of averaged rates doesn't match that from supplied solution: %s != %s", (Object)Float.valueOf((float)origSum), (Object)Float.valueOf((float)indvSum));
    }

    @Override
    public FaultSystemSolution getParent() {
        return this.sol;
    }

    @Override
    public SubModule<FaultSystemSolution> copy(FaultSystemSolution newParent) throws IllegalStateException {
        if (this.sol != null) {
            Preconditions.checkState((boolean)this.sol.getRupSet().isEquivalentTo(newParent.getRupSet()));
        }
        return new IndividualSolutionRates(newParent, this.ratesList);
    }

    @Override
    public CSVFile<?> getCSV() {
        CSVFile csv = new CSVFile(true);
        ArrayList<Object> header = new ArrayList<Object>();
        header.add("Rupture Index");
        for (int i = 0; i < this.ratesList.size(); ++i) {
            header.add("Solution " + (i + 1));
        }
        csv.addLine(header);
        int numRups = this.sol.getRupSet().getNumRuptures();
        for (int r = 0; r < numRups; ++r) {
            ArrayList<CallSite> line = new ArrayList<CallSite>(csv.getNumCols());
            line.add((CallSite)((Object)("" + r)));
            for (double[] rates : this.ratesList) {
                line.add((CallSite)((Object)("" + rates[r])));
            }
            csv.addLine(line);
        }
        return csv;
    }

    @Override
    public void initFromCSV(CSVFile<String> csv) {
        Preconditions.checkNotNull((Object)this.sol, (Object)"Solution not set but initFromCSV called");
        int numRups = this.sol.getRupSet().getNumRuptures();
        Preconditions.checkState((csv.getNumRows() == numRups + 1 ? 1 : 0) != 0, (String)"Expected numRups+1 rows in CSV, have %s with numRups=%s", (int)csv.getNumRows(), (int)numRups);
        int numSols = csv.getLine(0).size() - 1;
        ArrayList<double[]> individualRates = new ArrayList<double[]>();
        for (int s = 0; s < numSols; ++s) {
            individualRates.add(new double[numRups]);
        }
        for (int r = 0; r < numRups; ++r) {
            int row = r + 1;
            Preconditions.checkState((csv.getInt(row, 0) == r ? 1 : 0) != 0, (Object)"CSV out of order or not 0-based");
            for (int s = 0; s < numSols; ++s) {
                ((double[])individualRates.get((int)s))[r] = csv.getDouble(row, s + 1);
            }
        }
        this.init(this.sol, individualRates);
    }
}

