/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchAverageableModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionMisfitStats;

public class InversionMisfitProgress
implements CSV_BackedModule,
BranchAverageableModule<InversionMisfitProgress> {
    private List<Long> iterations;
    private List<Long> times;
    private List<InversionMisfitStats> stats;
    private InversionMisfitStats.Quantity targetQuantity;
    private List<Double> targetVals;
    public static final String MISFIT_PROGRESS_FILE_NAME = "inversion_misfit_progress.csv";

    private InversionMisfitProgress() {
    }

    public InversionMisfitProgress(CSVFile<String> csv) {
        this.initFromCSV(csv);
    }

    public InversionMisfitProgress(List<Long> iterations, List<Long> times, List<InversionMisfitStats> stats) {
        this(iterations, times, stats, null, null);
    }

    public InversionMisfitProgress(List<Long> iterations, List<Long> times, List<InversionMisfitStats> stats, InversionMisfitStats.Quantity targetQuantity, List<Double> targetVals) {
        Preconditions.checkState((iterations.size() == times.size() ? 1 : 0) != 0);
        Preconditions.checkState((iterations.size() == stats.size() ? 1 : 0) != 0);
        this.iterations = iterations;
        this.times = times;
        this.stats = stats;
        if (targetQuantity == null || targetVals == null) {
            Preconditions.checkState((targetVals == null && targetQuantity == null ? 1 : 0) != 0, (Object)"Should specify both target quantity and values, or neither");
        } else {
            Preconditions.checkState((targetVals.size() == iterations.size() ? 1 : 0) != 0);
            this.targetQuantity = targetQuantity;
            this.targetVals = targetVals;
        }
    }

    @Override
    public String getFileName() {
        return MISFIT_PROGRESS_FILE_NAME;
    }

    @Override
    public String getName() {
        return "Inversion Misfit Progress";
    }

    public List<Long> getIterations() {
        return this.iterations;
    }

    public List<Long> getTimes() {
        return this.times;
    }

    public List<InversionMisfitStats> getStats() {
        return this.stats;
    }

    public InversionMisfitStats.Quantity getTargetQuantity() {
        return this.targetQuantity;
    }

    public List<Double> getTargetVals() {
        return this.targetVals;
    }

    @Override
    public CSVFile<?> getCSV() {
        boolean targets;
        CSVFile csv = new CSVFile(true);
        ArrayList<Object> header = new ArrayList<Object>();
        header.add("Iteration");
        header.add("Time (ms)");
        boolean bl = targets = this.targetQuantity != null && this.targetVals != null;
        if (targets) {
            header.add("Target " + String.valueOf((Object)this.targetQuantity));
        }
        header.addAll(InversionMisfitStats.csvHeader);
        csv.addLine(header);
        for (int i = 0; i < this.iterations.size(); ++i) {
            String iters = String.valueOf(this.iterations.get(i));
            String time = String.valueOf(this.times.get(i));
            String target = targets ? String.valueOf(this.targetVals.get(i)) : null;
            for (InversionMisfitStats.MisfitStats stat : this.stats.get(i).getStats()) {
                ArrayList<Object> line = new ArrayList<Object>(header.size());
                line.add(iters);
                line.add(time);
                if (targets) {
                    line.add(target);
                }
                line.addAll(stat.buildCSVLine());
                csv.addLine(line);
            }
        }
        return csv;
    }

    @Override
    public void initFromCSV(CSVFile<String> csv) {
        this.iterations = new ArrayList<Long>();
        this.times = new ArrayList<Long>();
        this.stats = new ArrayList<InversionMisfitStats>();
        boolean targets = csv.get(0, 2).trim().startsWith("Target");
        if (targets) {
            this.targetQuantity = null;
            String header = csv.get(0, 2).trim();
            for (InversionMisfitStats.Quantity quantity : InversionMisfitStats.Quantity.values()) {
                if (!header.equals("Target " + String.valueOf((Object)quantity))) continue;
                Preconditions.checkState((this.targetQuantity == null ? 1 : 0) != 0);
                this.targetQuantity = quantity;
            }
            Preconditions.checkNotNull((Object)((Object)this.targetQuantity));
            this.targetVals = new ArrayList<Double>();
        }
        long curIteration = -1L;
        long curTime = -1L;
        Double curTarget = null;
        ArrayList<InversionMisfitStats.MisfitStats> curStats = null;
        for (int row = 1; row < csv.getNumRows(); ++row) {
            int col = 0;
            long iteration = csv.getLong(row, col++);
            long time = csv.getLong(row, col++);
            Double targetVal = null;
            if (targets) {
                targetVal = csv.getDouble(row, col++);
            }
            List<String> misfitLine = csv.getLine(row);
            misfitLine = misfitLine.subList(col, misfitLine.size());
            InversionMisfitStats.MisfitStats stats = new InversionMisfitStats.MisfitStats(misfitLine);
            Preconditions.checkState((iteration >= 0L ? 1 : 0) != 0);
            Preconditions.checkState((iteration >= curIteration ? 1 : 0) != 0);
            Preconditions.checkState((time >= curTime ? 1 : 0) != 0);
            if (iteration != curIteration) {
                if (curStats != null) {
                    Preconditions.checkState((curIteration >= 0L ? 1 : 0) != 0);
                    Preconditions.checkState((curTime >= 0L ? 1 : 0) != 0);
                    Preconditions.checkState((!curStats.isEmpty() ? 1 : 0) != 0);
                    this.iterations.add(curIteration);
                    this.times.add(curTime);
                    if (targets) {
                        this.targetVals.add(curTarget);
                    }
                    this.stats.add(new InversionMisfitStats(curStats));
                }
                curStats = new ArrayList<InversionMisfitStats.MisfitStats>();
                curIteration = iteration;
                curTime = time;
                curTarget = targetVal;
            }
            Preconditions.checkState((time == curTime ? 1 : 0) != 0);
            curStats.add(stats);
        }
        Preconditions.checkState((curIteration >= 0L ? 1 : 0) != 0);
        Preconditions.checkState((curTime >= 0L ? 1 : 0) != 0);
        Preconditions.checkState((!curStats.isEmpty() ? 1 : 0) != 0);
        this.iterations.add(curIteration);
        this.times.add(curTime);
        if (targets) {
            this.targetVals.add(curTarget);
        }
        this.stats.add(new InversionMisfitStats((List<InversionMisfitStats.MisfitStats>)curStats));
    }

    @Override
    public AverageableModule.AveragingAccumulator<InversionMisfitProgress> averagingAccumulator() {
        return new AverageableModule.AveragingAccumulator<InversionMisfitProgress>(){
            List<InversionMisfitProgress> progresses = new ArrayList<InversionMisfitProgress>();
            List<Double> weights = new ArrayList<Double>();

            @Override
            public void process(InversionMisfitProgress module, double relWeight) {
                this.progresses.add(module);
                this.weights.add(relWeight);
            }

            @Override
            public Class<InversionMisfitProgress> getType() {
                return InversionMisfitProgress.class;
            }

            @Override
            public InversionMisfitProgress getAverage() {
                int minNumSteps = Integer.MAX_VALUE;
                int maxNumSteps = 0;
                for (InversionMisfitProgress p : this.progresses) {
                    int steps = p.iterations.size();
                    minNumSteps = Integer.min(minNumSteps, steps);
                    maxNumSteps = Integer.max(maxNumSteps, steps);
                }
                Preconditions.checkState((minNumSteps > 0 ? 1 : 0) != 0, (Object)"At least 1 InversionMisfitProgress instance has no steps");
                if (minNumSteps < maxNumSteps) {
                    System.err.println("WARNING: Not all InversionMisfitProgress instances have the same number of steps, only averaging the first " + minNumSteps + " (max is " + maxNumSteps + ")");
                }
                ArrayList<Long> avgIters = new ArrayList<Long>(minNumSteps);
                ArrayList<Long> avgTimes = new ArrayList<Long>(minNumSteps);
                ArrayList<InversionMisfitStats> avgStats = new ArrayList<InversionMisfitStats>(minNumSteps);
                InversionMisfitStats.Quantity targetQuantity = null;
                for (int p = 0; p < this.progresses.size(); ++p) {
                    InversionMisfitProgress progress = this.progresses.get(p);
                    if (p == 0) {
                        targetQuantity = progress.targetQuantity;
                    } else if (targetQuantity != progress.targetQuantity) {
                        targetQuantity = null;
                    }
                    if (targetQuantity == null) break;
                }
                ArrayList<Double> avgTargetVals = null;
                if (targetQuantity != null) {
                    avgTargetVals = new ArrayList<Double>(minNumSteps);
                }
                for (int i = 0; i < minNumSteps; ++i) {
                    ArrayList<Long> iters = new ArrayList<Long>(this.progresses.size());
                    ArrayList<Long> times = new ArrayList<Long>(this.progresses.size());
                    AverageableModule.AveragingAccumulator<InversionMisfitStats> statsAccumulator = null;
                    ArrayList<Double> targetVals = avgTargetVals == null ? null : new ArrayList<Double>(this.progresses.size());
                    for (int p = 0; p < this.progresses.size(); ++p) {
                        InversionMisfitProgress progress = this.progresses.get(p);
                        double weight = this.weights.get(p);
                        iters.add(progress.iterations.get(i));
                        times.add(progress.times.get(i));
                        InversionMisfitStats stats = progress.stats.get(i);
                        if (statsAccumulator == null) {
                            statsAccumulator = stats.averagingAccumulator();
                        }
                        statsAccumulator.process(stats, weight);
                        if (targetVals == null) continue;
                        targetVals.add(progress.targetVals.get(i));
                    }
                    avgIters.add(InversionMisfitProgress.longAvg(iters, this.weights));
                    avgTimes.add(InversionMisfitProgress.longAvg(times, this.weights));
                    if (targetVals != null) {
                        targetVals.add(InversionMisfitProgress.doubleAvg(targetVals, this.weights));
                    }
                    avgStats.add((InversionMisfitStats)statsAccumulator.getAverage());
                }
                return new InversionMisfitProgress(avgIters, avgTimes, avgStats, targetQuantity, avgTargetVals);
            }
        };
    }

    private static long longAvg(List<Long> vals, List<Double> weights) {
        long val1 = vals.get(0);
        double avgSum = 0.0;
        double weightSum = 0.0;
        boolean allSame = true;
        for (int i = 0; i < vals.size(); ++i) {
            long val = vals.get(i);
            double weight = weights.get(i);
            allSame = allSame && val == val1;
            avgSum += (double)val * weight;
            weightSum += weight;
        }
        if (allSame) {
            return val1;
        }
        return (long)(avgSum / weightSum + 0.5);
    }

    private static double doubleAvg(List<Double> vals, List<Double> weights) {
        double val1 = vals.get(0);
        double avgSum = 0.0;
        double weightSum = 0.0;
        boolean allSame = true;
        for (int i = 0; i < vals.size(); ++i) {
            double val = vals.get(i);
            double weight = weights.get(i);
            allSame = allSame && val == val1;
            avgSum += val * weight;
            weightSum += weight;
        }
        if (allSame) {
            return val1;
        }
        return avgSum / weightSum + 0.5;
    }
}

