/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import com.google.common.primitives.Doubles;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.modules.helpers.JSON_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.SolutionLogicTree;

public class LogicTreeRateStatistics
implements JSON_BackedModule {
    public static final double[] RATE_THRESHOLDS_DEFAULT = new double[]{0.0, 1.0E-16, 1.0E-14, 1.0E-12, 1.0E-10, 1.0E-8};
    private double[] thresholds;
    private FractAboveStats[] overallStats;
    private List<String> logicTreeLevels;
    private List<List<String>> logicTreeValues;
    private List<List<FractAboveStats[]>> logicTreeValueStats;
    private static DecimalFormat pDF = new DecimalFormat("0.00%");

    public static LogicTreeRateStatistics forSolutionLogicTree(SolutionLogicTree slt) throws IOException {
        return LogicTreeRateStatistics.forSolutionLogicTree(RATE_THRESHOLDS_DEFAULT, slt);
    }

    public static LogicTreeRateStatistics forSolutionLogicTree(double[] thresholds, SolutionLogicTree slt) throws IOException {
        Builder builder = new Builder();
        for (LogicTreeBranch<?> branch : slt.getLogicTree()) {
            double[] rates = slt.loadRatesForBranch(branch);
            builder.process(branch, rates);
        }
        return builder.build();
    }

    private LogicTreeRateStatistics() {
    }

    @Override
    public String getName() {
        return "Logic Tree Rupture Rate Statistics";
    }

    @Override
    public String getFileName() {
        return "logic_tree_rate_stats.json";
    }

    public FractAboveStats[] getOverallStats() {
        return Arrays.copyOf(this.overallStats, this.overallStats.length);
    }

    public List<String> getLevels() {
        return ImmutableList.copyOf(this.logicTreeLevels);
    }

    public List<String> getLevelValues(int levelIndex) {
        return ImmutableList.copyOf((Collection)this.logicTreeValues.get(levelIndex));
    }

    public FractAboveStats[] getValueStats(int levelIndex, int valueIndex) {
        return Arrays.copyOf(this.logicTreeValueStats.get(levelIndex).get(valueIndex), this.thresholds.length);
    }

    public MarkdownUtils.TableBuilder buildTable() {
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        table.initNewLine().addColumn("");
        for (double threshold : this.thresholds) {
            table.addColumn("% &ge; " + (float)threshold);
        }
        table.finalizeLine();
        this.statLine(table, "**Overall**", this.overallStats);
        block1: for (int l = 0; l < this.logicTreeLevels.size(); ++l) {
            table.initNewLine();
            table.addColumn("**" + this.logicTreeLevels.get(l) + "**");
            for (int i = 0; i < this.thresholds.length; ++i) {
                table.addColumn("");
            }
            table.finalizeLine();
            List<String> values = this.logicTreeValues.get(l);
            List<FractAboveStats[]> valueStats = this.logicTreeValueStats.get(l);
            for (int v = 0; v < values.size(); ++v) {
                if (v == 15 && values.size() > 16) {
                    int numLeft = values.size() - v;
                    table.addLine("_(Skipping " + numLeft + " additional)_");
                    continue block1;
                }
                this.statLine(table, values.get(v), valueStats.get(v));
            }
        }
        return table;
    }

    private void statLine(MarkdownUtils.TableBuilder table, String heading, FractAboveStats[] stats) {
        table.initNewLine();
        table.addColumn(heading);
        for (FractAboveStats stat : stats) {
            table.addColumn(pDF.format(stat.avg) + ", [" + pDF.format(stat.min) + "," + pDF.format(stat.max) + "]");
        }
        table.finalizeLine();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeToJSON(JsonWriter out, Gson gson) throws IOException {
        void var3_6;
        out.beginObject();
        out.name("thresholds").beginArray();
        for (double threshold : this.thresholds) {
            out.value(threshold);
        }
        out.endArray();
        out.name("overallStats").beginArray();
        for (FractAboveStats stats : this.overallStats) {
            gson.toJson((Object)stats, stats.getClass(), out);
        }
        out.endArray();
        out.name("logicTreeStats").beginArray();
        boolean bl = false;
        while (var3_6 < this.logicTreeLevels.size()) {
            out.beginObject();
            out.name("level").value(this.logicTreeLevels.get((int)var3_6));
            out.name("values").beginArray();
            List<String> values = this.logicTreeValues.get((int)var3_6);
            for (int v = 0; v < values.size(); ++v) {
                out.beginObject();
                out.name("value").value(values.get(v));
                out.name("stats").beginArray();
                for (FractAboveStats stats : this.logicTreeValueStats.get((int)var3_6).get(v)) {
                    gson.toJson((Object)stats, stats.getClass(), out);
                }
                out.endArray();
                out.endObject();
            }
            out.endArray();
            out.endObject();
            ++var3_6;
        }
        out.endArray();
        out.endObject();
    }

    @Override
    public void initFromJSON(JsonReader in, Gson gson) throws IOException {
        in.beginObject();
        block26: while (in.hasNext()) {
            switch (in.nextName()) {
                case "thresholds": {
                    ArrayList<Double> thresholds = new ArrayList<Double>();
                    in.beginArray();
                    while (in.hasNext()) {
                        thresholds.add(in.nextDouble());
                    }
                    in.endArray();
                    Preconditions.checkState((!thresholds.isEmpty() ? 1 : 0) != 0, (Object)"no thresholds supplied");
                    this.thresholds = Doubles.toArray(thresholds);
                    continue block26;
                }
                case "overallStats": {
                    this.overallStats = LogicTreeRateStatistics.loadStats(in, gson, this.thresholds);
                    continue block26;
                }
                case "logicTreeStats": {
                    this.logicTreeLevels = new ArrayList<String>();
                    this.logicTreeValues = new ArrayList<List<String>>();
                    this.logicTreeValueStats = new ArrayList<List<FractAboveStats[]>>();
                    in.beginArray();
                    while (in.hasNext()) {
                        in.beginObject();
                        String level = null;
                        ArrayList<String> values = new ArrayList<String>();
                        ArrayList<FractAboveStats[]> valueStats = new ArrayList<FractAboveStats[]>();
                        block29: while (in.hasNext()) {
                            switch (in.nextName()) {
                                case "level": {
                                    level = in.nextString();
                                    continue block29;
                                }
                                case "values": {
                                    in.beginArray();
                                    while (in.hasNext()) {
                                        in.beginObject();
                                        String value = null;
                                        FractAboveStats[] stats = null;
                                        block31: while (in.hasNext()) {
                                            switch (in.nextName()) {
                                                case "value": {
                                                    value = in.nextString();
                                                    continue block31;
                                                }
                                                case "stats": {
                                                    stats = LogicTreeRateStatistics.loadStats(in, gson, this.thresholds);
                                                    continue block31;
                                                }
                                            }
                                            System.err.println("WARNING: skipping value at " + in.getPath());
                                            in.skipValue();
                                        }
                                        Preconditions.checkNotNull(stats);
                                        Preconditions.checkNotNull(value);
                                        values.add(value);
                                        valueStats.add(stats);
                                        in.endObject();
                                    }
                                    in.endArray();
                                    continue block29;
                                }
                            }
                            System.err.println("WARNING: skipping unexpected value at " + in.getPath());
                            in.skipValue();
                        }
                        Preconditions.checkNotNull(level, (Object)"level name was not supplied");
                        Preconditions.checkState((!values.isEmpty() ? 1 : 0) != 0, (String)"no values for level %s", level);
                        Preconditions.checkState((!valueStats.isEmpty() ? 1 : 0) != 0, (String)"no value stats for level %s", (Object)level);
                        Preconditions.checkState((values.size() == valueStats.size() ? 1 : 0) != 0, (String)"value and stats sizes inconsistent for %s", (Object)level);
                        this.logicTreeLevels.add(level);
                        this.logicTreeValues.add(values);
                        this.logicTreeValueStats.add(valueStats);
                        in.endObject();
                    }
                    in.endArray();
                    continue block26;
                }
            }
            System.err.println("WARNING: skipping unexpected value at " + in.getPath());
            in.skipValue();
        }
        in.endObject();
    }

    private static FractAboveStats[] loadStats(JsonReader in, Gson gson, double[] thresholds) throws IOException {
        Preconditions.checkNotNull((Object)thresholds, (Object)"thresholds muust be specified before stats in json");
        ArrayList<FractAboveStats> stats = new ArrayList<FractAboveStats>();
        in.beginArray();
        while (in.hasNext()) {
            stats.add((FractAboveStats)gson.fromJson(in, FractAboveStats.class));
        }
        in.endArray();
        Preconditions.checkState((stats.size() == thresholds.length ? 1 : 0) != 0);
        return stats.toArray(new FractAboveStats[0]);
    }

    public static void main(String[] args) throws IOException {
        File jsonFile = new File("/tmp/logic_tree_rate_stats.json");
        BufferedReader reader = new BufferedReader(new FileReader(jsonFile));
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonReader in = gson.newJsonReader((Reader)reader);
        LogicTreeRateStatistics stats = new LogicTreeRateStatistics();
        stats.initFromJSON(in, gson);
        System.out.println(stats.buildTable());
    }

    public static class Builder {
        private double[] thresholds;
        private DataUtils.MinMaxAveTracker[] overallStats;
        private Table<String, String, DataUtils.MinMaxAveTracker[]> branchStats;
        private List<String> levelNames = new ArrayList<String>();
        private List<List<String>> levelValues = new ArrayList<List<String>>();

        public Builder() {
            this(RATE_THRESHOLDS_DEFAULT);
        }

        public Builder(double[] thresholds) {
            Preconditions.checkState((thresholds.length > 0 ? 1 : 0) != 0);
            this.thresholds = thresholds;
            this.overallStats = this.initStats(thresholds);
            this.branchStats = HashBasedTable.create();
        }

        private DataUtils.MinMaxAveTracker[] initStats(double[] statLevels) {
            DataUtils.MinMaxAveTracker[] ret = new DataUtils.MinMaxAveTracker[statLevels.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new DataUtils.MinMaxAveTracker();
            }
            return ret;
        }

        public void process(LogicTreeBranch<?> branch, double[] rates) {
            ArrayList<DataUtils.MinMaxAveTracker[]> tracks = new ArrayList<DataUtils.MinMaxAveTracker[]>(branch.size() + 1);
            tracks.add(this.overallStats);
            for (int i = 0; i < branch.size(); ++i) {
                String level = branch.getLevel(i).getName();
                if (i >= this.levelNames.size()) {
                    this.levelNames.add(level);
                    this.levelValues.add(new ArrayList());
                } else {
                    Preconditions.checkState((boolean)level.equals(this.levelNames.get(i)));
                }
                Object choice = branch.getValue(i);
                if (choice == null) continue;
                String value = choice.getName();
                DataUtils.MinMaxAveTracker[] choiceStats = (DataUtils.MinMaxAveTracker[])this.branchStats.get((Object)level, (Object)value);
                if (choiceStats == null) {
                    choiceStats = this.initStats(this.thresholds);
                    this.branchStats.put((Object)level, (Object)value, (Object)choiceStats);
                    this.levelValues.get(i).add(value);
                }
                tracks.add(choiceStats);
            }
            for (int t = 0; t < this.thresholds.length; ++t) {
                int numAbove = 0;
                for (double rate : rates) {
                    if (!(rate > this.thresholds[t])) continue;
                    ++numAbove;
                }
                double fract = (double)numAbove / (double)rates.length;
                for (DataUtils.MinMaxAveTracker[] track : tracks) {
                    track[t].addValue(fract);
                }
            }
        }

        public LogicTreeRateStatistics build() {
            Preconditions.checkState((this.overallStats[0].getNum() > 0 ? 1 : 0) != 0);
            LogicTreeRateStatistics ret = new LogicTreeRateStatistics();
            ret.thresholds = this.thresholds;
            ret.overallStats = this.tracksToStats(this.overallStats);
            ret.logicTreeLevels = new ArrayList<String>();
            ret.logicTreeValues = new ArrayList<List<String>>();
            ret.logicTreeValueStats = new ArrayList<List<FractAboveStats[]>>();
            for (int l = 0; l < this.levelNames.size(); ++l) {
                String level = this.levelNames.get(l);
                List<String> values = this.levelValues.get(l);
                if (values.size() == 1) continue;
                ret.logicTreeLevels.add(level);
                ret.logicTreeValues.add(values);
                ArrayList<FractAboveStats[]> stats = new ArrayList<FractAboveStats[]>();
                ret.logicTreeValueStats.add(stats);
                for (String value : this.levelValues.get(l)) {
                    stats.add(this.tracksToStats((DataUtils.MinMaxAveTracker[])this.branchStats.get((Object)level, (Object)value)));
                }
            }
            return ret;
        }

        private FractAboveStats[] tracksToStats(DataUtils.MinMaxAveTracker[] tracks) {
            FractAboveStats[] stats = new FractAboveStats[tracks.length];
            for (int i = 0; i < stats.length; ++i) {
                stats[i] = new FractAboveStats(this.thresholds[i], tracks[i].getAverage(), tracks[i].getMin(), tracks[i].getMax());
            }
            return stats;
        }
    }

    public static class FractAboveStats {
        public final double threshold;
        public final double avg;
        public final double min;
        public final double max;

        public FractAboveStats(double threshold, double avg, double min, double max) {
            this.threshold = threshold;
            this.avg = avg;
            this.min = min;
            this.max = max;
        }
    }
}

