/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensha.commons.data.uncertainty.UncertainBoundedIncrMagFreqDist;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.geo.json.FeatureCollection;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.helpers.JSON_TypeAdapterBackedModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchAverageableModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionTargetMFDs;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.util.TectonicRegionType;

public class RegionsOfInterest
implements JSON_TypeAdapterBackedModule<FeatureCollection>,
BranchAverageableModule<RegionsOfInterest> {
    private List<Region> regions;
    private List<IncrementalMagFreqDist> regionalMFDs;
    private List<TectonicRegionType> regionalTRTs;
    public static final String MFD_PROPERTY_NAME = "MFD";
    public static final String TRT_PROPERTY_NAME = "TectonicRegionType";

    private RegionsOfInterest() {
    }

    public RegionsOfInterest(Region ... regions) {
        this(List.of(regions));
    }

    public RegionsOfInterest(List<Region> regions) {
        this(regions, null);
    }

    public RegionsOfInterest(List<Region> regions, List<IncrementalMagFreqDist> regionalMFDs) {
        this(regions, regionalMFDs, null);
    }

    public RegionsOfInterest(List<Region> regions, List<IncrementalMagFreqDist> regionalMFDs, List<TectonicRegionType> regionalTRTs) {
        Preconditions.checkState((!regions.isEmpty() ? 1 : 0) != 0, (Object)"Must supply at least 1 region");
        this.regions = regions;
        Preconditions.checkState((regionalMFDs == null || regionalMFDs.size() == regions.size() ? 1 : 0) != 0, (Object)"If regional MFDs are supplied, there must be exactly one for each region");
        this.regionalMFDs = regionalMFDs;
        Preconditions.checkState((regionalTRTs == null || regionalTRTs.size() == regions.size() ? 1 : 0) != 0, (Object)"If regional TRTs are supplied, there must be exactly one for each region");
        this.regionalTRTs = regionalTRTs;
    }

    @Override
    public String getFileName() {
        return "regions_of_interest.json";
    }

    @Override
    public String getName() {
        return "Regions of Interest";
    }

    @Override
    public Type getType() {
        return FeatureCollection.class;
    }

    @Override
    public FeatureCollection get() {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (int i = 0; i < this.regions.size(); ++i) {
            TectonicRegionType trt;
            IncrementalMagFreqDist mfd;
            Region region = this.regions.get(i);
            Feature feature = region.toFeature();
            if (this.regionalMFDs != null && (mfd = this.regionalMFDs.get(i)) != null) {
                feature.properties.set(MFD_PROPERTY_NAME, mfd);
            }
            if (this.regionalTRTs != null && (trt = this.regionalTRTs.get(i)) != null) {
                feature.properties.set(TRT_PROPERTY_NAME, trt.name());
            }
            features.add(feature);
        }
        return new FeatureCollection(features);
    }

    @Override
    public void set(FeatureCollection features) {
        Preconditions.checkState((!features.features.isEmpty() ? 1 : 0) != 0, (Object)"Must supply at least 1 region");
        this.regions = new ArrayList<Region>();
        this.regionalMFDs = null;
        for (Feature feature : features) {
            String trtName;
            Region region = Region.fromFeature(feature);
            IncrementalMagFreqDist mfd = feature.properties.get(MFD_PROPERTY_NAME, null);
            if (mfd != null) {
                if (this.regionalMFDs == null) {
                    this.regionalMFDs = new ArrayList<IncrementalMagFreqDist>();
                }
                while (this.regionalMFDs.size() < this.regions.size()) {
                    this.regionalMFDs.add(null);
                }
                this.regionalMFDs.add(mfd);
            }
            if ((trtName = feature.properties.getString(TRT_PROPERTY_NAME, null)) != null) {
                TectonicRegionType trt = TectonicRegionType.valueOf(trtName);
                if (this.regionalTRTs == null) {
                    this.regionalTRTs = new ArrayList<TectonicRegionType>();
                }
                while (this.regionalTRTs.size() < this.regions.size()) {
                    this.regionalTRTs.add(null);
                }
                this.regionalTRTs.add(trt);
            }
            this.regions.add(region);
        }
        if (this.regionalMFDs != null) {
            while (this.regionalMFDs.size() < this.regions.size()) {
                this.regionalMFDs.add(null);
            }
        }
        if (this.regionalTRTs != null) {
            while (this.regionalTRTs.size() < this.regions.size()) {
                this.regionalTRTs.add(null);
            }
        }
    }

    @Override
    public void registerTypeAdapters(GsonBuilder builder) {
        builder.registerTypeAdapter(this.getType(), (Object)new FeatureCollection.FeatureCollectionAdapter());
    }

    public List<Region> getRegions() {
        return ImmutableList.copyOf(this.regions);
    }

    public List<IncrementalMagFreqDist> getMFDs() {
        return this.regionalMFDs == null ? null : Collections.unmodifiableList(this.regionalMFDs);
    }

    public List<TectonicRegionType> getTRTs() {
        return this.regionalTRTs == null ? null : Collections.unmodifiableList(this.regionalTRTs);
    }

    public boolean areRegionsIdenticalTo(RegionsOfInterest o) {
        if (this.regions.size() != o.regions.size()) {
            return false;
        }
        for (int i = 0; i < this.regions.size(); ++i) {
            if (this.regions.get(i).equalsRegion(o.regions.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public AverageableModule.AveragingAccumulator<RegionsOfInterest> averagingAccumulator() {
        return new AverageableModule.AveragingAccumulator<RegionsOfInterest>(){
            private List<Region> regions;
            private List<IncrementalMagFreqDist> regionalMFDs;
            private List<String> mfdNames;
            private List<String> mfdBoundNames;
            private List<TectonicRegionType> regionalTRTs;
            private double weightSum = 0.0;

            @Override
            public Class<RegionsOfInterest> getType() {
                return RegionsOfInterest.class;
            }

            @Override
            public void process(RegionsOfInterest module, double relWeight) {
                if (this.regions == null) {
                    this.regions = new ArrayList<Region>(module.regions);
                    if (module.regionalMFDs != null) {
                        this.regionalMFDs = new ArrayList<IncrementalMagFreqDist>();
                        this.mfdNames = new ArrayList<String>();
                        this.mfdBoundNames = new ArrayList<String>();
                        for (IncrementalMagFreqDist mfd : module.regionalMFDs) {
                            if (mfd == null || relWeight == 0.0) {
                                this.regionalMFDs.add(null);
                                this.mfdNames.add(null);
                                this.mfdBoundNames.add(null);
                                continue;
                            }
                            this.regionalMFDs.add(InversionTargetMFDs.Precomputed.buildSameSize(mfd));
                            if (mfd.getName() != null && !mfd.getName().isBlank() && !mfd.getName().equals(mfd.getDefaultName())) {
                                this.mfdNames.add(mfd.getName());
                            } else {
                                this.mfdNames.add(null);
                            }
                            if (mfd instanceof UncertainBoundedIncrMagFreqDist) {
                                UncertainBoundedIncrMagFreqDist bounded = (UncertainBoundedIncrMagFreqDist)mfd;
                                String boundName = bounded.getBoundName();
                                if (boundName != null && !boundName.isBlank() && !boundName.equals(bounded.getDefaultBoundName())) {
                                    this.mfdBoundNames.add(boundName);
                                    continue;
                                }
                                this.mfdBoundNames.add(null);
                                continue;
                            }
                            this.mfdBoundNames.add(null);
                        }
                    } else {
                        this.regionalMFDs = null;
                    }
                    if (module.regionalTRTs != null) {
                        this.regionalTRTs = new ArrayList<TectonicRegionType>();
                        for (TectonicRegionType trt : module.regionalTRTs) {
                            this.regionalTRTs.add(trt);
                        }
                        Preconditions.checkState((this.regionalTRTs.size() == this.regions.size() ? 1 : 0) != 0, (String)"Region has %s regions but TRTs list has only %s", (int)this.regions.size(), (int)this.regionalTRTs.size());
                    } else {
                        this.regionalTRTs = null;
                    }
                }
                Preconditions.checkState((this.regions.size() == module.regions.size() ? 1 : 0) != 0);
                if (this.regionalMFDs != null && module.regionalMFDs == null) {
                    this.regionalMFDs = null;
                }
                if (this.regionalTRTs != null && module.regionalTRTs == null) {
                    this.regionalTRTs = null;
                }
                for (int r = 0; r < this.regions.size(); ++r) {
                    TectonicRegionType newTRT;
                    Preconditions.checkState((boolean)this.regions.get(r).equalsRegion(module.regions.get(r)));
                    if (this.regionalMFDs != null) {
                        if (module.regionalMFDs == null) {
                            System.err.println("ROI-Average: encountered an ROI w/o MFDs, clearing all");
                            this.regionalMFDs = null;
                        } else {
                            IncrementalMagFreqDist mfd;
                            mfd = module.regionalMFDs.get(r);
                            IncrementalMagFreqDist runningMFD = this.regionalMFDs.get(r);
                            if (mfd == null) {
                                if (runningMFD != null) {
                                    System.err.println("ROI-Average: encountered an ROI w/o MFD for region " + r + ", clearing");
                                }
                                this.regionalMFDs.set(r, null);
                            } else if (runningMFD != null) {
                                this.regionalMFDs.set(r, InversionTargetMFDs.Precomputed.averageInWeighted(runningMFD, mfd, "Regional MFD", relWeight));
                                if (this.mfdNames.get(r) != null && !this.mfdNames.get(r).equals(mfd.getName())) {
                                    System.err.println("ROI-Average: MFD name mismatch, clearing MFD for region " + r + ": '" + this.mfdNames.get(r) + "' != '" + mfd.getName() + "'");
                                    this.mfdNames.set(r, null);
                                }
                                if (this.mfdBoundNames.get(r) != null && mfd instanceof UncertainBoundedIncrMagFreqDist && !this.mfdBoundNames.get(r).equals(((UncertainBoundedIncrMagFreqDist)mfd).getBoundName())) {
                                    System.err.println("ROI-Average: MFD bound name mismatch, clearing MFD for region " + r + ": '" + this.mfdBoundNames.get(r) + "' != '" + ((UncertainBoundedIncrMagFreqDist)mfd).getBoundName() + "'");
                                    this.mfdBoundNames.set(r, null);
                                }
                            }
                        }
                    }
                    if (this.regionalTRTs == null) continue;
                    if (module.regionalTRTs == null) {
                        this.regionalTRTs = null;
                        continue;
                    }
                    TectonicRegionType prevTRT = this.regionalTRTs.get(r);
                    if (Objects.equal((Object)prevTRT, (Object)(newTRT = module.regionalTRTs.get(r)))) continue;
                    this.regionalTRTs.set(r, null);
                }
                this.weightSum += relWeight;
            }

            @Override
            public RegionsOfInterest getAverage() {
                boolean hasNonNullMFD = false;
                if (this.regionalMFDs != null) {
                    for (IncrementalMagFreqDist mfd : this.regionalMFDs) {
                        hasNonNullMFD |= mfd != null;
                    }
                }
                if (hasNonNullMFD) {
                    for (int r = 0; r < this.regionalMFDs.size(); ++r) {
                        IncrementalMagFreqDist mfd;
                        mfd = this.regionalMFDs.get(r);
                        if (mfd == null) continue;
                        if (this.mfdNames.get(r) != null) {
                            mfd.setName(this.mfdNames.get(r));
                        }
                        if (this.mfdBoundNames.get(r) != null && mfd instanceof UncertainBoundedIncrMagFreqDist) {
                            ((UncertainBoundedIncrMagFreqDist)mfd).setBoundName(this.mfdBoundNames.get(r));
                        }
                        InversionTargetMFDs.Precomputed.scaleToTotWeight(mfd, this.weightSum);
                    }
                } else {
                    this.regionalMFDs = null;
                }
                boolean hasNonNullTRT = false;
                if (this.regionalTRTs != null) {
                    for (TectonicRegionType trt : this.regionalTRTs) {
                        hasNonNullTRT |= trt != null;
                    }
                }
                if (!hasNonNullTRT) {
                    this.regionalTRTs = null;
                }
                return new RegionsOfInterest(this.regions, this.regionalMFDs, this.regionalTRTs);
            }
        };
    }
}

