/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import java.awt.geom.Point2D;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.LightFixedXFunc;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.SubModule;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;

public class RupMFDsModule
implements CSV_BackedModule,
SubModule<FaultSystemSolution>,
AverageableModule<RupMFDsModule> {
    private DiscretizedFunc[] rupMFDs;
    private FaultSystemSolution parent;
    public static final String FILE_NAME = "rup_mfds.csv";

    private RupMFDsModule() {
    }

    public RupMFDsModule(FaultSystemSolution sol, DiscretizedFunc[] rupMFDs) {
        if (rupMFDs != null) {
            Preconditions.checkNotNull((Object)sol);
            Preconditions.checkState((rupMFDs.length == sol.getRupSet().getNumRuptures() ? 1 : 0) != 0);
        }
        this.parent = sol;
        this.rupMFDs = rupMFDs;
    }

    @Override
    public String getName() {
        return "Rupture MFDs";
    }

    @Override
    public String getFileName() {
        return FILE_NAME;
    }

    @Override
    public CSVFile<?> getCSV() {
        CSVFile<String> csv = new CSVFile<String>(true);
        csv.addLine("Rupture Index", "Magnitude", "Rate");
        for (int r = 0; r < this.rupMFDs.length; ++r) {
            if (this.rupMFDs[r] == null || this.rupMFDs[r].size() == 0) continue;
            for (Point2D pt : this.rupMFDs[r]) {
                csv.addLine("" + r, "" + pt.getX(), "" + pt.getY());
            }
        }
        return csv;
    }

    @Override
    public void initFromCSV(CSVFile<String> csv) {
        Preconditions.checkNotNull((Object)this.parent, (Object)"Cannot init from CSV without parent solution set");
        DiscretizedFunc[] rupMFDs = new DiscretizedFunc[this.parent.getRupSet().getNumRuptures()];
        for (int row = 1; row < csv.getNumRows(); ++row) {
            int r = csv.getInt(row, 0);
            double mag = csv.getDouble(row, 1);
            double rate = csv.getDouble(row, 2);
            if (rupMFDs[r] == null) {
                rupMFDs[r] = new ArbitrarilyDiscretizedFunc();
            }
            Preconditions.checkState((!rupMFDs[r].hasX(mag) ? 1 : 0) != 0, (String)"Duplicate magntiude encountered for rupture %s: %s", (Object)("" + r), (Object)mag);
            rupMFDs[r].set(mag, rate);
        }
        for (int r = 0; r < rupMFDs.length; ++r) {
            if (rupMFDs[r] == null) continue;
            rupMFDs[r] = new LightFixedXFunc(rupMFDs[r]);
        }
        this.rupMFDs = rupMFDs;
    }

    public DiscretizedFunc getRuptureMFD(int rupIndex) {
        return this.rupMFDs[rupIndex];
    }

    public DiscretizedFunc[] getRuptureMFDs() {
        return this.rupMFDs;
    }

    @Override
    public void setParent(FaultSystemSolution parent) throws IllegalStateException {
        if (parent != null && this.parent != null) {
            Preconditions.checkState((boolean)this.parent.getRupSet().isEquivalentTo(parent.getRupSet()), (String)"Can't update parent! New rupture set with numSects=%s and numRups=%s isn't compatible with previous with numSects=%s and numRups=%s", (Object)parent.getRupSet().getNumSections(), (Object)parent.getRupSet().getNumRuptures(), (Object)this.parent.getRupSet().getNumSections(), (Object)this.parent.getRupSet().getNumRuptures());
        }
        if (this.rupMFDs != null) {
            Preconditions.checkState((this.rupMFDs.length == parent.getRupSet().getNumRuptures() ? 1 : 0) != 0, (String)"RupMFDs has %s ruptures, but new parent has %s", (int)this.rupMFDs.length, (int)parent.getRupSet().getNumRuptures());
        }
        this.parent = parent;
    }

    @Override
    public FaultSystemSolution getParent() {
        return this.parent;
    }

    public RupMFDsModule copy(FaultSystemSolution newParent) throws IllegalStateException {
        if (this.parent != null) {
            Preconditions.checkState((boolean)this.parent.getRupSet().isEquivalentTo(newParent.getRupSet()));
        }
        return new RupMFDsModule(newParent, this.rupMFDs);
    }

    @Override
    public AverageableModule.AveragingAccumulator<RupMFDsModule> averagingAccumulator() {
        return new AverageableModule.AveragingAccumulator<RupMFDsModule>(){
            private double sumWeight = 0.0;
            private DiscretizedFunc[] rupMFDs = null;

            @Override
            public void process(RupMFDsModule module, double relWeight) {
                if (this.rupMFDs == null) {
                    this.rupMFDs = new DiscretizedFunc[RupMFDsModule.this.parent.getRupSet().getNumRuptures()];
                }
                this.sumWeight += relWeight;
                for (int r = 0; r < this.rupMFDs.length; ++r) {
                    DiscretizedFunc mfd = module.rupMFDs[r];
                    if (mfd == null || !(mfd.calcSumOfY_Vals() > 0.0)) continue;
                    if (this.rupMFDs[r] == null) {
                        this.rupMFDs[r] = new ArbitrarilyDiscretizedFunc();
                    }
                    for (Point2D pt : mfd) {
                        double x = pt.getX();
                        double y = pt.getY() * relWeight;
                        if (this.rupMFDs[r].hasX(x)) {
                            y += this.rupMFDs[r].getY(x);
                        }
                        this.rupMFDs[r].set(x, y);
                    }
                }
            }

            @Override
            public Class<RupMFDsModule> getType() {
                return RupMFDsModule.class;
            }

            @Override
            public RupMFDsModule getAverage() {
                double scale = 1.0 / this.sumWeight;
                for (DiscretizedFunc mfd : this.rupMFDs) {
                    if (mfd == null) continue;
                    mfd.scale(scale);
                }
                RupMFDsModule avg = new RupMFDsModule();
                avg.rupMFDs = this.rupMFDs;
                return avg;
            }
        };
    }
}

