/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Set;
import org.opensha.commons.util.modules.helpers.JSON_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;

public class RuptureSubSetMappings
implements JSON_BackedModule {
    private BiMap<Integer, Integer> sectIDs_newToOld;
    private BiMap<Integer, Integer> sectIDs_oldToNew;
    private BiMap<Integer, Integer> rupIDs_newToOld;
    private BiMap<Integer, Integer> rupIDs_oldToNew;
    private transient FaultSystemRupSet origRupSet;

    private RuptureSubSetMappings() {
    }

    public RuptureSubSetMappings(BiMap<Integer, Integer> sectIDs_newToOld, BiMap<Integer, Integer> rupIDs_newToOld, FaultSystemRupSet origRupSet) {
        this.sectIDs_newToOld = sectIDs_newToOld;
        this.sectIDs_oldToNew = sectIDs_newToOld.inverse();
        this.rupIDs_newToOld = rupIDs_newToOld;
        this.rupIDs_oldToNew = rupIDs_newToOld.inverse();
        this.origRupSet = origRupSet;
    }

    public int getNumRetainedSects() {
        return this.sectIDs_newToOld.size();
    }

    public Set<Integer> getRetainedOrigSectIDs() {
        return this.sectIDs_newToOld.values();
    }

    public boolean isSectRetained(int origSectID) {
        return this.sectIDs_newToOld.containsValue((Object)origSectID);
    }

    public int getNewSectID(int origSectID) {
        return (Integer)this.sectIDs_oldToNew.get((Object)origSectID);
    }

    public int getOrigSectID(int newSectID) {
        return (Integer)this.sectIDs_newToOld.get((Object)newSectID);
    }

    public int getNumRetainedRuptures() {
        return this.rupIDs_newToOld.size();
    }

    public Set<Integer> getRetainedOrigRupIDs() {
        return this.rupIDs_newToOld.values();
    }

    public boolean isRupRetained(int origRupID) {
        return this.rupIDs_newToOld.containsValue((Object)origRupID);
    }

    public int getNewRupID(int origRupID) {
        return (Integer)this.rupIDs_oldToNew.get((Object)origRupID);
    }

    public int getOrigRupID(int newRupID) {
        return (Integer)this.rupIDs_newToOld.get((Object)newRupID);
    }

    @Override
    public String getName() {
        return "Rupture Subset Mappings";
    }

    @Override
    public String getFileName() {
        return "rupture_sub_set_mappings.json";
    }

    public FaultSystemRupSet getOrigRupSet() {
        return this.origRupSet;
    }

    @Override
    public void writeToJSON(JsonWriter out, Gson gson) throws IOException {
        out.beginObject();
        out.name("sectIDs_newToOld");
        RuptureSubSetMappings.writeBiMapJSON(out, this.sectIDs_newToOld);
        out.name("rupIDs_newToOld");
        RuptureSubSetMappings.writeBiMapJSON(out, this.rupIDs_newToOld);
        out.endObject();
    }

    private static void writeBiMapJSON(JsonWriter out, BiMap<Integer, Integer> map) throws IOException {
        out.beginArray();
        for (Integer key : map.keySet()) {
            out.beginArray();
            out.value((long)key.intValue());
            out.value((long)((Integer)map.get((Object)key)).intValue());
            out.endArray();
        }
        out.endArray();
    }

    private static BiMap<Integer, Integer> readBiMapJSON(JsonReader in) throws IOException {
        HashBiMap map = HashBiMap.create();
        in.beginArray();
        while (in.hasNext()) {
            in.beginArray();
            int key = in.nextInt();
            int val = in.nextInt();
            map.put((Object)key, (Object)val);
            in.endArray();
        }
        in.endArray();
        return map;
    }

    @Override
    public void initFromJSON(JsonReader in, Gson gson) throws IOException {
        in.beginObject();
        block8: while (in.hasNext()) {
            switch (in.nextName()) {
                case "sectIDs_newToOld": {
                    this.sectIDs_newToOld = RuptureSubSetMappings.readBiMapJSON(in);
                    continue block8;
                }
                case "rupIDs_newToOld": {
                    this.rupIDs_newToOld = RuptureSubSetMappings.readBiMapJSON(in);
                    continue block8;
                }
            }
            in.skipValue();
        }
        Preconditions.checkNotNull(this.sectIDs_newToOld);
        Preconditions.checkNotNull(this.rupIDs_newToOld);
        in.endObject();
    }
}

