/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import org.opensha.commons.util.modules.helpers.AbstractDoubleArrayCSV_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchAverageableModule;

public class WaterLevelRates
extends AbstractDoubleArrayCSV_BackedModule.Averageable<WaterLevelRates>
implements BranchAverageableModule<WaterLevelRates> {
    private WaterLevelRates() {
    }

    public WaterLevelRates(double[] waterlevelRates) {
        super(waterlevelRates);
    }

    public double[] subtractFrom(double[] rates) {
        Preconditions.checkState((rates.length == this.values.length ? 1 : 0) != 0);
        double[] ret = new double[rates.length];
        for (int i = 0; i < rates.length; ++i) {
            ret[i] = rates[i] - this.values[i];
            if (ret[i] < 0.0) {
                Preconditions.checkState((ret[i] > -1.0E-10 ? 1 : 0) != 0, (String)"encounted negative rate after adjusting for waterlevl: %s - %s = %s", (Object)rates[i], (Object)this.values[i], (Object)ret[i]);
                ret[i] = 0.0;
                continue;
            }
            if (!(ret[i] < 1.0E-16) && (float)rates[i] != (float)this.values[i]) continue;
            ret[i] = 0.0;
        }
        return ret;
    }

    @Override
    public String getFileName() {
        return "water_level_rates.csv";
    }

    @Override
    public String getName() {
        return "Water Level (pre-inversion minimum) Rates";
    }

    @Override
    protected WaterLevelRates averageInstance(double[] avgValues) {
        return new WaterLevelRates(avgValues);
    }

    @Override
    protected String getIndexHeading() {
        return "Rupture Index";
    }

    @Override
    protected String getValueHeading() {
        return "Water Level Rate";
    }
}

