/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractRupSetPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.RupSetMetadata;

public abstract class AbstractSolutionPlot
extends AbstractRupSetPlot {
    public void writePlot(FaultSystemSolution sol, String name, File outputDir) throws IOException {
        super.writePlot(sol.getRupSet(), sol, name, outputDir);
    }

    @Override
    public List<String> plot(FaultSystemRupSet rupSet, FaultSystemSolution sol, ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        Preconditions.checkNotNull((Object)sol, (Object)"Solution must be supplied for a solution plot");
        return this.plot(sol, meta, resourcesDir, relPathToResources, topLink);
    }

    public List<String> plot(FaultSystemSolution sol, String name, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        return this.plot(sol, new ReportMetadata(new RupSetMetadata(name, sol)), resourcesDir, relPathToResources, topLink);
    }

    public abstract List<String> plot(FaultSystemSolution var1, ReportMetadata var2, File var3, String var4, String var5) throws IOException;
}

