/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.zip.ZipFile;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.ComparablePairing;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.modules.SectSlipRates;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractRupSetPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractSolutionPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.RupSetMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.BiasiWesnouskyPlots;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.CreepingAndParkfieldReport;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.CumulantMagnitudePlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.FaultSectionConnectionsPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.GeneralInfoPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.GriddedDiagnosticPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.HazardMapPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.InversionConfigurationPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.InversionMisfitsPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.InversionProgressPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.JumpAzimuthsPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.JumpCountsOverDistancePlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.LogicTreeBranchPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.ModulesPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.NamedFaultPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.NucleationRatePlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.PaleoDataComparisonPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.ParticipationRatePlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.PlausibilityConfigurationReport;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.PlausibilityFilterPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.RateDistributionPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.RupHistogramPlots;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.RuptureScalingPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.SectBValuePlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.SectBySectDetailPlots;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.SectMaxValuesPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.SegmentationPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.SlipRatePlots;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.SolMFDPlot;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.ScalarCoulombPlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.CumulativeProbPathEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.NucleationClusterEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.PathPlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.ScalarCoulombPathEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.CoulombSectRatioProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RelativeCoulombProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RuptureProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.InputJumpsOrDistClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureConnectionSearch;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCache;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCalculator;
import org.opensha.sha.simulators.stiffness.SubSectStiffnessCalculator;
import scratch.UCERF3.enumTreeBranches.FaultModels;

public class ReportPageGen {
    private ReportMetadata meta;
    private List<AbstractRupSetPlot> plots;
    private File outputDir;
    private File indexDir;
    private double defaultMaxDist = DEFAULT_MAX_DIST;
    private File cacheDir;
    private List<PlausibilityFilter> altFilters = null;
    private boolean replot = false;
    public static PlotLevel PLOT_LEVEL_DEFAULT = PlotLevel.DEFAULT;
    private static final DecimalFormat countDF = AbstractRupSetPlot.countDF;
    private static final DecimalFormat percentDF = AbstractRupSetPlot.percentDF;
    protected static final String META_FILE_NAME = "metadata.json";
    protected static final String PLOT_META_FILE_NAME = "plots.json";
    public static double DEFAULT_MAX_DIST = 10.0;

    public static List<AbstractRupSetPlot> getDefaultRupSetPlots(PlotLevel level) {
        ArrayList<AbstractRupSetPlot> plots = new ArrayList<AbstractRupSetPlot>();
        plots.add(new GeneralInfoPlot());
        plots.add(new LogicTreeBranchPlot());
        plots.add(new RuptureScalingPlot());
        plots.add(new SolMFDPlot());
        plots.add(new PlausibilityConfigurationReport());
        if (level == PlotLevel.DEFAULT || level == PlotLevel.FULL || level == PlotLevel.REVIEW) {
            plots.add(new SlipRatePlots());
            plots.add(new CreepingAndParkfieldReport());
            plots.add(new RupHistogramPlots(RupHistogramPlots.RUP_SET_SCALARS));
            plots.add(new PlausibilityFilterPlot());
            if (level != PlotLevel.REVIEW) {
                plots.add(new ModulesPlot());
            }
            plots.add(new FaultSectionConnectionsPlot());
            plots.add(new JumpCountsOverDistancePlot());
            plots.add(new PaleoDataComparisonPlot());
        } else {
            plots.add(new RupHistogramPlots(RupHistogramPlots.RUP_SET_LIGHT_SCALARS));
        }
        plots.add(new SectMaxValuesPlot(SectMaxValuesPlot.RUP_SET_DEFAULTS));
        if (level == PlotLevel.FULL) {
            plots.add(new JumpAzimuthsPlot());
            plots.add(new BiasiWesnouskyPlots());
        }
        if (level == PlotLevel.DEFAULT || level == PlotLevel.FULL || level == PlotLevel.REVIEW) {
            plots.add(new NamedFaultPlot());
        }
        if (level == PlotLevel.FULL || level == PlotLevel.REVIEW) {
            plots.add(new SectBySectDetailPlots());
        }
        for (AbstractRupSetPlot plot : plots) {
            plot.setPlotLevel(level);
        }
        return plots;
    }

    public static List<AbstractRupSetPlot> getDefaultSolutionPlots(PlotLevel level) {
        ArrayList<AbstractRupSetPlot> plots = new ArrayList<AbstractRupSetPlot>();
        plots.add(new GeneralInfoPlot());
        plots.add(new LogicTreeBranchPlot());
        plots.add(new SolMFDPlot());
        plots.add(new InversionConfigurationPlot());
        plots.add(new InversionProgressPlot());
        plots.add(new RateDistributionPlot());
        if (level == PlotLevel.DEFAULT || level == PlotLevel.FULL) {
            plots.add(new InversionMisfitsPlot());
        }
        plots.add(new ParticipationRatePlot());
        plots.add(new NucleationRatePlot());
        if (level == PlotLevel.DEFAULT || level == PlotLevel.FULL || level == PlotLevel.REVIEW) {
            plots.add(new GriddedDiagnosticPlot());
            plots.add(new SectBValuePlot());
        }
        if (level != PlotLevel.REVIEW) {
            plots.add(new PlausibilityConfigurationReport());
        }
        if (level == PlotLevel.DEFAULT || level == PlotLevel.FULL || level == PlotLevel.REVIEW) {
            plots.add(new RuptureScalingPlot());
            plots.add(new RupHistogramPlots(RupHistogramPlots.SOL_SCALARS));
            plots.add(new SectMaxValuesPlot(SectMaxValuesPlot.SOL_DEFAULTS));
            if (level != PlotLevel.REVIEW) {
                plots.add(new ModulesPlot());
            }
            plots.add(new FaultSectionConnectionsPlot());
            plots.add(new SlipRatePlots());
            plots.add(new CreepingAndParkfieldReport());
            plots.add(new PaleoDataComparisonPlot());
            plots.add(new JumpCountsOverDistancePlot());
        }
        if (level == PlotLevel.FULL) {
            plots.add(new CumulantMagnitudePlot());
            plots.add(new HazardMapPlot());
            plots.add(new SegmentationPlot());
        } else if (level == PlotLevel.DEFAULT || level == PlotLevel.REVIEW) {
            plots.add(new SegmentationPlot(null, new double[]{0.0}));
        }
        if (level == PlotLevel.DEFAULT || level == PlotLevel.FULL || level == PlotLevel.REVIEW) {
            plots.add(new NamedFaultPlot());
        }
        if (level == PlotLevel.FULL || level == PlotLevel.REVIEW) {
            plots.add(new SectBySectDetailPlots());
        }
        for (AbstractRupSetPlot plot : plots) {
            plot.setPlotLevel(level);
        }
        return plots;
    }

    public ReportPageGen(FaultSystemRupSet rupSet, FaultSystemSolution sol, String name, File outputDir, List<AbstractRupSetPlot> plots) {
        this(new ReportMetadata(new RupSetMetadata(name, rupSet, sol)), outputDir, plots);
    }

    public ReportPageGen(ReportMetadata meta, File outputDir, List<AbstractRupSetPlot> plots) {
        this.init(meta, outputDir, plots);
    }

    public ReportPageGen(CommandLine cmd) throws IOException {
        FaultSystemRupSet rupSet;
        File outputDir;
        File inputFile = new File(cmd.getOptionValue("input-file"));
        Preconditions.checkArgument((boolean)inputFile.exists(), (String)"Rupture set file doesn't exist: %s", (Object)inputFile.getAbsolutePath());
        String inputName = cmd.hasOption("name") ? cmd.getOptionValue("name") : inputFile.getName().replaceAll(".zip", "");
        File compareFile = null;
        String compName = null;
        if (cmd.hasOption("compare-to")) {
            compareFile = new File(cmd.getOptionValue("compare-to"));
            Preconditions.checkArgument((boolean)compareFile.exists(), (String)"Rupture set file doesn't exist: %s", (Object)compareFile.getAbsolutePath());
            compName = cmd.hasOption("comp-name") ? cmd.getOptionValue("comp-name") : compareFile.getName().replaceAll(".zip", "");
        }
        if (cmd.hasOption("output-dir")) {
            Preconditions.checkArgument((!cmd.hasOption("reports-dir") ? 1 : 0) != 0, (Object)"Can't supply both --output-dir and --reports-dir");
            outputDir = new File(cmd.getOptionValue("output-dir"));
            Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0, (String)"Output dir doesn't exist and could not be created: %s", (Object)outputDir.getAbsolutePath());
        } else {
            Preconditions.checkArgument((boolean)cmd.hasOption("reports-dir"), (Object)"Must supply either --output-dir or --reports-dir");
            File reportsDir = new File(cmd.getOptionValue("reports-dir"));
            Preconditions.checkState((reportsDir.exists() || reportsDir.mkdir() ? 1 : 0) != 0, (String)"Reports dir doesn't exist and could not be created: %s", (Object)reportsDir.getAbsolutePath());
            this.indexDir = new File(reportsDir, inputFile.getName().replaceAll(".zip", ""));
            Preconditions.checkState((this.indexDir.exists() || this.indexDir.mkdir() ? 1 : 0) != 0);
            outputDir = compareFile == null ? this.indexDir : new File(this.indexDir, "comp_" + compareFile.getName().replaceAll(".zip", ""));
            Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        }
        FaultSystemSolution sol = null;
        FaultSystemRupSet compRupSet = null;
        FaultSystemSolution compSol = null;
        System.out.println("Loading input");
        ZipFile inputZip = new ZipFile(inputFile);
        if (FaultSystemSolution.isSolution(inputZip)) {
            System.out.println("Input is a solution");
            sol = FaultSystemSolution.load(inputZip);
            rupSet = sol.getRupSet();
        } else {
            rupSet = FaultSystemRupSet.load(inputZip);
        }
        if (compareFile != null) {
            System.out.println("Loading comparison");
            ZipFile compZip = new ZipFile(compareFile);
            if (FaultSystemSolution.isSolution(compZip)) {
                System.out.println("comp is a solution");
                compSol = FaultSystemSolution.load(compZip);
                compRupSet = compSol.getRupSet();
            } else {
                compRupSet = FaultSystemRupSet.load(compZip);
            }
        }
        RupSetMetadata primaryMeta = new RupSetMetadata(inputName, rupSet, sol);
        RupSetMetadata comparisonMeta = null;
        if (compRupSet != null) {
            comparisonMeta = new RupSetMetadata(compName, compRupSet, compSol);
        }
        ReportMetadata meta = new ReportMetadata(primaryMeta, comparisonMeta);
        PlotLevel level = PLOT_LEVEL_DEFAULT;
        if (cmd.hasOption("plot-level")) {
            level = PlotLevel.valueOf(cmd.getOptionValue("plot-level").trim().toUpperCase());
        }
        List<AbstractRupSetPlot> plots = sol != null ? ReportPageGen.getDefaultSolutionPlots(level) : ReportPageGen.getDefaultRupSetPlots(level);
        if (cmd.hasOption("skip-sect-by-sect")) {
            int i = plots.size();
            while (--i >= 0) {
                if (!(plots.get(i) instanceof SectBySectDetailPlots)) continue;
                plots.remove(i);
            }
        }
        if (cmd.hasOption("default-max-dist")) {
            this.defaultMaxDist = Double.parseDouble(cmd.getOptionValue("default-max-dist"));
        }
        this.cacheDir = FaultSysTools.getCacheDir(cmd);
        this.replot = cmd.hasOption("replot");
        this.init(meta, outputDir, plots);
        this.setNumThreads(FaultSysTools.getNumThreads(cmd));
        if (cmd.hasOption("skip-plausibility")) {
            this.skipPlausibility();
        } else if (cmd.hasOption("alt-plausibility")) {
            this.attachDefaultModules(primaryMeta, true);
            File altPlausibilityCompareFile = new File(cmd.getOptionValue("alt-plausibility"));
            Preconditions.checkState((boolean)altPlausibilityCompareFile.exists(), (String)"Alt-plausibility file doesn't exist: %s", (Object)altPlausibilityCompareFile.getAbsolutePath());
            ClusterConnectionStrategy primaryStrat = null;
            if (primaryMeta.rupSet.hasModule(PlausibilityConfiguration.class)) {
                primaryStrat = primaryMeta.rupSet.getModule(PlausibilityConfiguration.class).getConnectionStrategy();
            }
            this.altFilters = PlausibilityConfiguration.readFiltersJSON(altPlausibilityCompareFile, primaryStrat, primaryMeta.rupSet.getModule(SectionDistanceAzimuthCalculator.class));
            this.setAltPlausibility(this.altFilters, null, false);
        }
    }

    public void setNumThreads(int threads) {
        for (AbstractRupSetPlot plot : this.plots) {
            plot.setNumThreads(threads);
        }
    }

    public void setAltPlausibility(List<PlausibilityFilter> altFilters, String altName, boolean applyToComparison) {
        int insertionIndex = -1;
        for (int i = 0; i < this.plots.size(); ++i) {
            if (!(this.plots.get(i) instanceof PlausibilityFilterPlot)) continue;
            insertionIndex = i + 1;
        }
        if (insertionIndex < 0) {
            insertionIndex = this.plots.size();
        }
        this.plots.add(new PlausibilityFilterPlot(altFilters, altName, applyToComparison));
    }

    public void skipPlausibility() {
        int i = this.plots.size();
        while (--i >= 0) {
            if (!(this.plots.get(i) instanceof PlausibilityFilterPlot)) continue;
            this.plots.remove(i);
        }
    }

    public void skipSectBySect() {
        int i = this.plots.size();
        while (--i >= 0) {
            if (!(this.plots.get(i) instanceof SectBySectDetailPlots)) continue;
            this.plots.remove(i);
        }
    }

    private void init(ReportMetadata meta, File outputDir, List<AbstractRupSetPlot> plots) {
        this.meta = meta;
        this.outputDir = outputDir;
        this.plots = plots;
        if (this.cacheDir == null) {
            this.cacheDir = FaultSysTools.getCacheDir();
        }
    }

    public List<? extends AbstractRupSetPlot> getPlots() {
        return this.plots;
    }

    public void setPlots(List<AbstractRupSetPlot> plots) {
        this.plots = plots;
    }

    public void setReplot(boolean replot) {
        this.replot = replot;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public File getIndexDir() {
        return this.indexDir;
    }

    public void setIndexDir(File indexDir) {
        this.indexDir = indexDir;
    }

    public double getDefaultMaxDist() {
        return this.defaultMaxDist;
    }

    public void setDefaultMaxDist(double defaultMaxDist) {
        this.defaultMaxDist = defaultMaxDist;
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public void setCacheDir(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    public ReportMetadata getMeta() {
        return this.meta;
    }

    private void attachDefaultModules(RupSetMetadata meta, boolean loadCoulomb) throws IOException {
        ReportPageGen.attachDefaultModules(meta, this.cacheDir, this.defaultMaxDist);
        if (this.cacheDir != null && this.cacheDir.exists() && loadCoulomb) {
            this.loadCoulombCache(this.cacheDir);
        }
    }

    public static void attachDefaultModules(RupSetMetadata meta, File cacheDir, double defaultMaxDist) throws IOException {
        File distCache;
        final FaultSystemRupSet rupSet = meta.rupSet;
        SectionDistanceAzimuthCalculator distAzCalc = rupSet.getModule(SectionDistanceAzimuthCalculator.class);
        PlausibilityConfiguration config = rupSet.getModule(PlausibilityConfiguration.class);
        if (config == null) {
            FaultModels fm;
            if (distAzCalc == null) {
                distAzCalc = new SectionDistanceAzimuthCalculator(rupSet.getFaultSectionDataList());
                rupSet.addModule(distAzCalc);
            }
            if ((fm = ReportPageGen.getUCERF3FM(rupSet)) != null && (rupSet.getNumRuptures() == 253706 || rupSet.getNumRuptures() == 305709)) {
                try {
                    config = PlausibilityConfiguration.getUCERF3(rupSet.getFaultSectionDataList(), distAzCalc, fm);
                    rupSet.addModule(config);
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
        } else if (distAzCalc == null) {
            distAzCalc = config.getDistAzCalc();
            rupSet.addModule(distAzCalc);
        }
        if (!rupSet.hasModule(RuptureConnectionSearch.class)) {
            rupSet.addModule(new RuptureConnectionSearch(rupSet, distAzCalc, ReportPageGen.getSearchMaxJumpDist(config), false));
        }
        if (!rupSet.hasAvailableModule(ClusterRuptures.class)) {
            rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<ClusterRuptures>(){

                @Override
                public ClusterRuptures call() throws Exception {
                    return ClusterRuptures.instance(rupSet, rupSet.requireModule(RuptureConnectionSearch.class));
                }
            }, ClusterRuptures.class);
        }
        if (config == null) {
            ClusterRuptures cRups = rupSet.getModule(ClusterRuptures.class);
            int maxNumSplays = 0;
            for (int r = 0; r < cRups.size(); ++r) {
                ClusterRupture rup = cRups.get(r);
                maxNumSplays = Integer.max(maxNumSplays, rup.getTotalNumSplays());
            }
            config = new PlausibilityConfiguration(null, 0, ReportPageGen.buildDefaultConnStrat(distAzCalc, meta.jumps, defaultMaxDist), distAzCalc);
        }
        if (cacheDir != null && cacheDir.exists() && (distCache = new File(cacheDir, distAzCalc.getDefaultCacheFileName())).exists()) {
            distAzCalc.loadCacheFile(distCache);
        }
    }

    static FaultModels getUCERF3FM(FaultSystemRupSet rupSet) {
        if (rupSet.getNumRuptures() == 253706) {
            return FaultModels.FM3_1;
        }
        if (rupSet.getNumRuptures() == 305709) {
            return FaultModels.FM3_2;
        }
        if (rupSet.hasModule(LogicTreeBranch.class)) {
            LogicTreeBranch branch = rupSet.getModule(LogicTreeBranch.class);
            return branch.getValue(FaultModels.class);
        }
        return null;
    }

    private static double getSearchMaxJumpDist(PlausibilityConfiguration config) {
        if (config == null) {
            return 100.0;
        }
        ClusterConnectionStrategy connStrat = config.getConnectionStrategy();
        double maxDist = connStrat.getMaxJumpDist();
        if (Double.isFinite(maxDist)) {
            return maxDist;
        }
        return 100.0;
    }

    public static ClusterConnectionStrategy buildDefaultConnStrat(SectionDistanceAzimuthCalculator distAzCalc, Set<Jump> jumps, double defaultMaxDist) {
        System.err.println("WARNING: primary rupture set doesn't have a connection strategy, using actual connections, plus any up to the fallback maxDist=" + (float)defaultMaxDist + " km. This may be used by plausibilty filters or segmentation plots. Override with --default-max-dist <dist>");
        return new InputJumpsOrDistClusterConnectionStrategy(distAzCalc.getSubSections(), distAzCalc, defaultMaxDist, jumps);
    }

    public void loadCoulombCache(File cacheDir) throws IOException {
        PlausibilityConfiguration compConfig;
        HashMap<String, List<AggregatedStiffnessCache>> loadedCoulombCaches = new HashMap<String, List<AggregatedStiffnessCache>>();
        PlausibilityConfiguration primaryConfig = this.meta.primary.rupSet.getModule(PlausibilityConfiguration.class);
        if (primaryConfig != null) {
            ReportPageGen.checkLoadCoulombCache(primaryConfig.getFilters(), cacheDir, loadedCoulombCaches);
        }
        PlausibilityConfiguration plausibilityConfiguration = compConfig = this.meta.comparison == null ? null : this.meta.comparison.rupSet.getModule(PlausibilityConfiguration.class);
        if (compConfig != null) {
            ReportPageGen.checkLoadCoulombCache(compConfig.getFilters(), cacheDir, loadedCoulombCaches);
        }
        if (this.altFilters != null) {
            ReportPageGen.checkLoadCoulombCache(this.altFilters, cacheDir, loadedCoulombCaches);
        }
    }

    public static void checkLoadCoulombCache(List<PlausibilityFilter> filters, File cacheDir, Map<String, List<AggregatedStiffnessCache>> loadedCoulombCaches) throws IOException {
        if (filters == null) {
            return;
        }
        for (PlausibilityFilter filter : filters) {
            List<AggregatedStiffnessCache> caches;
            SubSectStiffnessCalculator stiffnessCalc;
            AggregatedStiffnessCache cache;
            String cacheName;
            File cacheFile;
            AggregatedStiffnessCalculator agg = null;
            if (filter instanceof ScalarCoulombPlausibilityFilter) {
                agg = ((ScalarCoulombPlausibilityFilter)filter).getAggregator();
            } else if (filter instanceof PathPlausibilityFilter) {
                PathPlausibilityFilter pFilter = (PathPlausibilityFilter)filter;
                for (NucleationClusterEvaluator eval : pFilter.getEvaluators()) {
                    if (eval instanceof ScalarCoulombPathEvaluator) {
                        agg = ((ScalarCoulombPathEvaluator)eval).getAggregator();
                        break;
                    }
                    if (!(eval instanceof CumulativeProbPathEvaluator)) continue;
                    for (RuptureProbabilityCalc calc : ((CumulativeProbPathEvaluator)eval).getCalcs()) {
                        if (calc instanceof CoulombSectRatioProb) {
                            agg = ((CoulombSectRatioProb)calc).getAggregator();
                            break;
                        }
                        if (!(calc instanceof RelativeCoulombProb)) continue;
                        agg = ((RelativeCoulombProb)calc).getAggregator();
                        break;
                    }
                    if (agg != null) break;
                }
            }
            if (agg == null || !(cacheFile = new File(cacheDir, cacheName = (cache = (stiffnessCalc = agg.getCalc()).getAggregationCache(agg.getType())).getCacheFileName())).exists()) continue;
            if (loadedCoulombCaches.containsKey(cacheName)) {
                caches = loadedCoulombCaches.get(cacheName);
                boolean found = false;
                for (AggregatedStiffnessCache oCache : caches) {
                    if (oCache != cache) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    cache.copyCacheFrom(cache);
                    caches.add(cache);
                }
            }
            if (loadedCoulombCaches.containsKey(cacheName) || !cacheFile.exists()) continue;
            cache.loadCacheFile(cacheFile);
            caches = new ArrayList<AggregatedStiffnessCache>();
            caches.add(cache);
            loadedCoulombCaches.put(cacheName, caches);
        }
    }

    private static final String countPercentStr(Number count, Number total) {
        Object ret = count instanceof Integer ? countDF.format(count) : "" + count.floatValue();
        ret = (String)ret + " (";
        double fract = count.doubleValue() / total.doubleValue();
        ret = (String)ret + percentDF.format(fract);
        return (String)ret + ")";
    }

    private static MarkdownUtils.TableBuilder getHeaderTable(RupSetMetadata primary, ReportMetadata.RupSetOverlap primaryOverlap, RupSetMetadata comparison, ReportMetadata.RupSetOverlap comparisonOverlap) {
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        if (comparison != null) {
            table.addLine("", "Primary", "Comparison: " + comparison.name);
        }
        table.initNewLine();
        table.addColumn("**Num Sections**");
        table.addColumn(countDF.format(primary.rupSet.getFaultSectionDataList().size()));
        if (comparison != null) {
            table.addColumn(countDF.format(comparison.rupSet.getFaultSectionDataList().size()));
        }
        table.finalizeLine();
        table.initNewLine();
        table.addColumn("**Num Ruptures**");
        table.addColumn(countDF.format(primary.numRuptures));
        if (comparison != null) {
            table.addColumn(countDF.format(comparison.numRuptures));
        }
        table.finalizeLine();
        if (primary.numSingleStrandRuptures != primary.numRuptures || comparison != null && comparison.numSingleStrandRuptures != comparison.numRuptures) {
            table.initNewLine();
            table.addColumn("**Num Single-Stranded Ruptures**");
            table.addColumn(ReportPageGen.countPercentStr(primary.numSingleStrandRuptures, primary.numRuptures));
            if (comparison != null) {
                table.addColumn(ReportPageGen.countPercentStr(comparison.numSingleStrandRuptures, comparison.numRuptures));
            }
            table.finalizeLine();
        }
        if (comparison != null) {
            table.initNewLine();
            table.addColumn("**Num Unique Ruptures**");
            table.addColumn(ReportPageGen.countPercentStr(primaryOverlap.numUniqueRuptures, primary.numRuptures));
            table.addColumn(ReportPageGen.countPercentStr(comparisonOverlap.numUniqueRuptures, comparison.numRuptures));
            table.finalizeLine();
        }
        if (primary.sol != null || comparison != null && comparison.sol != null) {
            table.initNewLine();
            table.addColumn("**Total Supra-Seis Rupture Rate**");
            if (primary.sol == null) {
                table.addColumn("_N/A_");
            } else {
                table.addColumn(Float.valueOf((float)primary.totalRate));
            }
            if (comparison != null) {
                if (comparison.sol == null) {
                    table.addColumn("_N/A_");
                } else {
                    table.addColumn(Float.valueOf((float)comparison.totalRate));
                }
            }
            table.finalizeLine();
            if (comparison != null && (primaryOverlap.numUniqueRuptures > 0 || comparisonOverlap.numUniqueRuptures > 0)) {
                table.initNewLine();
                table.addColumn("**Unique Rupture Rate**");
                if (primary.sol == null) {
                    table.addColumn("_N/A_");
                } else {
                    table.addColumn(ReportPageGen.countPercentStr(primaryOverlap.uniqueRuptureRate, primary.totalRate));
                }
                if (comparison.sol == null) {
                    table.addColumn("_N/A_");
                } else {
                    table.addColumn(ReportPageGen.countPercentStr(comparisonOverlap.uniqueRuptureRate, comparison.totalRate));
                }
                table.finalizeLine();
            }
            table.initNewLine();
            table.addColumn("**Total Supra-Seis Recurrence Interval**");
            if (primary.sol == null) {
                table.addColumn("_N/A_");
            } else {
                table.addColumn(AbstractRupSetPlot.twoDigits.format(1.0 / primary.totalRate) + " yrs");
            }
            if (comparison != null) {
                if (comparison.sol == null) {
                    table.addColumn("_N/A_");
                } else {
                    table.addColumn(AbstractRupSetPlot.twoDigits.format(1.0 / comparison.totalRate) + " yrs");
                }
            }
            table.finalizeLine();
            table.initNewLine();
            table.addColumn("**Solution Total Moment Rate**");
            if (primary.sol == null) {
                table.addColumn("_N/A_");
            } else {
                table.addColumn(ReportPageGen.momentRateStr(primary.sol.getTotalFaultSolutionMomentRate()));
            }
            if (comparison != null) {
                if (comparison.sol == null) {
                    table.addColumn("_N/A_");
                } else {
                    table.addColumn(ReportPageGen.momentRateStr(comparison.sol.getTotalFaultSolutionMomentRate()));
                }
            }
            table.finalizeLine();
        }
        if (primary.rupSet != null) {
            table.initNewLine();
            table.addColumn("**Target Total Moment Rate**");
            table.addColumn(ReportPageGen.momentRateStr(primary.rupSet.requireModule(SectSlipRates.class).calcTotalMomentRate()));
            if (comparison != null) {
                table.addColumn(ReportPageGen.momentRateStr(comparison.rupSet.requireModule(SectSlipRates.class).calcTotalMomentRate()));
            }
            table.finalizeLine();
            table.initNewLine();
            table.addColumn("**Deformation Model Creep-Reduced Total Moment Rate**");
            table.addColumn(ReportPageGen.momentRateStr(ReportPageGen.dmMomentRate(primary.rupSet.getFaultSectionDataList(), true)));
            if (comparison != null) {
                table.addColumn(ReportPageGen.momentRateStr(ReportPageGen.dmMomentRate(comparison.rupSet.getFaultSectionDataList(), true)));
            }
            table.finalizeLine();
            table.initNewLine();
            table.addColumn("**Deformation Model Original Total Moment Rate**");
            table.addColumn(ReportPageGen.momentRateStr(ReportPageGen.dmMomentRate(primary.rupSet.getFaultSectionDataList(), false)));
            if (comparison != null) {
                table.addColumn(ReportPageGen.momentRateStr(ReportPageGen.dmMomentRate(comparison.rupSet.getFaultSectionDataList(), false)));
            }
            table.finalizeLine();
            table.initNewLine();
            table.addColumn("**Magnitude Range**");
            table.addColumn(ReportPageGen.magRange(primary.rupSet));
            if (comparison != null) {
                table.addColumn(ReportPageGen.magRange(comparison.rupSet));
            }
            table.finalizeLine();
            table.initNewLine();
            table.addColumn("**Length Range**");
            table.addColumn(ReportPageGen.lengthRange(primary.rupSet));
            if (comparison != null) {
                table.addColumn(ReportPageGen.lengthRange(comparison.rupSet));
            }
            table.finalizeLine();
            table.initNewLine();
            table.addColumn("**Rupture Section Count Range**");
            table.addColumn(ReportPageGen.sectRange(primary.rupSet));
            if (comparison != null) {
                table.addColumn(ReportPageGen.sectRange(comparison.rupSet));
            }
            table.finalizeLine();
        }
        return table;
    }

    private static double dmMomentRate(List<? extends FaultSection> subSects, boolean creepReduced) {
        double moRate = 0.0;
        for (FaultSection faultSection : subSects) {
            moRate += faultSection.calcMomentRate(creepReduced);
        }
        return moRate;
    }

    private static String momentRateStr(double moRate) {
        Object str = "" + (float)moRate;
        str = ((String)str).toLowerCase();
        return (String)str + " N-m/yr";
    }

    public void generatePage() throws IOException {
        boolean loadCoulomb = false;
        for (AbstractRupSetPlot plot : this.plots) {
            if (!(plot instanceof PlausibilityFilterPlot)) continue;
            loadCoulomb = true;
        }
        this.attachDefaultModules(this.meta.primary, loadCoulomb);
        if (this.meta.comparison != null) {
            this.attachDefaultModules(this.meta.comparison, loadCoulomb);
        }
        Preconditions.checkState((this.outputDir.exists() || this.outputDir.mkdir() ? 1 : 0) != 0, (String)"Could not create output directory: %s", (Object)this.outputDir.getAbsolutePath());
        File resourcesDir = new File(this.outputDir, "resources");
        Preconditions.checkState((resourcesDir.exists() || resourcesDir.mkdir() ? 1 : 0) != 0, (String)"Could not create resources directory: %s", (Object)resourcesDir.getAbsolutePath());
        String relPathToResources = resourcesDir.getName();
        boolean solution = this.meta.primary.sol != null;
        ArrayList<String> headerLines = new ArrayList<String>();
        if (solution) {
            headerLines.add("# Solution Report: " + this.meta.primary.name);
        } else {
            headerLines.add("# Rupture Set Report: " + this.meta.primary.name);
        }
        headerLines.add("");
        headerLines.addAll(ReportPageGen.getHeaderTable(this.meta.primary, this.meta.primaryOverlap, this.meta.comparison, this.meta.comparisonOverlap).build());
        headerLines.add("");
        String topLink = "_[(top)](#table-of-contents)_";
        File plotMetaFile = new File(this.outputDir, PLOT_META_FILE_NAME);
        boolean firstTime = !plotMetaFile.exists();
        PlotsMetadata prevMeta = null;
        if (!firstTime && !this.replot) {
            prevMeta = ReportPageGen.loadPlotMetadata(plotMetaFile);
        }
        ArrayList<PlotMetadata> plotMetas = new ArrayList<PlotMetadata>();
        PlotsMetadata plotMeta = new PlotsMetadata(headerLines, plotMetas);
        for (AbstractRupSetPlot plot : this.plots) {
            PlotMetadata prev;
            if (prevMeta != null && (prev = prevMeta.getPlot(plot.getClass())) != null) {
                System.out.println("Already have plot '" + plot.getName() + "', won't regenerate. Force regeneration with --replot option.");
                plotMetas.add(prev);
                continue;
            }
            String plotName = ClassUtils.getClassNameWithoutPackage(plot.getClass());
            if (!solution && plot instanceof AbstractSolutionPlot) {
                System.out.println("Skipping " + plotName + " as we only have a rupture set");
                continue;
            }
            Collection<Class<? extends OpenSHA_Module>> required = plot.getRequiredModules();
            if (required != null && !required.isEmpty()) {
                boolean hasRequired = true;
                for (Class<? extends OpenSHA_Module> module : required) {
                    if (this.meta.primary.rupSet.hasModule(module) || solution && this.meta.primary.sol.hasModule(module)) continue;
                    hasRequired = false;
                    System.out.println("Rupture set doesn't have required module " + ClassUtils.getClassNameWithoutPackage(module) + ", skipping plot: " + plotName);
                    break;
                }
                if (!hasRequired) continue;
            }
            plot.setSubHeading("###");
            System.out.println("Generating plot: " + plotName);
            try {
                List<String> plotLines = plot.plot(this.meta.primary.rupSet, this.meta.primary.sol, this.meta, resourcesDir, relPathToResources, topLink);
                if (plotLines != null && !plotLines.isEmpty()) {
                    plotMetas.add(new PlotMetadata(plot.getName(), plot.getClass().getName(), plotLines));
                }
                if (!firstTime) continue;
                System.out.println("Writing intermediate markdown following " + plotName);
                ReportPageGen.writeMarkdown(this.outputDir, this.meta, plotMeta, topLink);
            }
            catch (Exception e) {
                System.err.println("Error processing plot (skipping): " + plotName);
                e.printStackTrace();
                System.err.flush();
            }
        }
        System.out.println("DONE building report, writing markdown and HTML");
        if (this.indexDir != null) {
            MarkdownUtils.TableBuilder table;
            ArrayList<String> compLines;
            String compTopLink = "*[(back to comparisons table)](#" + MarkdownUtils.getAnchorName("Comparisons Table") + ")*";
            if (this.indexDir == this.outputDir) {
                compLines = new ArrayList<String>();
                table = this.buildComparisonsTable(compLines, compTopLink);
                if (table != null) {
                    plotMeta.comparisonsTable = table;
                    plotMeta.comparisonLines = compLines;
                }
                ReportPageGen.writeMarkdown(this.outputDir, this.meta, plotMeta, topLink);
            } else {
                ReportPageGen.writeMarkdown(this.outputDir, this.meta, plotMeta, topLink);
                System.out.println("Writing top-level index with comparisons table");
                compLines = new ArrayList();
                table = this.buildComparisonsTable(compLines, compTopLink);
                if (table != null) {
                    PlotsMetadata topLevel;
                    File topLevelMeta = new File(this.indexDir, PLOT_META_FILE_NAME);
                    if (topLevelMeta.exists()) {
                        topLevel = ReportPageGen.loadPlotMetadata(topLevelMeta);
                    } else {
                        headerLines = new ArrayList();
                        if (solution) {
                            headerLines.add("# Solution Report: " + this.meta.primary.name);
                        } else {
                            headerLines.add("# Rupture Set Report: " + this.meta.primary.name);
                        }
                        headerLines.add("");
                        headerLines.addAll(ReportPageGen.getHeaderTable(this.meta.primary, null, null, null).build());
                        headerLines.add("");
                        topLevel = new PlotsMetadata(headerLines, new ArrayList<PlotMetadata>());
                    }
                    topLevel.comparisonsTable = table;
                    topLevel.comparisonLines = compLines;
                    ReportPageGen.writeMarkdown(this.indexDir, null, topLevel, topLink);
                }
            }
        } else {
            ReportPageGen.writeMarkdown(this.outputDir, this.meta, plotMeta, topLink);
        }
    }

    private MarkdownUtils.TableBuilder buildComparisonsTable(List<String> lines, String topLink) throws IOException {
        Preconditions.checkNotNull((Object)this.indexDir, (Object)"Must have an index to build comparisons");
        HashMap<File, ReportMetadata> comparisonsMap = new HashMap<File, ReportMetadata>();
        HashMap<File, String> comparisonNamesMap = new HashMap<File, String>();
        HashMap<File, PlotsMetadata> plotMetasMap = new HashMap<File, PlotsMetadata>();
        for (File subDir : this.indexDir.listFiles()) {
            File resourcesDir;
            File plotMetaFile;
            File reportMetaFile;
            if (!subDir.isDirectory() || !(reportMetaFile = new File(subDir, META_FILE_NAME)).exists() || !(plotMetaFile = new File(subDir, PLOT_META_FILE_NAME)).exists() || !(resourcesDir = new File(subDir, "resources")).exists()) continue;
            ReportMetadata meta = ReportPageGen.loadReportMetadata(reportMetaFile);
            if (meta.comparison == null) {
                System.out.println("WARNING: found valid plots in sub-directory, but not a comparison (skipping): " + subDir.getAbsolutePath());
                continue;
            }
            System.out.println("Found comparison to " + meta.comparison.name + " in " + subDir.getAbsolutePath());
            PlotsMetadata plotMeta = ReportPageGen.loadPlotMetadata(plotMetaFile);
            comparisonNamesMap.put(subDir, meta.comparison.name);
            comparisonsMap.put(subDir, meta);
            plotMetasMap.put(subDir, plotMeta);
        }
        if (comparisonsMap.isEmpty()) {
            return null;
        }
        List<File> subDirs = ComparablePairing.getSortedData(comparisonNamesMap);
        MarkdownUtils.TableBuilder compTable = MarkdownUtils.tableBuilder();
        compTable.addLine("*Name*", "*Num Ruptures*", "*% Change*", "% Overlap (of primary)", "*Num Connections*", "*% Change*");
        lines.add("## Comparison Details");
        lines.add(topLink);
        lines.add("");
        for (File subDir : subDirs) {
            ReportMetadata meta = (ReportMetadata)comparisonsMap.get(subDir);
            String compLink = "**[" + meta.comparison.name + "](#" + MarkdownUtils.getAnchorName(meta.comparison.name) + ")** [(full page)](" + subDir.getName() + "/README.md)";
            Object rupPercent = percentDF.format((double)(meta.comparison.numRuptures - meta.primary.numRuptures) / (double)meta.primary.numRuptures);
            if (!((String)rupPercent).startsWith("-")) {
                rupPercent = "+" + (String)rupPercent;
            }
            String overlapPercent = percentDF.format((double)meta.comparisonOverlap.numCommonRuptures / (double)meta.primary.numRuptures);
            Object connPercent = percentDF.format((double)(meta.comparison.actualConnections - meta.primary.actualConnections) / (double)meta.primary.actualConnections);
            if (!((String)connPercent).startsWith("-")) {
                connPercent = "+" + (String)connPercent;
            }
            compTable.addLine(new String[]{compLink, countDF.format(meta.comparison.numRuptures), rupPercent, overlapPercent, countDF.format(meta.comparison.actualConnections), connPercent});
            PlotsMetadata plotsMeta = (PlotsMetadata)plotMetasMap.get(subDir);
            File resourcesDir = new File(subDir, "resources");
            String relPath = subDir.getName() + "/" + resourcesDir.getName();
            lines.add("### " + meta.comparison.name);
            lines.add(topLink);
            lines.add("");
            lines.addAll(ReportPageGen.getHeaderTable(meta.primary, meta.primaryOverlap, meta.comparison, meta.comparisonOverlap).build());
            lines.add("");
            for (PlotMetadata plotMeta : plotsMeta.plots) {
                AbstractRupSetPlot plot;
                try {
                    Class<?> clazz = Class.forName(plotMeta.plotClassName);
                    plot = (AbstractRupSetPlot)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException e) {
                    System.out.println("Skipping summary for unkown comparison plot (" + plotMeta.plotName + "): " + e.getMessage());
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.flush();
                    System.out.println("Skipping summary plot (see above error): " + plotMeta.plotName);
                    continue;
                }
                System.out.println("Getting summary for " + plotMeta.plotName);
                plot.setSubHeading("####");
                List<String> summary = plot.getSummary(meta, resourcesDir, relPath, topLink);
                if (summary == null || summary.isEmpty()) continue;
                lines.addAll(summary);
                lines.add("");
            }
        }
        return compTable;
    }

    private static void writeMarkdown(File outputDir, ReportMetadata meta, PlotsMetadata plotMeta, String topLink) throws IOException {
        ArrayList<String> lines = new ArrayList<String>(plotMeta.headerLines);
        if (plotMeta.comparisonsTable != null) {
            lines.add("");
            lines.add("## Comparisons Table");
            lines.add("");
            lines.addAll(plotMeta.comparisonsTable.build());
            lines.add("");
        }
        int tocIndex = lines.size();
        for (PlotMetadata plot : plotMeta.plots) {
            if (plot.markdown == null || plot.markdown.isEmpty()) continue;
            lines.add("## " + plot.plotName);
            lines.add(topLink);
            lines.add("");
            lines.addAll(plot.markdown);
            lines.add("");
        }
        if (plotMeta.comparisonLines != null && !plotMeta.comparisonLines.isEmpty()) {
            lines.add("");
            lines.addAll(plotMeta.comparisonLines);
        }
        lines.addAll(tocIndex, MarkdownUtils.buildTOC(lines, 2, 3));
        lines.add(tocIndex, "## Table Of Contents");
        MarkdownUtils.writeReadmeAndHTML(lines, outputDir);
        System.out.println("Writing JSON metadata");
        if (meta != null) {
            ReportPageGen.writeMetadataJSON(meta, new File(outputDir, META_FILE_NAME));
            ReportPageGen.writeMetadataJSON(plotMeta, new File(outputDir, PLOT_META_FILE_NAME));
        }
    }

    private static Gson buildMetaGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.serializeSpecialFloatingPointValues();
        builder.setPrettyPrinting();
        return builder.create();
    }

    private static void writeMetadataJSON(Object meta, File jsonFile) throws IOException {
        Gson gson = ReportPageGen.buildMetaGson();
        FileWriter fw = new FileWriter(jsonFile);
        gson.toJson(meta, (Appendable)fw);
        fw.write("\n");
        fw.close();
    }

    private static ReportMetadata loadReportMetadata(File jsonFile) throws IOException {
        Gson gson = ReportPageGen.buildMetaGson();
        BufferedReader reader = new BufferedReader(new FileReader(jsonFile));
        return (ReportMetadata)gson.fromJson((Reader)reader, ReportMetadata.class);
    }

    private static PlotsMetadata loadPlotMetadata(File jsonFile) throws IOException {
        Gson gson = ReportPageGen.buildMetaGson();
        BufferedReader reader = new BufferedReader(new FileReader(jsonFile));
        return (PlotsMetadata)gson.fromJson((Reader)reader, PlotsMetadata.class);
    }

    private static String magRange(FaultSystemRupSet rupSet) {
        DataUtils.MinMaxAveTracker magTrack = new DataUtils.MinMaxAveTracker();
        for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
            magTrack.addValue(rupSet.getMagForRup(r));
        }
        return "[" + AbstractRupSetPlot.twoDigits.format(magTrack.getMin()) + "," + AbstractRupSetPlot.twoDigits.format(magTrack.getMax()) + "]";
    }

    private static String lengthRange(FaultSystemRupSet rupSet) {
        DataUtils.MinMaxAveTracker lenTrack = new DataUtils.MinMaxAveTracker();
        for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
            lenTrack.addValue(rupSet.getLengthForRup(r) * 0.001);
        }
        return "[" + AbstractRupSetPlot.twoDigits.format(lenTrack.getMin()) + "," + AbstractRupSetPlot.twoDigits.format(lenTrack.getMax()) + "] km";
    }

    private static String sectRange(FaultSystemRupSet rupSet) {
        DataUtils.MinMaxAveTracker sectsTrack = new DataUtils.MinMaxAveTracker();
        for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
            sectsTrack.addValue(rupSet.getSectionsIndicesForRup(r).size());
        }
        return "[" + (int)sectsTrack.getMin() + "," + (int)sectsTrack.getMax() + "]";
    }

    public static Options createOptions() {
        Options ops = new Options();
        ops.addOption(FaultSysTools.cacheDirOption());
        ops.addOption(FaultSysTools.threadsOption());
        Option outDirOption = new Option("od", "output-dir", true, "Output directory to write the report. Must supply either this or --reports-dir");
        outDirOption.setRequired(false);
        ops.addOption(outDirOption);
        Option reportsDirOption = new Option("rd", "reports-dir", true, "Directory where reports should be written. Individual reports will be placed in subdirectories created using the fault system rupture set/solution file names. Must supply either this or --output-dir");
        reportsDirOption.setRequired(false);
        ops.addOption(reportsDirOption);
        Option rupSetOption = new Option("i", "input-file", true, "Path to the primary rupture set/solution being evaluated");
        rupSetOption.setRequired(true);
        ops.addOption(rupSetOption);
        Option nameOption = new Option("n", "name", true, "Name of the rupture set/solution, if not supplied then the file name will be used as the name");
        nameOption.setRequired(false);
        ops.addOption(nameOption);
        Option compRupSetOption = new Option("cmp", "compare-to", true, "Optional path to an alternative rupture set for comparison");
        compRupSetOption.setRequired(false);
        ops.addOption(compRupSetOption);
        Option compNameOption = new Option("cn", "comp-name", true, "Name of the comparison rupture set, if not supplied then the file name will be used");
        compNameOption.setRequired(false);
        ops.addOption(compNameOption);
        Option altPlausibilityOption = new Option("ap", "alt-plausibility", true, "Path to a JSON file with an alternative set of plausibility filters which the rupture set should be tested against");
        altPlausibilityOption.setRequired(false);
        ops.addOption(altPlausibilityOption);
        Option skipPlausibilityOption = new Option("sp", "skip-plausibility", false, "Flag to skip plausibility calculations");
        skipPlausibilityOption.setRequired(false);
        ops.addOption(skipPlausibilityOption);
        Option skipSectBySectOption = new Option("ssbs", "skip-sect-by-sect", false, "Flag to skip section-by-section plots, regardless of selected plot level");
        skipSectBySectOption.setRequired(false);
        ops.addOption(skipSectBySectOption);
        Option distAzCacheOption = new Option("cd", "cache-dir", true, "Path to cache files to speed up calculations");
        distAzCacheOption.setRequired(false);
        ops.addOption(distAzCacheOption);
        Option maxDistOption = new Option("dmd", "default-max-dist", true, "Default maximum distance to use to infer connection strategies (if rupture set doesn't have one). Default: " + (float)DEFAULT_MAX_DIST + " km");
        maxDistOption.setRequired(false);
        ops.addOption(maxDistOption);
        Option plotLevelOption = new Option("pl", "plot-level", true, "This determines which set of plots should be included. One of: " + FaultSysTools.enumOptions(PlotLevel.class) + ". Default: " + PLOT_LEVEL_DEFAULT.name());
        plotLevelOption.setRequired(false);
        ops.addOption(plotLevelOption);
        Option replotOption = new Option("rp", "replot", false, "If supplied, existing plots will be re-generated when re-running a report");
        replotOption.setRequired(false);
        ops.addOption(replotOption);
        return ops;
    }

    public static void main(String[] args) {
        if (args.length == 1 && args[0].equals("--hardcoded")) {
            File rupSetsDir = new File("/home/kevin/OpenSHA/UCERF4/rup_sets");
            PlotLevel level = PlotLevel.FULL;
            String inputName = "UCERF4 Proposed (U3 Faults)";
            File inputFile = new File(rupSetsDir, "fm3_1_plausibleMulti15km_adaptive6km_direct_cmlRake360_jumpP0.001_slipP0.05incrCapDist_cff0.75IntsPos_comb2Paths_cffFavP0.01_cffFavRatioN2P0.5_sectFractGrow0.1.zip");
            boolean skipPlausibility = true;
            String compName = "RSQSim 4983, SectArea=0.5";
            File compareFile = new File(rupSetsDir, "rsqsim_4983_stitched_m6.5_skip65000_sectArea0.5.zip");
            File altPlausibilityCompareFile = null;
            ArrayList<String> argz = new ArrayList<String>();
            argz.add("--reports-dir");
            argz.add("/home/kevin/markdown/rupture-sets");
            argz.add("--input-file");
            argz.add(inputFile.getAbsolutePath());
            if (inputName != null) {
                argz.add("--name");
                argz.add(inputName);
            }
            if (compareFile != null) {
                argz.add("--compare-to");
                argz.add(compareFile.getAbsolutePath());
                if (compName != null) {
                    argz.add("--comp-name");
                }
                argz.add(compName);
            }
            if (altPlausibilityCompareFile != null) {
                argz.add("--alt-plausibility");
                argz.add(altPlausibilityCompareFile.getAbsolutePath());
            }
            if (skipPlausibility) {
                argz.add("--skip-plausibility");
            }
            if (level != null) {
                argz.add("--plot-level");
                argz.add(level.name());
            }
            argz.add("--default-max-dist");
            argz.add("15");
            argz.add("--skip-sect-by-sect");
            argz.add("--replot");
            args = argz.toArray(new String[0]);
        }
        System.setProperty("java.awt.headless", "true");
        CommandLine cmd = FaultSysTools.parseOptions(ReportPageGen.createOptions(), args, ReportPageGen.class);
        try {
            new ReportPageGen(cmd).generatePage();
            System.exit(0);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static enum PlotLevel {
        LIGHT,
        DEFAULT,
        FULL,
        REVIEW;

    }

    static class PlotsMetadata {
        public final List<String> headerLines;
        public final List<PlotMetadata> plots;
        public transient MarkdownUtils.TableBuilder comparisonsTable = null;
        public transient List<String> comparisonLines = null;

        public PlotsMetadata(List<String> headerLines, List<PlotMetadata> plots) {
            this.headerLines = headerLines;
            this.plots = plots;
        }

        public boolean hasPlot(Class<? extends AbstractRupSetPlot> clazz) {
            return this.getPlot(clazz) != null;
        }

        public PlotMetadata getPlot(Class<? extends AbstractRupSetPlot> clazz) {
            for (PlotMetadata plot : this.plots) {
                if (!plot.plotClassName.equals(clazz.getName())) continue;
                return plot;
            }
            return null;
        }
    }

    static class PlotMetadata {
        public final String plotName;
        public final String plotClassName;
        public final List<String> markdown;

        public PlotMetadata(String plotName, String plotClassName, List<String> markdown) {
            this.plotName = plotName;
            this.plotClassName = plotClassName;
            this.markdown = markdown;
        }
    }
}

