/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports.plots;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractRupSetPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;

public class LogicTreeBranchPlot
extends AbstractRupSetPlot {
    @Override
    public String getName() {
        return "Logic Tree Branch";
    }

    @Override
    public List<String> plot(FaultSystemRupSet rupSet, FaultSystemSolution sol, ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        String name;
        LogicTreeLevel level;
        int i;
        LogicTreeBranch compBranch;
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        LogicTreeBranch branch = rupSet.requireModule(LogicTreeBranch.class);
        LogicTreeBranch logicTreeBranch = compBranch = meta.comparison == null ? null : meta.comparison.rupSet.getModule(LogicTreeBranch.class);
        if (compBranch == null) {
            table.addLine("Level", "Choice");
        } else {
            table.addLine("Level", "Choice", "Comparison Choice");
        }
        ArrayList<String> levelNames = new ArrayList<String>();
        HashMap choices = new HashMap();
        HashMap compChoices = compBranch == null ? null : new HashMap();
        for (i = 0; i < branch.size(); ++i) {
            level = branch.getLevel(i);
            name = level.getName();
            levelNames.add(name);
            choices.put(name, branch.getValue(i));
        }
        if (compBranch != null) {
            for (i = 0; i < compBranch.size(); ++i) {
                level = compBranch.getLevel(i);
                name = level.getName();
                if (!levelNames.contains(name)) {
                    levelNames.add(name);
                }
                compChoices.put(name, compBranch.getValue(i));
            }
        }
        for (String name2 : levelNames) {
            table.initNewLine().addColumn("**" + name2 + "**");
            LogicTreeNode choice = (LogicTreeNode)choices.get(name2);
            if (choice == null) {
                table.addColumn("_(N/A)_");
            } else {
                table.addColumn(choice.getName());
            }
            if (compBranch != null) {
                LogicTreeNode compChoice = (LogicTreeNode)compChoices.get(name2);
                if (compChoice == null) {
                    table.addColumn("_(N/A)_");
                } else {
                    table.addColumn(compChoice.getName());
                }
            }
            table.finalizeLine();
        }
        return table.build();
    }

    @Override
    public Collection<Class<? extends OpenSHA_Module>> getRequiredModules() {
        return Collections.singleton(LogicTreeBranch.class);
    }
}

