/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports.plots;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.Range;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.xyz.EvenlyDiscrXYZ_DataSet;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.gui.plot.jfreechart.xyzPlot.XYZPlotSpec;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.SimulatedAnnealing;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.AnnealingProgress;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.modules.InitialSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.LogicTreeRateStatistics;
import org.opensha.sha.earthquake.faultSysSolution.modules.WaterLevelRates;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractSolutionPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.RupSetMetadata;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.UniqueRupture;

public class RateDistributionPlot
extends AbstractSolutionPlot {
    @Override
    public String getName() {
        return "Rupture Rate Distribution";
    }

    @Override
    public List<String> plot(FaultSystemSolution sol, ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        double[] crates;
        boolean hasPerturbs;
        boolean equivRups;
        FaultSystemSolution compSol = null;
        if (meta.hasComparisonSol()) {
            compSol = meta.comparison.sol;
        }
        ArrayList<String> lines = new ArrayList<String>();
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        double[] rates = sol.getRateForAllRups();
        double[] ratesNoMin = sol.hasModule(WaterLevelRates.class) ? sol.getModule(WaterLevelRates.class).subtractFrom(rates) : rates;
        double[] initial = sol.hasModule(InitialSolution.class) ? sol.getModule(InitialSolution.class).get() : new double[rates.length];
        int numNonZero = 0;
        int numAboveWaterlevel = 0;
        for (int r = 0; r < rates.length; ++r) {
            if (!((float)rates[r] > 0.0f)) continue;
            ++numNonZero;
            if (!((float)ratesNoMin[r] > 0.0f)) continue;
            ++numAboveWaterlevel;
        }
        table.initNewLine();
        if (compSol != null) {
            table.addColumn("");
        }
        table.addColumn("**Non-zero ruptures**");
        boolean bl = equivRups = compSol != null && meta.primary.rupSet.isEquivalentTo(meta.comparison.rupSet);
        if (equivRups) {
            table.addColumn("**Unique non-zero ruptures**").addColumn("**Rate of unique non-zero ruptures**");
        }
        if (ratesNoMin != rates) {
            table.addColumn("**Ruptures above water-level**");
        }
        boolean bl2 = hasPerturbs = sol.hasModule(AnnealingProgress.class) || compSol != null && compSol.hasModule(AnnealingProgress.class);
        if (hasPerturbs) {
            table.addColumn("**Avg. # perturbations per rupture**").addColumn("**Avg. # perturbations per non-zero rupture**");
        }
        table.finalizeLine().initNewLine();
        if (compSol != null) {
            table.addColumn("Primary");
        }
        table.addColumn(countDF.format(numNonZero) + " (" + percentDF.format((double)numNonZero / (double)rates.length) + ")");
        if (equivRups) {
            crates = meta.comparison.sol.getRateForAllRups();
            int uniqueNZ = 0;
            double uniqueRate = 0.0;
            for (int r = 0; r < rates.length; ++r) {
                if (!(rates[r] > 0.0) || crates[r] != 0.0) continue;
                ++uniqueNZ;
                uniqueRate += rates[r];
            }
            table.addColumn(countDF.format(uniqueNZ) + " (" + percentDF.format((double)uniqueNZ / (double)rates.length) + ")");
            table.addColumn((float)uniqueRate + " (" + percentDF.format(uniqueRate / sol.getTotalRateForAllFaultSystemRups()) + ")");
        }
        if (ratesNoMin != rates) {
            table.addColumn(countDF.format(numAboveWaterlevel) + " (" + percentDF.format((double)numAboveWaterlevel / (double)rates.length) + ")");
        }
        if (hasPerturbs) {
            AnnealingProgress progress = sol.getModule(AnnealingProgress.class);
            if (progress == null) {
                table.addColumn("_(N/A)_").addColumn("_(N/A)_");
            } else {
                long perturbs = progress.getNumPerturbations(progress.size() - 1);
                table.addColumn(Float.valueOf((float)((double)perturbs / (double)rates.length)));
                table.addColumn(Float.valueOf((float)((double)perturbs / (double)numAboveWaterlevel)));
            }
        }
        table.finalizeLine();
        crates = null;
        double[] cratesNoMin = null;
        boolean inferredWL = false;
        if (compSol != null) {
            crates = compSol.getRateForAllRups();
            if (compSol.hasModule(WaterLevelRates.class)) {
                cratesNoMin = compSol.getModule(WaterLevelRates.class).subtractFrom(crates);
            } else if (sol.hasModule(WaterLevelRates.class) && rates.length == crates.length) {
                FaultSystemSolution remapped;
                boolean equiv = meta.primary.rupSet.isEquivalentTo(meta.comparison.rupSet);
                if (!equiv && (remapped = RateDistributionPlot.getRemapped(meta.primary.rupSet, compSol)) != null) {
                    compSol = remapped;
                    equiv = true;
                    crates = compSol.getRateForAllRups();
                }
                if (equiv) {
                    inferredWL = true;
                    WaterLevelRates wl = sol.requireModule(WaterLevelRates.class);
                    double[] origWL = wl.get();
                    for (int r = 0; r < crates.length; ++r) {
                        if (!((float)crates[r] < (float)origWL[r])) continue;
                        inferredWL = false;
                        break;
                    }
                    cratesNoMin = inferredWL ? wl.subtractFrom(crates) : crates;
                } else {
                    cratesNoMin = crates;
                }
            } else {
                cratesNoMin = crates;
            }
            int cnumNonZero = 0;
            int cnumAboveWaterlevel = 0;
            for (int r = 0; r < crates.length; ++r) {
                if (!(crates[r] > 0.0)) continue;
                ++cnumNonZero;
                if (!(cratesNoMin[r] > 0.0)) continue;
                ++cnumAboveWaterlevel;
            }
            table.initNewLine().addColumn("Comparison");
            table.addColumn(countDF.format(cnumNonZero) + " (" + percentDF.format((double)cnumNonZero / (double)crates.length) + ")");
            if (equivRups) {
                int uniqueNZ = 0;
                double uniqueRate = 0.0;
                for (int r = 0; r < rates.length; ++r) {
                    if (!(crates[r] > 0.0) || rates[r] != 0.0) continue;
                    ++uniqueNZ;
                    uniqueRate += crates[r];
                }
                table.addColumn(countDF.format(uniqueNZ) + " (" + percentDF.format((double)uniqueNZ / (double)crates.length) + ")");
                table.addColumn((float)uniqueRate + " (" + percentDF.format(uniqueRate / meta.comparison.sol.getTotalRateForAllFaultSystemRups()) + ")");
            }
            if (ratesNoMin != rates) {
                if (cratesNoMin != crates) {
                    table.addColumn(countDF.format(cnumAboveWaterlevel) + " (" + percentDF.format((double)cnumAboveWaterlevel / (double)crates.length) + ")");
                } else {
                    table.addColumn("");
                }
            }
            if (hasPerturbs) {
                AnnealingProgress progress = compSol.getModule(AnnealingProgress.class);
                if (progress == null) {
                    table.addColumn("_(N/A)_").addColumn("_(N/A)_");
                } else {
                    long perturbs = progress.getNumPerturbations(progress.size() - 1);
                    table.addColumn(Float.valueOf((float)((double)perturbs / (double)crates.length)));
                    table.addColumn(Float.valueOf((float)((double)perturbs / (double)cnumAboveWaterlevel)));
                }
            }
        }
        lines.addAll(table.invert().build());
        lines.add("");
        if (inferredWL) {
            lines.add("_NOTE: The comnparison solution didn't have an attached waterlevel, but seems to have been generated with the same waterlevel, so we assume that was the case. This can cause slight numerical artifacts affecting the red line below and ruptures above waterlevel count above._");
            lines.add("");
        }
        if (compSol == null) {
            SimulatedAnnealing.writeRateVsRankPlot(resourcesDir, "rate_dist", ratesNoMin, rates, initial);
        } else {
            SimulatedAnnealing.writeRateVsRankPlot(resourcesDir, "rate_dist", ratesNoMin, rates, initial, crates, cratesNoMin);
        }
        lines.add("![Rate Distribution](" + relPathToResources + "/rate_dist.png)");
        lines.add("");
        lines.add("![Cumulative Rate Distribution](" + relPathToResources + "/rate_dist_cumulative.png)");
        if (sol.hasModule(LogicTreeRateStatistics.class)) {
            LogicTreeRateStatistics stats = sol.requireModule(LogicTreeRateStatistics.class);
            lines.add("");
            lines.add(this.getSubHeading() + " Logic Tree Rate Statistics");
            lines.add(topLink);
            lines.add("");
            lines.addAll(stats.buildTable().build());
        }
        FaultSystemRupSet rupSet = sol.getRupSet();
        if (compSol != null) {
            int numRups = meta.primary.numRuptures;
            if (!meta.primary.rupSet.isEquivalentTo(compSol.getRupSet())) {
                if (numRups != compSol.getRupSet().getNumRuptures()) {
                    return lines;
                }
                compSol = RateDistributionPlot.getRemapped(sol.getRupSet(), compSol);
                if (compSol == null) {
                    return lines;
                }
            }
            double minMag = rupSet.getMinMag();
            double maxMag = rupSet.getMaxMag();
            ArrayList<Range> magRanges = new ArrayList<Range>();
            magRanges.add(null);
            int minBinSize = (int)((double)rupSet.getNumRuptures() * 0.001);
            double binFloor = 0.0;
            double binCeil = Math.ceil(minMag);
            while (binFloor < maxMag) {
                Range range = new Range(binFloor, binCeil);
                int numInRange = this.numInRange(range, rupSet.getMagForAllRups());
                if (binFloor == 0.0) {
                    if (numInRange < minBinSize) {
                        binCeil += 1.0;
                        continue;
                    }
                } else if (binCeil > maxMag && numInRange < minBinSize && magRanges.size() > 1) {
                    Range prev = (Range)magRanges.remove(magRanges.size() - 1);
                    magRanges.add(new Range(prev.getLowerBound(), binCeil));
                    break;
                }
                magRanges.add(range);
                binFloor = binCeil;
                binCeil += 1.0;
            }
            ArrayList<DefaultXY_DataSet> scatters = new ArrayList<DefaultXY_DataSet>();
            for (int i = 0; i < magRanges.size(); ++i) {
                scatters.add(new DefaultXY_DataSet());
            }
            DataUtils.MinMaxAveTracker rateTrack = new DataUtils.MinMaxAveTracker();
            for (int r = 0; r < numRups; ++r) {
                double x = Math.max(1.0E-16, sol.getRateForRup(r));
                double y = Math.max(1.0E-16, compSol.getRateForRup(r));
                for (int m = 0; m < magRanges.size(); ++m) {
                    Range range = (Range)magRanges.get(m);
                    if (range != null && !range.contains(rupSet.getMagForRup(r))) continue;
                    ((XY_DataSet)scatters.get(m)).set(x, y);
                }
                rateTrack.addValue(x);
                rateTrack.addValue(y);
            }
            Range range = new Range(Math.max(1.0E-16, Math.pow(10.0, Math.floor(Math.log10(rateTrack.getMin())))), Math.pow(10.0, Math.ceil(Math.log10(rateTrack.getMax()))));
            table = MarkdownUtils.tableBuilder();
            for (int m = 0; m < magRanges.size(); ++m) {
                Object prefix;
                Object title;
                Range magRange = (Range)magRanges.get(m);
                if (magRange == null) {
                    title = "Rupture Rate Comparison";
                    prefix = "rate_comparison";
                } else if (magRange.getLowerBound() == 0.0) {
                    title = "M\u2264" + (int)magRange.getUpperBound() + " Rupture Rate Comparison";
                    prefix = "rate_comparison_m_lt_" + (int)magRange.getUpperBound();
                } else if (magRange.getUpperBound() >= maxMag) {
                    title = "M\u2265" + (int)magRange.getLowerBound() + " Rupture Rate Comparison";
                    prefix = "rate_comparison_m_ge_" + (int)magRange.getLowerBound();
                } else {
                    title = "M" + (int)magRange.getLowerBound() + "-" + (int)magRange.getUpperBound() + " Rupture Rate Comparison";
                    prefix = "rate_comparison_m_" + (int)magRange.getLowerBound() + "_" + (int)magRange.getUpperBound();
                }
                ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
                ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                DefaultXY_DataSet oneToOne = new DefaultXY_DataSet();
                oneToOne.set(range.getLowerBound(), range.getLowerBound());
                oneToOne.set(range.getUpperBound(), range.getUpperBound());
                XY_DataSet scatter = (XY_DataSet)scatters.get(m);
                funcs.add(scatter);
                chars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLACK));
                funcs.add(oneToOne);
                chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 3.0f, Color.GRAY));
                PlotSpec spec = new PlotSpec(funcs, chars, (String)title, RateDistributionPlot.getTruncatedTitle(meta.primary.name) + " Rate", RateDistributionPlot.getTruncatedTitle(meta.comparison.name) + " Rate");
                HeadlessGraphPanel gp = PlotUtils.initHeadless();
                gp.drawGraphPanel(spec, true, true, range, range);
                PlotUtils.writePlots(resourcesDir, (String)prefix, (GraphPanel)gp, 1000, false, true, false, false);
                double logMin = Math.log10(range.getLowerBound());
                double logMax = Math.log10(range.getUpperBound());
                oneToOne = new DefaultXY_DataSet();
                oneToOne.set(logMin, logMin);
                oneToOne.set(logMax, logMax);
                funcs = new ArrayList();
                chars = new ArrayList();
                funcs.add(oneToOne);
                chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 3.0f, Color.GRAY));
                HistogramFunction refFunc = HistogramFunction.getEncompassingHistogram(logMin + 0.01, logMax - 0.01, 0.2);
                EvenlyDiscrXYZ_DataSet xyz = new EvenlyDiscrXYZ_DataSet(refFunc.size(), refFunc.size(), refFunc.getMinX(), refFunc.getMinX(), refFunc.getDelta());
                for (Point2D pt : scatter) {
                    double logX = Math.log10(pt.getX());
                    double logY = Math.log10(pt.getY());
                    int xInd = refFunc.getClosestXIndex(logX);
                    int yInd = refFunc.getClosestXIndex(logY);
                    xyz.set(xInd, yInd, xyz.get(xInd, yInd) + 1.0);
                }
                for (int i = 0; i < xyz.size(); ++i) {
                    if (xyz.get(i) != 0.0) continue;
                    xyz.set(i, Double.NaN);
                }
                xyz.log10();
                double maxZ = xyz.getMaxZ();
                CPT cpt = GMT_CPT_Files.BLACK_RED_YELLOW_UNIFORM.instance().reverse().rescale(0.0, Math.ceil(maxZ));
                cpt.setNanColor(new Color(255, 255, 255, 0));
                cpt.setBelowMinColor(cpt.getNanColor());
                XYZPlotSpec xyzSpec = new XYZPlotSpec(xyz, cpt, (String)title, "Log10 " + spec.getXAxisLabel(), "Log10 " + spec.getYAxisLabel(), "Log10 Count");
                xyzSpec.setCPTPosition(RectangleEdge.BOTTOM);
                xyzSpec.setXYElems(funcs);
                xyzSpec.setXYChars(chars);
                Range logRange = new Range(refFunc.getMinX() - 0.5 * refFunc.getDelta(), refFunc.getMaxX() + 0.5 * refFunc.getDelta());
                gp.drawGraphPanel(xyzSpec, false, false, logRange, logRange);
                gp.getChartPanel().setSize(1000, 1000);
                gp.saveAsPNG(new File(resourcesDir, (String)prefix + "_hist2D.png").getAbsolutePath());
                table.initNewLine();
                table.addColumn("![rate comparison](" + relPathToResources + "/" + (String)prefix + ".png)");
                table.addColumn("![rate hist](" + relPathToResources + "/" + (String)prefix + "_hist2D.png)");
                table.finalizeLine();
            }
            lines.add("");
            lines.add(this.getSubHeading() + " Rupture Rate Comparison");
            lines.add(topLink);
            lines.add("");
            lines.addAll(table.build());
        }
        if (rupSet.hasModule(ClusterRuptures.class)) {
            boolean jumpFound = false;
            ClusterRuptures cRups = rupSet.requireModule(ClusterRuptures.class);
            for (ClusterRupture cRup : cRups) {
                if (cRup.getTotalNumJumps() <= 0) continue;
                jumpFound = true;
                break;
            }
            if (jumpFound) {
                double[] initialJumpRates;
                double[] jumpRates = RateDistributionPlot.calcJumpRates(rupSet, sol.getRateForAllRups());
                if (jumpRates == null || jumpRates.length < 2) {
                    return lines;
                }
                double[] dArray = initialJumpRates = sol.hasModule(InitialSolution.class) ? RateDistributionPlot.calcJumpRates(rupSet, initial) : null;
                if (initialJumpRates == null) {
                    initialJumpRates = new double[jumpRates.length];
                }
                double[] compJumpRates = null;
                if (compSol != null) {
                    compJumpRates = RateDistributionPlot.calcJumpRates(compSol.getRupSet(), compSol.getRateForAllRups());
                }
                lines.add(this.getSubHeading() + " Connection Rate Distribution");
                lines.add(topLink);
                lines.add("");
                lines.add("This plot gives the rate that each unique connection (between separate fault sections) is utilized.");
                lines.add("");
                SimulatedAnnealing.writeRateVsRankPlot(resourcesDir, "conn_rate_dist", jumpRates, jumpRates, initialJumpRates, compJumpRates, compJumpRates, "Connection Rate Distribution");
                lines.add("![Connection Rate Distribution](" + relPathToResources + "/conn_rate_dist.png)");
                lines.add("");
            }
        }
        return lines;
    }

    @Override
    public Collection<Class<? extends OpenSHA_Module>> getRequiredModules() {
        return null;
    }

    private static FaultSystemSolution getRemapped(FaultSystemRupSet refRupSet, FaultSystemSolution oSol) {
        ClusterRuptures cRups1 = refRupSet.getModule(ClusterRuptures.class);
        FaultSystemRupSet oRupSet = oSol.getRupSet();
        ClusterRuptures cRups2 = oRupSet.getModule(ClusterRuptures.class);
        Preconditions.checkState((refRupSet.getNumRuptures() == oSol.getRupSet().getNumRuptures() ? 1 : 0) != 0);
        int numRups = refRupSet.getNumRuptures();
        HashMap<UniqueRupture, Integer> refIndexes = new HashMap<UniqueRupture, Integer>();
        for (int r = 0; r < numRups; ++r) {
            UniqueRupture unique = cRups1 == null ? UniqueRupture.forIDs(refRupSet.getSectionsIndicesForRup(r)) : cRups1.get((int)r).unique;
            refIndexes.put(unique, r);
        }
        Preconditions.checkState((refIndexes.size() == numRups ? 1 : 0) != 0);
        double[] remappedRates = new double[numRups];
        for (int r = 0; r < numRups; ++r) {
            UniqueRupture unique = cRups2 == null ? UniqueRupture.forIDs(oRupSet.getSectionsIndicesForRup(r)) : cRups2.get((int)r).unique;
            if (!refIndexes.containsKey(unique)) {
                return null;
            }
            int index = (Integer)refIndexes.get(unique);
            Preconditions.checkState((remappedRates[index] == 0.0 ? 1 : 0) != 0);
            remappedRates[index] = oSol.getRateForRup(r);
        }
        return new FaultSystemSolution(refRupSet, remappedRates);
    }

    private int numInRange(Range range, double[] mags) {
        int count = 0;
        for (double mag : mags) {
            if (!range.contains(mag)) continue;
            ++count;
        }
        return count;
    }

    private static double[] calcJumpRates(FaultSystemRupSet rupSet, double[] rates) {
        HashMap<Jump, Double> jumpRates = new HashMap<Jump, Double>();
        ClusterRuptures cRups = rupSet.requireModule(ClusterRuptures.class);
        for (int rupIndex = 0; rupIndex < rupSet.getNumRuptures(); ++rupIndex) {
            double rate = rates[rupIndex];
            if (rate == 0.0) continue;
            ClusterRupture cRup = cRups.get(rupIndex);
            for (Jump jump : cRup.getJumpsIterable()) {
                if (jump.fromSection.getSectionId() > jump.toSection.getSectionId()) {
                    jump = jump.reverse();
                }
                if (jumpRates.containsKey(jump)) {
                    jumpRates.put(jump, (Double)jumpRates.get(jump) + rate);
                    continue;
                }
                jumpRates.put(jump, rate);
            }
        }
        if (jumpRates.isEmpty()) {
            return null;
        }
        double[] ret = new double[jumpRates.size()];
        int index = 0;
        for (Jump jump : jumpRates.keySet()) {
            ret[index++] = (Double)jumpRates.get(jump);
        }
        return ret;
    }

    public static void main(String[] args) throws IOException {
        File mainDir = new File("/home/kevin/markdown/inversions");
        final FaultSystemSolution sol1 = FaultSystemSolution.load(new File("/home/kevin/OpenSHA/UCERF4/batch_inversions/2021_10_19-reproduce-ucerf3-ref_branch-tapered-convergence-u3Iters/mean_solution.zip"));
        FaultSystemSolution sol2 = FaultSystemSolution.load(new File("/home/kevin/OpenSHA/UCERF4/batch_inversions/2021_10_19-reproduce-ucerf3-ref_branch-tapered-convergence-u3Iters/FM3_1_ZENGBB_Shaw09Mod_DsrTap_CharConst_M5Rate7.9_MMaxOff7.6_NoFix_SpatSeisU3_mean_sol.zip"));
        sol1.getRupSet().addAvailableModule((Callable<OpenSHA_Module>)new Callable<ClusterRuptures>(){

            @Override
            public ClusterRuptures call() throws Exception {
                return ClusterRuptures.singleStranged(sol1.getRupSet());
            }
        }, ClusterRuptures.class);
        RateDistributionPlot plot = new RateDistributionPlot();
        ReportMetadata meta = new ReportMetadata(new RupSetMetadata("sol1", sol1), new RupSetMetadata("sol2", sol2));
        plot.plot(sol1, meta, new File("/tmp"), "resources", "");
    }
}

