/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.dom4j.DocumentException;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.RupSetScalingRelationship;
import org.opensha.sha.earthquake.faultSysSolution.RuptureSets;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.RuptureGrowingStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.FilterDataClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.UniqueRupture;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_FaultModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_ScalingRelationships;
import org.opensha.sha.faultSurface.FaultSection;

public class ClusterRuptureBuilder {
    private List<FaultSubsectionCluster> clusters;
    private List<PlausibilityFilter> filters;
    private int maxNumSplays = 0;
    private SectionDistanceAzimuthCalculator distAzCalc;
    private RupDebugCriteria debugCriteria;
    private boolean stopAfterDebugMatch;
    private static DecimalFormat oneDigitDF = new DecimalFormat("0.0");
    public static DecimalFormat countDF = new DecimalFormat("#");

    public ClusterRuptureBuilder(PlausibilityConfiguration configuration) {
        this(configuration.getConnectionStrategy().getClusters(), configuration.getFilters(), configuration.getMaxNumSplays(), configuration.getDistAzCalc());
    }

    public ClusterRuptureBuilder(List<FaultSubsectionCluster> clusters, List<PlausibilityFilter> filters, int maxNumSplays, SectionDistanceAzimuthCalculator distAzCalc) {
        this.clusters = clusters;
        this.filters = filters;
        this.maxNumSplays = maxNumSplays;
        this.distAzCalc = distAzCalc;
    }

    public void setDebugCriteria(RupDebugCriteria debugCriteria, boolean stopAfterMatch) {
        this.debugCriteria = debugCriteria;
        this.stopAfterDebugMatch = stopAfterMatch;
    }

    public static String rupRateStr(int count, long timeDeltaMillis) {
        if (timeDeltaMillis == 0L) {
            return "N/A rups/s";
        }
        double timeDeltaSecs = (double)timeDeltaMillis / 1000.0;
        double perSec = (double)count / timeDeltaSecs;
        if (count == 0 || perSec >= 0.1) {
            if (perSec > 10.0) {
                return countDF.format(perSec) + " rups/s";
            }
            return oneDigitDF.format(perSec) + " rups/s";
        }
        double perMin = perSec * 60.0;
        if (perMin >= 0.1) {
            if (perMin > 10.0) {
                return countDF.format(perMin) + " rups/m";
            }
            return oneDigitDF.format(perMin) + " rups/m";
        }
        double perHour = perMin * 60.0;
        if (perHour > 10.0) {
            return countDF.format(perHour) + " rups/hr";
        }
        return oneDigitDF.format(perHour) + " rups/hr";
    }

    public List<ClusterRupture> build(RuptureGrowingStrategy growingStrategy) {
        return this.build(growingStrategy, 1);
    }

    public List<ClusterRupture> build(RuptureGrowingStrategy growingStrategy, int numThreads) {
        growingStrategy.clearCaches();
        ArrayList<ClusterRupture> rups = new ArrayList<ClusterRupture>();
        HashSet<UniqueRupture> uniques = new HashSet<UniqueRupture>();
        ProgressTracker track = new ProgressTracker();
        if (numThreads <= 1) {
            for (FaultSubsectionCluster cluster : this.clusters) {
                ClusterBuildCallable build = new ClusterBuildCallable(growingStrategy, cluster, uniques, track, null);
                try {
                    build.call();
                }
                catch (Exception exception) {
                    throw ExceptionUtils.asRuntimeException(exception);
                }
                try {
                    build.merge(rups);
                }
                catch (InterruptedException | ExecutionException exception) {
                    throw ExceptionUtils.asRuntimeException(exception);
                }
                if (!build.debugStop) continue;
                break;
            }
        } else {
            ClusterBuildCallable build;
            ExecutorService exec = Executors.newFixedThreadPool(numThreads);
            ArrayList<Future<ClusterBuildCallable>> futures = new ArrayList<Future<ClusterBuildCallable>>();
            for (FaultSubsectionCluster faultSubsectionCluster : this.clusters) {
                build = new ClusterBuildCallable(growingStrategy, faultSubsectionCluster, uniques, track, exec);
                futures.add(exec.submit(build));
            }
            System.out.println("Waiting on " + futures.size() + " cluster build futures");
            for (Future future : futures) {
                try {
                    build = (ClusterBuildCallable)future.get();
                }
                catch (Exception e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
                try {
                    build.merge(rups);
                }
                catch (InterruptedException | ExecutionException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
                if (!build.debugStop) continue;
                exec.shutdownNow();
                break;
            }
            exec.shutdown();
        }
        return rups;
    }

    private PlausibilityResult testRup(ClusterRupture rupture, boolean debug) {
        PlausibilityResult result = PlausibilityResult.PASS;
        for (PlausibilityFilter filter : this.filters) {
            PlausibilityResult filterResult = filter.apply(rupture, debug);
            if (debug) {
                System.out.println("\t\t" + filter.getShortName() + ": " + String.valueOf((Object)filterResult));
            }
            if ((result = result.logicalAnd(filterResult)).canContinue() || debug) continue;
            break;
        }
        return result;
    }

    private boolean addRuptures(List<ClusterRupture> rups, HashSet<UniqueRupture> uniques, ClusterRupture currentRupture, ClusterRupture currentStrand, RuptureGrowingStrategy growingStrategy, ProgressTracker track, ExecutorService exec, List<Future<List<ClusterRupture>>> futures) {
        FaultSubsectionCluster lastCluster = currentStrand.clusters[currentStrand.clusters.length - 1];
        FaultSection firstSection = currentStrand.clusters[0].startSect;
        if (currentStrand == currentRupture && currentRupture.splays.size() < this.maxNumSplays) {
            for (FaultSection section : lastCluster.subSects) {
                if (section.equals(firstSection)) continue;
                if (lastCluster.endSects.contains((Object)section)) break;
                for (Jump jump : lastCluster.getConnections(section)) {
                    boolean canContinue;
                    if (currentRupture.contains(jump.toSection) || (canContinue = this.addJumpVariations(rups, uniques, currentRupture, currentStrand, growingStrategy, jump, track))) continue;
                    return false;
                }
            }
        }
        for (FaultSection endSection : lastCluster.endSects) {
            for (Jump jump : lastCluster.getConnections(endSection)) {
                if (currentRupture.contains(jump.toSection)) continue;
                if (exec != null) {
                    Future<List<ClusterRupture>> future = exec.submit(new AddRupturesCallable(uniques, currentRupture, currentStrand, growingStrategy, track, jump));
                    track.addStartClusterFuture(currentRupture.clusters[0].parentSectionID, future);
                    futures.add(future);
                    continue;
                }
                boolean canContinue = this.addJumpVariations(rups, uniques, currentRupture, currentStrand, growingStrategy, jump, track);
                if (canContinue) continue;
                return false;
            }
        }
        return true;
    }

    private Jump buildJump(Jump jump, FaultSubsectionCluster toVariation) {
        double minDist = Double.POSITIVE_INFINITY;
        for (FaultSection s1 : jump.fromCluster.subSects) {
            for (FaultSection s2 : toVariation.subSects) {
                minDist = Double.min(minDist, this.distAzCalc.getDistance(s1, s2));
            }
        }
        Preconditions.checkState((boolean)toVariation.startSect.equals(jump.toSection));
        Preconditions.checkState((boolean)toVariation.contains(jump.toSection));
        return new Jump(jump.fromSection, jump.fromCluster, jump.toSection, toVariation, minDist);
    }

    private boolean addJumpVariations(List<ClusterRupture> rups, HashSet<UniqueRupture> uniques, ClusterRupture currentRupture, ClusterRupture currentStrand, RuptureGrowingStrategy growingStrategy, Jump jump, ProgressTracker track) {
        Preconditions.checkNotNull((Object)jump);
        for (FaultSubsectionCluster variation : growingStrategy.getVariations(currentRupture, jump.toCluster, jump.toSection)) {
            boolean debugMatch;
            boolean hasLoopback = false;
            for (FaultSection sect : variation.subSects) {
                if (!currentRupture.contains(sect)) continue;
                hasLoopback = true;
                break;
            }
            if (hasLoopback) continue;
            Jump testJump = this.buildJump(jump, variation);
            ClusterRupture candidateRupture = currentRupture.take(testJump);
            PlausibilityResult result = this.testRup(candidateRupture, false);
            boolean bl = debugMatch = this.debugCriteria != null && this.debugCriteria.isMatch(currentRupture, testJump) && this.debugCriteria.appliesTo(result);
            if (debugMatch) {
                System.out.println("Debug match with result=" + String.valueOf((Object)result));
                System.out.println("\tMulti " + String.valueOf(currentRupture) + " => " + String.valueOf(testJump.toCluster));
                System.out.println("Testing full:");
                this.testRup(candidateRupture, true);
                if (this.stopAfterDebugMatch) {
                    return false;
                }
            }
            if (!result.canContinue()) {
                if (!debugMatch) continue;
                System.out.println("Can't continue, bailing");
                continue;
            }
            if (result.isPass()) {
                track.processPassedRupture(candidateRupture);
                if (!uniques.contains(candidateRupture.unique)) {
                    if (debugMatch) {
                        System.out.println("We passed and this is potentially new, adding");
                    }
                    rups.add(candidateRupture);
                } else if (debugMatch) {
                    System.out.println("We passed but have already processed this rupture, skipping");
                }
            }
            if (currentStrand == currentRupture) {
                boolean canContinue = this.addRuptures(rups, uniques, candidateRupture, candidateRupture, growingStrategy, track, null, null);
                if (canContinue) continue;
                return false;
            }
            ClusterRupture splayStrand = null;
            for (ClusterRupture splay : candidateRupture.splays.values()) {
                if (!splay.contains(jump.toSection)) continue;
                splayStrand = splay;
                break;
            }
            Preconditions.checkNotNull(splayStrand);
            FaultSection newLastStart = splayStrand.clusters[splayStrand.clusters.length - 1].startSect;
            Preconditions.checkState((boolean)newLastStart.equals(variation.startSect));
            boolean canContinue = this.addRuptures(rups, uniques, candidateRupture, splayStrand, growingStrategy, track, null, null);
            if (!canContinue) {
                return false;
            }
            canContinue = this.addRuptures(rups, uniques, candidateRupture, candidateRupture, growingStrategy, track, null, null);
            if (canContinue) continue;
            return false;
        }
        return true;
    }

    public static int[] loadRupString(String rupStr, boolean parents) {
        Preconditions.checkState((boolean)rupStr.contains("["));
        ArrayList<Integer> ids = new ArrayList<Integer>();
        while (rupStr.contains("[")) {
            String[] split;
            String str;
            rupStr = rupStr.substring(rupStr.indexOf("[") + 1);
            Preconditions.checkState((boolean)rupStr.contains(":"));
            if (parents) {
                str = rupStr.substring(0, rupStr.indexOf(":"));
                ids.add(Integer.parseInt(str));
                continue;
            }
            rupStr = rupStr.substring(rupStr.indexOf(":") + 1);
            Preconditions.checkState((boolean)rupStr.contains("]"));
            str = rupStr.substring(0, rupStr.indexOf("]"));
            for (String idStr : split = str.split(",")) {
                ids.add(Integer.parseInt(idStr));
            }
        }
        return Ints.toArray(ids);
    }

    public static void main(String[] args) throws IOException, DocumentException {
        File rupSetsDir = new File("/home/kevin/OpenSHA/UCERF4/rup_sets");
        boolean writeRupSet = true;
        int threads = Integer.max(1, Integer.min(31, Runtime.getRuntime().availableProcessors() - 2));
        NSHM23_FaultModels fm = NSHM23_FaultModels.WUS_FM_v3;
        RuptureSets.CoulombRupSetConfig rsConfig = new RuptureSets.CoulombRupSetConfig(fm.getDefaultDeformationModel().build(fm), fm.getFilePrefix(), NSHM23_ScalingRelationships.AVERAGE);
        FaultSystemRupSet rupSet = rsConfig.build(threads);
        if (writeRupSet) {
            File outputFile = new File(rupSetsDir, ((RuptureSets.RupSetConfig)rsConfig).getRupSetFileName());
            rupSet.write(outputFile);
        }
    }

    public static FaultSystemRupSet buildClusterRupSet(RupSetScalingRelationship scale, List<? extends FaultSection> subSects, PlausibilityConfiguration config, List<ClusterRupture> rups) {
        FaultSystemRupSet.Builder builder = FaultSystemRupSet.builderForClusterRups(subSects, rups);
        builder.forScalingRelationship(scale);
        if (config != null) {
            builder.addModule(config.getDistAzCalc());
            builder.addModule(config);
        }
        return builder.build();
    }

    static {
        countDF.setGroupingUsed(true);
        countDF.setGroupingSize(3);
    }

    public static interface RupDebugCriteria {
        public boolean isMatch(ClusterRupture var1);

        public boolean isMatch(ClusterRupture var1, Jump var2);

        public boolean appliesTo(PlausibilityResult var1);
    }

    private class ProgressTracker {
        private int largestRup = 0;
        private int largestRupPrintMod = 10;
        private int rupCountPrintMod = 1000;
        private HashSet<UniqueRupture> allPassedUniques;
        private HashSet<Integer> startClusterIDs = new HashSet();
        private HashMap<Integer, List<Future<?>>> runningStartClusterFutures = new HashMap();
        private HashSet<Integer> completedStartClusters = new HashSet();
        private long startTime;
        private long prevTime;
        private int prevCount;

        public ProgressTracker() {
            this.allPassedUniques = new HashSet();
            this.prevTime = this.startTime = System.currentTimeMillis();
        }

        public synchronized void processPassedRupture(ClusterRupture rup) {
            if (!this.allPassedUniques.contains(rup.unique)) {
                int numUnique;
                this.allPassedUniques.add(rup.unique);
                int count = rup.getTotalNumSects();
                if (count > this.largestRup) {
                    this.largestRup = count;
                    if (this.largestRup % this.largestRupPrintMod == 0) {
                        System.out.println("New largest rup has " + this.largestRup + " subsections with " + rup.getTotalNumJumps() + " jumps and " + rup.splays.size() + " splays.");
                        this.printCountAndStartClusterStatus();
                        return;
                    }
                }
                if ((numUnique = this.allPassedUniques.size()) % this.rupCountPrintMod == 0) {
                    if (this.rupCountPrintMod <= 1000000) {
                        if (numUnique == 10000) {
                            this.rupCountPrintMod = 5000;
                        }
                        if (numUnique == 50000) {
                            this.rupCountPrintMod = 10000;
                        } else if (numUnique == 100000) {
                            this.rupCountPrintMod = 25000;
                        } else if (numUnique == 500000) {
                            this.rupCountPrintMod = 50000;
                        } else if (numUnique == 1000000) {
                            this.rupCountPrintMod = 100000;
                        }
                    }
                    this.printCountAndStartClusterStatus();
                }
            }
        }

        public synchronized int newStartCluster(int parentSectionID) {
            this.startClusterIDs.add(parentSectionID);
            return this.startClusterIDs.size();
        }

        public synchronized int startClusterCount() {
            return this.startClusterIDs.size();
        }

        public synchronized void addStartClusterFuture(int parentSectionID, Future<?> future) {
            Preconditions.checkNotNull(future);
            List<Future<?>> futures = this.runningStartClusterFutures.get(parentSectionID);
            if (futures == null) {
                futures = new ArrayList();
                this.runningStartClusterFutures.put(parentSectionID, futures);
            }
            futures.add(future);
        }

        public synchronized void printCountAndStartClusterStatus() {
            long curTime = System.currentTimeMillis();
            ArrayList<Integer> newlyCompleted = new ArrayList<Integer>();
            int futuresOutstanding = 0;
            for (Integer n : this.runningStartClusterFutures.keySet()) {
                List<Future<?>> list = this.runningStartClusterFutures.get(n);
                int i = list.size();
                while (--i >= 0) {
                    if (!list.get(i).isDone()) continue;
                    list.remove(i);
                }
                if (list.isEmpty()) {
                    newlyCompleted.add(n);
                    continue;
                }
                futuresOutstanding += list.size();
            }
            int numRups = this.allPassedUniques.size();
            if (numRups == this.prevCount && newlyCompleted.isEmpty()) {
                return;
            }
            for (Integer n : newlyCompleted) {
                this.runningStartClusterFutures.remove(n);
                this.completedStartClusters.add(n);
            }
            StringBuilder stringBuilder = new StringBuilder("\t").append(countDF.format(numRups));
            stringBuilder.append(" total unique passing ruptures found, longest has ").append(this.largestRup);
            stringBuilder.append(" subsections.\tClusters: ").append(this.runningStartClusterFutures.size());
            stringBuilder.append(" running (").append(futuresOutstanding).append(" futures), ");
            stringBuilder.append(this.completedStartClusters.size()).append(" completed, ");
            stringBuilder.append(this.startClusterIDs.size()).append(" total. ");
            stringBuilder.append("\tRate: ").append(ClusterRuptureBuilder.rupRateStr(numRups, curTime - this.startTime));
            long l = curTime - this.prevTime;
            stringBuilder.append(" (").append(ClusterRuptureBuilder.rupRateStr(numRups - this.prevCount, l)).append(" over last ");
            double recentSecs = (double)l / 1000.0;
            if (recentSecs > 60.0) {
                double recentMins = recentSecs / 60.0;
                if (recentMins > 60.0) {
                    double recentHours = recentMins / 60.0;
                    stringBuilder.append(oneDigitDF.format(recentHours) + "h");
                } else {
                    stringBuilder.append(oneDigitDF.format(recentMins) + "m");
                }
            } else if (recentSecs > 10.0) {
                stringBuilder.append(countDF.format(recentSecs) + "s");
            } else {
                stringBuilder.append(oneDigitDF.format(recentSecs) + "s");
            }
            stringBuilder.append(")");
            this.prevTime = curTime;
            this.prevCount = numRups;
            System.out.println(stringBuilder.toString());
        }
    }

    private class ClusterBuildCallable
    implements Callable<ClusterBuildCallable> {
        private RuptureGrowingStrategy growingStrategy;
        private FaultSubsectionCluster cluster;
        private HashSet<UniqueRupture> uniques;
        private List<Future<List<ClusterRupture>>> rupListFutures;
        private boolean debugStop = false;
        private ProgressTracker track;
        private ExecutorService exec;
        private int clusterIndex;

        public ClusterBuildCallable(RuptureGrowingStrategy growingStrategy, FaultSubsectionCluster cluster, HashSet<UniqueRupture> uniques, ProgressTracker track, ExecutorService exec) {
            this.growingStrategy = growingStrategy;
            this.cluster = cluster;
            this.uniques = uniques;
            this.track = track;
            this.exec = exec;
            this.clusterIndex = track.newStartCluster(cluster.parentSectionID);
        }

        @Override
        public ClusterBuildCallable call() throws Exception {
            FakeFuture<ClusterBuildCallable> primaryFuture = new FakeFuture<ClusterBuildCallable>(this, false);
            this.track.addStartClusterFuture(this.cluster.parentSectionID, primaryFuture);
            this.rupListFutures = this.exec != null ? Collections.synchronizedList(new ArrayList()) : new ArrayList<Future<List<ClusterRupture>>>();
            for (FaultSection startSection : this.cluster.subSects) {
                for (FaultSubsectionCluster variation : this.growingStrategy.getVariations(this.cluster, startSection)) {
                    FilterDataClusterRupture rup = new FilterDataClusterRupture(variation);
                    PlausibilityResult result = ClusterRuptureBuilder.this.testRup(rup, false);
                    if (ClusterRuptureBuilder.this.debugCriteria != null && ClusterRuptureBuilder.this.debugCriteria.isMatch(rup) && ClusterRuptureBuilder.this.debugCriteria.appliesTo(result)) {
                        System.out.println("\tVariation " + String.valueOf(variation) + " result=" + String.valueOf((Object)result));
                        ClusterRuptureBuilder.this.testRup(rup, true);
                        if (ClusterRuptureBuilder.this.stopAfterDebugMatch) {
                            this.debugStop = true;
                            primaryFuture.setDone(true);
                            return this;
                        }
                    }
                    if (!result.canContinue()) continue;
                    if (result.isPass()) {
                        this.track.processPassedRupture(rup);
                        if (!this.uniques.contains(rup.unique)) {
                            this.rupListFutures.add(new FakeFuture<List<FilterDataClusterRupture>>(Collections.singletonList(rup), true));
                        }
                    }
                    ArrayList<ClusterRupture> rups = new ArrayList<ClusterRupture>();
                    boolean canContinue = ClusterRuptureBuilder.this.addRuptures(rups, this.uniques, rup, rup, this.growingStrategy, this.track, this.exec, this.rupListFutures);
                    if (!rups.isEmpty()) {
                        this.rupListFutures.add(new FakeFuture<ArrayList<ClusterRupture>>(rups, true));
                    }
                    if (canContinue) continue;
                    System.out.println("Stopping due to debug criteria match with " + rups.size() + " ruptures");
                    this.debugStop = true;
                    primaryFuture.setDone(true);
                    return this;
                }
            }
            primaryFuture.setDone(true);
            return this;
        }

        public void merge(List<ClusterRupture> masterRups) throws InterruptedException, ExecutionException {
            int added = 0;
            int raw = 0;
            for (Future<List<ClusterRupture>> future : this.rupListFutures) {
                for (ClusterRupture rup : future.get()) {
                    if (this.uniques.contains(rup.unique)) continue;
                    masterRups.add(rup);
                    this.uniques.add(rup.unique);
                    Preconditions.checkState((boolean)this.uniques.contains(rup.unique));
                    ++added;
                    ++raw;
                }
            }
            System.out.println("Merged in " + countDF.format(masterRups.size()) + " ruptures after processing start cluster " + this.clusterIndex + "/" + this.track.startClusterCount() + " (id=" + this.cluster.parentSectionID + "): " + this.cluster.parentSectionName + " (" + added + " new, " + raw + " incl. possible duplicates).");
            this.track.printCountAndStartClusterStatus();
        }
    }

    private class AddRupturesCallable
    implements Callable<List<ClusterRupture>> {
        private HashSet<UniqueRupture> uniques;
        private ClusterRupture currentRupture;
        private ClusterRupture currentStrand;
        private RuptureGrowingStrategy growingStrategy;
        private ProgressTracker track;
        private Jump jump;

        public AddRupturesCallable(HashSet<UniqueRupture> uniques, ClusterRupture currentRupture, ClusterRupture currentStrand, RuptureGrowingStrategy growingStrategy, ProgressTracker track, Jump jump) {
            this.uniques = uniques;
            this.currentRupture = currentRupture;
            this.currentStrand = currentStrand;
            this.growingStrategy = growingStrategy;
            this.track = track;
            this.jump = jump;
        }

        @Override
        public List<ClusterRupture> call() {
            ArrayList<ClusterRupture> rups = new ArrayList<ClusterRupture>();
            ClusterRuptureBuilder.this.addJumpVariations(rups, this.uniques, this.currentRupture, this.currentStrand, this.growingStrategy, this.jump, this.track);
            return rups;
        }
    }

    public static class ResultCriteria
    implements RupDebugCriteria {
        private PlausibilityResult[] results;

        public ResultCriteria(PlausibilityResult ... results) {
            this.results = results;
        }

        @Override
        public boolean isMatch(ClusterRupture rup) {
            return true;
        }

        @Override
        public boolean isMatch(ClusterRupture rup, Jump newJump) {
            return true;
        }

        @Override
        public boolean appliesTo(PlausibilityResult result) {
            for (PlausibilityResult r : this.results) {
                if (r != result) continue;
                return true;
            }
            return false;
        }
    }

    public static class CompareRupSetExclusionCriteria
    implements RupDebugCriteria {
        private HashSet<UniqueRupture> uniques = new HashSet();

        public CompareRupSetExclusionCriteria(FaultSystemRupSet rupSet) {
            for (List<Integer> rupSects : rupSet.getSectionIndicesForAllRups()) {
                this.uniques.add(UniqueRupture.forIDs(rupSects));
            }
        }

        @Override
        public boolean isMatch(ClusterRupture rup) {
            return this.uniques.contains(rup.unique);
        }

        @Override
        public boolean isMatch(ClusterRupture rup, Jump newJump) {
            return this.uniques.contains(UniqueRupture.add(rup.unique, newJump.toCluster.unique));
        }

        @Override
        public boolean appliesTo(PlausibilityResult result) {
            return !result.isPass();
        }
    }

    public static class CompareRupSetNewInclusionCriteria
    implements RupDebugCriteria {
        private HashSet<UniqueRupture> uniques = new HashSet();

        public CompareRupSetNewInclusionCriteria(FaultSystemRupSet rupSet) {
            for (List<Integer> rupSects : rupSet.getSectionIndicesForAllRups()) {
                this.uniques.add(UniqueRupture.forIDs(rupSects));
            }
        }

        @Override
        public boolean isMatch(ClusterRupture rup) {
            return !this.uniques.contains(rup.unique);
        }

        @Override
        public boolean isMatch(ClusterRupture rup, Jump newJump) {
            return !this.uniques.contains(UniqueRupture.add(rup.unique, newJump.toCluster.unique));
        }

        @Override
        public boolean appliesTo(PlausibilityResult result) {
            return result.isPass();
        }
    }

    public static class SectsRupDebugCriteria
    implements RupDebugCriteria {
        private boolean failOnly;
        private boolean allowAdditional;
        private int[] sectIDs;

        public SectsRupDebugCriteria(boolean failOnly, boolean allowAdditional, int ... sectIDs) {
            this.failOnly = failOnly;
            this.allowAdditional = allowAdditional;
            this.sectIDs = sectIDs;
        }

        private HashSet<Integer> getSects(ClusterRupture rup) {
            HashSet<Integer> sects = new HashSet<Integer>();
            for (FaultSubsectionCluster cluster : rup.clusters) {
                for (FaultSection sect : cluster.subSects) {
                    sects.add(sect.getSectionId());
                }
            }
            for (ClusterRupture splay : rup.splays.values()) {
                sects.addAll(this.getSects(splay));
            }
            return sects;
        }

        private boolean test(HashSet<Integer> sects) {
            if (!this.allowAdditional && sects.size() != this.sectIDs.length) {
                return false;
            }
            for (int sectID : this.sectIDs) {
                if (sects.contains(sectID)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isMatch(ClusterRupture rup) {
            return this.test(this.getSects(rup));
        }

        @Override
        public boolean isMatch(ClusterRupture rup, Jump newJump) {
            HashSet<Integer> sects = this.getSects(rup);
            for (FaultSection sect : newJump.toCluster.subSects) {
                sects.add(sect.getSectionId());
            }
            return this.test(sects);
        }

        @Override
        public boolean appliesTo(PlausibilityResult result) {
            if (this.failOnly) {
                return !result.isPass();
            }
            return true;
        }
    }

    public static class ParentSectsRupDebugCriteria
    implements RupDebugCriteria {
        private boolean failOnly;
        private boolean allowAdditional;
        private int[] parentIDs;

        public ParentSectsRupDebugCriteria(boolean failOnly, boolean allowAdditional, int ... parentIDs) {
            this.failOnly = failOnly;
            this.allowAdditional = allowAdditional;
            this.parentIDs = parentIDs;
        }

        private HashSet<Integer> getParents(ClusterRupture rup) {
            HashSet<Integer> parents = new HashSet<Integer>();
            for (FaultSubsectionCluster cluster : rup.clusters) {
                parents.add(cluster.parentSectionID);
            }
            for (ClusterRupture splay : rup.splays.values()) {
                parents.addAll(this.getParents(splay));
            }
            return parents;
        }

        private boolean test(HashSet<Integer> parents) {
            if (!this.allowAdditional && parents.size() != this.parentIDs.length) {
                return false;
            }
            for (int parentID : this.parentIDs) {
                if (parents.contains(parentID)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isMatch(ClusterRupture rup) {
            return this.test(this.getParents(rup));
        }

        @Override
        public boolean isMatch(ClusterRupture rup, Jump newJump) {
            HashSet<Integer> parents = this.getParents(rup);
            parents.add(newJump.toCluster.parentSectionID);
            return this.test(parents);
        }

        @Override
        public boolean appliesTo(PlausibilityResult result) {
            if (this.failOnly) {
                return !result.isPass();
            }
            return true;
        }
    }

    public static class StartEndSectRupDebugCriteria
    implements RupDebugCriteria {
        private int startSect;
        private int endSect;
        private boolean parentIDs;
        private boolean failOnly;

        public StartEndSectRupDebugCriteria(int startSect, int endSect, boolean parentIDs, boolean failOnly) {
            this.startSect = startSect;
            this.endSect = endSect;
            this.parentIDs = parentIDs;
            this.failOnly = failOnly;
        }

        @Override
        public boolean isMatch(ClusterRupture rup) {
            if (this.startSect >= 0 && !this.isMatch(rup.clusters[0].startSect, this.startSect)) {
                return false;
            }
            FaultSubsectionCluster lastCluster = rup.clusters[rup.clusters.length - 1];
            return this.endSect < 0 || this.isMatch((FaultSection)lastCluster.subSects.get(lastCluster.subSects.size() - 1), this.endSect);
        }

        @Override
        public boolean isMatch(ClusterRupture rup, Jump newJump) {
            if (this.startSect >= 0 && !this.isMatch(rup.clusters[0].startSect, this.startSect)) {
                return false;
            }
            return this.endSect < 0 || this.isMatch((FaultSection)newJump.toCluster.subSects.get(newJump.toCluster.subSects.size() - 1), this.endSect);
        }

        private boolean isMatch(FaultSection sect, int id) {
            if (this.parentIDs) {
                return sect.getParentSectionId() == id;
            }
            return sect.getSectionId() == id;
        }

        @Override
        public boolean appliesTo(PlausibilityResult result) {
            if (this.failOnly) {
                return !result.isPass();
            }
            return true;
        }
    }

    private class FakeFuture<E>
    implements Future<E> {
        private E result;
        private boolean done;

        public FakeFuture(E result, boolean done) {
            this.result = result;
            this.done = done;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        public void setDone(boolean done) {
            this.done = done;
        }

        @Override
        public E get() throws InterruptedException, ExecutionException {
            return this.result;
        }

        @Override
        public E get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.result;
        }
    }
}

