/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.util.Comparator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;

public interface ScalarValuePlausibiltyFilter<E extends Number>
extends PlausibilityFilter {
    public E getValue(ClusterRupture var1);

    public Range<E> getAcceptableRange();

    public String getScalarName();

    public String getScalarUnits();

    default public E getWorseValue(E val1, E val2) {
        if (this.isValueBetter(val1, val2)) {
            return val2;
        }
        return val1;
    }

    default public Comparator<E> worstToBestComparator() {
        return new Comparator<E>(){

            @Override
            public int compare(E val1, E val2) {
                if (val1.equals(val2)) {
                    return 0;
                }
                if (ScalarValuePlausibiltyFilter.this.isValueBetter(val1, val2)) {
                    return 1;
                }
                return -1;
            }
        };
    }

    default public E getBestValue(E val1, E val2) {
        if (this.isValueBetter(val1, val2)) {
            return val1;
        }
        return val2;
    }

    default public boolean isValueBetter(E testVal, E refVal) {
        return ScalarValuePlausibiltyFilter.isValueBetter(testVal, refVal, this.getAcceptableRange());
    }

    public static <E extends Number> boolean isValueBetter(E testVal, E refVal, Range<E> range) {
        double dist1 = ScalarValuePlausibiltyFilter.distFromRange(testVal, range);
        double dist2 = ScalarValuePlausibiltyFilter.distFromRange(refVal, range);
        if ((float)dist1 == 0.0f && (float)dist2 == 0.0f) {
            if (!range.hasLowerBound()) {
                return ((Comparable)((Object)testVal)).compareTo(refVal) < 0;
            }
            return ((Comparable)((Object)testVal)).compareTo(refVal) > 0;
        }
        return dist1 < dist2;
    }

    public static <E extends Number> double distFromRange(E val, Range<E> range) {
        if (range.contains(val)) {
            return 0.0;
        }
        if (range.hasUpperBound() && ((Comparable)((Object)val)).compareTo((Number)((Object)range.upperEndpoint())) > 0) {
            return val.doubleValue() - ((Number)((Object)range.upperEndpoint())).doubleValue();
        }
        return ((Number)((Object)range.lowerEndpoint())).doubleValue() - val.doubleValue();
    }

    default public String getRangeStr() {
        return ScalarValuePlausibiltyFilter.getRangeStr(this.getAcceptableRange());
    }

    public static <E extends Number> String getRangeStr(Range<E> acceptableRange) {
        Preconditions.checkState((acceptableRange.hasLowerBound() || acceptableRange.hasUpperBound() ? 1 : 0) != 0);
        if (!acceptableRange.hasLowerBound()) {
            char ineq;
            Number upper = (Number)((Object)acceptableRange.upperEndpoint());
            char c = ineq = acceptableRange.upperBoundType() == BoundType.CLOSED ? (char)'\u2264' : '<';
            if (upper.floatValue() == 0.0f) {
                return ineq + "0";
            }
            return ineq + String.valueOf(upper);
        }
        if (!acceptableRange.hasUpperBound()) {
            char ineq;
            Number lower = (Number)((Object)acceptableRange.lowerEndpoint());
            char c = ineq = acceptableRange.lowerBoundType() == BoundType.CLOSED ? (char)'\u2265' : '>';
            if (lower.floatValue() == 0.0f) {
                return ineq + "0";
            }
            return ineq + String.valueOf(lower);
        }
        Object ret = "\u2208";
        ret = (String)ret + (acceptableRange.lowerBoundType() == BoundType.CLOSED ? "[" : "(");
        ret = (String)ret + String.valueOf(acceptableRange.lowerEndpoint()) + "," + String.valueOf(acceptableRange.upperEndpoint());
        ret = (String)ret + (acceptableRange.upperBoundType() == BoundType.CLOSED ? "]" : ")");
        return ret;
    }

    public static class DoubleWrapper
    implements ScalarValuePlausibiltyFilter<Double> {
        private ScalarValuePlausibiltyFilter<?> filter;
        private Range<Double> doubleRange;

        public DoubleWrapper(ScalarValuePlausibiltyFilter<?> filter) {
            this.filter = filter;
            Range<?> origRange = filter.getAcceptableRange();
            this.doubleRange = origRange.hasLowerBound() && origRange.hasUpperBound() ? Range.range((Comparable)Double.valueOf(this.numberToDouble(origRange.lowerEndpoint())), (BoundType)origRange.lowerBoundType(), (Comparable)Double.valueOf(this.numberToDouble(origRange.upperEndpoint())), (BoundType)origRange.upperBoundType()) : (origRange.hasLowerBound() ? Range.downTo((Comparable)Double.valueOf(this.numberToDouble(origRange.lowerEndpoint())), (BoundType)origRange.lowerBoundType()) : Range.upTo((Comparable)Double.valueOf(this.numberToDouble(origRange.upperEndpoint())), (BoundType)origRange.upperBoundType()));
        }

        private double numberToDouble(Object obj) {
            return ((Number)obj).doubleValue();
        }

        @Override
        public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
            return this.filter.apply(rupture, verbose);
        }

        @Override
        public String getShortName() {
            return this.filter.getShortName();
        }

        @Override
        public String getName() {
            return this.filter.getName();
        }

        @Override
        public Double getValue(ClusterRupture rupture) {
            Object value = this.filter.getValue(rupture);
            if (value == null) {
                return null;
            }
            return ((Number)value).doubleValue();
        }

        @Override
        public Range<Double> getAcceptableRange() {
            return this.doubleRange;
        }

        @Override
        public String getScalarName() {
            return this.filter.getScalarName();
        }

        @Override
        public String getScalarUnits() {
            return this.filter.getScalarUnits();
        }
    }
}

