/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.JumpPlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.ScalarValuePlausibiltyFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;

public class JumpAzimuthChangeFilter
extends JumpPlausibilityFilter
implements ScalarValuePlausibiltyFilter<Float> {
    private AzimuthCalc azCalc;
    private float threshold;
    private transient boolean errOnCantEval = false;
    private boolean useEndpointsForSingle = true;

    public JumpAzimuthChangeFilter(AzimuthCalc calc, float threshold) {
        this.azCalc = calc;
        this.threshold = threshold;
    }

    public void setErrOnCantEvaluate(boolean errOnCantEval) {
        this.errOnCantEval = errOnCantEval;
    }

    @Override
    public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
        if (this.errOnCantEval) {
            PlausibilityResult result = PlausibilityResult.PASS;
            RuntimeException error = null;
            for (Jump jump : rupture.getJumpsIterable()) {
                if (!result.canContinue()) {
                    return result;
                }
                try {
                    result = result.logicalAnd(this.testJump(rupture, jump, verbose));
                }
                catch (RuntimeException e) {
                    error = e;
                }
            }
            if (error != null) {
                if (!result.isPass()) {
                    return result;
                }
                throw error;
            }
            return result;
        }
        return super.apply(rupture, verbose);
    }

    @Override
    public PlausibilityResult testJump(ClusterRupture rupture, Jump jump, boolean verbose) {
        RuptureTreeNavigator navigator = rupture.getTreeNavigator();
        FaultSection before1 = navigator.getPredecessor(jump.fromSection);
        if (before1 == null && !this.useEndpointsForSingle) {
            if (this.errOnCantEval) {
                throw new IllegalStateException(this.getShortName() + ": erring because fewer than 2 sects before a jump");
            }
            if (verbose) {
                System.out.println(this.getShortName() + ": failing because fewer than 2 before 1st jump");
            }
            return PlausibilityResult.FAIL_HARD_STOP;
        }
        Float value = this.calc(rupture, jump, verbose);
        if (value == null) {
            if (this.errOnCantEval) {
                throw new IllegalStateException(this.getShortName() + ": erring because fewer than 2 sects after a jump");
            }
            return PlausibilityResult.FAIL_FUTURE_POSSIBLE;
        }
        if (value.floatValue() > this.threshold) {
            if (this.useEndpointsForSingle && navigator.getDescendants(jump.toCluster).isEmpty()) {
                return PlausibilityResult.FAIL_FUTURE_POSSIBLE;
            }
            return PlausibilityResult.FAIL_HARD_STOP;
        }
        return PlausibilityResult.PASS;
    }

    public static double horzDistToTrace(Location loc, FaultTrace trace) {
        double minDist = Double.POSITIVE_INFINITY;
        for (Location loc2 : trace) {
            minDist = Math.min(minDist, LocationUtils.horzDistanceFast(loc, loc2));
        }
        return minDist;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Float calc(ClusterRupture rupture, Jump jump, boolean verbose) {
        double beforeAz;
        int beforeID1;
        FaultSection after1;
        FaultSection before2;
        RuptureTreeNavigator navigator;
        block23: {
            FaultSection before1;
            block22: {
                navigator = rupture.getTreeNavigator();
                before1 = navigator.getPredecessor(jump.fromSection);
                before2 = jump.fromSection;
                after1 = jump.toSection;
                if (before1 != null) break block22;
                if (this.useEndpointsForSingle) {
                    Location tmp;
                    beforeID1 = -1;
                    Location startLoc = before2.getFaultTrace().first();
                    Location endLoc = before2.getFaultTrace().last();
                    if (JumpAzimuthChangeFilter.horzDistToTrace(startLoc, after1.getFaultTrace()) < JumpAzimuthChangeFilter.horzDistToTrace(endLoc, after1.getFaultTrace())) {
                        tmp = startLoc;
                        startLoc = endLoc;
                        endLoc = tmp;
                    }
                    if (this.azCalc instanceof HardCodedLeftLateralFlipAzimuthCalc) {
                        if (((HardCodedLeftLateralFlipAzimuthCalc)this.azCalc).parentIDs.contains(before2.getParentSectionId())) {
                            tmp = startLoc;
                            startLoc = endLoc;
                            endLoc = tmp;
                        }
                    } else if (this.azCalc instanceof LeftLateralFlipAzimuthCalc && ((LeftLateralFlipAzimuthCalc)this.azCalc).rakeRange.contains((Comparable)Double.valueOf(before2.getAveRake()))) {
                        tmp = startLoc;
                        startLoc = endLoc;
                        endLoc = tmp;
                    }
                    beforeAz = LocationUtils.azimuth(startLoc, endLoc);
                    if (verbose) {
                        System.out.println(this.getShortName() + ": using endpoint azimuth for beforeAz=" + beforeAz);
                    }
                    break block23;
                } else {
                    if (verbose) {
                        System.out.println(this.getShortName() + ": failing because fewer than 2 before 1st jump");
                    }
                    return null;
                }
            }
            beforeID1 = before1.getSectionId();
            beforeAz = this.azCalc.calcAzimuth(before1, before2);
        }
        Preconditions.checkState((boolean)rupture.contains(after1));
        Collection<FaultSection> after2s = navigator.getDescendants(after1);
        if (after2s.isEmpty()) {
            if (this.useEndpointsForSingle) {
                Location tmp;
                Location startLoc = after1.getFaultTrace().first();
                Location endLoc = after1.getFaultTrace().last();
                if (JumpAzimuthChangeFilter.horzDistToTrace(startLoc, before2.getFaultTrace()) > JumpAzimuthChangeFilter.horzDistToTrace(endLoc, before2.getFaultTrace())) {
                    tmp = startLoc;
                    startLoc = endLoc;
                    endLoc = tmp;
                }
                if (this.azCalc instanceof HardCodedLeftLateralFlipAzimuthCalc) {
                    if (((HardCodedLeftLateralFlipAzimuthCalc)this.azCalc).parentIDs.contains(after1.getParentSectionId())) {
                        tmp = startLoc;
                        startLoc = endLoc;
                        endLoc = tmp;
                    }
                } else if (this.azCalc instanceof LeftLateralFlipAzimuthCalc && ((LeftLateralFlipAzimuthCalc)this.azCalc).rakeRange.contains((Comparable)Double.valueOf(after1.getAveRake()))) {
                    tmp = startLoc;
                    startLoc = endLoc;
                    endLoc = tmp;
                }
                double afterAz = LocationUtils.azimuth(startLoc, endLoc);
                if (verbose) {
                    System.out.println(this.getShortName() + ": using endpoint azimuth for afterAz=" + afterAz);
                }
                double diff = JumpAzimuthChangeFilter.getAzimuthDifference(beforeAz, afterAz);
                Preconditions.checkState((boolean)Double.isFinite(diff));
                if (verbose) {
                    System.out.println(this.getShortName() + ": [" + beforeID1 + "," + before2.getSectionId() + "]=" + beforeAz + " => [" + after1.getSectionId() + ",-1]=" + afterAz + " = " + diff);
                }
                return Float.valueOf((float)Math.abs(diff));
            }
            if (verbose) {
                System.out.println(this.getShortName() + ": jump to single-section cluster & nothing downstream");
            }
            return null;
        }
        float maxVal = 0.0f;
        Iterator<FaultSection> iterator = after2s.iterator();
        while (iterator.hasNext()) {
            FaultSection after2 = iterator.next();
            double afterAz = this.azCalc.calcAzimuth(after1, after2);
            double diff = JumpAzimuthChangeFilter.getAzimuthDifference(beforeAz, afterAz);
            Preconditions.checkState((boolean)Double.isFinite(diff));
            if (verbose) {
                System.out.println(this.getShortName() + ": [" + beforeID1 + "," + before2.getSectionId() + "]=" + beforeAz + " => [" + after1.getSectionId() + "," + after2.getSectionId() + "]=" + afterAz + " = " + diff);
            }
            maxVal = Float.max(maxVal, (float)Math.abs(diff));
        }
        return Float.valueOf(maxVal);
    }

    public static double getAzimuthDifference(double azimuth1, double azimuth2) {
        double diff = azimuth2 - azimuth1;
        if (diff > 180.0) {
            return diff - 360.0;
        }
        if (diff < -180.0) {
            return diff + 360.0;
        }
        return diff;
    }

    private static HashSet<Integer> getU3LeftLateralParents() {
        HashSet<Integer> parentIDs = new HashSet<Integer>();
        parentIDs.add(48);
        parentIDs.add(49);
        parentIDs.add(93);
        parentIDs.add(341);
        parentIDs.add(47);
        parentIDs.add(169);
        return parentIDs;
    }

    @Override
    public String getShortName() {
        return "JumpAz";
    }

    @Override
    public String getName() {
        return "Jump Azimuth Change Filter";
    }

    @Override
    public Float getValue(ClusterRupture rupture) {
        float max = 0.0f;
        for (Jump jump : rupture.getJumpsIterable()) {
            Float val = this.calc(rupture, jump, false);
            if (val == null) {
                return val;
            }
            max = Float.max(val.floatValue(), max);
        }
        return Float.valueOf(max);
    }

    @Override
    public Range<Float> getAcceptableRange() {
        return Range.atMost((Comparable)Float.valueOf(this.threshold));
    }

    @Override
    public String getScalarName() {
        return "Max Jump Azimuth Change";
    }

    @Override
    public String getScalarUnits() {
        return "Degrees";
    }

    @Override
    public boolean isDirectional(boolean splayed) {
        return splayed;
    }

    public static interface AzimuthCalc {
        public double calcAzimuth(FaultSection var1, FaultSection var2);
    }

    public static class HardCodedLeftLateralFlipAzimuthCalc
    implements AzimuthCalc {
        private SectionDistanceAzimuthCalculator calc;
        private HashSet<Integer> parentIDs;

        public HardCodedLeftLateralFlipAzimuthCalc(SectionDistanceAzimuthCalculator calc, HashSet<Integer> parentIDs) {
            this.calc = calc;
            this.parentIDs = parentIDs;
        }

        @Override
        public double calcAzimuth(FaultSection sect1, FaultSection sect2) {
            if (this.parentIDs.contains(sect1.getParentSectionId()) && this.parentIDs.contains(sect2.getParentSectionId())) {
                return this.calc.getAzimuth(sect2, sect1);
            }
            return this.calc.getAzimuth(sect1, sect2);
        }
    }

    public static class LeftLateralFlipAzimuthCalc
    implements AzimuthCalc {
        private SectionDistanceAzimuthCalculator calc;
        private Range<Double> rakeRange;

        public LeftLateralFlipAzimuthCalc(SectionDistanceAzimuthCalculator calc, Range<Double> rakeRange) {
            this.calc = calc;
            this.rakeRange = rakeRange;
        }

        @Override
        public double calcAzimuth(FaultSection sect1, FaultSection sect2) {
            if (this.rakeRange.contains((Comparable)Double.valueOf(sect1.getAveRake())) && this.rakeRange.contains((Comparable)Double.valueOf(sect2.getAveRake()))) {
                return this.calc.getAzimuth(sect2, sect1);
            }
            return this.calc.getAzimuth(sect1, sect2);
        }
    }

    public static class AzimuthCalcTypeAdapter
    extends TypeAdapter<AzimuthCalc> {
        private SectionDistanceAzimuthCalculator distAzCalc;

        public AzimuthCalcTypeAdapter(SectionDistanceAzimuthCalculator distAzCalc) {
            this.distAzCalc = distAzCalc;
        }

        public void write(JsonWriter out, AzimuthCalc calc) throws IOException {
            out.beginObject();
            if (calc instanceof LeftLateralFlipAzimuthCalc) {
                Range<Double> range = ((LeftLateralFlipAzimuthCalc)calc).rakeRange;
                Object rangeStr = "";
                rangeStr = range.lowerBoundType() == BoundType.CLOSED ? (String)rangeStr + "[" : (String)rangeStr + "(";
                rangeStr = (String)rangeStr + String.valueOf(range.lowerEndpoint()) + "," + String.valueOf(range.upperEndpoint());
                rangeStr = range.upperBoundType() == BoundType.CLOSED ? (String)rangeStr + "]" : ")";
                out.name("leftLateralRange").value((String)rangeStr);
            } else if (calc instanceof HardCodedLeftLateralFlipAzimuthCalc) {
                out.name("leftLateralParents").beginArray();
                for (Integer parent : ((HardCodedLeftLateralFlipAzimuthCalc)calc).parentIDs) {
                    out.value((Number)parent);
                }
                out.endArray();
            } else {
                Preconditions.checkState((boolean)(calc instanceof SimpleAzimuthCalc), (Object)"Don't know how to serialize this azimuth calculator");
            }
            out.endObject();
        }

        public AzimuthCalc read(JsonReader in) throws IOException {
            in.beginObject();
            AzimuthCalc calc = null;
            while (in.hasNext()) {
                switch (in.nextName()) {
                    case "leftLateralRange": {
                        boolean upperClosed;
                        boolean lowerClosed;
                        String str = in.nextString().trim();
                        if (str.startsWith("[")) {
                            lowerClosed = true;
                        } else {
                            lowerClosed = false;
                            Preconditions.checkState((boolean)str.startsWith("("));
                        }
                        str = str.substring(1);
                        if (str.endsWith("]")) {
                            upperClosed = true;
                        } else {
                            upperClosed = false;
                            Preconditions.checkState((boolean)str.endsWith(")"));
                        }
                        str = str.substring(0, str.length() - 1);
                        String[] split = str.split(",");
                        Preconditions.checkState((split.length == 2 ? 1 : 0) != 0);
                        double lower = Double.parseDouble(split[0]);
                        double upper = Double.parseDouble(split[1]);
                        Range range = lowerClosed && upperClosed ? Range.closed((Comparable)Double.valueOf(lower), (Comparable)Double.valueOf(upper)) : (lowerClosed && !upperClosed ? Range.closedOpen((Comparable)Double.valueOf(lower), (Comparable)Double.valueOf(upper)) : (!lowerClosed && upperClosed ? Range.openClosed((Comparable)Double.valueOf(lower), (Comparable)Double.valueOf(upper)) : Range.open((Comparable)Double.valueOf(lower), (Comparable)Double.valueOf(upper))));
                        calc = new LeftLateralFlipAzimuthCalc(this.distAzCalc, (Range<Double>)range);
                        break;
                    }
                    case "leftLateralParents": {
                        HashSet<Integer> parents = new HashSet<Integer>();
                        in.beginArray();
                        while (in.hasNext()) {
                            parents.add(in.nextInt());
                        }
                        in.endArray();
                        calc = new HardCodedLeftLateralFlipAzimuthCalc(this.distAzCalc, parents);
                        break;
                    }
                }
            }
            if (calc == null) {
                calc = new SimpleAzimuthCalc(this.distAzCalc);
            }
            in.endObject();
            return calc;
        }
    }

    public static class SimpleAzimuthCalc
    implements AzimuthCalc {
        private SectionDistanceAzimuthCalculator calc;

        public SimpleAzimuthCalc(SectionDistanceAzimuthCalculator calc) {
            this.calc = calc;
        }

        @Override
        public double calcAzimuth(FaultSection sect1, FaultSection sect2) {
            return this.calc.getAzimuth(sect1, sect2);
        }
    }

    public static class UCERF3LeftLateralFlipAzimuthCalc
    extends HardCodedLeftLateralFlipAzimuthCalc {
        public UCERF3LeftLateralFlipAzimuthCalc(SectionDistanceAzimuthCalculator calc) {
            super(calc, JumpAzimuthChangeFilter.getU3LeftLateralParents());
        }
    }
}

