/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl;

import com.google.common.collect.Range;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.ScalarValuePlausibiltyFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.CumulativeRakeChangeFilter;
import org.opensha.sha.faultSurface.FaultSection;

public class JumpCumulativeRakeChangeFilter
implements ScalarValuePlausibiltyFilter<Float> {
    private float threshold;

    public JumpCumulativeRakeChangeFilter(float threshold) {
        this.threshold = threshold;
    }

    @Override
    public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
        double tot = this.calc(rupture, verbose, !verbose);
        if ((float)tot <= this.threshold) {
            if (verbose) {
                System.out.println(this.getShortName() + ": passing with tot=" + tot);
            }
            return PlausibilityResult.PASS;
        }
        if (verbose) {
            System.out.println(this.getShortName() + ": failing with tot=" + tot);
        }
        return PlausibilityResult.FAIL_HARD_STOP;
    }

    private double calc(ClusterRupture rupture, boolean verbose, boolean shortCircuit) {
        double tot = 0.0;
        for (Jump jump : rupture.getJumpsIterable()) {
            double diff = this.calc(jump, verbose);
            if (!((float)(tot += diff) > this.threshold) || !shortCircuit) continue;
            return tot;
        }
        return tot;
    }

    private double calc(Jump jump, boolean verbose) {
        FaultSection sect1 = jump.fromSection;
        FaultSection sect2 = jump.toSection;
        double rake1 = sect1.getAveRake();
        double rake2 = sect2.getAveRake();
        double diff = CumulativeRakeChangeFilter.rakeDiff(rake1, rake2);
        if (verbose && diff != 0.0) {
            System.out.println(this.getShortName() + ": " + sect1.getSectionId() + "=" + (float)rake1 + " => " + sect2.getSectionId() + "=" + (float)rake2 + " = " + diff);
        }
        return diff;
    }

    @Override
    public String getShortName() {
        return "JumpCumRake";
    }

    @Override
    public String getName() {
        return "Jump Cumulative Rake Filter";
    }

    @Override
    public Float getValue(ClusterRupture rupture) {
        return Float.valueOf((float)this.calc(rupture, false, false));
    }

    @Override
    public Range<Float> getAcceptableRange() {
        return Range.atMost((Comparable)Float.valueOf(this.threshold));
    }

    @Override
    public String getScalarName() {
        return "Cumulative Rake Change";
    }

    @Override
    public String getScalarUnits() {
        return "Degrees";
    }

    @Override
    public boolean isDirectional(boolean splayed) {
        return splayed;
    }
}

