/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.AbstractClusterSizeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;

public class MinSectsPerParentFilter
extends AbstractClusterSizeFilter {
    private int minPerParent;

    public MinSectsPerParentFilter(int minPerParent, boolean allowIfNoDirect, boolean allowChained, ClusterConnectionStrategy connStrategy) {
        super(allowIfNoDirect, allowChained, connStrategy);
        this.minPerParent = minPerParent;
    }

    @Override
    boolean isClusterSufficient(FaultSubsectionCluster cluster) {
        return cluster.subSects.size() >= this.minPerParent;
    }

    @Override
    String getQuantityStr(FaultSubsectionCluster cluster) {
        return "sectsPerParent=" + cluster.subSects.size();
    }

    @Override
    public String getShortName() {
        return "SectsPerParent";
    }

    @Override
    public String getName() {
        return "Min Sections Per Parent";
    }

    @Override
    public TypeAdapter<PlausibilityFilter> getTypeAdapter() {
        return new Adapter();
    }

    @Override
    public boolean isDirectional(boolean splayed) {
        return splayed;
    }

    public static class Adapter
    extends PlausibilityFilter.PlausibilityFilterTypeAdapter {
        private ClusterConnectionStrategy connStrategy;

        @Override
        public void init(ClusterConnectionStrategy connStrategy, SectionDistanceAzimuthCalculator distAzCalc, Gson gson) {
            this.connStrategy = connStrategy;
        }

        public void write(JsonWriter out, PlausibilityFilter value) throws IOException {
            MinSectsPerParentFilter filter = (MinSectsPerParentFilter)value;
            out.beginObject();
            out.name("minPerParent").value((long)filter.minPerParent);
            out.name("allowIfNoDirect").value(filter.allowIfNoDirect);
            out.name("allowChained").value(filter.allowChained);
            out.endObject();
        }

        public PlausibilityFilter read(JsonReader in) throws IOException {
            in.beginObject();
            Integer minPerParent = null;
            Boolean allowIfNoDirect = null;
            boolean allowChained = false;
            while (in.hasNext()) {
                switch (in.nextName()) {
                    case "minPerParent": {
                        minPerParent = in.nextInt();
                        break;
                    }
                    case "allowIfNoDirect": {
                        allowIfNoDirect = in.nextBoolean();
                        break;
                    }
                    case "allowChained": {
                        allowChained = in.nextBoolean();
                        break;
                    }
                }
            }
            in.endObject();
            return new MinSectsPerParentFilter(minPerParent, allowIfNoDirect, allowChained, this.connStrategy);
        }
    }
}

