/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl;

import com.google.common.collect.Range;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.ScalarValuePlausibiltyFilter;

public class NumClustersFilter
implements ScalarValuePlausibiltyFilter<Integer> {
    private int maxNumClusters;

    public NumClustersFilter(int maxNumClusters) {
        this.maxNumClusters = maxNumClusters;
    }

    @Override
    public String getShortName() {
        return "Max" + this.maxNumClusters + "Clusters";
    }

    @Override
    public String getName() {
        return "Max " + this.maxNumClusters + " Clusters";
    }

    @Override
    public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
        if (rupture.getTotalNumClusters() > this.maxNumClusters) {
            return PlausibilityResult.FAIL_HARD_STOP;
        }
        return PlausibilityResult.PASS;
    }

    @Override
    public Integer getValue(ClusterRupture rupture) {
        return rupture.getTotalNumClusters();
    }

    @Override
    public Range<Integer> getAcceptableRange() {
        return Range.atMost((Comparable)Integer.valueOf(this.maxNumClusters));
    }

    @Override
    public String getScalarName() {
        return "Number of Clusters";
    }

    @Override
    public String getScalarUnits() {
        return null;
    }
}

