/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.faultSurface.FaultSection;

public class SplayConnectionsOnlyFilter
implements PlausibilityFilter {
    private ClusterConnectionStrategy connStrat;
    private boolean applyToMainStrand;
    private transient Map<Integer, FaultSubsectionCluster> fullClusters;

    public SplayConnectionsOnlyFilter(ClusterConnectionStrategy connStrat, boolean applyToMainStrand) {
        this.connStrat = connStrat;
        this.applyToMainStrand = applyToMainStrand;
    }

    @Override
    public String getShortName() {
        return "SplayConnOnly";
    }

    @Override
    public String getName() {
        return "Splays Equal Length";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FaultSubsectionCluster getFullCluster(Integer parentID) {
        if (this.fullClusters == null) {
            SplayConnectionsOnlyFilter splayConnectionsOnlyFilter = this;
            synchronized (splayConnectionsOnlyFilter) {
                if (this.fullClusters == null) {
                    List<FaultSubsectionCluster> clusters = this.connStrat.getClusters();
                    HashMap<Integer, FaultSubsectionCluster> fullClusters = new HashMap<Integer, FaultSubsectionCluster>();
                    for (FaultSubsectionCluster cluster : clusters) {
                        fullClusters.put(cluster.parentSectionID, cluster);
                    }
                    this.fullClusters = fullClusters;
                }
            }
        }
        return this.fullClusters.get(parentID);
    }

    @Override
    public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
        if (rupture.splays.isEmpty()) {
            return PlausibilityResult.PASS;
        }
        RuptureTreeNavigator nav = rupture.getTreeNavigator();
        if (this.applyToMainStrand) {
            return this.doApply(rupture, nav);
        }
        PlausibilityResult result = PlausibilityResult.PASS;
        for (ClusterRupture splay : rupture.splays.values()) {
            result = result.logicalAnd(this.doApply(splay, nav));
        }
        return result;
    }

    private PlausibilityResult doApply(ClusterRupture rupture, RuptureTreeNavigator nav) {
        PlausibilityResult result = PlausibilityResult.PASS;
        for (FaultSubsectionCluster cluster : rupture.clusters) {
            boolean end;
            FaultSubsectionCluster full = this.getFullCluster(cluster.parentSectionID);
            FaultSection last = (FaultSection)cluster.subSects.get(cluster.subSects.size() - 1);
            int indexInFull = full.subSects.indexOf((Object)last);
            Preconditions.checkState((indexInFull >= 0 ? 1 : 0) != 0);
            boolean bl = end = indexInFull == 0 || indexInFull == full.subSects.size() - 1;
            if (end) continue;
            if (full.getConnections(last).isEmpty()) {
                return PlausibilityResult.FAIL_HARD_STOP;
            }
            if (!nav.getDescendants(last).isEmpty()) continue;
            result = PlausibilityResult.FAIL_FUTURE_POSSIBLE;
        }
        for (ClusterRupture splay : rupture.splays.values()) {
            result = result.logicalAnd(this.doApply(splay, nav));
        }
        return result;
    }

    @Override
    public boolean isDirectional(boolean splayed) {
        return splayed;
    }
}

