/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl;

import com.google.common.collect.Range;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.ScalarValuePlausibiltyFilter;

public class SplayCountFilter
implements ScalarValuePlausibiltyFilter<Integer> {
    private int maxSplays;

    public SplayCountFilter(int maxSplays) {
        this.maxSplays = maxSplays;
    }

    @Override
    public String getShortName() {
        if (this.maxSplays == 0) {
            return "NoSplays";
        }
        if (this.maxSplays > 1) {
            return "Max" + this.maxSplays + "Splays";
        }
        return "Max1Splay";
    }

    @Override
    public String getName() {
        if (this.maxSplays == 0) {
            return "No Splays";
        }
        if (this.maxSplays > 1) {
            return "Max " + this.maxSplays + " Splays";
        }
        return "Max 1 Splay";
    }

    @Override
    public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
        int count = rupture.getTotalNumSplays();
        if (verbose) {
            System.out.println("Have " + count + " splays");
        }
        if (count > this.maxSplays) {
            return PlausibilityResult.FAIL_HARD_STOP;
        }
        return PlausibilityResult.PASS;
    }

    @Override
    public Integer getValue(ClusterRupture rupture) {
        return rupture.getTotalNumSplays();
    }

    @Override
    public Range<Integer> getAcceptableRange() {
        return Range.atMost((Comparable)Integer.valueOf(this.maxSplays));
    }

    @Override
    public String getScalarName() {
        return "Number of Splays";
    }

    @Override
    public String getScalarUnits() {
        return null;
    }

    @Override
    public boolean isDirectional(boolean splayed) {
        return splayed;
    }
}

