/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.coulomb;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.ScalarCoulombPlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCalculator;

public class ClusterCoulombCompatibilityFilter
implements ScalarCoulombPlausibilityFilter {
    private AggregatedStiffnessCalculator aggCalc;
    private Range<Float> acceptableRange;

    public ClusterCoulombCompatibilityFilter(AggregatedStiffnessCalculator aggCalc, float threshold) {
        this(aggCalc, (Range<Float>)Range.atLeast((Comparable)Float.valueOf(threshold)));
    }

    public ClusterCoulombCompatibilityFilter(AggregatedStiffnessCalculator aggCalc, Range<Float> acceptableRange) {
        this.aggCalc = aggCalc;
        this.acceptableRange = acceptableRange;
    }

    @Override
    public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
        PlausibilityResult result;
        double worstVal = this.doTest(new ArrayList<FaultSection>(), rupture.clusters[0], rupture.getTreeNavigator(), verbose, !verbose);
        PlausibilityResult plausibilityResult = result = this.acceptableRange.contains((Comparable)Float.valueOf((float)worstVal)) ? PlausibilityResult.PASS : PlausibilityResult.FAIL_HARD_STOP;
        if (verbose) {
            System.out.println(this.getShortName() + ": worst val=" + worstVal + "\tresult=" + result.name());
        }
        return result;
    }

    @Override
    public Float getValue(ClusterRupture rupture) {
        if (rupture.getTotalNumJumps() == 0) {
            return null;
        }
        return Float.valueOf(this.doTest(new ArrayList<FaultSection>(), rupture.clusters[0], rupture.getTreeNavigator(), false, false));
    }

    private float doTest(List<FaultSection> curSects, FaultSubsectionCluster nextCluster, RuptureTreeNavigator navigator, boolean verbose, boolean shortCircuit) {
        float val = Float.POSITIVE_INFINITY;
        if (!curSects.isEmpty()) {
            val = (float)this.aggCalc.calc((Collection<? extends FaultSection>)curSects, (Collection<? extends FaultSection>)nextCluster.subSects);
            if (verbose) {
                System.out.println(this.getShortName() + ": " + curSects.size() + " sects to " + String.valueOf(nextCluster) + ", val=" + val);
            } else if (!this.acceptableRange.contains((Comparable)Float.valueOf(val))) {
                return val;
            }
        }
        if (navigator != null) {
            for (FaultSubsectionCluster descendant : navigator.getDescendants(nextCluster)) {
                ArrayList<FaultSection> newSects = new ArrayList<FaultSection>(curSects);
                newSects.addAll((Collection<FaultSection>)nextCluster.subSects);
                val = this.getWorseValue(Float.valueOf(val), Float.valueOf(this.doTest(newSects, descendant, navigator, verbose, shortCircuit))).floatValue();
                if (verbose || this.acceptableRange.contains((Comparable)Float.valueOf(val))) continue;
                break;
            }
        }
        return val;
    }

    @Override
    public String getShortName() {
        String type = "[" + this.aggCalc.getScalarShortName() + "]";
        return "JumpCluster" + type + this.getRangeStr();
    }

    @Override
    public String getName() {
        String type = "[" + this.aggCalc.getScalarName() + "]";
        return "Jump Cluster " + type + " " + this.getRangeStr();
    }

    @Override
    public boolean isDirectional(boolean splayed) {
        return true;
    }

    @Override
    public Range<Float> getAcceptableRange() {
        return this.acceptableRange;
    }

    @Override
    public AggregatedStiffnessCalculator getAggregator() {
        return this.aggCalc;
    }
}

