/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.coulomb;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCalculator;
import org.opensha.sha.simulators.stiffness.SubSectStiffnessCalculator;
import scratch.UCERF3.inversion.coulomb.CoulombRates;
import scratch.UCERF3.inversion.coulomb.CoulombRatesRecord;
import scratch.UCERF3.inversion.coulomb.CoulombRatesTester;

public class U3CoulombJunctionFilter
implements PlausibilityFilter {
    private CoulombRatesTester tester;
    private CoulombRates coulombRates;
    private AggregatedStiffnessCalculator tauCalc;
    private AggregatedStiffnessCalculator cffCalc;
    private transient ClusterConnectionStrategy connStrat;

    public U3CoulombJunctionFilter(CoulombRatesTester tester, CoulombRates coulombRates) {
        this.tester = tester;
        this.coulombRates = coulombRates;
    }

    @Override
    public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
        if (rupture.getTotalNumJumps() == 0) {
            return PlausibilityResult.PASS;
        }
        ArrayList<List<IDPairing>> paths = new ArrayList<List<IDPairing>>();
        this.findPaths(rupture.getTreeNavigator(), paths, new ArrayList<IDPairing>(), rupture.clusters[0].startSect);
        return this.testPaths(paths, verbose);
    }

    private void findPaths(RuptureTreeNavigator navigator, List<List<IDPairing>> fullPaths, List<IDPairing> curPath, FaultSection curSect) {
        Collection<FaultSection> descendants = navigator.getDescendants(curSect);
        while (descendants.size() == 1) {
            FaultSection destSect = descendants.iterator().next();
            if (curSect.getParentSectionId() != destSect.getParentSectionId()) {
                curPath.add(new IDPairing(curSect.getSectionId(), destSect.getSectionId()));
            }
            curSect = destSect;
            descendants = navigator.getDescendants(curSect);
        }
        if (descendants.isEmpty()) {
            fullPaths.add(curPath);
        } else {
            for (FaultSection destSect : descendants) {
                ArrayList<IDPairing> branchPath = new ArrayList<IDPairing>(curPath);
                if (curSect.getParentSectionId() != destSect.getParentSectionId()) {
                    branchPath.add(new IDPairing(curSect.getSectionId(), destSect.getSectionId()));
                }
                this.findPaths(navigator, fullPaths, branchPath, destSect);
            }
        }
    }

    private PlausibilityResult testPaths(List<List<IDPairing>> paths, boolean verbose) {
        if (verbose) {
            System.out.println(this.getShortName() + ": found " + paths.size() + " paths");
        }
        Preconditions.checkState((paths.size() >= 0 ? 1 : 0) != 0);
        for (List<IDPairing> path : paths) {
            if (verbose) {
                System.out.println(this.getShortName() + ": testing a path with " + path.size() + " jumps");
            }
            if (path.isEmpty()) continue;
            ArrayList<CoulombRatesRecord> forwardRates = new ArrayList<CoulombRatesRecord>();
            ArrayList<CoulombRatesRecord> backwardRates = new ArrayList<CoulombRatesRecord>();
            for (IDPairing pair : path) {
                CoulombRatesRecord forwardRate = this.getCoulombRates(pair);
                Preconditions.checkNotNull((Object)forwardRate, (String)"No coulomb rates for %s", (Object)pair);
                CoulombRatesRecord backwardRate = this.getCoulombRates(pair.getReversed());
                Preconditions.checkNotNull((Object)backwardRate, (String)"No coulomb rates for reversed %s", (Object)pair);
                if (verbose) {
                    System.out.println(this.getShortName() + ": " + pair.getID1() + " => " + pair.getID2());
                    System.out.println("\tForward rate: " + String.valueOf(forwardRate));
                    System.out.println("\tBackward rate: " + String.valueOf(backwardRate));
                }
                forwardRates.add(forwardRate);
                backwardRates.add(0, backwardRate);
            }
            boolean passes = this.tester.doesRupturePass(forwardRates, backwardRates);
            if (verbose) {
                System.out.println(this.getShortName() + ": test with " + forwardRates.size() + " jumps. passes ? " + passes);
            }
            if (passes) continue;
            return PlausibilityResult.FAIL_HARD_STOP;
        }
        return PlausibilityResult.PASS;
    }

    public void setFallbackCalculator(SubSectStiffnessCalculator calc, ClusterConnectionStrategy connStrat) {
        Preconditions.checkState((calc.getGridSpacing() == 1.0 ? 1 : 0) != 0, (Object)"Should be 1km grid spacing for fallback calculation");
        this.connStrat = connStrat;
        CoulombRatesTester.TestType testType = this.tester.getTestType();
        if (testType == CoulombRatesTester.TestType.SHEAR_STRESS) {
            this.tauCalc = new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.TAU, calc, false, AggregatedStiffnessCalculator.AggregationMethod.MAX, AggregatedStiffnessCalculator.AggregationMethod.MAX);
        } else if (testType == CoulombRatesTester.TestType.COULOMB_STRESS) {
            this.cffCalc = new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.CFF, calc, false, AggregatedStiffnessCalculator.AggregationMethod.MAX, AggregatedStiffnessCalculator.AggregationMethod.MAX);
        } else {
            this.tauCalc = new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.TAU, calc, false, AggregatedStiffnessCalculator.AggregationMethod.MAX, AggregatedStiffnessCalculator.AggregationMethod.MAX);
            this.cffCalc = new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.CFF, calc, false, AggregatedStiffnessCalculator.AggregationMethod.MAX, AggregatedStiffnessCalculator.AggregationMethod.MAX);
        }
    }

    public CoulombRatesRecord calculateFallbackCoulombRates(IDPairing pair) {
        SubSectStiffnessCalculator.StiffnessType[] types;
        Preconditions.checkNotNull((Object)this.connStrat, (Object)"have stiffness calculator but not connection strategy");
        List<? extends FaultSection> subSects = this.cffCalc.getCalc().getSubSects();
        double ds = 0.0;
        double pds = 0.0;
        double dcff = 0.0;
        double pdcff = 0.0;
        switch (this.tester.getTestType()) {
            case COULOMB_STRESS: {
                types = new SubSectStiffnessCalculator.StiffnessType[]{SubSectStiffnessCalculator.StiffnessType.CFF};
                break;
            }
            case SHEAR_STRESS: {
                types = new SubSectStiffnessCalculator.StiffnessType[]{SubSectStiffnessCalculator.StiffnessType.TAU};
                break;
            }
            default: {
                types = new SubSectStiffnessCalculator.StiffnessType[]{SubSectStiffnessCalculator.StiffnessType.TAU, SubSectStiffnessCalculator.StiffnessType.CFF};
            }
        }
        for (SubSectStiffnessCalculator.StiffnessType type : types) {
            double prob;
            AggregatedStiffnessCalculator stiffnessCalc = type == SubSectStiffnessCalculator.StiffnessType.CFF ? this.cffCalc : this.tauCalc;
            Preconditions.checkNotNull((Object)((Object)type), (String)"Don't have a stiffness calculator for %s", (Object)((Object)type));
            FaultSection source = subSects.get(pair.getID1());
            Preconditions.checkState((source.getSectionId() == pair.getID1() ? 1 : 0) != 0);
            FaultSection receiver = subSects.get(pair.getID2());
            Preconditions.checkState((receiver.getSectionId() == pair.getID2() ? 1 : 0) != 0);
            double val = Math.max(0.0, stiffnessCalc.calc(source, receiver));
            double sum = val *= 1.5945456137624658;
            for (Jump jump : this.connStrat.getJumpsFrom(source)) {
                if (jump.toCluster.parentSectionID == receiver.getParentSectionId()) continue;
                sum += Math.max(0.0, stiffnessCalc.calc(source, jump.toSection));
            }
            if (source.getSectionId() > 0 && source.getParentSectionId() == subSects.get(source.getSectionId() - 1).getParentSectionId()) {
                sum += Math.max(0.0, stiffnessCalc.calc(source, subSects.get(source.getSectionId() - 1)));
            }
            if (source.getSectionId() < subSects.size() - 1 && source.getParentSectionId() == subSects.get(source.getSectionId() + 1).getParentSectionId()) {
                sum += Math.max(0.0, stiffnessCalc.calc(source, subSects.get(source.getSectionId() + 1)));
            }
            double d = prob = sum > 0.0 ? val / sum : 0.0;
            if (type == SubSectStiffnessCalculator.StiffnessType.CFF) {
                dcff = val;
                pdcff = prob;
                continue;
            }
            ds = val;
            pds = prob;
        }
        return new CoulombRatesRecord(pair, ds, pds, dcff, pdcff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoulombRatesRecord getCoulombRates(IDPairing pair) {
        CoulombRatesRecord rates;
        U3CoulombJunctionFilter u3CoulombJunctionFilter = this;
        synchronized (u3CoulombJunctionFilter) {
            rates = (CoulombRatesRecord)this.coulombRates.get(pair);
        }
        if (rates == null && (this.cffCalc != null || this.tauCalc != null)) {
            rates = this.calculateFallbackCoulombRates(pair);
            u3CoulombJunctionFilter = this;
            synchronized (u3CoulombJunctionFilter) {
                this.coulombRates.put(pair, rates);
            }
        }
        return rates;
    }

    @Override
    public String getShortName() {
        return "Coulomb";
    }

    @Override
    public String getName() {
        return "Coulomb Jump Filter";
    }

    @Override
    public boolean isDirectional(boolean splayed) {
        return splayed;
    }

    @Override
    public TypeAdapter<PlausibilityFilter> getTypeAdapter() {
        return new Adapter();
    }

    public static class Adapter
    extends PlausibilityFilter.PlausibilityFilterTypeAdapter {
        private ClusterConnectionStrategy connStrategy;
        private Gson gson;

        @Override
        public void init(ClusterConnectionStrategy connStrategy, SectionDistanceAzimuthCalculator distAzCalc, Gson gson) {
            this.connStrategy = connStrategy;
            this.gson = gson;
        }

        public void write(JsonWriter out, PlausibilityFilter value) throws IOException {
            U3CoulombJunctionFilter filter = (U3CoulombJunctionFilter)value;
            this.gson.toJson((Object)filter, filter.getClass(), out);
        }

        public PlausibilityFilter read(JsonReader in) throws IOException {
            U3CoulombJunctionFilter filter = (U3CoulombJunctionFilter)this.gson.fromJson(in, U3CoulombJunctionFilter.class);
            filter.connStrat = this.connStrategy;
            return filter;
        }
    }
}

