/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.ScalarValuePlausibiltyFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.NucleationClusterEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.faultSurface.FaultSection;

public abstract class PathEvaluator
implements NucleationClusterEvaluator {
    public abstract PlausibilityResult testAddition(Collection<FaultSection> var1, PathAddition var2, boolean var3);

    protected abstract PathNavigator getPathNav(ClusterRupture var1, FaultSubsectionCluster var2);

    @Override
    public PlausibilityResult testNucleationCluster(ClusterRupture rupture, FaultSubsectionCluster nucleationCluster, boolean verbose) {
        PathNavigator nav = this.getPathNav(rupture, nucleationCluster);
        nav.setVerbose(verbose);
        if (verbose) {
            System.out.println(this.getName() + ": testing strand(s) with start=" + String.valueOf(nucleationCluster));
        }
        List<FaultSection> curSects = nav.getCurrentSects();
        Set<PathAddition> nextAdds = nav.getNextAdditions();
        if (verbose) {
            System.out.println("Have " + nextAdds.size() + " nextAdds");
        }
        PlausibilityResult result = PlausibilityResult.PASS;
        while (!nextAdds.isEmpty()) {
            for (PathAddition add : nextAdds) {
                PlausibilityResult myResult = this.testAddition(curSects, add, verbose);
                if (verbose) {
                    System.out.println("\taddition=" + String.valueOf(add) + " w/ " + curSects.size() + " sources: " + String.valueOf((Object)myResult));
                }
                result = result.logicalAnd(myResult);
                if (verbose || result.isPass()) continue;
                return result;
            }
            curSects = nav.getCurrentSects();
            nextAdds = nav.getNextAdditions();
            if (!verbose) continue;
            System.out.println("Have " + nextAdds.size() + " nextAdds");
        }
        Preconditions.checkState((nav.getCurrentSects().size() == rupture.getTotalNumSects() ? 1 : 0) != 0, (String)"Processed %s sects but rupture has %s:\n\t%s", (Object)nav.getCurrentSects().size(), (Object)rupture.getTotalNumSects(), (Object)rupture);
        return result;
    }

    public static interface PathNavigator {
        public List<FaultSection> getCurrentSects();

        public Set<PathAddition> getNextAdditions();

        default public void setVerbose(boolean verbose) {
        }
    }

    public static class PathAddition {
        public final FaultSection fromSect;
        public final FaultSubsectionCluster fromCluster;
        public final Collection<? extends FaultSection> toSects;
        public final FaultSubsectionCluster toCluster;
        public final double distance;

        public PathAddition(FaultSection fromSect, FaultSubsectionCluster fromCluster, Collection<? extends FaultSection> toSects, FaultSubsectionCluster toCluster, double distance) {
            this.fromSect = fromSect;
            this.fromCluster = fromCluster;
            for (FaultSection faultSection : toSects) {
                Preconditions.checkState((faultSection.getParentSectionId() == toCluster.parentSectionID ? 1 : 0) != 0, (String)"toSect[%s:%s] has different parent than toCluster=%s", (Object)faultSection.getParentSectionId(), (Object)faultSection.getSectionId(), (Object)toCluster);
            }
            this.toSects = toSects;
            this.toCluster = toCluster;
            this.distance = distance;
        }

        public PathAddition(FaultSection fromSect, FaultSubsectionCluster fromCluster, FaultSection toSect, FaultSubsectionCluster toCluster, double distance) {
            this.fromSect = fromSect;
            this.fromCluster = fromCluster;
            Preconditions.checkState((toSect.getParentSectionId() == toCluster.parentSectionID ? 1 : 0) != 0, (String)"toSect[%s:%s] has different parent than toCluster=%s", (Object)toSect.getParentSectionId(), (Object)toSect.getSectionId(), (Object)toCluster);
            this.toSects = Collections.singleton(toSect);
            this.toCluster = toCluster;
            this.distance = distance;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.toSects == null ? 0 : this.toSects.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathAddition other = (PathAddition)obj;
            return !(this.toSects == null ? other.toSects != null : !this.toSects.equals(other.toSects));
        }

        public String toString() {
            Object ret = this.fromSect != null ? this.fromSect.getSectionId() + "->[" : "?->[";
            return (String)ret + this.toSects.stream().map(S -> S.getSectionId()).map(S -> S.toString()).collect(Collectors.joining(",")) + "], " + (float)this.distance + "km";
        }
    }

    public static abstract class Scalar<E extends Number>
    extends PathEvaluator
    implements NucleationClusterEvaluator.Scalar<E> {
        protected final Range<E> acceptableRange;
        protected final PlausibilityResult failureType;

        public Scalar(Range<E> acceptableRange, PlausibilityResult failureType) {
            this.acceptableRange = acceptableRange;
            Preconditions.checkState((!failureType.isPass() ? 1 : 0) != 0);
            this.failureType = failureType;
        }

        public abstract E getAdditionValue(Collection<FaultSection> var1, PathAddition var2, boolean var3);

        @Override
        public PlausibilityResult testAddition(Collection<FaultSection> curSects, PathAddition addition, boolean verbose) {
            if (this.acceptableRange.contains(this.getAdditionValue(curSects, addition, verbose))) {
                return PlausibilityResult.PASS;
            }
            return this.failureType;
        }

        @Override
        public E getNucleationClusterValue(ClusterRupture rupture, FaultSubsectionCluster nucleationCluster, boolean verbose) {
            PathNavigator nav = this.getPathNav(rupture, nucleationCluster);
            nav.setVerbose(verbose);
            if (verbose) {
                System.out.println(this.getName() + ": testing strand(s) with start=" + String.valueOf(nucleationCluster));
            }
            List<FaultSection> curSects = nav.getCurrentSects();
            Set<PathAddition> nextAdds = nav.getNextAdditions();
            if (verbose) {
                System.out.println("Have " + nextAdds.size() + " nextAdds");
            }
            Number worstVal = null;
            while (!nextAdds.isEmpty()) {
                for (PathAddition add : nextAdds) {
                    E val = this.getAdditionValue(curSects, add, verbose);
                    if (worstVal == null || !ScalarValuePlausibiltyFilter.isValueBetter(val, worstVal, this.acceptableRange)) {
                        worstVal = val;
                    }
                    if (!verbose) continue;
                    System.out.println("\taddition=" + String.valueOf(add) + ": " + String.valueOf(val) + " (worst=" + String.valueOf(worstVal) + ")");
                }
                curSects = nav.getCurrentSects();
                nextAdds = nav.getNextAdditions();
                if (!verbose) continue;
                System.out.println("Have " + nextAdds.size() + " nextAdds");
            }
            Preconditions.checkState((nav.getCurrentSects().size() == rupture.getTotalNumSects() ? 1 : 0) != 0, (String)"Processed %s sects but rupture has %s:\n\t%s", (Object)nav.getCurrentSects().size(), (Object)rupture.getTotalNumSects(), (Object)rupture);
            return worstVal;
        }

        @Override
        public Range<E> getAcceptableRange() {
            return this.acceptableRange;
        }

        @Override
        public PlausibilityResult getFailureType() {
            return this.failureType;
        }
    }

    public static class SectionPathNavigator
    implements PathNavigator {
        protected HashSet<FaultSection> currentSects;
        protected RuptureTreeNavigator rupNav;
        private Set<FaultSection> growthPoints;
        protected boolean verbose = true;

        public SectionPathNavigator(Collection<? extends FaultSection> startSects, RuptureTreeNavigator nav) {
            this.currentSects = new HashSet<FaultSection>(startSects);
            Preconditions.checkState((this.currentSects.size() == startSects.size() ? 1 : 0) != 0);
            this.rupNav = nav;
            this.growthPoints = this.currentSects;
        }

        @Override
        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        protected List<FaultSection> getNeighbors(FaultSection sect) {
            ArrayList<FaultSection> neighbors = new ArrayList<FaultSection>();
            FaultSection predecessor = this.rupNav.getPredecessor(sect);
            if (predecessor != null) {
                neighbors.add(predecessor);
            }
            neighbors.addAll(this.rupNav.getDescendants(sect));
            return neighbors;
        }

        @Override
        public List<FaultSection> getCurrentSects() {
            return Lists.newArrayList(this.currentSects);
        }

        @Override
        public Set<PathAddition> getNextAdditions() {
            HashSet<PathAddition> nextAdds = new HashSet<PathAddition>();
            if (this.verbose) {
                System.out.println("getNextAdditions with " + this.growthPoints.size() + " growth points, " + this.currentSects.size() + " curSects");
            }
            for (FaultSection sect : this.growthPoints) {
                FaultSubsectionCluster fromCluster = this.rupNav.locateCluster(sect);
                for (FaultSection neighbor : this.getNeighbors(sect)) {
                    if (this.currentSects.contains(neighbor)) continue;
                    FaultSubsectionCluster destCluster = this.rupNav.locateCluster(neighbor);
                    double distance = destCluster == fromCluster ? 0.0 : this.rupNav.getJump((FaultSubsectionCluster)fromCluster, (FaultSubsectionCluster)destCluster).distance;
                    nextAdds.add(new PathAddition(sect, fromCluster, neighbor, destCluster, distance));
                }
            }
            if (this.verbose) {
                System.out.println("\tFound " + nextAdds.size() + " nextAdds: " + nextAdds.stream().map(S -> S.toString()).collect(Collectors.joining(";")));
            }
            HashSet<FaultSection> newGrowthPoints = new HashSet<FaultSection>(nextAdds.size());
            for (PathAddition add : nextAdds) {
                this.currentSects.addAll(add.toSects);
                newGrowthPoints.addAll(add.toSects);
            }
            this.growthPoints = newGrowthPoints;
            return nextAdds;
        }
    }

    public static class ClusterPathNavigator
    implements PathNavigator {
        protected HashSet<FaultSubsectionCluster> currentClusters;
        protected HashSet<FaultSection> currentSects;
        protected RuptureTreeNavigator rupNav;
        private List<FaultSubsectionCluster> growthPoints;
        protected boolean verbose = true;

        public ClusterPathNavigator(FaultSubsectionCluster startCluster, RuptureTreeNavigator nav) {
            this.currentSects = new HashSet<FaultSection>((Collection<FaultSection>)startCluster.subSects);
            this.currentClusters = new HashSet();
            this.currentClusters.add(startCluster);
            this.rupNav = nav;
            this.growthPoints = new ArrayList<FaultSubsectionCluster>();
            this.growthPoints.add(startCluster);
        }

        @Override
        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        @Override
        public List<FaultSection> getCurrentSects() {
            return new ArrayList<FaultSection>(this.currentSects);
        }

        protected List<FaultSubsectionCluster> getNeighbors(FaultSubsectionCluster cluster) {
            ArrayList<FaultSubsectionCluster> neighbors = new ArrayList<FaultSubsectionCluster>();
            FaultSubsectionCluster predecessor = this.rupNav.getPredecessor(cluster);
            if (predecessor != null) {
                neighbors.add(predecessor);
            }
            neighbors.addAll(this.rupNav.getDescendants(cluster));
            return neighbors;
        }

        @Override
        public Set<PathAddition> getNextAdditions() {
            HashSet<PathAddition> nextAdds = new HashSet<PathAddition>();
            if (this.verbose) {
                System.out.println("getNextAdditions with " + this.growthPoints.size() + " growth points, " + this.currentSects.size() + " curSects");
            }
            for (FaultSubsectionCluster cluster : this.growthPoints) {
                for (FaultSubsectionCluster neighbor : this.getNeighbors(cluster)) {
                    if (this.currentClusters.contains(neighbor)) continue;
                    Jump jump = this.rupNav.getJump(cluster, neighbor);
                    nextAdds.add(new PathAddition(jump.fromSection, cluster, (Collection<? extends FaultSection>)neighbor.subSects, neighbor, jump.distance));
                }
            }
            if (this.verbose) {
                System.out.println("\tFound " + nextAdds.size() + " nextAdds: " + nextAdds.stream().map(S -> S.toString()).collect(Collectors.joining(";")));
            }
            ArrayList<FaultSubsectionCluster> newGrowthPoints = new ArrayList<FaultSubsectionCluster>(nextAdds.size());
            for (PathAddition add : nextAdds) {
                this.currentSects.addAll(add.toSects);
                newGrowthPoints.add(add.toCluster);
                this.currentClusters.add(add.toCluster);
            }
            this.growthPoints = newGrowthPoints;
            return nextAdds;
        }
    }
}

