/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.ScalarValuePlausibiltyFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.CumulativeProbPathEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.NucleationClusterEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RuptureProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.FilterDataClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;

public class PathPlausibilityFilter
implements PlausibilityFilter {
    protected final float fractPassThreshold;
    private final NucleationClusterEvaluator[] evaluators;
    private final boolean logicalOr;
    private final transient PlausibilityResult failureType;

    public PathPlausibilityFilter(NucleationClusterEvaluator ... evaluators) {
        this(0.0f, evaluators);
    }

    public PathPlausibilityFilter(float fractPassThreshold, NucleationClusterEvaluator ... evaluators) {
        this(fractPassThreshold, false, evaluators);
    }

    public PathPlausibilityFilter(float fractPassThreshold, boolean logicalOr, NucleationClusterEvaluator ... evaluators) {
        Preconditions.checkState((fractPassThreshold <= 1.0f ? 1 : 0) != 0);
        this.fractPassThreshold = fractPassThreshold;
        this.logicalOr = logicalOr;
        Preconditions.checkArgument((evaluators.length > 0 ? 1 : 0) != 0, (Object)"must supply at least one path evaluator");
        this.evaluators = evaluators;
        PlausibilityResult failureType = null;
        for (NucleationClusterEvaluator eval : evaluators) {
            failureType = failureType == null ? eval.getFailureType() : failureType.logicalAnd(eval.getFailureType());
        }
        this.failureType = failureType;
        Preconditions.checkState((!failureType.isPass() ? 1 : 0) != 0);
    }

    @Override
    public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
        if (rupture.getTotalNumJumps() == 0) {
            return PlausibilityResult.PASS;
        }
        ArrayList clusters = Lists.newArrayList(rupture.getClustersIterable());
        int numPaths = clusters.size();
        int numPasses = 0;
        int numNeeded = 1;
        if (this.fractPassThreshold > 0.0f) {
            numNeeded = Integer.max(1, (int)Math.ceil(this.fractPassThreshold * (float)numPaths));
        }
        HashSet<FaultSubsectionCluster> skipClusters = null;
        if (rupture instanceof FilterDataClusterRupture) {
            FilterDataClusterRupture fdRupture = (FilterDataClusterRupture)rupture;
            Object filterData = fdRupture.getFilterData(this);
            skipClusters = filterData != null && filterData instanceof HashSet ? new HashSet((HashSet)filterData) : new HashSet<FaultSubsectionCluster>();
            fdRupture.addFilterData(this, skipClusters);
        }
        for (FaultSubsectionCluster nucleationCluster : clusters) {
            if (skipClusters != null && skipClusters.contains(nucleationCluster)) {
                if (!verbose) continue;
                System.out.println("Skipping known cluster that won't work: " + String.valueOf(nucleationCluster));
                continue;
            }
            PlausibilityResult result = PlausibilityResult.PASS;
            if (verbose) {
                System.out.println(this.getShortName() + ": Nucleation point " + String.valueOf(nucleationCluster));
            }
            for (NucleationClusterEvaluator eval : this.evaluators) {
                if (verbose) {
                    System.out.println("Testing " + eval.getName() + "...");
                }
                PlausibilityResult subResult = eval.testNucleationCluster(rupture, nucleationCluster, verbose);
                if (verbose) {
                    System.out.println("\t" + eval.getName() + ": " + String.valueOf((Object)subResult));
                }
                result = this.logicalOr ? result.logicalOr(subResult) : result.logicalAnd(subResult);
                if (this.logicalOr && result.isPass() && !verbose || !this.logicalOr && !result.canContinue() && !verbose) break;
            }
            if (result.isPass()) {
                ++numPasses;
            } else if (skipClusters != null) {
                skipClusters.add(nucleationCluster);
            }
            if (verbose || numPasses < numNeeded) continue;
            return PlausibilityResult.PASS;
        }
        if (verbose) {
            System.out.println(this.getShortName() + ": " + numPasses + "/" + numPaths + " pass, " + numNeeded + " needed");
        }
        if (numPasses >= numNeeded) {
            return PlausibilityResult.PASS;
        }
        return this.failureType;
    }

    private String getPathString() {
        if (this.fractPassThreshold > 0.0f) {
            if (this.fractPassThreshold == 0.5f) {
                return "Half Paths";
            }
            if (this.fractPassThreshold == 0.33333334f) {
                return "1/3 Paths";
            }
            if (this.fractPassThreshold == 0.6666667f) {
                return "2/3 Paths";
            }
            if (this.fractPassThreshold == 0.25f) {
                return "1/4 Paths";
            }
            if (this.fractPassThreshold == 0.75f) {
                return "3/4 Paths";
            }
            return this.fractPassThreshold + "x Paths ";
        }
        return "Path";
    }

    @Override
    public String getShortName() {
        String paths = this.getPathString().replaceAll(" ", "");
        if (this.evaluators.length > 1) {
            return paths + "[" + this.evaluators.length + " criteria]";
        }
        return paths + this.evaluators[0].getShortName();
    }

    @Override
    public String getName() {
        if (this.evaluators.length == 1) {
            return this.getPathString() + " " + this.evaluators[0].getName();
        }
        return this.getPathString() + " [" + Arrays.stream(this.evaluators).map(E -> E.getName()).collect(Collectors.joining(", ")) + "]";
    }

    @Override
    public boolean isDirectional(boolean splayed) {
        return splayed;
    }

    public NucleationClusterEvaluator[] getEvaluators() {
        return this.evaluators;
    }

    public float getFractPassThreshold() {
        return this.fractPassThreshold;
    }

    public boolean isLogicalOr() {
        return this.logicalOr;
    }

    @Override
    public TypeAdapter<PlausibilityFilter> getTypeAdapter() {
        return new Adapter();
    }

    public static class Adapter
    extends PlausibilityFilter.PlausibilityFilterTypeAdapter {
        private Gson gson;
        private ClusterConnectionStrategy connStrategy;
        private SectionDistanceAzimuthCalculator distAzCalc;

        @Override
        public void init(ClusterConnectionStrategy connStrategy, SectionDistanceAzimuthCalculator distAzCalc, Gson gson) {
            this.connStrategy = connStrategy;
            this.distAzCalc = distAzCalc;
            this.gson = gson;
        }

        public void write(JsonWriter out, PlausibilityFilter value) throws IOException {
            Preconditions.checkState((boolean)(value instanceof PathPlausibilityFilter));
            PathPlausibilityFilter filter = (PathPlausibilityFilter)value;
            out.beginObject();
            out.name("fractPassThreshold").value((double)filter.fractPassThreshold);
            out.name("logicalOr").value(filter.logicalOr);
            out.name("evaluators").beginArray();
            for (NucleationClusterEvaluator eval : filter.evaluators) {
                out.beginObject();
                out.name("class").value(eval.getClass().getName());
                out.name("value");
                if (eval instanceof CumulativeProbPathEvaluator) {
                    out.beginObject();
                    CumulativeProbPathEvaluator pathEval = (CumulativeProbPathEvaluator)eval;
                    out.name("minProbability").value((double)pathEval.minProbability);
                    out.name("failureType").value(pathEval.failureType.name());
                    out.name("calcs").beginArray();
                    for (RuptureProbabilityCalc calc : pathEval.calcs) {
                        out.beginObject();
                        out.name("class").value(calc.getClass().getName());
                        out.name("value");
                        this.gson.toJson((Object)calc, calc.getClass(), out);
                        out.endObject();
                    }
                    out.endArray();
                    out.endObject();
                } else {
                    this.gson.toJson((Object)eval, eval.getClass(), out);
                }
                out.endObject();
            }
            out.endArray();
            out.endObject();
        }

        public PlausibilityFilter read(JsonReader in) throws IOException {
            in.beginObject();
            Float fractPassThreshold = null;
            Boolean logicalOr = null;
            NucleationClusterEvaluator[] evaluators = null;
            block40: while (in.hasNext()) {
                switch (in.nextName()) {
                    case "fractPassThreshold": {
                        fractPassThreshold = Float.valueOf((float)in.nextDouble());
                        continue block40;
                    }
                    case "logicalOr": {
                        logicalOr = in.nextBoolean();
                        continue block40;
                    }
                    case "evaluators": {
                        ArrayList<NucleationClusterEvaluator> list = new ArrayList<NucleationClusterEvaluator>();
                        in.beginArray();
                        while (in.hasNext()) {
                            in.beginObject();
                            Class type = null;
                            NucleationClusterEvaluator eval = null;
                            block42: while (in.hasNext()) {
                                switch (in.nextName()) {
                                    case "class": {
                                        try {
                                            type = PlausibilityConfiguration.getDeclaredTypeClass(in.nextString());
                                            continue block42;
                                        }
                                        catch (ClassNotFoundException e) {
                                            throw ExceptionUtils.asRuntimeException(e);
                                        }
                                    }
                                    case "value": {
                                        Preconditions.checkNotNull(type, (Object)"Class must preceed value in PathPlausibility JSON");
                                        if (type.equals(CumulativeProbPathEvaluator.class)) {
                                            in.beginObject();
                                            Float minProbability = null;
                                            PlausibilityResult failureType = null;
                                            RuptureProbabilityCalc[] calcs = null;
                                            block43: while (in.hasNext()) {
                                                switch (in.nextName()) {
                                                    case "minProbability": {
                                                        minProbability = Float.valueOf((float)in.nextDouble());
                                                        continue block43;
                                                    }
                                                    case "failureType": {
                                                        failureType = PlausibilityResult.valueOf(in.nextString());
                                                        continue block43;
                                                    }
                                                    case "calcs": {
                                                        in.beginArray();
                                                        ArrayList<RuptureProbabilityCalc> calcList = new ArrayList<RuptureProbabilityCalc>();
                                                        while (in.hasNext()) {
                                                            in.beginObject();
                                                            Class calcType = null;
                                                            RuptureProbabilityCalc calc = null;
                                                            block45: while (in.hasNext()) {
                                                                switch (in.nextName()) {
                                                                    case "class": {
                                                                        try {
                                                                            calcType = PlausibilityConfiguration.getDeclaredTypeClass(in.nextString());
                                                                            continue block45;
                                                                        }
                                                                        catch (ClassNotFoundException e) {
                                                                            throw ExceptionUtils.asRuntimeException(e);
                                                                        }
                                                                    }
                                                                    case "value": {
                                                                        Preconditions.checkNotNull(calcType, (Object)"Class must preceed value in PathPlausibility JSON");
                                                                        calc = (RuptureProbabilityCalc)this.gson.fromJson(in, calcType);
                                                                        continue block45;
                                                                    }
                                                                }
                                                                throw new IllegalStateException("Unexpected JSON field");
                                                            }
                                                            Preconditions.checkNotNull(calc, (Object)"Calculator is null?");
                                                            calcList.add(calc);
                                                            in.endObject();
                                                        }
                                                        in.endArray();
                                                        calcs = calcList.toArray(new RuptureProbabilityCalc[0]);
                                                        continue block43;
                                                    }
                                                }
                                                throw new IllegalStateException("Unexpected JSON field");
                                            }
                                            in.endObject();
                                            eval = new CumulativeProbPathEvaluator(minProbability.floatValue(), failureType, calcs);
                                            continue block42;
                                        }
                                        eval = (NucleationClusterEvaluator)this.gson.fromJson(in, type);
                                        continue block42;
                                    }
                                }
                                throw new IllegalStateException("Unexpected JSON field");
                            }
                            Preconditions.checkNotNull(eval, (Object)"Evaluator is null?");
                            eval.init(this.connStrategy, this.distAzCalc);
                            list.add(eval);
                            in.endObject();
                        }
                        in.endArray();
                        Preconditions.checkState((!list.isEmpty() ? 1 : 0) != 0, (Object)"No prob calcs?");
                        evaluators = list.toArray(new NucleationClusterEvaluator[0]);
                        continue block40;
                    }
                }
                throw new IllegalStateException("Unexpected JSON field");
            }
            in.endObject();
            Preconditions.checkNotNull(fractPassThreshold, (Object)"fractPassThreshold not supplied");
            Preconditions.checkNotNull(logicalOr, (Object)"logicalOr not supplied");
            Preconditions.checkNotNull(evaluators, (Object)"evaluators not supplied");
            if (evaluators.length == 1 && evaluators[0] instanceof NucleationClusterEvaluator.Scalar) {
                return new Scalar(fractPassThreshold.floatValue(), (NucleationClusterEvaluator.Scalar)evaluators[0]);
            }
            return new PathPlausibilityFilter(fractPassThreshold.floatValue(), logicalOr, evaluators);
        }
    }

    public static class Scalar<E extends Number>
    extends PathPlausibilityFilter
    implements ScalarValuePlausibiltyFilter<E> {
        private NucleationClusterEvaluator.Scalar<E> evaluator;

        public Scalar(NucleationClusterEvaluator.Scalar<E> evaluator) {
            this(0.0f, evaluator);
        }

        public Scalar(float fractPassThreshold, NucleationClusterEvaluator.Scalar<E> evaluator) {
            super(fractPassThreshold, false, evaluator);
            this.evaluator = evaluator;
        }

        @Override
        public E getValue(ClusterRupture rupture) {
            if (rupture.getTotalNumJumps() == 0) {
                return null;
            }
            ArrayList<E> vals = new ArrayList<E>();
            for (FaultSubsectionCluster nucleationCluster : rupture.getClustersIterable()) {
                Object val = this.evaluator.getNucleationClusterValue(rupture, nucleationCluster, false);
                vals.add(val);
            }
            if (this.fractPassThreshold > 0.0f) {
                int numPaths = vals.size();
                int numNeeded = Integer.max(1, (int)Math.ceil(this.fractPassThreshold * (float)numPaths));
                Collections.sort(vals, this.worstToBestComparator());
                return (E)((Number)vals.get(vals.size() - numNeeded));
            }
            Object bestVal = null;
            for (Object val : vals) {
                if (bestVal != null && !this.isValueBetter(val, bestVal)) continue;
                bestVal = val;
            }
            return bestVal;
        }

        @Override
        public Range<E> getAcceptableRange() {
            return this.evaluator.getAcceptableRange();
        }

        @Override
        public String getScalarName() {
            return this.evaluator.getScalarName();
        }

        @Override
        public String getScalarUnits() {
            return this.evaluator.getScalarUnits();
        }
    }
}

