/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.ScalarValuePlausibiltyFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.PathEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.ScalarCoulombPathEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCalculator;

public class SectCoulombPathEvaluator
extends ScalarCoulombPathEvaluator {
    private boolean jumpToMostFavorable;
    private float maxJumpDist;
    private transient SectionDistanceAzimuthCalculator distAzCalc;

    public static FaultSection findMostFavorableJumpSect(Collection<? extends FaultSection> sources, Jump jump, float maxSearchDist, Range<Float> acceptableRange, AggregatedStiffnessCalculator aggCalc, SectionDistanceAzimuthCalculator distAzCalc, boolean verbose) {
        if (verbose) {
            System.out.println("Finding most favorable jump to " + String.valueOf(jump.toCluster) + ", origJump=" + String.valueOf(jump) + ", maxSearchDist=" + maxSearchDist);
        }
        ArrayList<FaultSection> allowedJumps = new ArrayList<FaultSection>();
        block0: for (FaultSection sect : jump.toCluster.subSects) {
            if (sources.contains(sect)) continue;
            for (FaultSection source : jump.fromCluster.subSects) {
                if (sect != jump.toSection && !((float)distAzCalc.getDistance(sect, source) <= maxSearchDist)) continue;
                allowedJumps.add(sect);
                continue block0;
            }
        }
        Preconditions.checkState((!allowedJumps.isEmpty() ? 1 : 0) != 0, (String)"No jumps within %s km found between %s and %s", (Object)Float.valueOf(maxSearchDist), (Object)jump.fromCluster, (Object)jump.toCluster);
        if (allowedJumps.size() == 1) {
            if (verbose) {
                System.out.println("Only 1 possible jump: " + ((FaultSection)allowedJumps.get(0)).getSectionId());
            }
            return (FaultSection)allowedJumps.get(0);
        }
        float bestVal = Float.NaN;
        FaultSection bestSect = null;
        for (FaultSection sect : allowedJumps) {
            float myVal = (float)aggCalc.calc(sources, sect);
            if (verbose) {
                System.out.println("CFF to " + sect.getSectionId() + ": " + myVal);
            }
            if (!Double.isNaN(bestVal) && !ScalarValuePlausibiltyFilter.isValueBetter(Float.valueOf(myVal), Float.valueOf(bestVal), acceptableRange)) continue;
            bestVal = myVal;
            bestSect = sect;
        }
        Preconditions.checkNotNull(bestSect);
        return bestSect;
    }

    public SectCoulombPathEvaluator(AggregatedStiffnessCalculator aggCalc, Range<Float> acceptableRange, PlausibilityResult failureType) {
        this(aggCalc, acceptableRange, failureType, false, 0.0f, null);
    }

    public SectCoulombPathEvaluator(AggregatedStiffnessCalculator aggCalc, Range<Float> acceptableRange, PlausibilityResult failureType, boolean jumpToMostFavorable, float maxJumpDist, SectionDistanceAzimuthCalculator distAzCalc) {
        super(aggCalc, acceptableRange, failureType);
        this.jumpToMostFavorable = jumpToMostFavorable;
        if (jumpToMostFavorable) {
            Preconditions.checkState(((double)maxJumpDist > 0.0 ? 1 : 0) != 0);
            Preconditions.checkNotNull((Object)distAzCalc);
            this.maxJumpDist = maxJumpDist;
            this.distAzCalc = distAzCalc;
        } else {
            this.maxJumpDist = 0.0f;
            this.distAzCalc = null;
        }
    }

    @Override
    public void init(ClusterConnectionStrategy connStrat, SectionDistanceAzimuthCalculator distAzCalc) {
        this.distAzCalc = distAzCalc;
    }

    public void setMaxJumpDist(float maxJumpDist) {
        this.maxJumpDist = maxJumpDist;
    }

    @Override
    protected PathEvaluator.SectionPathNavigator getPathNav(ClusterRupture rupture, FaultSubsectionCluster nucleationCluster) {
        if (this.jumpToMostFavorable) {
            return new CoulombFavorableSectionPathNavigator((Collection<FaultSection>)nucleationCluster.subSects, rupture.getTreeNavigator(), this.aggCalc, (Range<Float>)this.acceptableRange, this.distAzCalc, this.maxJumpDist);
        }
        return new PathEvaluator.SectionPathNavigator((Collection<? extends FaultSection>)nucleationCluster.subSects, rupture.getTreeNavigator());
    }

    @Override
    public Float getAdditionValue(Collection<FaultSection> curSects, PathEvaluator.PathAddition addition, boolean verbose) {
        Preconditions.checkState((addition.toSects.size() == 1 ? 1 : 0) != 0);
        FaultSection destSect = addition.toSects.iterator().next();
        double val = this.aggCalc.calc(curSects, destSect);
        if (verbose) {
            System.out.println("\t" + curSects.size() + " sources to " + destSect.getSectionId() + ": " + val);
        }
        return Float.valueOf((float)val);
    }

    @Override
    public String getShortName() {
        String sectStr = this.jumpToMostFavorable ? "SectFav" + new DecimalFormat("0.#").format(this.maxJumpDist) : "Sect";
        return sectStr + "[" + this.aggCalc.getScalarShortName() + "]" + ScalarValuePlausibiltyFilter.getRangeStr(this.getAcceptableRange());
    }

    @Override
    public String getName() {
        String sectStr = this.jumpToMostFavorable ? "Sect Favorable (" + new DecimalFormat("0.#").format(this.maxJumpDist) + "km)" : "Sect";
        return sectStr + " [" + this.aggCalc.getScalarName() + "] " + ScalarValuePlausibiltyFilter.getRangeStr(this.getAcceptableRange());
    }

    public static class CoulombFavorableSectionPathNavigator
    extends PathEvaluator.SectionPathNavigator {
        private final AggregatedStiffnessCalculator aggCalc;
        private final SectionDistanceAzimuthCalculator distAzCalc;
        private final float maxSearchDist;
        private Range<Float> acceptableRange;

        public CoulombFavorableSectionPathNavigator(Collection<FaultSection> startSects, RuptureTreeNavigator nav, AggregatedStiffnessCalculator aggCalc, Range<Float> acceptableRange, SectionDistanceAzimuthCalculator distAzCalc, float maxSearchDist) {
            super(startSects, nav);
            this.aggCalc = aggCalc;
            this.acceptableRange = acceptableRange;
            this.distAzCalc = distAzCalc;
            this.maxSearchDist = maxSearchDist;
        }

        @Override
        protected List<FaultSection> getNeighbors(FaultSection fromSect) {
            ArrayList<FaultSection> neighbors = new ArrayList<FaultSection>();
            for (FaultSection neighbor : super.getNeighbors(fromSect)) {
                if (this.currentSects.contains(neighbor)) continue;
                if (neighbor.getParentSectionId() == fromSect.getParentSectionId()) {
                    if (this.verbose) {
                        System.out.println("\tneighbor of " + fromSect.getSectionId() + " is on same parent: " + neighbor.getSectionId());
                    }
                    neighbors.add(neighbor);
                    continue;
                }
                Jump jump = this.rupNav.getJump(fromSect, neighbor);
                neighbors.add(SectCoulombPathEvaluator.findMostFavorableJumpSect(this.currentSects, jump, this.maxSearchDist, this.acceptableRange, this.aggCalc, this.distAzCalc, this.verbose));
            }
            return neighbors;
        }
    }
}

