/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.jfree.data.Range;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.RupHistogramPlots;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.JumpAzimuthChangeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.JumpProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RuptureProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.Shaw07JumpDistProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.faultSurface.FaultSection;

public class BiasiWesnouskyJumpProb {
    public static final EvenlyDiscretizedFunc bw2017_ss_passRatio = new EvenlyDiscretizedFunc(5.0, 45.0, 5);
    public static final double bw2017_mech_change_prob = 0.05333333333333334;

    public static RuptureProbabilityCalc[] getPrefferedBWCalcs(SectionDistanceAzimuthCalculator distAzCalc) {
        return new RuptureProbabilityCalc[]{new BiasiWesnousky2016CombJumpDistProb(), new BiasiWesnousky2017JumpAzChangeProb(distAzCalc), new BiasiWesnousky2017MechChangeProb()};
    }

    public static double passingRatioToProb(double passingRatio) {
        return passingRatio / (passingRatio + 1.0);
    }

    public static double probToPassingRatio(double prob) {
        return -prob / (prob - 1.0);
    }

    static {
        bw2017_ss_passRatio.set(5.0, 2.7);
        bw2017_ss_passRatio.set(15.0, 1.35);
        bw2017_ss_passRatio.set(25.0, 1.3);
        bw2017_ss_passRatio.set(35.0, 0.1);
        bw2017_ss_passRatio.set(45.0, 0.08);
    }

    public static class BiasiWesnousky2016CombJumpDistProb
    implements JumpProbabilityCalc {
        private double minJumpDist;
        private BiasiWesnousky2016SSJumpProb ssJumpProb;
        private BiasiWesnouskyDistIndepJumpProb indepJumpProb;

        public BiasiWesnousky2016CombJumpDistProb() {
            this(1.0);
        }

        public BiasiWesnousky2016CombJumpDistProb(double minJumpDist) {
            this.minJumpDist = minJumpDist;
            this.ssJumpProb = new BiasiWesnousky2016SSJumpProb(minJumpDist);
            this.indepJumpProb = new BiasiWesnouskyDistIndepJumpProb(minJumpDist);
        }

        @Override
        public double calcJumpProbability(ClusterRupture fullRupture, Jump jump, boolean verbose) {
            RupHistogramPlots.RakeType type2;
            if (jump.distance < this.minJumpDist) {
                return 1.0;
            }
            RupHistogramPlots.RakeType type1 = RupHistogramPlots.RakeType.getType(jump.fromSection.getAveRake());
            if (type1 == (type2 = RupHistogramPlots.RakeType.getType(jump.toSection.getAveRake())) && (type1 == RupHistogramPlots.RakeType.LEFT_LATERAL || type1 == RupHistogramPlots.RakeType.RIGHT_LATERAL)) {
                return this.ssJumpProb.calcJumpProbability(fullRupture, jump, verbose);
            }
            return this.indepJumpProb.calcJumpProbability(fullRupture, jump, verbose);
        }

        @Override
        public String getName() {
            return "BW16 JumpDist";
        }

        @Override
        public boolean isDirectional(boolean splayed) {
            return false;
        }
    }

    public static class BiasiWesnousky2017JumpAzChangeProb
    implements JumpProbabilityCalc {
        private SectionDistanceAzimuthCalculator distAzCalc;

        public BiasiWesnousky2017JumpAzChangeProb(SectionDistanceAzimuthCalculator distAzCalc) {
            this.distAzCalc = distAzCalc;
        }

        @Override
        public double calcJumpProbability(ClusterRupture fullRupture, Jump jump, boolean verbose) {
            RupHistogramPlots.RakeType type2;
            RuptureTreeNavigator nav = fullRupture.getTreeNavigator();
            RupHistogramPlots.RakeType type1 = RupHistogramPlots.RakeType.getType(jump.fromSection.getAveRake());
            if (type1 != (type2 = RupHistogramPlots.RakeType.getType(jump.toSection.getAveRake()))) {
                return 1.0;
            }
            FaultSection before2 = jump.fromSection;
            FaultSection before1 = nav.getPredecessor(before2);
            if (before1 == null) {
                return 1.0;
            }
            double beforeAz = this.distAzCalc.getAzimuth(before1, before2);
            FaultSection after1 = jump.toSection;
            double prob = 1.0;
            for (FaultSection after2 : nav.getDescendants(after1)) {
                double afterAz = this.distAzCalc.getAzimuth(after1, after2);
                double diff = Math.abs(JumpAzimuthChangeFilter.getAzimuthDifference(beforeAz, afterAz));
                double passingRatio = type1 == RupHistogramPlots.RakeType.LEFT_LATERAL || type1 == RupHistogramPlots.RakeType.RIGHT_LATERAL ? bw2017_ss_passRatio.getY(bw2017_ss_passRatio.getClosestXIndex(diff)) : (diff < 60.0 ? 2.0 : 0.5);
                prob = Math.min(prob, BiasiWesnouskyJumpProb.passingRatioToProb(passingRatio));
            }
            return prob;
        }

        @Override
        public String getName() {
            return "BW17 AzChange";
        }

        @Override
        public boolean isDirectional(boolean splayed) {
            return false;
        }
    }

    public static class BiasiWesnousky2017MechChangeProb
    implements JumpProbabilityCalc {
        @Override
        public double calcJumpProbability(ClusterRupture fullRupture, Jump jump, boolean verbose) {
            RupHistogramPlots.RakeType type2;
            double rake2;
            double rake1 = jump.fromSection.getAveRake();
            if ((float)rake1 == (float)(rake2 = jump.toSection.getAveRake())) {
                return 1.0;
            }
            RupHistogramPlots.RakeType type1 = RupHistogramPlots.RakeType.getType(rake1);
            if (type1 == (type2 = RupHistogramPlots.RakeType.getType(rake2))) {
                return 1.0;
            }
            return 0.05333333333333334;
        }

        @Override
        public String getName() {
            return "BW17 MechChange";
        }

        @Override
        public boolean isDirectional(boolean splayed) {
            return false;
        }

        public static void main(String[] args) throws IOException {
            ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
            EvenlyDiscretizedFunc distFunc = new EvenlyDiscretizedFunc(0.0, 15.0, 100);
            ArrayList<JumpProbabilityCalc.DistDependentJumpProbabilityCalc> jumpProbs = new ArrayList<JumpProbabilityCalc.DistDependentJumpProbabilityCalc>();
            jumpProbs.add(new HardcodedMechDistIndepJumpProb(1.0, RupHistogramPlots.RakeType.REVERSE));
            jumpProbs.add(new HardcodedMechDistIndepJumpProb(1.0, RupHistogramPlots.RakeType.NORMAL));
            jumpProbs.add(new HardcodedMechDistIndepJumpProb(1.0, RupHistogramPlots.RakeType.RIGHT_LATERAL));
            jumpProbs.add(new BiasiWesnousky2016SSJumpProb());
            jumpProbs.add(new Shaw07JumpDistProb(1.0, 1.0));
            jumpProbs.add(new Shaw07JumpDistProb(1.0, 2.0));
            jumpProbs.add(new Shaw07JumpDistProb(1.0, 3.0));
            jumpProbs.add(new Shaw07JumpDistProb(1.0, 4.0));
            CPT cpt = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(0.0, jumpProbs.size() - 1);
            for (int i = 0; i < jumpProbs.size(); ++i) {
                JumpProbabilityCalc.DistDependentJumpProbabilityCalc calc = (JumpProbabilityCalc.DistDependentJumpProbabilityCalc)jumpProbs.get(i);
                EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(distFunc.getMinX(), distFunc.getMaxX(), distFunc.size());
                func.setName(calc.getName());
                for (int j = 0; j < func.size(); ++j) {
                    func.set(j, calc.calcJumpProbability(func.getX(j)));
                }
                funcs.add(func);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, cpt.getColor(i)));
            }
            PlotSpec spec = new PlotSpec(funcs, chars, "Jump Distance Models", "Jump Distance (km)", "Jump Probability");
            spec.setLegendInset(true);
            Range xRange = new Range(distFunc.getMinX(), distFunc.getMaxX());
            Range yRange = new Range(0.0, 1.0);
            HeadlessGraphPanel gp = PlotUtils.initHeadless();
            gp.drawGraphPanel(spec, false, false, xRange, yRange);
            File outputDir = new File("/tmp");
            String prefix = "jump_dist_models";
            PlotUtils.writePlots(outputDir, prefix, (GraphPanel)gp, 1000, 850, true, true, false);
            yRange = new Range(1.0E-4, 1.0);
            gp.drawGraphPanel(spec, false, true, xRange, yRange);
            PlotUtils.writePlots(outputDir, prefix + "_log", (GraphPanel)gp, 1000, 850, true, true, false);
        }
    }

    public static class BiasiWesnousky2017_SSJumpAzChangeProb
    implements JumpProbabilityCalc {
        private SectionDistanceAzimuthCalculator distAzCalc;

        public BiasiWesnousky2017_SSJumpAzChangeProb(SectionDistanceAzimuthCalculator distAzCalc) {
            this.distAzCalc = distAzCalc;
        }

        @Override
        public double calcJumpProbability(ClusterRupture fullRupture, Jump jump, boolean verbose) {
            RupHistogramPlots.RakeType type2;
            RuptureTreeNavigator nav = fullRupture.getTreeNavigator();
            RupHistogramPlots.RakeType type1 = RupHistogramPlots.RakeType.getType(jump.fromSection.getAveRake());
            if (type1 != (type2 = RupHistogramPlots.RakeType.getType(jump.toSection.getAveRake()))) {
                return 1.0;
            }
            if (type1 != RupHistogramPlots.RakeType.RIGHT_LATERAL && type1 != RupHistogramPlots.RakeType.LEFT_LATERAL) {
                return 1.0;
            }
            FaultSection before2 = jump.fromSection;
            FaultSection before1 = nav.getPredecessor(before2);
            if (before1 == null) {
                return 1.0;
            }
            double beforeAz = this.distAzCalc.getAzimuth(before1, before2);
            FaultSection after1 = jump.toSection;
            double prob = 1.0;
            for (FaultSection after2 : nav.getDescendants(after1)) {
                double afterAz = this.distAzCalc.getAzimuth(after1, after2);
                double diff = Math.abs(JumpAzimuthChangeFilter.getAzimuthDifference(beforeAz, afterAz));
                double passingRatio = bw2017_ss_passRatio.getY(bw2017_ss_passRatio.getClosestXIndex(diff));
                prob = Math.min(prob, BiasiWesnouskyJumpProb.passingRatioToProb(passingRatio));
            }
            return prob;
        }

        @Override
        public String getName() {
            return "BW17 SS AzChange";
        }

        @Override
        public boolean isDirectional(boolean splayed) {
            return false;
        }
    }

    public static class BiasiWesnousky2016SSJumpProb
    implements JumpProbabilityCalc.DistDependentJumpProbabilityCalc {
        private double minJumpDist;

        public BiasiWesnousky2016SSJumpProb() {
            this(1.0);
        }

        public BiasiWesnousky2016SSJumpProb(double minJumpDist) {
            this.minJumpDist = minJumpDist;
        }

        public double calcPassingRatio(double distance) {
            return Math.max(0.0, 1.89 - 0.31 * distance);
        }

        public double calcPassingProb(double distance) {
            return BiasiWesnouskyJumpProb.passingRatioToProb(this.calcPassingRatio(distance));
        }

        @Override
        public double calcJumpProbability(double distance) {
            if (distance < this.minJumpDist) {
                return 1.0;
            }
            return this.calcPassingProb(distance);
        }

        @Override
        public String getName() {
            return "BW16 SS JumpDist";
        }

        @Override
        public boolean isDirectional(boolean splayed) {
            return false;
        }
    }

    public static class BiasiWesnouskyDistIndepJumpProb
    implements JumpProbabilityCalc {
        private double minJumpDist;

        public BiasiWesnouskyDistIndepJumpProb(double minJumpDist) {
            this.minJumpDist = minJumpDist;
        }

        @Override
        public boolean isDirectional(boolean splayed) {
            return false;
        }

        @Override
        public String getName() {
            return "BW16 DistIndep";
        }

        @Override
        public double calcJumpProbability(ClusterRupture fullRupture, Jump jump, boolean verbose) {
            if (jump.distance < this.minJumpDist) {
                return 1.0;
            }
            RupHistogramPlots.RakeType type1 = RupHistogramPlots.RakeType.getType(jump.fromSection.getAveRake());
            RupHistogramPlots.RakeType type2 = RupHistogramPlots.RakeType.getType(jump.toSection.getAveRake());
            return 0.5 * (BiasiWesnouskyDistIndepJumpProb.getDistanceIndepentProb(type1) + BiasiWesnouskyDistIndepJumpProb.getDistanceIndepentProb(type2));
        }

        public static double getDistanceIndepentProb(RupHistogramPlots.RakeType type) {
            if (type == RupHistogramPlots.RakeType.REVERSE) {
                return 0.62;
            }
            if (type == RupHistogramPlots.RakeType.NORMAL) {
                return 0.37;
            }
            return 0.46;
        }
    }

    private static class HardcodedMechDistIndepJumpProb
    implements JumpProbabilityCalc.DistDependentJumpProbabilityCalc {
        private double minJumpDist;
        private RupHistogramPlots.RakeType type;

        public HardcodedMechDistIndepJumpProb(double minJumpDist, RupHistogramPlots.RakeType type) {
            this.minJumpDist = minJumpDist;
            this.type = type;
        }

        @Override
        public boolean isDirectional(boolean splayed) {
            return false;
        }

        @Override
        public String getName() {
            return "BW16 DistIndep" + this.type.name;
        }

        @Override
        public double calcJumpProbability(double distance) {
            if (distance < this.minJumpDist) {
                return 1.0;
            }
            return BiasiWesnouskyDistIndepJumpProb.getDistanceIndepentProb(this.type);
        }
    }
}

