/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.math3.stat.StatUtils;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.PathEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.SectCoulombPathEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.CumulativeProbabilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RuptureProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCalculator;

public class CoulombSectRatioProb
implements RuptureProbabilityCalc {
    private AggregatedStiffnessCalculator aggCalc;
    private int numDenominatorSubsects;
    private boolean jumpToMostFavorable;
    private float maxJumpDist;
    private transient SectionDistanceAzimuthCalculator distAzCalc;

    public CoulombSectRatioProb(AggregatedStiffnessCalculator aggCalc, int numDenominatorSubsects) {
        this(aggCalc, numDenominatorSubsects, false, 0.0f, null);
    }

    public CoulombSectRatioProb(AggregatedStiffnessCalculator aggCalc, int numDenominatorSubsects, boolean jumpToMostFavorable, float maxJumpDist, SectionDistanceAzimuthCalculator distAzCalc) {
        this.aggCalc = aggCalc;
        Preconditions.checkState((numDenominatorSubsects >= 1 ? 1 : 0) != 0);
        this.numDenominatorSubsects = numDenominatorSubsects;
        this.jumpToMostFavorable = jumpToMostFavorable;
        this.maxJumpDist = maxJumpDist;
        this.distAzCalc = distAzCalc;
    }

    public void setMaxJumpDist(float maxJumpDist) {
        this.maxJumpDist = maxJumpDist;
    }

    public AggregatedStiffnessCalculator getAggregator() {
        return this.aggCalc;
    }

    @Override
    public void init(ClusterConnectionStrategy connStrat, SectionDistanceAzimuthCalculator distAzCalc) {
        this.distAzCalc = distAzCalc;
    }

    @Override
    public String getName() {
        String str = "CFF Sect Ratio, N=" + this.numDenominatorSubsects;
        if (this.jumpToMostFavorable) {
            str = str + ", Fav" + CumulativeProbabilityFilter.optionalDigitDF.format(this.maxJumpDist) + "km";
        }
        return str;
    }

    @Override
    public double calcRuptureProb(ClusterRupture rupture, boolean verbose) {
        PathEvaluator.SectionPathNavigator nav = this.jumpToMostFavorable ? new SectCoulombPathEvaluator.CoulombFavorableSectionPathNavigator((Collection<FaultSection>)rupture.clusters[0].subSects, rupture.getTreeNavigator(), this.aggCalc, (Range<Float>)Range.atLeast((Comparable)Float.valueOf(0.0f)), this.distAzCalc, this.maxJumpDist) : new PathEvaluator.SectionPathNavigator((Collection<? extends FaultSection>)rupture.clusters[0].subSects, rupture.getTreeNavigator());
        nav.setVerbose(verbose);
        double prob = 1.0;
        List<FaultSection> currentSects = nav.getCurrentSects();
        Set<PathEvaluator.PathAddition> nextAdds = nav.getNextAdditions();
        if (verbose) {
            System.out.println("Have " + nextAdds.size() + " nextAdds");
        }
        while (!nextAdds.isEmpty()) {
            for (PathEvaluator.PathAddition add : nextAdds) {
                Preconditions.checkState((add.toSects.size() == 1 ? 1 : 0) != 0);
                FaultSection receiver = add.toSects.iterator().next();
                HighestNTracker track = new HighestNTracker(this.numDenominatorSubsects);
                for (FaultSection source : currentSects) {
                    track.addValue(this.aggCalc.calc(source, receiver));
                }
                double myProb = track.sum / Math.abs(track.getSumHighest());
                if (myProb < 0.0) {
                    myProb = 0.0;
                } else if (myProb > 1.0) {
                    myProb = 1.0;
                }
                if (verbose) {
                    System.out.println("Probability of adding " + receiver.getSectionId() + " with " + currentSects.size() + " sources: " + track.sum + "/|" + track.getSumHighest() + "| = " + myProb);
                }
                if ((prob *= myProb) != 0.0 || verbose) continue;
                return 0.0;
            }
            currentSects = nav.getCurrentSects();
            nextAdds = nav.getNextAdditions();
            if (!verbose) continue;
            System.out.println("Have " + nextAdds.size() + " nextAdds");
        }
        Preconditions.checkState((currentSects.size() == rupture.getTotalNumSects() ? 1 : 0) != 0);
        return prob;
    }

    @Override
    public boolean isDirectional(boolean splayed) {
        return true;
    }

    public int getNumDenominatorSubsects() {
        return this.numDenominatorSubsects;
    }

    public boolean isJumpToMostFavorable() {
        return this.jumpToMostFavorable;
    }

    public float getMaxJumpDist() {
        return this.maxJumpDist;
    }

    public static class HighestNTracker {
        private int numProcessed = 0;
        double sum = 0.0;
        private double smallestHigh = Double.POSITIVE_INFINITY;
        private int smallestIndex = -1;
        private double[] highVals;

        public HighestNTracker(int n) {
            this.highVals = new double[n];
        }

        public void addValue(double val) {
            if (this.numProcessed < this.highVals.length) {
                this.highVals[this.numProcessed] = val;
                if (val < this.smallestHigh) {
                    this.smallestHigh = val;
                    this.smallestIndex = this.numProcessed;
                }
            } else if (val > this.smallestHigh) {
                this.highVals[this.smallestIndex] = val;
                this.smallestHigh = Double.POSITIVE_INFINITY;
                for (int i = 0; i < this.highVals.length; ++i) {
                    if (!(this.highVals[i] < this.smallestHigh)) continue;
                    this.smallestHigh = this.highVals[i];
                    this.smallestIndex = i;
                }
            }
            ++this.numProcessed;
            this.sum += val;
        }

        public double getSum() {
            return this.sum;
        }

        public double getSumHighest() {
            return StatUtils.sum((double[])this.highVals);
        }
    }
}

