/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.ScalarValuePlausibiltyFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RuptureProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;

public class CumulativeProbabilityFilter
implements ScalarValuePlausibiltyFilter<Float> {
    static final DecimalFormat optionalDigitDF = new DecimalFormat("0.#");
    private float minProbability;
    private RuptureProbabilityCalc[] calcs;

    public CumulativeProbabilityFilter(float minProbability, RuptureProbabilityCalc ... calcs) {
        Preconditions.checkArgument(((double)minProbability > 0.0 && (double)minProbability <= 1.0 ? 1 : 0) != 0, (String)"Minimum probability (%s) not in the range (0,1]", (Object)Float.valueOf(minProbability));
        this.minProbability = minProbability;
        Preconditions.checkArgument((calcs.length > 0 ? 1 : 0) != 0);
        this.calcs = calcs;
    }

    @Override
    public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
        float prob = this.getValue(rupture, verbose).floatValue();
        if (verbose) {
            System.out.println(this.getShortName() + ": final prob=" + prob + ", pass=" + (prob >= this.minProbability));
        }
        if (prob >= this.minProbability) {
            return PlausibilityResult.PASS;
        }
        return PlausibilityResult.FAIL_HARD_STOP;
    }

    @Override
    public String getShortName() {
        if (this.calcs.length > 1) {
            return "CumProb\u2265" + this.minProbability;
        }
        return "P(" + this.calcs[0].getName().replaceAll(" ", "") + ")\u2265" + this.minProbability;
    }

    @Override
    public String getName() {
        if (this.calcs.length > 1) {
            return "Cumulative Probability Filter \u2265" + this.minProbability;
        }
        return "P(" + this.calcs[0].getName() + ") \u2265" + this.minProbability;
    }

    @Override
    public Float getValue(ClusterRupture rupture) {
        return this.getValue(rupture, false);
    }

    public Float getValue(ClusterRupture rupture, boolean verbose) {
        double prob = 1.0;
        for (RuptureProbabilityCalc calc : this.calcs) {
            double indvProb = calc.calcRuptureProb(rupture, verbose);
            if (verbose) {
                System.out.println("\t" + calc.getName() + ": P=" + indvProb);
            }
            Preconditions.checkState((indvProb >= 0.0 && indvProb <= 1.0 ? 1 : 0) != 0, (String)"Bad probability for %s: %s\n\tRupture: %s", (Object)indvProb, (Object)calc.getName(), (Object)rupture);
            prob *= indvProb;
        }
        return Float.valueOf((float)prob);
    }

    public RuptureProbabilityCalc[] getProbCalcs() {
        return this.calcs;
    }

    @Override
    public Range<Float> getAcceptableRange() {
        return Range.closed((Comparable)Float.valueOf(this.minProbability), (Comparable)Float.valueOf(1.0f));
    }

    @Override
    public String getScalarName() {
        return "Conditional Probability";
    }

    @Override
    public String getScalarUnits() {
        return null;
    }

    @Override
    public TypeAdapter<PlausibilityFilter> getTypeAdapter() {
        return new Adapter();
    }

    @Override
    public boolean isDirectional(boolean splayed) {
        for (RuptureProbabilityCalc calc : this.calcs) {
            if (!calc.isDirectional(splayed)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
    }

    public static class Adapter
    extends PlausibilityFilter.PlausibilityFilterTypeAdapter {
        private Gson gson;
        private ClusterConnectionStrategy connStrategy;
        private SectionDistanceAzimuthCalculator distAzCalc;

        @Override
        public void init(ClusterConnectionStrategy connStrategy, SectionDistanceAzimuthCalculator distAzCalc, Gson gson) {
            this.connStrategy = connStrategy;
            this.distAzCalc = distAzCalc;
            this.gson = gson;
        }

        public void write(JsonWriter out, PlausibilityFilter value) throws IOException {
            Preconditions.checkState((boolean)(value instanceof CumulativeProbabilityFilter));
            CumulativeProbabilityFilter filter = (CumulativeProbabilityFilter)value;
            out.beginObject();
            out.name("minProbability").value((double)filter.minProbability);
            out.name("calcs").beginArray();
            for (RuptureProbabilityCalc calc : filter.calcs) {
                out.beginObject();
                out.name("class").value(calc.getClass().getName());
                out.name("value");
                this.gson.toJson((Object)calc, calc.getClass(), out);
                out.endObject();
            }
            out.endArray();
            out.endObject();
        }

        public PlausibilityFilter read(JsonReader in) throws IOException {
            in.beginObject();
            Float minProbability = null;
            RuptureProbabilityCalc[] calcs = null;
            block18: while (in.hasNext()) {
                switch (in.nextName()) {
                    case "minProbability": {
                        minProbability = Float.valueOf((float)in.nextDouble());
                        continue block18;
                    }
                    case "calcs": {
                        ArrayList<RuptureProbabilityCalc> list = new ArrayList<RuptureProbabilityCalc>();
                        in.beginArray();
                        while (in.hasNext()) {
                            in.beginObject();
                            Class type = null;
                            RuptureProbabilityCalc calc = null;
                            block20: while (in.hasNext()) {
                                switch (in.nextName()) {
                                    case "class": {
                                        try {
                                            type = PlausibilityConfiguration.getDeclaredTypeClass(in.nextString());
                                            continue block20;
                                        }
                                        catch (ClassNotFoundException e) {
                                            throw ExceptionUtils.asRuntimeException(e);
                                        }
                                    }
                                    case "value": {
                                        Preconditions.checkNotNull(type, (Object)"Class must preceed value in ProbCalc JSON");
                                        calc = (RuptureProbabilityCalc)this.gson.fromJson(in, type);
                                        continue block20;
                                    }
                                }
                                throw new IllegalStateException("Unexpected JSON field");
                            }
                            Preconditions.checkNotNull(calc, (Object)"Penalty is null?");
                            calc.init(this.connStrategy, this.distAzCalc);
                            list.add(calc);
                            in.endObject();
                        }
                        in.endArray();
                        Preconditions.checkState((!list.isEmpty() ? 1 : 0) != 0, (Object)"No prob calcs?");
                        calcs = list.toArray(new RuptureProbabilityCalc[0]);
                        continue block18;
                    }
                }
                throw new IllegalStateException("Unexpected JSON field");
            }
            in.endObject();
            Preconditions.checkNotNull(minProbability, (Object)"threshold not supplied");
            Preconditions.checkNotNull(calcs, (Object)"penalties not supplied");
            return new CumulativeProbabilityFilter(minProbability.floatValue(), calcs);
        }
    }
}

