/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RuptureProbabilityCalc;

public interface JumpProbabilityCalc
extends RuptureProbabilityCalc {
    public double calcJumpProbability(ClusterRupture var1, Jump var2, boolean var3);

    @Override
    default public double calcRuptureProb(ClusterRupture rupture, boolean verbose) {
        double prob = 1.0;
        for (Jump jump : rupture.getJumpsIterable()) {
            double jumpProb = this.calcJumpProbability(rupture, jump, verbose);
            if (verbose) {
                System.out.println(this.getName() + ": " + String.valueOf(jump) + ", P=" + jumpProb);
            }
            if ((prob *= jumpProb) != 0.0 || verbose) continue;
            break;
        }
        return prob;
    }

    public static class GenericJumpProbCalcAdapter
    extends TypeAdapter<JumpProbabilityCalc> {
        Gson gson = new Gson();

        public void write(JsonWriter out, JumpProbabilityCalc value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("type").value(value.getClass().getName());
            out.name("data");
            this.gson.toJson((Object)value, value.getClass(), out);
            out.endObject();
        }

        public JumpProbabilityCalc read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                return null;
            }
            Class<?> type = null;
            in.beginObject();
            Preconditions.checkState((boolean)in.nextName().equals("type"), (Object)"JSON 'type' object must be first");
            try {
                type = Class.forName(in.nextString());
            }
            catch (ClassCastException | ClassNotFoundException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            Preconditions.checkState((boolean)in.nextName().equals("data"), (Object)"JSON 'data' object must be second");
            JumpProbabilityCalc model = (JumpProbabilityCalc)this.gson.fromJson(in, type);
            in.endObject();
            return model;
        }
    }

    public static class GenericArrayBinaryJumpProbCalcAdapter
    extends TypeAdapter<BinaryJumpProbabilityCalc[]> {
        private GenericJumpProbCalcAdapter adapter = new GenericJumpProbCalcAdapter();

        public void write(JsonWriter out, BinaryJumpProbabilityCalc[] calcs) throws IOException {
            out.beginArray();
            for (BinaryJumpProbabilityCalc calc : calcs) {
                this.adapter.write(out, calc);
            }
            out.endArray();
        }

        public BinaryJumpProbabilityCalc[] read(JsonReader in) throws IOException {
            in.beginArray();
            ArrayList<BinaryJumpProbabilityCalc> calcs = new ArrayList<BinaryJumpProbabilityCalc>();
            while (in.hasNext()) {
                JumpProbabilityCalc calc = this.adapter.read(in);
                Preconditions.checkState((boolean)(calc instanceof BinaryJumpProbabilityCalc));
                calcs.add((BinaryJumpProbabilityCalc)calc);
            }
            in.endArray();
            return calcs.toArray(new BinaryJumpProbabilityCalc[0]);
        }
    }

    public static class GenericArrayJumpProbCalcAdapter
    extends TypeAdapter<JumpProbabilityCalc[]> {
        private GenericJumpProbCalcAdapter adapter = new GenericJumpProbCalcAdapter();

        public void write(JsonWriter out, JumpProbabilityCalc[] calcs) throws IOException {
            out.beginArray();
            for (JumpProbabilityCalc calc : calcs) {
                this.adapter.write(out, calc);
            }
            out.endArray();
        }

        public JumpProbabilityCalc[] read(JsonReader in) throws IOException {
            in.beginArray();
            ArrayList<JumpProbabilityCalc> calcs = new ArrayList<JumpProbabilityCalc>();
            while (in.hasNext()) {
                calcs.add(this.adapter.read(in));
            }
            in.endArray();
            return calcs.toArray(new JumpProbabilityCalc[0]);
        }
    }

    public static class HardcodedBinaryJumpProb
    implements BinaryJumpProbabilityCalc {
        private String name;
        private Set<IDPairing> ids;
        private boolean excludeMatches;
        private boolean parentSects;

        public HardcodedBinaryJumpProb(String name, boolean excludeMatches, Set<IDPairing> ids, boolean parentSects) {
            this.name = name;
            this.excludeMatches = excludeMatches;
            this.ids = ids;
            this.parentSects = parentSects;
        }

        @Override
        public boolean isDirectional(boolean splayed) {
            return false;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isJumpAllowed(ClusterRupture fullRupture, Jump jump, boolean verbose) {
            boolean contains;
            IDPairing pair = this.parentSects ? new IDPairing(jump.fromSection.getParentSectionId(), jump.toSection.getParentSectionId()) : new IDPairing(jump.fromSection.getSectionId(), jump.toSection.getSectionId());
            boolean bl = contains = this.ids.contains(pair) || this.ids.contains(pair.getReversed());
            if (verbose) {
                System.out.println("Hardcoded jump contained " + String.valueOf(jump) + "? " + contains);
            }
            if (contains) {
                return !this.excludeMatches;
            }
            return this.excludeMatches;
        }
    }

    public static class IDtoProbsTypeAdapter
    extends TypeAdapter<Map<IDPairing, Double>> {
        public void write(JsonWriter out, Map<IDPairing, Double> map) throws IOException {
            out.beginArray();
            for (IDPairing pair : map.keySet()) {
                out.beginArray();
                out.value((long)pair.getID1()).value((long)pair.getID2()).value((Number)map.get(pair));
                out.endArray();
            }
            out.endArray();
        }

        public Map<IDPairing, Double> read(JsonReader in) throws IOException {
            in.beginArray();
            HashMap<IDPairing, Double> ret = new HashMap<IDPairing, Double>();
            while (in.hasNext()) {
                in.beginArray();
                int id1 = in.nextInt();
                int id2 = in.nextInt();
                double prob = in.nextDouble();
                ret.put(new IDPairing(id1, id2), prob);
                in.endArray();
            }
            in.endArray();
            return ret;
        }
    }

    public static class HardcodedJumpProb
    implements JumpProbabilityCalc {
        private String name;
        @JsonAdapter(value=IDtoProbsTypeAdapter.class)
        private Map<IDPairing, Double> idsToProbs;
        private boolean parentSects;
        @JsonAdapter(value=GenericJumpProbCalcAdapter.class)
        private JumpProbabilityCalc fallback;

        public HardcodedJumpProb(String name, Map<IDPairing, Double> idsToProbs, boolean parentSects) {
            this(name, idsToProbs, parentSects, null);
        }

        public HardcodedJumpProb(String name, Map<IDPairing, Double> idsToProbs, boolean parentSects, JumpProbabilityCalc fallback) {
            this.name = name;
            this.idsToProbs = idsToProbs;
            this.parentSects = parentSects;
            this.fallback = fallback;
        }

        @Override
        public boolean isDirectional(boolean splayed) {
            return false;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public double calcJumpProbability(ClusterRupture fullRupture, Jump jump, boolean verbose) {
            IDPairing pair = this.parentSects ? new IDPairing(jump.fromSection.getParentSectionId(), jump.toSection.getParentSectionId()) : new IDPairing(jump.fromSection.getSectionId(), jump.toSection.getSectionId());
            Double prob = this.idsToProbs.get(pair);
            if (prob == null) {
                prob = this.idsToProbs.get(pair.getReversed());
            }
            if (verbose) {
                System.out.println("Hardcoded probability for jump " + String.valueOf(jump) + ": " + prob);
            }
            if (prob != null) {
                return prob;
            }
            if (this.fallback == null) {
                return 1.0;
            }
            return this.fallback.calcJumpProbability(fullRupture, jump, verbose);
        }
    }

    public static class LogicalAnd
    implements BinaryJumpProbabilityCalc {
        @JsonAdapter(value=GenericArrayBinaryJumpProbCalcAdapter.class)
        private BinaryJumpProbabilityCalc[] calcs;

        public LogicalAnd(BinaryJumpProbabilityCalc ... calcs) {
            Preconditions.checkState((calcs.length > 1 ? 1 : 0) != 0);
            this.calcs = calcs;
        }

        private LogicalAnd() {
        }

        @Override
        public String getName() {
            return "Logical AND of " + this.calcs.length + " models";
        }

        @Override
        public boolean isDirectional(boolean splayed) {
            for (BinaryJumpProbabilityCalc calc : this.calcs) {
                if (!calc.isDirectional(splayed)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isJumpAllowed(ClusterRupture fullRupture, Jump jump, boolean verbose) {
            for (BinaryJumpProbabilityCalc calc : this.calcs) {
                if (calc.isJumpAllowed(fullRupture, jump, verbose)) continue;
                return false;
            }
            return true;
        }
    }

    public static class NoJumps
    implements BinaryJumpProbabilityCalc {
        @Override
        public boolean isDirectional(boolean splayed) {
            return false;
        }

        @Override
        public String getName() {
            return "No Jumps";
        }

        @Override
        public boolean isJumpAllowed(ClusterRupture fullRupture, Jump jump, boolean verbose) {
            return false;
        }
    }

    public static class Minimum
    implements JumpProbabilityCalc {
        @JsonAdapter(value=GenericArrayJumpProbCalcAdapter.class)
        private JumpProbabilityCalc[] calcs;

        public Minimum(JumpProbabilityCalc ... calcs) {
            Preconditions.checkState((calcs.length > 1 ? 1 : 0) != 0);
            this.calcs = calcs;
        }

        @Override
        public String getName() {
            return "Minimum from " + this.calcs.length + " models";
        }

        @Override
        public boolean isDirectional(boolean splayed) {
            for (JumpProbabilityCalc calc : this.calcs) {
                if (!calc.isDirectional(splayed)) continue;
                return true;
            }
            return false;
        }

        @Override
        public double calcJumpProbability(ClusterRupture fullRupture, Jump jump, boolean verbose) {
            double min = 1.0;
            for (JumpProbabilityCalc calc : this.calcs) {
                min = Math.min(min, calc.calcJumpProbability(fullRupture, jump, verbose));
            }
            return min;
        }
    }

    public static class MultiProduct
    implements JumpProbabilityCalc {
        @JsonAdapter(value=GenericArrayJumpProbCalcAdapter.class)
        private JumpProbabilityCalc[] calcs;

        public MultiProduct(JumpProbabilityCalc ... calcs) {
            Preconditions.checkState((calcs.length > 1 ? 1 : 0) != 0);
            this.calcs = calcs;
        }

        @Override
        public String getName() {
            return "Product of " + this.calcs.length + " models";
        }

        @Override
        public boolean isDirectional(boolean splayed) {
            for (JumpProbabilityCalc calc : this.calcs) {
                if (!calc.isDirectional(splayed)) continue;
                return true;
            }
            return false;
        }

        @Override
        public double calcJumpProbability(ClusterRupture fullRupture, Jump jump, boolean verbose) {
            double product = 1.0;
            for (JumpProbabilityCalc calc : this.calcs) {
                product *= calc.calcJumpProbability(fullRupture, jump, verbose);
            }
            return product;
        }
    }

    public static interface BinaryJumpProbabilityCalc
    extends RuptureProbabilityCalc.BinaryRuptureProbabilityCalc,
    JumpProbabilityCalc {
        public boolean isJumpAllowed(ClusterRupture var1, Jump var2, boolean var3);

        @Override
        default public double calcJumpProbability(ClusterRupture fullRupture, Jump jump, boolean verbose) {
            if (this.isJumpAllowed(fullRupture, jump, verbose)) {
                return 1.0;
            }
            return 0.0;
        }

        @Override
        default public boolean isRupAllowed(ClusterRupture fullRupture, boolean verbose) {
            for (Jump jump : fullRupture.getJumpsIterable()) {
                if (this.isJumpAllowed(fullRupture, jump, verbose)) continue;
                return false;
            }
            return true;
        }

        @Override
        default public double calcRuptureProb(ClusterRupture rupture, boolean verbose) {
            return RuptureProbabilityCalc.BinaryRuptureProbabilityCalc.super.calcRuptureProb(rupture, verbose);
        }
    }

    public static interface DistDependentJumpProbabilityCalc
    extends JumpProbabilityCalc {
        @Override
        default public double calcJumpProbability(ClusterRupture fullRupture, Jump jump, boolean verbose) {
            return this.calcJumpProbability(jump.distance);
        }

        public double calcJumpProbability(double var1);
    }
}

