/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.opensha.commons.data.Named;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;

public interface RuptureProbabilityCalc
extends Named {
    public double calcRuptureProb(ClusterRupture var1, boolean var2);

    default public void init(ClusterConnectionStrategy connStrat, SectionDistanceAzimuthCalculator distAzCalc) {
    }

    public boolean isDirectional(boolean var1);

    public static class GenericRupProbCalcAdapter
    extends TypeAdapter<RuptureProbabilityCalc> {
        Gson gson = new Gson();

        public void write(JsonWriter out, RuptureProbabilityCalc value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("type").value(value.getClass().getName());
            out.name("data");
            this.gson.toJson((Object)value, value.getClass(), out);
            out.endObject();
        }

        public RuptureProbabilityCalc read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                return null;
            }
            Class<?> type = null;
            in.beginObject();
            Preconditions.checkState((boolean)in.nextName().equals("type"), (Object)"JSON 'type' object must be first");
            try {
                type = Class.forName(in.nextString());
            }
            catch (ClassCastException | ClassNotFoundException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            Preconditions.checkState((boolean)in.nextName().equals("data"), (Object)"JSON 'data' object must be second");
            RuptureProbabilityCalc model = (RuptureProbabilityCalc)this.gson.fromJson(in, type);
            in.endObject();
            return model;
        }
    }

    public static class GenericArrayBinaryRupProbCalcAdapter
    extends TypeAdapter<BinaryRuptureProbabilityCalc[]> {
        private GenericRupProbCalcAdapter adapter = new GenericRupProbCalcAdapter();

        public void write(JsonWriter out, BinaryRuptureProbabilityCalc[] calcs) throws IOException {
            out.beginArray();
            for (BinaryRuptureProbabilityCalc calc : calcs) {
                this.adapter.write(out, calc);
            }
            out.endArray();
        }

        public BinaryRuptureProbabilityCalc[] read(JsonReader in) throws IOException {
            in.beginArray();
            ArrayList<BinaryRuptureProbabilityCalc> calcs = new ArrayList<BinaryRuptureProbabilityCalc>();
            while (in.hasNext()) {
                RuptureProbabilityCalc calc = this.adapter.read(in);
                Preconditions.checkState((boolean)(calc instanceof BinaryRuptureProbabilityCalc));
                calcs.add((BinaryRuptureProbabilityCalc)calc);
            }
            in.endArray();
            return calcs.toArray(new BinaryRuptureProbabilityCalc[0]);
        }
    }

    public static class GenericArrayRupProbCalcAdapter
    extends TypeAdapter<RuptureProbabilityCalc[]> {
        private GenericRupProbCalcAdapter adapter = new GenericRupProbCalcAdapter();

        public void write(JsonWriter out, RuptureProbabilityCalc[] calcs) throws IOException {
            out.beginArray();
            for (RuptureProbabilityCalc calc : calcs) {
                this.adapter.write(out, calc);
            }
            out.endArray();
        }

        public RuptureProbabilityCalc[] read(JsonReader in) throws IOException {
            in.beginArray();
            ArrayList<RuptureProbabilityCalc> calcs = new ArrayList<RuptureProbabilityCalc>();
            while (in.hasNext()) {
                calcs.add(this.adapter.read(in));
            }
            in.endArray();
            return calcs.toArray(new RuptureProbabilityCalc[0]);
        }
    }

    public static class MultiProduct
    implements RuptureProbabilityCalc {
        @JsonAdapter(value=GenericArrayRupProbCalcAdapter.class)
        private RuptureProbabilityCalc[] calcs;

        public MultiProduct(RuptureProbabilityCalc ... calcs) {
            Preconditions.checkState((calcs.length > 1 ? 1 : 0) != 0);
            this.calcs = calcs;
        }

        @Override
        public String getName() {
            return "Product of " + this.calcs.length + " models";
        }

        @Override
        public double calcRuptureProb(ClusterRupture rupture, boolean verbose) {
            double product = 1.0;
            for (RuptureProbabilityCalc calc : this.calcs) {
                product *= calc.calcRuptureProb(rupture, verbose);
            }
            return product;
        }

        @Override
        public boolean isDirectional(boolean splayed) {
            for (RuptureProbabilityCalc calc : this.calcs) {
                if (!calc.isDirectional(splayed)) continue;
                return true;
            }
            return false;
        }
    }

    public static class LogicalAnd
    implements BinaryRuptureProbabilityCalc {
        @JsonAdapter(value=GenericArrayBinaryRupProbCalcAdapter.class)
        private BinaryRuptureProbabilityCalc[] calcs;

        public LogicalAnd(BinaryRuptureProbabilityCalc ... calcs) {
            Preconditions.checkState((calcs.length > 1 ? 1 : 0) != 0);
            this.calcs = calcs;
        }

        @Override
        public String getName() {
            return "Logical AND of " + this.calcs.length + " models";
        }

        @Override
        public boolean isDirectional(boolean splayed) {
            for (BinaryRuptureProbabilityCalc calc : this.calcs) {
                if (!calc.isDirectional(splayed)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isRupAllowed(ClusterRupture fullRupture, boolean verbose) {
            for (BinaryRuptureProbabilityCalc calc : this.calcs) {
                if (calc.isRupAllowed(fullRupture, verbose)) continue;
                return false;
            }
            return true;
        }
    }

    public static interface BinaryRuptureProbabilityCalc
    extends RuptureProbabilityCalc {
        public boolean isRupAllowed(ClusterRupture var1, boolean var2);

        @Override
        default public double calcRuptureProb(ClusterRupture rupture, boolean verbose) {
            if (this.isRupAllowed(rupture, verbose)) {
                return 1.0;
            }
            return 0.0;
        }
    }
}

