/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.RuptureGrowingStrategy;
import org.opensha.sha.faultSurface.FaultSection;

public class ConnectionPointsRuptureGrowingStrategy
implements RuptureGrowingStrategy {
    @Override
    public List<FaultSubsectionCluster> getVariations(FaultSubsectionCluster fullCluster, FaultSection firstSection) {
        return this.getVariations(null, fullCluster, firstSection);
    }

    @Override
    public List<FaultSubsectionCluster> getVariations(ClusterRupture currentRupture, FaultSubsectionCluster fullCluster, FaultSection firstSection) {
        FaultSection nextSection;
        ImmutableList<FaultSection> clusterSects = fullCluster.subSects;
        int myInd = fullCluster.subSects.indexOf((Object)firstSection);
        Preconditions.checkState((myInd >= 0 ? 1 : 0) != 0, (Object)"first section not found in cluster");
        ArrayList<FaultSection> newSects = new ArrayList<FaultSection>();
        newSects.add(firstSection);
        Set<FaultSection> exitPoints = fullCluster.getExitPoints();
        if (currentRupture != null && !exitPoints.isEmpty()) {
            ArrayList<FaultSection> toRemove = new ArrayList<FaultSection>();
            for (FaultSection exit : exitPoints) {
                boolean externalConnection = false;
                for (Jump jump : fullCluster.getConnections(exit)) {
                    if (currentRupture.contains(jump.toSection)) continue;
                    externalConnection = true;
                    break;
                }
                if (externalConnection) continue;
                toRemove.add(exit);
            }
            if (!toRemove.isEmpty()) {
                exitPoints = new HashSet<FaultSection>(exitPoints);
                for (FaultSection remove : toRemove) {
                    exitPoints.remove(remove);
                }
            }
        }
        ArrayList<FaultSubsectionCluster> permuations = new ArrayList<FaultSubsectionCluster>();
        if (exitPoints.contains(firstSection)) {
            permuations.add(ConnectionPointsRuptureGrowingStrategy.buildCopyJumps(fullCluster, newSects));
        }
        if (myInd > 0) {
            int i = myInd;
            while (--i >= 0) {
                nextSection = (FaultSection)clusterSects.get(i);
                newSects.add(nextSection);
                if (!exitPoints.contains(nextSection) && i != 0) continue;
                permuations.add(ConnectionPointsRuptureGrowingStrategy.buildCopyJumps(fullCluster, newSects));
            }
        }
        if (myInd < clusterSects.size() - 1) {
            newSects = new ArrayList();
            newSects.add(firstSection);
            for (int i = myInd + 1; i < clusterSects.size(); ++i) {
                nextSection = (FaultSection)clusterSects.get(i);
                newSects.add(nextSection);
                if (!exitPoints.contains(nextSection) && i != clusterSects.size() - 1) continue;
                permuations.add(ConnectionPointsRuptureGrowingStrategy.buildCopyJumps(fullCluster, newSects));
            }
        }
        return permuations;
    }

    private static FaultSubsectionCluster buildCopyJumps(FaultSubsectionCluster fullCluster, List<FaultSection> subsetSects) {
        FaultSubsectionCluster permutation = new FaultSubsectionCluster(new ArrayList<FaultSection>(subsetSects));
        for (FaultSection sect : subsetSects) {
            for (Jump jump : fullCluster.getConnections(sect)) {
                permutation.addConnection(new Jump(sect, permutation, jump.toSection, jump.toCluster, jump.distance));
            }
        }
        return permutation;
    }

    @Override
    public String getName() {
        return "Connection Points Only";
    }
}

