/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ExhaustiveUnilateralRuptureGrowingStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.RuptureGrowingStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.faultSurface.FaultSection;

public class SectCountAdaptiveRuptureGrowingStrategy
implements RuptureGrowingStrategy {
    private float minFractSectIncrease;
    private boolean maintainConnectivity;
    private RuptureGrowingStrategy exhaustiveStrategy;
    private int minSectsPerParent = 1;
    private static final DecimalFormat optionalDigitPDF = new DecimalFormat("0.#%");

    public SectCountAdaptiveRuptureGrowingStrategy(float minFractSectIncrease, boolean maintainConnectivity, int minSectsPerParent) {
        this(new ExhaustiveUnilateralRuptureGrowingStrategy(), minFractSectIncrease, maintainConnectivity, minSectsPerParent);
    }

    public SectCountAdaptiveRuptureGrowingStrategy(RuptureGrowingStrategy exhaustiveStrategy, float minFractSectIncrease, boolean maintainConnectivity, int minSectsPerParent) {
        this.exhaustiveStrategy = exhaustiveStrategy;
        this.minFractSectIncrease = minFractSectIncrease;
        this.maintainConnectivity = maintainConnectivity;
        this.minSectsPerParent = minSectsPerParent;
    }

    @Override
    public List<FaultSubsectionCluster> getVariations(FaultSubsectionCluster fullCluster, FaultSection firstSection) {
        return this.exhaustiveStrategy.getVariations(fullCluster, firstSection);
    }

    public static HashSet<Integer> getValidAdditionCounts(int originalRupSize, int newClusterSize, float minFractSectIncrease, int minSectsPerParent) {
        HashSet<Integer> validAddSizes = new HashSet<Integer>();
        int lastValidSize = originalRupSize;
        for (int i = minSectsPerParent - 1; i < newClusterSize; ++i) {
            int newSize = originalRupSize + i + 1;
            int newDelta = newSize - lastValidSize;
            double fractAdded = (double)newDelta / (double)lastValidSize;
            if (!((float)fractAdded >= minFractSectIncrease)) continue;
            validAddSizes.add(i + 1);
            lastValidSize = newSize;
        }
        return validAddSizes;
    }

    public float getFractIncrease() {
        return this.minFractSectIncrease;
    }

    public boolean isMaintainConnectivity() {
        return this.maintainConnectivity;
    }

    @Override
    public List<FaultSubsectionCluster> getVariations(ClusterRupture currentRupture, FaultSubsectionCluster fullCluster, FaultSection firstSection) {
        List<FaultSubsectionCluster> exhaustivePerms = this.exhaustiveStrategy.getVariations(currentRupture, fullCluster, firstSection);
        if (currentRupture == null) {
            return exhaustivePerms;
        }
        HashSet<Integer> validAddSizes = SectCountAdaptiveRuptureGrowingStrategy.getValidAdditionCounts(currentRupture.getTotalNumSects(), fullCluster.subSects.size(), this.minFractSectIncrease, this.minSectsPerParent);
        boolean D = false;
        ArrayList<FaultSubsectionCluster> permutations = new ArrayList<FaultSubsectionCluster>();
        ImmutableList<FaultSection> fullSects = fullCluster.subSects;
        Set<FaultSection> exitPoints = fullCluster.getExitPoints();
        for (FaultSubsectionCluster permutation : exhaustivePerms) {
            if (validAddSizes.contains(permutation.subSects.size())) {
                permutations.add(permutation);
                continue;
            }
            ArrayList<FaultSection> myEnds = new ArrayList<FaultSection>();
            myEnds.add((FaultSection)permutation.subSects.get(permutation.subSects.size() - 1));
            if (!((FaultSection)permutation.subSects.get(0)).equals(firstSection)) {
                myEnds.add((FaultSection)permutation.subSects.get(0));
            }
            boolean rupturesToEnds = true;
            boolean rupturesToConnPoints = true;
            for (FaultSection endSect : myEnds) {
                rupturesToEnds = rupturesToEnds && (endSect.equals(fullSects.get(0)) || endSect.equals(fullSects.get(fullSects.size() - 1)));
                rupturesToConnPoints = rupturesToConnPoints && exitPoints.contains(endSect);
            }
            if (!rupturesToEnds && (!this.maintainConnectivity || !rupturesToConnPoints)) continue;
            permutations.add(permutation);
        }
        return permutations;
    }

    public ConnPointCleanupFilter buildConnPointCleanupFilter(ClusterConnectionStrategy connStrat) {
        Preconditions.checkState((boolean)this.maintainConnectivity, (Object)"Connection point cleanup filter only applies if we're maintaining connectivity");
        return new ConnPointCleanupFilter(this.minFractSectIncrease, this.minSectsPerParent, connStrat);
    }

    public static void main(String[] args) {
        int[] origCounts = new int[]{0, 5, 10, 15, 20, 30, 50, 100};
        int[] clusterSizes = new int[]{5, 13, 20};
        float fract = 0.1f;
        int minSectsPerParent = 2;
        System.out.println("Fractional increase: " + fract);
        for (int origCount : origCounts) {
            System.out.println("Valid add counts for rupture of size " + origCount);
            for (int clusterSize : clusterSizes) {
                System.out.println("\tNext cluster size: " + clusterSize);
                ArrayList<Integer> sizes = new ArrayList<Integer>(SectCountAdaptiveRuptureGrowingStrategy.getValidAdditionCounts(origCount, clusterSize, fract, minSectsPerParent));
                Collections.sort(sizes);
                System.out.println("\t\tValid additions: " + Joiner.on((String)",").join(sizes));
            }
        }
    }

    @Override
    public String getName() {
        Object ret = this.exhaustiveStrategy.getName().replace("Exhaustive", "").trim();
        while (((String)ret).startsWith(",") || ((String)ret).startsWith(";")) {
            ret = ((String)ret).substring(1).trim();
        }
        while (((String)ret).endsWith(",") || ((String)ret).endsWith(";")) {
            ret = ((String)ret).substring(0, ((String)ret).length() - 1).trim();
        }
        if (!((String)ret).isEmpty()) {
            ret = (String)ret + ", ";
        }
        ret = (String)ret + "Adaptive, " + optionalDigitPDF.format(this.minFractSectIncrease) + " Sect Increase";
        if (this.maintainConnectivity) {
            ret = (String)ret + ", Maintain Connectivity";
        }
        return ret;
    }

    @Override
    public void clearCaches() {
        this.exhaustiveStrategy.clearCaches();
    }

    public static class ConnPointCleanupFilter
    implements PlausibilityFilter {
        private float minFractSectIncrease;
        private int minSectsPerParent = 1;
        private ClusterConnectionStrategy connStrat;
        private transient Map<Integer, FaultSubsectionCluster> fullClusters;

        public ConnPointCleanupFilter(float minFractSectIncrease, int minSectsPerParent, ClusterConnectionStrategy connStrat) {
            this.minFractSectIncrease = minFractSectIncrease;
            this.minSectsPerParent = minSectsPerParent;
            this.connStrat = connStrat;
        }

        @Override
        public String getShortName() {
            return optionalDigitPDF.format(this.minFractSectIncrease) + "SectCleanup";
        }

        @Override
        public String getName() {
            return optionalDigitPDF.format(this.minFractSectIncrease) + " Sect Increase Cleanup";
        }

        private synchronized FaultSubsectionCluster getFullCluster(int parentSectionID) {
            if (this.fullClusters == null) {
                this.fullClusters = new HashMap<Integer, FaultSubsectionCluster>();
                for (FaultSubsectionCluster cluster : this.connStrat.getClusters()) {
                    this.fullClusters.put(cluster.parentSectionID, cluster);
                }
            }
            return this.fullClusters.get(parentSectionID);
        }

        @Override
        public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
            if (rupture.getTotalNumClusters() == 1) {
                return PlausibilityResult.PASS;
            }
            FaultSubsectionCluster firstCluster = rupture.clusters[0];
            PlausibilityResult result = PlausibilityResult.PASS;
            RuptureTreeNavigator navigator = rupture.getTreeNavigator();
            for (FaultSubsectionCluster descendant : navigator.getDescendants(firstCluster)) {
                if ((result = result.logicalAnd(this.testPathRecursive(firstCluster.subSects.size(), navigator, descendant, verbose))).isPass()) continue;
                return result;
            }
            return result;
        }

        private PlausibilityResult testPathRecursive(int sizeSoFar, RuptureTreeNavigator navigator, FaultSubsectionCluster nextCluster, boolean verbose) {
            PlausibilityResult result = this.testCluster(sizeSoFar, nextCluster, navigator, verbose);
            if (!result.isPass()) {
                return result;
            }
            for (FaultSubsectionCluster descendant : navigator.getDescendants(nextCluster)) {
                if ((result = result.logicalAnd(this.testPathRecursive(sizeSoFar + nextCluster.subSects.size(), navigator, descendant, verbose))).isPass()) continue;
                return result;
            }
            return result;
        }

        private PlausibilityResult testCluster(int rupSizeBefore, FaultSubsectionCluster cluster, RuptureTreeNavigator navigator, boolean verbose) {
            ArrayList<Integer> sizes;
            HashSet<Integer> validSizes;
            FaultSubsectionCluster fullCluster = this.getFullCluster(cluster.parentSectionID);
            int newSize = cluster.subSects.size();
            int fullSize = fullCluster.subSects.size();
            if (verbose) {
                System.out.println("Testing rupture of size=" + rupSizeBefore + " to new cluster " + cluster.parentSectionID + " with size=" + newSize + ": " + String.valueOf(cluster));
            }
            if (newSize == fullSize) {
                if (verbose) {
                    System.out.println(this.getShortName() + ": passes because it is the full cluster");
                }
                return PlausibilityResult.PASS;
            }
            FaultSection lastSect = (FaultSection)cluster.subSects.get(newSize - 1);
            int lastID = lastSect.getSectionId();
            if (lastID == ((FaultSection)fullCluster.subSects.get(0)).getSectionId() || lastID == ((FaultSection)fullCluster.subSects.get(fullSize - 1)).getSectionId()) {
                if (verbose) {
                    System.out.println(this.getShortName() + ": passes because " + lastID + " is a cluster end (fullCluster=" + String.valueOf(fullCluster) + ")");
                }
                return PlausibilityResult.PASS;
            }
            if (navigator != null) {
                for (FaultSection descendant : navigator.getDescendants(lastSect)) {
                    if (descendant.getParentSectionId() == cluster.parentSectionID) continue;
                    if (verbose) {
                        System.out.println(this.getShortName() + ": passes because it's a used connection to " + descendant.getParentSectionId());
                    }
                    return PlausibilityResult.PASS;
                }
            }
            if ((validSizes = SectCountAdaptiveRuptureGrowingStrategy.getValidAdditionCounts(rupSizeBefore, fullCluster.subSects.size(), this.minFractSectIncrease, this.minSectsPerParent)).contains(newSize)) {
                if (verbose) {
                    sizes = new ArrayList<Integer>(validSizes);
                    Collections.sort(sizes);
                    System.out.println(this.getShortName() + ": passes because it a valid size, " + newSize + " is in (" + Joiner.on((String)",").join(sizes) + ")");
                }
                return PlausibilityResult.PASS;
            }
            if (verbose) {
                sizes = new ArrayList<Integer>(validSizes);
                Collections.sort(sizes);
                System.out.println(this.getShortName() + ": failing because it not a valid size, " + newSize + " is not in (" + Joiner.on((String)",").join(sizes) + ")");
            }
            return PlausibilityResult.FAIL_FUTURE_POSSIBLE;
        }

        @Override
        public boolean isDirectional(boolean splayed) {
            return true;
        }

        @Override
        public TypeAdapter<PlausibilityFilter> getTypeAdapter() {
            return new ConnPointsAdapter();
        }
    }

    public static class ConnPointsAdapter
    extends PlausibilityFilter.PlausibilityFilterTypeAdapter {
        private ClusterConnectionStrategy connStrategy;

        @Override
        public void init(ClusterConnectionStrategy connStrategy, SectionDistanceAzimuthCalculator distAzCalc, Gson gson) {
            this.connStrategy = connStrategy;
        }

        public void write(JsonWriter out, PlausibilityFilter value) throws IOException {
            Preconditions.checkState((boolean)(value instanceof ConnPointCleanupFilter));
            ConnPointCleanupFilter filter = (ConnPointCleanupFilter)value;
            out.beginObject();
            out.name("minFractSectIncrease").value((double)filter.minFractSectIncrease);
            out.name("minSectsPerParent").value((long)filter.minSectsPerParent);
            out.endObject();
        }

        public PlausibilityFilter read(JsonReader in) throws IOException {
            Preconditions.checkNotNull((Object)this.connStrategy);
            in.beginObject();
            Float minFractSectIncrease = null;
            int minSectsPerParent = 1;
            block8: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "minFractSectIncrease": {
                        minFractSectIncrease = Float.valueOf((float)in.nextDouble());
                        continue block8;
                    }
                    case "minSectsPerParent": {
                        minSectsPerParent = in.nextInt();
                        continue block8;
                    }
                }
                throw new IllegalStateException("Unexpected name: " + name);
            }
            Preconditions.checkNotNull(minFractSectIncrease);
            in.endObject();
            return new ConnPointCleanupFilter(minFractSectIncrease.floatValue(), minSectsPerParent, this.connStrategy);
        }
    }
}

