/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.dom4j.DocumentException;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.ui.RectangleAnchor;
import org.jfree.data.Range;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FileNameUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportPageGen;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.PlausibilityFilterPlot;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.CumulativeRakeChangeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.MultiDirectionalPlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.coulomb.NetRuptureCoulombFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.CumulativeProbPathEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.NucleationClusterEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.PathPlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.CoulombSectRatioProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.CumulativeProbabilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RelativeCoulombProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RelativeSlipRateProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.Shaw07JumpDistProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.DistCutoffClosestSectClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.PassingSubRuptureSearch;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupCartoonGenerator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureConnectionSearch;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCache;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCalculator;
import org.opensha.sha.simulators.stiffness.SubSectStiffnessCalculator;

public class RupSetFilterComparePageGen {
    /*
     * Could not resolve type clashes
     */
    public static void main(String[] args) throws IOException, DocumentException {
        File rupSetsDir = new File("/home/kevin/OpenSHA/UCERF4/rup_sets");
        String inputName = "RSQSim 4983, SectArea=0.5";
        File inputFile = new File(rupSetsDir, "rsqsim_4983_stitched_m6.5_skip65000_sectArea0.5.zip");
        File distAzCache = new File(rupSetsDir, "fm3_1_dist_az_cache.csv");
        File altFiltersFile = new File(rupSetsDir, "u3_az_cff_cmls.json");
        String altName = "UCERF3";
        File markdownDir = new File("/home/kevin/markdown/rupture-sets");
        File myMDdir = new File(markdownDir, inputFile.getName().replace(".zip", ""));
        Preconditions.checkState((myMDdir.exists() || myMDdir.mkdir() ? 1 : 0) != 0);
        File outputDir = new File(myMDdir, "plausibility_filter_debug");
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        File resourcesDir = new File(outputDir, "resources");
        Preconditions.checkState((resourcesDir.exists() || resourcesDir.mkdir() ? 1 : 0) != 0);
        Object[] skipFaultNames = new String[]{"Great Valley"};
        final double maxDist = 10.0;
        double rupDebugMinMag = 8.0;
        int maxRupDebugs = 20;
        ArrayList<ParameterizedFilterWrapper> wrappers = new ArrayList<ParameterizedFilterWrapper>();
        ArrayList<Float> minVals = new ArrayList<Float>();
        ArrayList<Float> maxVals = new ArrayList<Float>();
        ArrayList<Float> prefVals = new ArrayList<Float>();
        ArrayList<String> names = new ArrayList<String>();
        FaultSystemRupSet rupSet = FaultSystemRupSet.load(inputFile);
        rupSet.removeModuleInstances(PlausibilityConfiguration.class);
        rupSet.removeModuleInstances(ClusterRuptures.class);
        final SectionDistanceAzimuthCalculator distAzCalc = new SectionDistanceAzimuthCalculator(rupSet.getFaultSectionDataList());
        if (distAzCache != null && distAzCache.exists()) {
            System.out.println("Loading dist/az cache from " + distAzCache.getAbsolutePath());
            distAzCalc.loadCacheFile(distAzCache);
        }
        RuptureConnectionSearch connSearch = rupSet.hasModule(PlausibilityConfiguration.class) ? new RuptureConnectionSearch(rupSet, distAzCalc, rupSet.getModule(PlausibilityConfiguration.class).getConnectionStrategy().getMaxJumpDist(), false) : new RuptureConnectionSearch(rupSet, distAzCalc, 100.0, false);
        if (!rupSet.hasModule(ClusterRuptures.class)) {
            rupSet.addModule(ClusterRuptures.instance(rupSet, connSearch));
        }
        List<ClusterRupture> rups = rupSet.requireModule(ClusterRuptures.class).getAll();
        HashSet<Jump> allJumps = new HashSet<Jump>();
        double minRupMag = rupSet.getMinMag();
        for (ClusterRupture rup : rups) {
            for (Jump jump : rup.getJumpsIterable()) {
                allJumps.add(jump);
            }
        }
        SubSectStiffnessCalculator stiffnessCalc = new SubSectStiffnessCalculator(rupSet.getFaultSectionDataList(), 2.0, 30000.0, 30000.0, 0.5, SubSectStiffnessCalculator.PatchAlignment.FILL_OVERLAP, 1.0);
        AggregatedStiffnessCache stiffnessCache = stiffnessCalc.getAggregationCache(SubSectStiffnessCalculator.StiffnessType.CFF);
        File stiffnessCacheFile = new File(rupSetsDir, stiffnessCache.getCacheFileName());
        if (stiffnessCacheFile.exists()) {
            stiffnessCache.loadCacheFile(stiffnessCacheFile);
        }
        final AggregatedStiffnessCalculator sumAgg = new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.CFF, stiffnessCalc, true, AggregatedStiffnessCalculator.AggregationMethod.FLATTEN, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM);
        AggregatedStiffnessCalculator fractRpatchPosAgg = new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.CFF, stiffnessCalc, true, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.PASSTHROUGH, AggregatedStiffnessCalculator.AggregationMethod.RECEIVER_SUM, AggregatedStiffnessCalculator.AggregationMethod.FRACT_POSITIVE);
        final AggregatedStiffnessCalculator fractIntsPositive = new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.CFF, stiffnessCalc, true, AggregatedStiffnessCalculator.AggregationMethod.FLATTEN, AggregatedStiffnessCalculator.AggregationMethod.NUM_POSITIVE, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.NORM_BY_COUNT);
        if ((double)((float)minRupMag) >= 7.0) {
            double[] dArray = new double[]{7.0, 7.5, 8.0};
        }
        double[] minMags = (double)((float)minRupMag) >= 6.5 ? new double[]{6.5, 7.0, 7.5, 8.0} : ((double)((float)minRupMag) >= 6.0 ? new double[]{6.0, 6.5, 7.0, 7.5, 8.0} : new double[]{0.0, 6.0, 6.5, 7.0, 7.5, 8.0});
        CPT magIndexCPT = new CPT(0.0, minMags.length - 1, Color.BLUE, Color.RED, Color.BLACK);
        final ClusterConnectionStrategy connStrat = rupSet.hasModule(PlausibilityConfiguration.class) ? rupSet.getModule(PlausibilityConfiguration.class).getConnectionStrategy() : ReportPageGen.buildDefaultConnStrat(distAzCalc, allJumps, maxDist);
        List<PlausibilityFilter> altFilters = PlausibilityConfiguration.readFiltersJSON(altFiltersFile, connStrat, distAzCalc);
        wrappers.add(new ParameterizedFilterWrapper(){

            @Override
            public PlausibilityFilter get(Float value) {
                return new CumulativeProbabilityFilter(value.floatValue(), new RelativeSlipRateProb(connStrat, true, false));
            }
        });
        minVals.add(Float.valueOf(0.01f));
        maxVals.add(Float.valueOf(0.2f));
        prefVals.add(Float.valueOf(0.05f));
        names.add("Slip Probability");
        wrappers.add(new ParameterizedFilterWrapper(){

            @Override
            public PlausibilityFilter get(Float value) {
                return new NetRuptureCoulombFilter(fractIntsPositive, value.floatValue());
            }
        });
        minVals.add(Float.valueOf(0.5f));
        maxVals.add(Float.valueOf(0.95f));
        prefVals.add(Float.valueOf(0.75f));
        names.add("Fraction of Interactions");
        wrappers.add(new ParameterizedFilterWrapper(){

            @Override
            public PlausibilityFilter get(Float value) {
                return new PathPlausibilityFilter(new CumulativeProbPathEvaluator(value.floatValue(), PlausibilityResult.FAIL_HARD_STOP, new CoulombSectRatioProb(sumAgg, 2, true, (float)maxDist, distAzCalc)));
            }
        });
        minVals.add(Float.valueOf(0.0f));
        maxVals.add(Float.valueOf(1.0f));
        prefVals.add(Float.valueOf(0.5f));
        names.add("CFF Favorability Ratio");
        wrappers.add(new ParameterizedFilterWrapper(){

            @Override
            public PlausibilityFilter get(Float value) {
                return new PathPlausibilityFilter(new CumulativeProbPathEvaluator(value.floatValue(), PlausibilityResult.FAIL_HARD_STOP, new RelativeCoulombProb(sumAgg, connStrat, false, true, true, (float)maxDist, distAzCalc)));
            }
        });
        minVals.add(Float.valueOf(0.0f));
        maxVals.add(Float.valueOf(0.1f));
        prefVals.add(Float.valueOf(0.01f));
        names.add("CFF Probability");
        wrappers.add(new ParameterizedFilterWrapper(){

            @Override
            public PlausibilityFilter get(Float value) {
                return new CumulativeProbabilityFilter(value.floatValue(), new Shaw07JumpDistProb(1.0, 3.0));
            }
        });
        minVals.add(Float.valueOf(1.0E-4f));
        maxVals.add(Float.valueOf(0.1f));
        prefVals.add(Float.valueOf(0.001f));
        names.add("Cumulative Jump Dist Prob");
        wrappers.add(new ParameterizedFilterWrapper(){

            @Override
            public PlausibilityFilter get(Float value) {
                return new CumulativeRakeChangeFilter(value.floatValue());
            }
        });
        minVals.add(Float.valueOf(90.0f));
        maxVals.add(Float.valueOf(540.0f));
        prefVals.add(Float.valueOf(360.0f));
        names.add("Cumulative Rake Change");
        boolean hasSplays = false;
        for (ClusterRupture rup : rups) {
            if (rup.splays.isEmpty()) continue;
            hasSplays = true;
            break;
        }
        ArrayList<Boolean[]> xValsList = new ArrayList<Boolean[]>();
        int threads = Integer.max(1, Integer.min(16, Runtime.getRuntime().availableProcessors() - 2));
        ExecutorService exec = Executors.newFixedThreadPool(threads);
        ArrayList futures = new ArrayList();
        for (int i = 0; i < wrappers.size(); ++i) {
            Boolean[] xVals;
            Float min = (Float)minVals.get(i);
            Float max = (Float)maxVals.get(i);
            Float pref = (Float)prefVals.get(i);
            ParameterizedFilterWrapper wrapper = (ParameterizedFilterWrapper)wrappers.get(i);
            ArrayList<Future<PlausibilityResult[]>> myFutures = new ArrayList<Future<PlausibilityResult[]>>();
            if (pref == null) {
                xVals = null;
                PlausibilityFilter filter = wrapper.get(null);
                if (filter.isDirectional(false) || hasSplays && filter.isDirectional(true)) {
                    filter = new MultiDirectionalPlausibilityFilter(filter, connSearch, !filter.isDirectional(false));
                }
                myFutures.add(exec.submit(new CalcCallable(filter, rups)));
            } else {
                xVals = new ArbitrarilyDiscretizedFunc();
                for (Point2D pt : new EvenlyDiscretizedFunc((double)min.floatValue(), max.floatValue(), 20)) {
                    xVals.set(pt);
                }
                xVals.set(pref.floatValue(), 0.0);
                for (int x = 0; x < xVals.size(); ++x) {
                    double thresh = xVals.getX(x);
                    PlausibilityFilter filter = wrapper.get(Float.valueOf((float)thresh));
                    if (filter.isDirectional(false) || hasSplays && filter.isDirectional(true)) {
                        filter = new MultiDirectionalPlausibilityFilter(filter, connSearch, !filter.isDirectional(false));
                    }
                    myFutures.add(exec.submit(new CalcCallable(filter, rups)));
                }
            }
            xValsList.add(xVals);
            futures.add(myFutures);
        }
        System.out.println("Waiting on param sweep futgures");
        for (List subFutures : futures) {
            for (Future future : subFutures) {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                    System.err.flush();
                    System.exit(1);
                }
            }
        }
        System.out.println("Done with sweep futures");
        ArrayList<PlausibilityFilterPlot.RupSetPlausibilityResult> combResults = new ArrayList<PlausibilityFilterPlot.RupSetPlausibilityResult>();
        ArrayList<Object> combNames = new ArrayList<Object>();
        Boolean[] maxs = new Boolean[]{null, false, true};
        ArrayList<PlausibilityFilter> combinedPrefFilters = null;
        for (int i = 0; i < wrappers.size(); ++i) {
            for (Boolean isMax : maxs) {
                if (isMax == null && i > 0) continue;
                Float value = isMax == null ? (Float)prefVals.get(i) : (isMax != false ? (Float)maxVals.get(i) : (Float)minVals.get(i));
                ArrayList<PlausibilityFilter> filters = new ArrayList<PlausibilityFilter>();
                for (int k = 0; k < wrappers.size(); ++k) {
                    if (k == i) {
                        filters.add(((ParameterizedFilterWrapper)wrappers.get(k)).get(value));
                        continue;
                    }
                    filters.add(((ParameterizedFilterWrapper)wrappers.get(k)).get((Float)prefVals.get(k)));
                }
                ArrayList<PlausibilityFilter> finalFilters = new ArrayList<PlausibilityFilter>();
                ArrayList<NucleationClusterEvaluator> pathEvals = new ArrayList<NucleationClusterEvaluator>();
                for (PlausibilityFilter filter : filters) {
                    if (filter instanceof PathPlausibilityFilter) {
                        for (NucleationClusterEvaluator eval : ((PathPlausibilityFilter)filter).getEvaluators()) {
                            pathEvals.add(eval);
                        }
                        continue;
                    }
                    finalFilters.add(filter);
                }
                if (!pathEvals.isEmpty()) {
                    finalFilters.add(new PathPlausibilityFilter(pathEvals.toArray(new NucleationClusterEvaluator[0])));
                }
                System.out.println("Testing " + (String)names.get(i) + ", isMax=" + isMax);
                combResults.add(PlausibilityFilterPlot.testRupSetPlausibility(rups, finalFilters, rupSet.getModule(PlausibilityConfiguration.class), connSearch, exec));
                if (isMax == null) {
                    combNames.add("Proposed Model");
                    combinedPrefFilters = new ArrayList<PlausibilityFilter>(filters);
                    if (pathEvals.isEmpty()) continue;
                    combinedPrefFilters.add(new PathPlausibilityFilter(pathEvals.toArray(new NucleationClusterEvaluator[0])));
                    continue;
                }
                if (isMax.booleanValue()) {
                    combNames.add((String)names.get(i) + " Max");
                    continue;
                }
                combNames.add((String)names.get(i) + " Min");
            }
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("# " + inputName + " Plausibility Comparisons");
        lines.add("");
        int tocIndex = lines.size();
        String topLink = "*[(top)](#table-of-contents)*";
        DecimalFormat pDF = new DecimalFormat("0.00%");
        for (int i = 0; i < wrappers.size(); ++i) {
            Range xRange;
            String name = (String)names.get(i);
            lines.add("## " + name);
            lines.add(topLink);
            lines.add("");
            DiscretizedFunc xVals = (DiscretizedFunc)xValsList.get(i);
            ArrayList<ArbitrarilyDiscretizedFunc> funcs = new ArrayList<ArbitrarilyDiscretizedFunc>();
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
            for (int m = 0; m < minMags.length; ++m) {
                double minMag = minMags[m];
                ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
                if (minMag > 0.0) {
                    func.setName("M\u2265" + (float)minMag);
                } else {
                    func.setName("Supra-Seismogenic");
                }
                funcs.add(func);
                Color color = magIndexCPT.getColor(m);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, color));
            }
            List myFutures = (List)futures.get(i);
            if (xVals == null) {
                PlausibilityResult[] results;
                xRange = new Range(0.0, 1.0);
                try {
                    results = (PlausibilityResult[])((Future)myFutures.get(0)).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    exec.shutdown();
                    throw ExceptionUtils.asRuntimeException(e);
                }
                int passes = 0;
                for (PlausibilityResult result : results) {
                    if (!result.isPass()) continue;
                    ++passes;
                }
                System.out.println("Testing " + name);
                System.out.println(passes + "/" + rups.size() + " = " + pDF.format((double)passes / (double)rups.size()) + " passed");
                for (int m = 0; m < minMags.length; ++m) {
                    double minMag = minMags[m];
                    int magPasses = 0;
                    int magRups = 0;
                    for (int r = 0; r < rups.size(); ++r) {
                        if (!(rupSet.getMagForRup(r) >= minMag)) continue;
                        ++magRups;
                        if (!results[r].isPass()) continue;
                        ++magPasses;
                    }
                    double val = 100.0 * (double)(magRups - magPasses) / (double)magRups;
                    ((DiscretizedFunc)funcs.get(m)).set(0.0, val);
                    ((DiscretizedFunc)funcs.get(m)).set(1.0, val);
                }
            } else {
                Float min = (Float)minVals.get(i);
                Float max = (Float)maxVals.get(i);
                for (int x = 0; x < xVals.size(); ++x) {
                    PlausibilityResult[] results;
                    try {
                        results = (PlausibilityResult[])((Future)myFutures.get(x)).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        exec.shutdown();
                        throw ExceptionUtils.asRuntimeException(e);
                    }
                    double thresh = xVals.getX(x);
                    int passes = 0;
                    for (PlausibilityResult result : results) {
                        if (!result.isPass()) continue;
                        ++passes;
                    }
                    System.out.println("Testing " + name + ": " + thresh);
                    System.out.println(passes + "/" + rups.size() + " = " + pDF.format((double)passes / (double)rups.size()) + " passed");
                    for (int m = 0; m < minMags.length; ++m) {
                        double minMag = minMags[m];
                        int magPasses = 0;
                        int magRups = 0;
                        for (int r = 0; r < rups.size(); ++r) {
                            if (!(rupSet.getMagForRup(r) >= minMag)) continue;
                            ++magRups;
                            if (!results[r].isPass()) continue;
                            ++magPasses;
                        }
                        ((DiscretizedFunc)funcs.get(m)).set(thresh, 100.0 * (double)(magRups - magPasses) / (double)magRups);
                    }
                }
                xRange = new Range((double)min.floatValue(), (double)max.floatValue());
            }
            PlotSpec spec = new PlotSpec(funcs, chars, name, "Threshold", "% Failed");
            spec.setLegendVisible(true);
            HeadlessGraphPanel gp = new HeadlessGraphPanel();
            gp.setBackgroundColor(Color.WHITE);
            gp.setTickLabelFontSize(18);
            gp.setAxisLabelFontSize(20);
            gp.setPlotLabelFontSize(21);
            gp.setLegendFontSize(22);
            double maxY = 20.0;
            if (((DiscretizedFunc)funcs.get(0)).getMaxY() > maxY) {
                maxY = 50.0;
            }
            if (((DiscretizedFunc)funcs.get(0)).getMaxY() > maxY) {
                maxY = 100.0;
            }
            gp.drawGraphPanel(spec, false, false, xRange, new Range(0.0, maxY));
            gp.getChartPanel().setSize(1000, 800);
            String prefix = FileNameUtils.simplify(name);
            File pngFile = new File(resourcesDir, prefix + ".png");
            File pdfFile = new File(resourcesDir, prefix + ".pdf");
            gp.saveAsPNG(pngFile.getAbsolutePath());
            gp.saveAsPDF(pdfFile.getAbsolutePath());
            lines.add("![plot](resources/" + pngFile.getName() + ")");
            lines.add("");
            MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
            table.initNewLine();
            table.addColumn("Description");
            table.addColumn("Threshold");
            for (DiscretizedFunc func : funcs) {
                table.addColumn(func.getName() + " Failure %");
            }
            table.finalizeLine();
            table.initNewLine();
            table.addColumn("**Minimum**");
            table.addColumn(minVals.get(i));
            for (DiscretizedFunc func : funcs) {
                table.addColumn(Float.valueOf((float)func.getY(0)));
            }
            table.finalizeLine();
            table.initNewLine();
            table.addColumn("**Preferred**");
            table.addColumn(prefVals.get(i));
            for (DiscretizedFunc func : funcs) {
                table.addColumn(Float.valueOf((float)func.getInterpolatedY(((Float)prefVals.get(i)).floatValue())));
            }
            table.finalizeLine();
            table.initNewLine();
            table.addColumn("**Maximum**");
            table.addColumn(maxVals.get(i));
            for (DiscretizedFunc func : funcs) {
                table.addColumn(Float.valueOf((float)func.getY(func.size() - 1)));
            }
            table.finalizeLine();
            lines.addAll(table.build());
            lines.add("");
        }
        PlausibilityFilterPlot.RupSetPlausibilityResult altResult = null;
        if (altFilters != null) {
            System.out.println("Calculating alt plausibility...");
            altResult = PlausibilityFilterPlot.testRupSetPlausibility(rups, altFilters, rupSet.getModule(PlausibilityConfiguration.class), connSearch, exec);
            System.out.println("done");
        }
        Color altColor = new Color(160, 160, 160);
        EvenlyDiscretizedFunc prefMagFunc = null;
        lines.add("## Combined Plausibility");
        lines.add(topLink);
        lines.add("");
        for (int r = 0; r < combResults.size(); ++r) {
            int numToRemove;
            PlausibilityFilterPlot.RupSetPlausibilityResult result = (PlausibilityFilterPlot.RupSetPlausibilityResult)combResults.get(r);
            lines.add("### Combined Plausibility: " + (String)combNames.get(r));
            lines.add(topLink);
            lines.add("");
            lines.add("*Filters:*");
            lines.add("");
            for (PlausibilityFilter filter : result.filters) {
                lines.add("* " + filter.getName());
            }
            lines.add("");
            String prefix = "plausibility_" + r;
            File plot = PlausibilityFilterPlot.plotRupSetPlausibility(result, resourcesDir, prefix, "Plausibility");
            lines.add("![plot](resources/" + plot.getName() + ")");
            lines.add("");
            Object table = MarkdownUtils.tableBuilder();
            for (double minMag : minMags) {
                PlausibilityFilterPlot.RupSetPlausibilityResult magResult = result.filterByMag(rupSet, minMag);
                if (magResult == null) continue;
                String magPrefix = prefix + "_m" + (float)minMag;
                String title = "M\u2265" + (float)minMag + " Comparison";
                File file = PlausibilityFilterPlot.plotRupSetPlausibility(magResult, resourcesDir, magPrefix, title);
                ((MarkdownUtils.TableBuilder)table).addColumn("![M>=" + (float)minMag + "](" + resourcesDir.getName() + "/" + file.getName() + ")");
            }
            lines.addAll(((MarkdownUtils.TableBuilder)table).wrap(2, 0).build());
            lines.add("");
            if (r == 0 && altResult != null) {
                lines.add("#### " + altName + " Comparisons");
                lines.add(topLink);
                lines.add("");
                String altPrefix = "alt_plausibility";
                plot = PlausibilityFilterPlot.plotRupSetPlausibility(altResult, resourcesDir, altPrefix, altName + " Plausibility");
                lines.add("![plot](resources/" + plot.getName() + ")");
                lines.add("");
                table = MarkdownUtils.tableBuilder();
                for (double minMag : minMags) {
                    PlausibilityFilterPlot.RupSetPlausibilityResult magResult = altResult.filterByMag(rupSet, minMag);
                    if (magResult == null) continue;
                    String magPrefix = altPrefix + "_m" + (float)minMag;
                    String title = "M\u2265" + (float)minMag + " Comparison";
                    File file = PlausibilityFilterPlot.plotRupSetPlausibility(magResult, resourcesDir, magPrefix, title);
                    ((MarkdownUtils.TableBuilder)table).addColumn("![M>=" + (float)minMag + "](" + resourcesDir.getName() + "/" + file.getName() + ")");
                }
                lines.addAll(((MarkdownUtils.TableBuilder)table).wrap(2, 0).build());
                lines.add("");
            }
            double minMag = minRupMag < 6.0 ? 6.0 : minMags[0];
            EvenlyDiscretizedFunc magFunc = new EvenlyDiscretizedFunc(minMag, minMags[minMags.length - 1], 100);
            magFunc.setName((String)combNames.get(r));
            for (int m = 0; m < magFunc.size(); ++m) {
                double mag = magFunc.getX(m);
                int fails = 0;
                int magRups = 0;
                block37: for (int i = 0; i < rups.size(); ++i) {
                    if (!(rupSet.getMagForRup(i) >= mag)) continue;
                    ++magRups;
                    for (int f = 0; f < result.filterResults.size(); ++f) {
                        PlausibilityResult rupResult = result.filterResults.get(f).get(i);
                        if (rupResult == null || rupResult.isPass()) continue;
                        ++fails;
                        continue block37;
                    }
                }
                magFunc.set(m, 100.0 * (double)fails / (double)magRups);
            }
            EvenlyDiscretizedFunc altMagFunc = null;
            if (altResult != null) {
                altMagFunc = new EvenlyDiscretizedFunc(magFunc.getMinX(), magFunc.getMaxX(), magFunc.size());
                altMagFunc.setName(altName);
                for (int m = 0; m < altMagFunc.size(); ++m) {
                    double mag = altMagFunc.getX(m);
                    int fails = 0;
                    int magRups = 0;
                    block40: for (int i = 0; i < rups.size(); ++i) {
                        if (!(rupSet.getMagForRup(i) >= mag)) continue;
                        ++magRups;
                        for (int f = 0; f < result.filterResults.size(); ++f) {
                            PlausibilityResult rupResult = altResult.filterResults.get(f).get(i);
                            if (rupResult == null || rupResult.isPass()) continue;
                            ++fails;
                            continue block40;
                        }
                    }
                    altMagFunc.set(m, 100.0 * (double)fails / (double)magRups);
                }
            }
            ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
            funcs.add(magFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.BLACK));
            if (prefMagFunc == null) {
                prefMagFunc = magFunc;
            } else {
                funcs.add(prefMagFunc);
                chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLACK));
            }
            if (altMagFunc != null) {
                funcs.add(altMagFunc);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, altColor));
            }
            PlotSpec spec = new PlotSpec(funcs, (List<PlotCurveCharacterstics>)chars, " ", "Minimum Magnitude", "% Failed");
            spec.setLegendVisible(true);
            HeadlessGraphPanel gp = PlotUtils.initHeadless();
            gp.setRenderingOrder(DatasetRenderingOrder.REVERSE);
            double maxY = 20.0;
            if (((DiscretizedFunc)funcs.get(0)).getMaxY() > maxY) {
                maxY = 50.0;
            }
            if (((DiscretizedFunc)funcs.get(0)).getMaxY() > maxY) {
                maxY = 100.0;
            }
            gp.setTickLabelFontSize(24);
            gp.setAxisLabelFontSize(28);
            gp.setPlotLabelFontSize(24);
            gp.setLegendFontSize(24);
            gp.drawGraphPanel(spec, false, false, new Range(magFunc.getMinX(), magFunc.getMaxX()), new Range(0.0, maxY));
            gp.getChartPanel().setSize(1000, 800);
            prefix = prefix + "_vs_mag";
            File pngFile = new File(resourcesDir, prefix + ".png");
            File pdfFile = new File(resourcesDir, prefix + ".pdf");
            gp.saveAsPNG(pngFile.getAbsolutePath());
            gp.saveAsPDF(pdfFile.getAbsolutePath());
            lines.add("![plot](resources/" + pngFile.getName() + ")");
            lines.add("");
            gp.drawGraphPanel(spec, false, false, new Range(magFunc.getMinX(), magFunc.getMaxX()), new Range(0.0, 40.0));
            gp.getChartPanel().setSize(1000, 450);
            pngFile = new File(resourcesDir, prefix + "_narrow.png");
            pdfFile = new File(resourcesDir, prefix + "_narrow.pdf");
            gp.saveAsPNG(pngFile.getAbsolutePath());
            gp.saveAsPDF(pdfFile.getAbsolutePath());
            if (r != 0) continue;
            int maxNumRemovals = 2;
            PlotLineType[] removeLineTypes = new PlotLineType[]{PlotLineType.DASHED, PlotLineType.DOTTED, PlotLineType.DOTTED_AND_DASHED};
            Preconditions.checkState((maxNumRemovals <= removeLineTypes.length ? 1 : 0) != 0);
            HashMap<Integer, Future<SubsetCallable>> failsRemovedMap = new HashMap<Integer, Future<SubsetCallable>>();
            for (int i = 0; i < rups.size(); ++i) {
                Object rupResult;
                int f;
                boolean include = false;
                for (f = 0; f < result.filterResults.size(); ++f) {
                    rupResult = result.filterResults.get(f).get(i);
                    if (rupResult == null || rupResult.isPass()) continue;
                    include = true;
                    break;
                }
                if (!include && altResult != null) {
                    for (f = 0; f < result.filterResults.size(); ++f) {
                        rupResult = altResult.filterResults.get(f).get(i);
                        if (rupResult == null || rupResult.isPass()) continue;
                        include = true;
                        break;
                    }
                }
                if (!include) continue;
                failsRemovedMap.put(i, exec.submit(new SubsetCallable(rups.get(i), maxNumRemovals, connSearch, result.filters, altResult == null ? null : altResult.filters)));
            }
            System.out.println("Waiting on " + failsRemovedMap.size() + " subset removal futures...");
            funcs = new ArrayList();
            chars = new ArrayList<PlotCurveCharacterstics>();
            funcs.add(magFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.BLACK));
            for (numToRemove = 1; numToRemove <= maxNumRemovals; ++numToRemove) {
                EvenlyDiscretizedFunc subFunc = RupSetFilterComparePageGen.getSubsetFailsFunc(rups, rupSet, result, numToRemove, failsRemovedMap, magFunc, true);
                String label = "Removing 0-" + numToRemove + " Subsections";
                subFunc.setName(label);
                funcs.add(subFunc);
                chars.add(new PlotCurveCharacterstics(removeLineTypes[numToRemove - 1], 2.0f, Color.BLACK));
            }
            if (altMagFunc != null) {
                funcs.add(altMagFunc);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, altColor));
                for (numToRemove = 1; numToRemove <= maxNumRemovals; ++numToRemove) {
                    EvenlyDiscretizedFunc subFunc = RupSetFilterComparePageGen.getSubsetFailsFunc(rups, rupSet, altResult, numToRemove, failsRemovedMap, magFunc, false);
                    String label = "Removing 0-" + numToRemove + " Subsections";
                    subFunc.setName(label);
                    funcs.add(subFunc);
                    chars.add(new PlotCurveCharacterstics(removeLineTypes[numToRemove - 1], 2.0f, altColor));
                }
            }
            spec = new PlotSpec(funcs, chars, " ", "Minimum Magnitude", "% Failed");
            spec.setLegendVisible(false);
            spec.setLegendInset(RectangleAnchor.TOP_LEFT, 0.05, 0.95, 0.3, true);
            gp.drawGraphPanel(spec, false, false, new Range(magFunc.getMinX(), magFunc.getMaxX()), new Range(0.0, maxY));
            gp.getChartPanel().setSize(1000, 800);
            prefix = prefix + "_sects_removed";
            pngFile = new File(resourcesDir, prefix + ".png");
            pdfFile = new File(resourcesDir, prefix + ".pdf");
            gp.saveAsPNG(pngFile.getAbsolutePath());
            gp.saveAsPDF(pdfFile.getAbsolutePath());
            lines.add("#### Section Removal Calculations");
            lines.add(topLink);
            lines.add("");
            lines.add("");
            lines.add("**This plot removes subsections from ends of failing ruptures and tries them again to see if they now pass**");
            lines.add("");
            lines.add("![plot](resources/" + pngFile.getName() + ")");
            lines.add("");
            table = MarkdownUtils.tableBuilder();
            ((MarkdownUtils.TableBuilder)table).initNewLine();
            ((MarkdownUtils.TableBuilder)table).addColumn("Min Mag");
            for (DiscretizedFunc func : funcs) {
                ((MarkdownUtils.TableBuilder)table).addColumn(func.getName());
            }
            ((MarkdownUtils.TableBuilder)table).finalizeLine();
            DecimalFormat df = new DecimalFormat("0.00");
            for (double mag = minMag; mag <= magFunc.getMaxX(); mag += 0.1) {
                ((MarkdownUtils.TableBuilder)table).initNewLine();
                ((MarkdownUtils.TableBuilder)table).addColumn("**" + (float)mag + "**");
                for (DiscretizedFunc func : funcs) {
                    ((MarkdownUtils.TableBuilder)table).addColumn(df.format(func.getInterpolatedY(mag)) + " %");
                }
                ((MarkdownUtils.TableBuilder)table).finalizeLine();
            }
            lines.add("**Table of Failure Percentages**");
            lines.add("");
            lines.addAll(((MarkdownUtils.TableBuilder)table).build());
            lines.add("");
        }
        if (rupDebugMinMag > 0.0 && rupDebugMinMag < 10.0) {
            lines.add("## Plausibility debug for M" + (float)rupDebugMinMag + " failing ruptures");
            lines.add(topLink);
            lines.add("");
            for (int f = 0; f < combinedPrefFilters.size(); ++f) {
                PlausibilityFilter filter = (PlausibilityFilter)combinedPrefFilters.get(f);
                if (!filter.isDirectional(false) && !filter.isDirectional(true)) continue;
                combinedPrefFilters.set(f, new MultiDirectionalPlausibilityFilter(filter, connSearch, !filter.isDirectional(false)));
            }
            PlausibilityFilterPlot.RupSetPlausibilityResult result = (PlausibilityFilterPlot.RupSetPlausibilityResult)combResults.get(0);
            int numDebugRups = 0;
            for (int r = 0; r < rups.size(); ++r) {
                double mag = rupSet.getMagForRup(r);
                if (mag < rupDebugMinMag) continue;
                PlausibilityResult rupResult = PlausibilityResult.PASS;
                for (int f = 0; f < result.filterResults.size(); ++f) {
                    PlausibilityResult fResult = result.filterResults.get(f).get(r);
                    rupResult = rupResult.logicalAnd(fResult);
                }
                if (rupResult.isPass()) continue;
                lines.add("## Plausibility debug for " + r + ", an M" + (float)mag);
                lines.add(topLink);
                lines.add("");
                ClusterRupture rup = rups.get(r);
                lines.add("Text representation:");
                lines.add("");
                lines.add("```");
                lines.add(rup.toString());
                lines.add("```");
                System.out.println("Debugging rupture " + r + " w/ M=" + mag);
                int numSects = rup.getTotalNumSects();
                System.out.println("Rupture: " + String.valueOf(rup));
                ClusterRupture passingSubset = new PassingSubRuptureSearch(rup, combinedPrefFilters).getLargestPassingSubset();
                HashSet<FaultSection> highlightSects = new HashSet<FaultSection>();
                lines.add("");
                if (passingSubset == null) {
                    lines.add("We were't able to find any subset ruptures that passed.");
                } else {
                    for (FaultSubsectionCluster cluster : passingSubset.getClustersIterable()) {
                        highlightSects.addAll((Collection<FaultSection>)cluster.subSects);
                    }
                    lines.add("We found a passing rupture subset by removing " + (rup.getTotalNumSects() - passingSubset.getTotalNumSects()) + " sections. That subset rupture is listed below and highlighted in green in the rupture picture.");
                    lines.add("");
                    lines.add("```");
                    lines.add(passingSubset.toString());
                    lines.add("```");
                }
                lines.add("");
                PlotSpec rupPlot = RupCartoonGenerator.buildRupturePlot(rup, "Rupture " + r, false, true, highlightSects, Color.GREEN.darker(), "Passing subset");
                String prefix = "rup_" + r;
                RupCartoonGenerator.plotRupture(resourcesDir, prefix, rupPlot, true);
                lines.add("![plot](resources/" + prefix + ".png)");
                lines.add("");
                MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
                table.addLine("Filter", "Pref. Threshold", "Result w/ Pref.", "Max Passing Threshold");
                ArrayList<NucleationClusterEvaluator> pathEvals = new ArrayList<NucleationClusterEvaluator>();
                for (int i = 0; i < wrappers.size(); ++i) {
                    Float pref = (Float)prefVals.get(i);
                    Float min = (Float)minVals.get(i);
                    Float max = (Float)maxVals.get(i);
                    ParameterizedFilterWrapper wrapper = (ParameterizedFilterWrapper)wrappers.get(i);
                    boolean passesPref = RupSetFilterComparePageGen.testWrapper(wrapper, connSearch, pref, rup);
                    PlausibilityFilter prefFilter = wrapper.get(pref);
                    if (prefFilter instanceof PathPlausibilityFilter) {
                        for (NucleationClusterEvaluator eval : ((PathPlausibilityFilter)prefFilter).getEvaluators()) {
                            pathEvals.add(eval);
                        }
                    }
                    if (pref == null) {
                        table.addLine((String)names.get(i), "*N/A*", passesPref ? "PASS" : "FAIL", "*N/A*");
                        continue;
                    }
                    EvenlyDiscretizedFunc discr = new EvenlyDiscretizedFunc((double)min.floatValue(), max.floatValue(), 100);
                    Float minPass = null;
                    int j = discr.size();
                    while (--j >= 0) {
                        float threshold = (float)discr.getX(j);
                        if (!RupSetFilterComparePageGen.testWrapper(wrapper, connSearch, Float.valueOf(threshold), rup)) continue;
                        minPass = Float.valueOf(threshold);
                        break;
                    }
                    table.addLine(names.get(i), pref, passesPref ? "PASS" : "FAIL", minPass == null ? "*N/A*" : minPass);
                }
                if (pathEvals.size() > 1) {
                    PathPlausibilityFilter combFilter = new PathPlausibilityFilter(pathEvals.toArray(new NucleationClusterEvaluator[0]));
                    boolean passes = combFilter.apply(rup, false).isPass();
                    table.addLine(pathEvals.size() + " Paths Combined", "*N/A*", passes ? "PASS" : "FAIL", "*N/A*");
                }
                lines.addAll(table.build());
                lines.add("");
                if (++numDebugRups == maxRupDebugs) break;
            }
        }
        if (skipFaultNames != null && skipFaultNames.length > 0) {
            HashMap<Integer, String> skipParents = new HashMap<Integer, String>();
            for (FaultSection sect : rupSet.getFaultSectionDataList()) {
                String parentName = sect.getParentSectionName();
                for (Object name : skipFaultNames) {
                    if (!parentName.contains((CharSequence)name)) continue;
                    skipParents.put(sect.getParentSectionId(), sect.getParentSectionName());
                }
            }
            Preconditions.checkState((!skipParents.isEmpty() ? 1 : 0) != 0);
            HashSet<Integer> retainedRups = new HashSet<Integer>();
            for (int r = 0; r < rups.size(); ++r) {
                boolean exclude = false;
                for (FaultSubsectionCluster cluster : rups.get(r).getClustersIterable()) {
                    if (!skipParents.containsKey(cluster.parentSectionID)) continue;
                    exclude = true;
                    break;
                }
                if (exclude) continue;
                retainedRups.add(r);
            }
            String combSkipNames = Joiner.on((String)", ").join(skipFaultNames);
            lines.add("## Plausibility without " + combSkipNames);
            PlausibilityFilterPlot.RupSetPlausibilityResult result = (PlausibilityFilterPlot.RupSetPlausibilityResult)combResults.get(0);
            lines.add(topLink);
            lines.add("");
            lines.add("This gives plausibility results with preferred filter values and " + (rups.size() - retainedRups.size()) + " ruptures involving the following faults exluded:");
            lines.add("");
            ArrayList parentNames = new ArrayList(skipParents.values());
            Collections.sort(parentNames);
            for (String name : parentNames) {
                lines.add("* " + name);
            }
            lines.add("");
            lines.add("*Filters:*");
            lines.add("");
            for (PlausibilityFilter filter : result.filters) {
                lines.add("* " + filter.getName());
            }
            lines.add("");
            Object prefix = "plausibility_sans_faults";
            File plot = PlausibilityFilterPlot.plotRupSetPlausibility(result.filterByRups(retainedRups), resourcesDir, (String)prefix, "Plausibility");
            lines.add("![plot](resources/" + plot.getName() + ")");
            lines.add("");
            double minMag = minRupMag < 6.0 ? 6.0 : minMags[0];
            EvenlyDiscretizedFunc magFunc = new EvenlyDiscretizedFunc(minMag, minMags[minMags.length - 1], 100);
            magFunc.setName("Excluding " + combSkipNames);
            for (int m = 0; m < magFunc.size(); ++m) {
                double mag = magFunc.getX(m);
                int fails = 0;
                int magRups = 0;
                block64: for (int i = 0; i < rups.size(); ++i) {
                    if (!retainedRups.contains(i) || !(rupSet.getMagForRup(i) >= mag)) continue;
                    ++magRups;
                    for (int f = 0; f < result.filterResults.size(); ++f) {
                        PlausibilityResult rupResult = result.filterResults.get(f).get(i);
                        if (rupResult == null || rupResult.isPass()) continue;
                        ++fails;
                        continue block64;
                    }
                }
                magFunc.set(m, 100.0 * (double)fails / (double)magRups);
            }
            EvenlyDiscretizedFunc altMagFunc = null;
            if (altResult != null) {
                altMagFunc = new EvenlyDiscretizedFunc(magFunc.getMinX(), magFunc.getMaxX(), magFunc.size());
                altMagFunc.setName(altName + " excluding " + combSkipNames);
                for (int m = 0; m < altMagFunc.size(); ++m) {
                    double mag = altMagFunc.getX(m);
                    int fails = 0;
                    int magRups = 0;
                    block67: for (int i = 0; i < rups.size(); ++i) {
                        if (!retainedRups.contains(i) || !(rupSet.getMagForRup(i) >= mag)) continue;
                        ++magRups;
                        for (int f = 0; f < result.filterResults.size(); ++f) {
                            PlausibilityResult rupResult = altResult.filterResults.get(f).get(i);
                            if (rupResult == null || rupResult.isPass()) continue;
                            ++fails;
                            continue block67;
                        }
                    }
                    altMagFunc.set(m, 100.0 * (double)fails / (double)magRups);
                }
            }
            ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
            if (altMagFunc != null) {
                funcs.add(altMagFunc);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLUE));
            }
            if (prefMagFunc != null) {
                prefMagFunc.setName("All Faults");
                funcs.add(prefMagFunc);
                chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 3.0f, altColor));
            }
            funcs.add(magFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK));
            PlotSpec spec = new PlotSpec(funcs, chars, "Combined Fails vs Mag", "Minimum Magnitude", "% Failed");
            spec.setLegendVisible(true);
            HeadlessGraphPanel gp = new HeadlessGraphPanel();
            gp.setBackgroundColor(Color.WHITE);
            gp.setTickLabelFontSize(18);
            gp.setAxisLabelFontSize(20);
            gp.setPlotLabelFontSize(21);
            gp.setLegendFontSize(22);
            double maxY = 20.0;
            if (((DiscretizedFunc)funcs.get(0)).getMaxY() > maxY) {
                maxY = 50.0;
            }
            if (((DiscretizedFunc)funcs.get(0)).getMaxY() > maxY) {
                maxY = 100.0;
            }
            gp.drawGraphPanel(spec, false, false, new Range(magFunc.getMinX(), magFunc.getMaxX()), new Range(0.0, maxY));
            gp.getChartPanel().setSize(1000, 800);
            prefix = (String)prefix + "_vs_mag";
            File pngFile = new File(resourcesDir, (String)prefix + ".png");
            File pdfFile = new File(resourcesDir, (String)prefix + ".pdf");
            gp.saveAsPNG(pngFile.getAbsolutePath());
            gp.saveAsPDF(pdfFile.getAbsolutePath());
            lines.add("![plot](resources/" + pngFile.getName() + ")");
            lines.add("");
        }
        lines.addAll(tocIndex, MarkdownUtils.buildTOC(lines, 2));
        lines.add(tocIndex, "## Table Of Contents");
        MarkdownUtils.writeReadmeAndHTML(lines, outputDir);
        exec.shutdown();
    }

    private static boolean testWrapper(ParameterizedFilterWrapper wrapper, RuptureConnectionSearch connSearch, Float threshold, ClusterRupture rup) {
        PlausibilityFilter filter = wrapper.get(threshold);
        if (filter.isDirectional(!rup.splays.isEmpty())) {
            filter = new MultiDirectionalPlausibilityFilter(filter, connSearch, !filter.isDirectional(false));
        }
        return filter.apply(rup, false).isPass();
    }

    private static List<FaultSection> locateEnds(ClusterRupture rup) {
        ArrayList<FaultSection> ends = new ArrayList<FaultSection>();
        ends.add(rup.clusters[0].startSect);
        for (ClusterRupture strand : rup.getStrandsIterable()) {
            ends.addAll((Collection<FaultSection>)strand.clusters[strand.clusters.length - 1].endSects);
        }
        return ends;
    }

    private static List<ClusterRupture> getWithNEndSectsRemoved(ClusterRupture primary, int numToRemove) {
        List<FaultSection> ends = RupSetFilterComparePageGen.locateEnds(primary);
        RuptureTreeNavigator nav = primary.getTreeNavigator();
        ArrayList<List<FaultSection>> maxStrands = new ArrayList<List<FaultSection>>();
        for (FaultSection end : ends) {
            Collection<FaultSection> descendants;
            ArrayList<FaultSection> maxRemovalStrand = new ArrayList<FaultSection>();
            if (end.equals(primary.clusters[0].startSect)) {
                FaultSection cur = end;
                while (maxRemovalStrand.size() < numToRemove && (descendants = nav.getDescendants(cur)).size() == 1) {
                    maxRemovalStrand.add(cur);
                    cur = descendants.iterator().next();
                }
            } else {
                FaultSection parent;
                maxRemovalStrand.add(end);
                while (maxRemovalStrand.size() < numToRemove && (parent = nav.getPredecessor(end)) != null && (descendants = nav.getDescendants(parent)).size() == 1) {
                    maxRemovalStrand.add(parent);
                }
            }
            maxStrands.add(maxRemovalStrand);
        }
        ArrayList<ClusterRupture> ret = new ArrayList<ClusterRupture>();
        RupSetFilterComparePageGen.findRemovalsRecursive(primary, ret, maxStrands, new ArrayList<List<FaultSection>>(), 0, 0, numToRemove);
        return ret;
    }

    private static void findRemovalsRecursive(ClusterRupture origRup, List<ClusterRupture> ret, List<List<FaultSection>> maxStrands, List<List<FaultSection>> myRemovals, int startIndex, int myCount, int targetCount) {
        if (myCount == targetCount) {
            ClusterRupture removed = RupSetFilterComparePageGen.removeEndSects(origRup, myRemovals);
            if (origRup.getTotalNumSects() - removed.getTotalNumSects() == targetCount) {
                ret.add(removed);
            }
            return;
        }
        for (int i = startIndex; i < maxStrands.size(); ++i) {
            int newCount;
            List<FaultSection> maxStrand = maxStrands.get(i);
            for (int j = 0; j < maxStrand.size() && (newCount = myCount + j + 1) <= targetCount; ++j) {
                ArrayList<List<FaultSection>> newRemovals = new ArrayList<List<FaultSection>>(myRemovals);
                newRemovals.add(maxStrand.subList(0, j + 1));
                RupSetFilterComparePageGen.findRemovalsRecursive(origRup, ret, maxStrands, newRemovals, i + 1, newCount, targetCount);
            }
        }
    }

    private static ClusterRupture removeEndSects(ClusterRupture rup, List<List<FaultSection>> removals) {
        for (List<FaultSection> removal : removals) {
            if (!(rup.clusters[0].startSect.equals(removal.get(0)) ? (rup = RupSetFilterComparePageGen.removeForward(rup, removal)) == null : (rup = RupSetFilterComparePageGen.removeBackward(rup, removal)) == null)) continue;
            return null;
        }
        return rup;
    }

    private static ClusterRupture removeForward(ClusterRupture rup, List<FaultSection> sects) {
        FaultSubsectionCluster origStart = rup.clusters[0];
        int c0 = 0;
        while (sects.size() >= origStart.subSects.size()) {
            sects = sects.subList(origStart.subSects.size(), sects.size());
            origStart = rup.clusters[++c0];
        }
        for (FaultSection sect : sects) {
            if (rup.contains(sect)) continue;
            return null;
        }
        FaultSubsectionCluster newStart = sects.isEmpty() ? origStart : new FaultSubsectionCluster((List<? extends FaultSection>)origStart.subSects.subList(sects.size(), origStart.subSects.size()));
        ClusterRupture ret = new ClusterRupture(newStart);
        for (int c = c0 + 1; c < rup.clusters.length; ++c) {
            Jump jump = rup.getTreeNavigator().getJump(rup.clusters[c - 1], rup.clusters[c]);
            if (jump.fromCluster == origStart && origStart != newStart) {
                jump = new Jump(jump.fromSection, newStart, jump.toSection, jump.toCluster, jump.distance);
            }
            ret = ret.take(jump);
        }
        for (Jump jump : rup.splays.keySet()) {
            ClusterRupture splay = (ClusterRupture)rup.splays.get((Object)jump);
            if (jump.fromCluster.equals(origStart)) {
                jump = new Jump(jump.fromSection, newStart, jump.toSection, jump.toCluster, jump.distance);
            }
            ret = RupSetFilterComparePageGen.buildOutSplay(ret, jump, splay, rup.getTreeNavigator());
        }
        return ret;
    }

    private static ClusterRupture buildOutSplay(ClusterRupture rup, Jump jump, ClusterRupture splay, RuptureTreeNavigator nav) {
        rup = rup.take(jump);
        for (int c = 1; c < splay.clusters.length; ++c) {
            rup = rup.take(nav.getJump(splay.clusters[c - 1], splay.clusters[c]));
        }
        for (Jump splayJump : splay.splays.keySet()) {
            rup = RupSetFilterComparePageGen.buildOutSplay(rup, splayJump, (ClusterRupture)splay.splays.get((Object)splayJump), nav);
        }
        return rup;
    }

    private static ClusterRupture removeBackward(ClusterRupture rup, List<FaultSection> sects) {
        FaultSubsectionCluster curCluster = rup.clusters[0];
        HashSet<FaultSection> sectsSet = new HashSet<FaultSection>(sects);
        for (FaultSection sect : sects) {
            FaultSection s;
            if (!curCluster.contains(sect)) continue;
            ArrayList<FaultSection> newSects = new ArrayList<FaultSection>();
            UnmodifiableIterator unmodifiableIterator = curCluster.subSects.iterator();
            while (unmodifiableIterator.hasNext() && !sectsSet.contains(s = (FaultSection)unmodifiableIterator.next())) {
                newSects.add(s);
            }
            if (newSects.isEmpty()) {
                return null;
            }
            return new ClusterRupture(new FaultSubsectionCluster(newSects));
        }
        RuptureTreeNavigator nav = rup.getTreeNavigator();
        return RupSetFilterComparePageGen.buildOutTo(new ClusterRupture(curCluster), curCluster, sectsSet, nav);
    }

    private static ClusterRupture buildOutTo(ClusterRupture rup, FaultSubsectionCluster curCluster, HashSet<FaultSection> sectsSet, RuptureTreeNavigator nav) {
        for (FaultSubsectionCluster child : nav.getDescendants(curCluster)) {
            int keepSects;
            if (sectsSet == null) {
                keepSects = child.subSects.size();
            } else {
                keepSects = 0;
                for (int i = 0; i < child.subSects.size() && !sectsSet.contains(child.subSects.get(i)); ++i) {
                    ++keepSects;
                }
                if (keepSects == 0) continue;
            }
            Jump jump = nav.getJump(curCluster, child);
            if (keepSects < child.subSects.size()) {
                FaultSubsectionCluster newChild = new FaultSubsectionCluster((List<? extends FaultSection>)child.subSects.subList(0, keepSects));
                rup = rup.take(new Jump(jump.fromSection, curCluster, jump.toSection, newChild, jump.distance));
                for (FaultSubsectionCluster splayCluster : nav.getDescendants(child)) {
                    if (sectsSet.contains(splayCluster.startSect)) continue;
                    Jump splayJump = nav.getJump(child, splayCluster);
                    rup = rup.take(new Jump(splayJump.fromSection, newChild, splayJump.toSection, splayJump.toCluster, splayJump.distance));
                    rup = RupSetFilterComparePageGen.buildOutTo(rup, splayCluster, null, nav);
                }
                continue;
            }
            rup = rup.take(jump);
            rup = RupSetFilterComparePageGen.buildOutTo(rup, child, sectsSet, nav);
        }
        return rup;
    }

    private static EvenlyDiscretizedFunc getSubsetFailsFunc(List<ClusterRupture> rups, FaultSystemRupSet rupSet, PlausibilityFilterPlot.RupSetPlausibilityResult results, int numToRemove, Map<Integer, Future<SubsetCallable>> failsRemovedMap, EvenlyDiscretizedFunc refMagFunc, boolean isPrimary) {
        EvenlyDiscretizedFunc ret = new EvenlyDiscretizedFunc(refMagFunc.getMinX(), refMagFunc.getMaxX(), refMagFunc.size());
        boolean[] failures = new boolean[rups.size()];
        int numDebugged = 0;
        for (int r = 0; r < failures.length; ++r) {
            boolean origFails = false;
            for (int t = 0; t < results.filterResults.size(); ++t) {
                origFails = origFails || !results.filterResults.get(t).get(r).isPass();
            }
            boolean newPasses = !origFails;
            ClusterRupture origRup = rups.get(r);
            if (origFails && origRup.getTotalNumClusters() > 1) {
                SubsetCallable subsets;
                Preconditions.checkState((boolean)failsRemovedMap.containsKey(r));
                failures[r] = origFails;
                try {
                    subsets = failsRemovedMap.get(r).get();
                }
                catch (Exception e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
                if (subsets != null && !subsets.alts.isEmpty()) {
                    boolean debug = false;
                    if (debug) {
                        System.out.println("Ddebugging " + r + " for " + String.valueOf(rups.get(r)) + "\tremoving " + numToRemove);
                    }
                    for (int i = 0; i < subsets.alts.size(); ++i) {
                        ClusterRupture alt = subsets.alts.get(i);
                        int myRemoved = origRup.getTotalNumSects() - alt.getTotalNumSects();
                        Preconditions.checkState((myRemoved > 0 ? 1 : 0) != 0);
                        if (myRemoved > numToRemove) continue;
                        boolean myPass = true;
                        if (debug) {
                            System.out.println("\tAlternative: " + String.valueOf(alt));
                        }
                        List<PlausibilityResult> filterResults = isPrimary ? subsets.primaryResults.get(i) : subsets.altResults.get(i);
                        for (int f = 0; f < results.filters.size(); ++f) {
                            PlausibilityResult result = filterResults.get(f);
                            boolean bl = myPass = myPass && result.isPass();
                            if (debug) {
                                System.out.println("\t\t" + results.filters.get(f).getName() + ": " + String.valueOf((Object)result));
                            }
                            if (!myPass && !debug) break;
                        }
                        if (debug) {
                            System.out.println("\t\tPasses: " + myPass);
                        }
                        if (!myPass) continue;
                        newPasses = true;
                        if (!debug) break;
                    }
                    if (debug) {
                        System.out.println("\t" + r + " NEW PASS: " + newPasses);
                    }
                    ++numDebugged;
                }
            }
            failures[r] = !newPasses;
        }
        for (int m = 0; m < ret.size(); ++m) {
            double minMag = ret.getX(m);
            int numFails = 0;
            int numRups = 0;
            for (int r = 0; r < failures.length; ++r) {
                if (!(rupSet.getMagForRup(r) >= minMag)) continue;
                ++numRups;
                if (!failures[r]) continue;
                ++numFails;
            }
            ret.set(m, 100.0 * (double)numFails / (double)numRups);
        }
        return ret;
    }

    private static interface ParameterizedFilterWrapper {
        public PlausibilityFilter get(Float var1);
    }

    private static class CalcCallable
    implements Callable<PlausibilityResult[]> {
        private final PlausibilityFilter filter;
        private final List<ClusterRupture> rups;

        public CalcCallable(PlausibilityFilter filter, List<ClusterRupture> rups) {
            this.filter = filter;
            this.rups = rups;
        }

        @Override
        public PlausibilityResult[] call() throws Exception {
            PlausibilityResult[] results = new PlausibilityResult[this.rups.size()];
            for (int r = 0; r < results.length; ++r) {
                results[r] = this.filter.apply(this.rups.get(r), false);
            }
            return results;
        }
    }

    private static class SubsetCallable
    implements Callable<SubsetCallable> {
        private ClusterRupture rup;
        private int maxNumToRemove;
        private RuptureConnectionSearch connSearch;
        private List<PlausibilityFilter> primaryFilters;
        private List<PlausibilityFilter> altFilters;
        List<ClusterRupture> alts;
        List<List<PlausibilityResult>> primaryResults;
        List<List<PlausibilityResult>> altResults;

        public SubsetCallable(ClusterRupture rup, int maxNumToRemove, RuptureConnectionSearch connSearch, List<PlausibilityFilter> primaryFilters, List<PlausibilityFilter> altFilters) {
            this.rup = rup;
            this.maxNumToRemove = maxNumToRemove;
            this.connSearch = connSearch;
            this.primaryFilters = primaryFilters;
            this.altFilters = altFilters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public SubsetCallable call() throws Exception {
            this.alts = new ArrayList<ClusterRupture>();
            ArrayList<FaultSubsectionCluster> allClusters = new ArrayList<FaultSubsectionCluster>();
            for (FaultSubsectionCluster cluster : this.rup.getClustersIterable()) {
                allClusters.add(cluster);
            }
            Iterator<Object> iterator = allClusters.iterator();
            block7: while (true) {
                int numToRemove;
                int mySize;
                FaultSubsectionCluster cluster;
                if (iterator.hasNext()) {
                    cluster = iterator.next();
                    mySize = cluster.subSects.size();
                    numToRemove = 1;
                } else {
                    if (this.primaryFilters != null) {
                        this.primaryResults = new ArrayList<List<PlausibilityResult>>();
                        for (ClusterRupture alt : this.alts) {
                            ArrayList<PlausibilityResult> myResults = new ArrayList<PlausibilityResult>();
                            this.primaryResults.add(myResults);
                            for (PlausibilityFilter filter : this.primaryFilters) {
                                myResults.add(filter.apply(alt, false));
                            }
                        }
                    }
                    if (this.altFilters == null) return this;
                    this.altResults = new ArrayList<List<PlausibilityResult>>();
                    iterator = this.alts.iterator();
                    block10: while (true) {
                        ClusterRupture alt;
                        if (!iterator.hasNext()) return this;
                        alt = (ClusterRupture)iterator.next();
                        ArrayList<PlausibilityResult> myResults = new ArrayList<PlausibilityResult>();
                        this.altResults.add(myResults);
                        Iterator<PlausibilityFilter> iterator2 = this.altFilters.iterator();
                        while (true) {
                            PlausibilityFilter filter;
                            if (!iterator2.hasNext()) continue block10;
                            filter = iterator2.next();
                            myResults.add(filter.apply(alt, false));
                        }
                        break;
                    }
                }
                while (true) {
                    if (numToRemove > this.maxNumToRemove) continue block7;
                    if (mySize >= numToRemove) {
                        ArrayList<FaultSubsectionCluster> myAlts = new ArrayList<FaultSubsectionCluster>();
                        if (mySize == numToRemove) {
                            myAlts.add(null);
                        } else {
                            myAlts.add(new FaultSubsectionCluster((List<? extends FaultSection>)cluster.subSects.subList(0, mySize - numToRemove)));
                            myAlts.add(new FaultSubsectionCluster((List<? extends FaultSection>)cluster.subSects.subList(numToRemove, mySize)));
                        }
                        for (FaultSubsectionCluster myAlt : myAlts) {
                            ArrayList<FaultSubsectionCluster> newClusters = new ArrayList<FaultSubsectionCluster>();
                            for (FaultSubsectionCluster testCluster : allClusters) {
                                if (testCluster == cluster) {
                                    if (myAlt == null) continue;
                                    Preconditions.checkState((myAlt.subSects.size() == mySize - numToRemove ? 1 : 0) != 0);
                                    newClusters.add(myAlt);
                                    continue;
                                }
                                newClusters.add(new FaultSubsectionCluster((List<? extends FaultSection>)testCluster.subSects));
                            }
                            if (newClusters.size() == 1) {
                                this.alts.add(new ClusterRupture((FaultSubsectionCluster)newClusters.get(0)));
                                continue;
                            }
                            SectionDistanceAzimuthCalculator distAzCalc = this.connSearch.getDistAzCalc();
                            new DistCutoffClosestSectClusterConnectionStrategy(distAzCalc.getSubSections(), newClusters, distAzCalc, 1000.0).getClusters();
                            List<Jump> jumps = this.connSearch.calcRuptureJumps(newClusters, false);
                            ClusterRupture altRup = null;
                            try {
                                altRup = this.connSearch.buildClusterRupture(newClusters, jumps, false);
                            }
                            catch (RuntimeException e) {
                                Class<RupSetFilterComparePageGen> clazz = RupSetFilterComparePageGen.class;
                                // MONITORENTER : org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupSetFilterComparePageGen.class
                                System.out.println("Error with subset of " + String.valueOf(this.rup));
                                System.out.println("Subset clusters:");
                                for (FaultSubsectionCluster c : newClusters) {
                                    System.out.println("\t" + String.valueOf(c));
                                }
                                jumps = this.connSearch.calcRuptureJumps(newClusters, true);
                                try {
                                    altRup = this.connSearch.buildClusterRupture(newClusters, jumps, true);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                e.printStackTrace();
                                System.err.flush();
                                System.exit(0);
                                // MONITOREXIT : clazz
                            }
                            Preconditions.checkState((altRup.getTotalNumSects() == this.rup.getTotalNumSects() - numToRemove ? 1 : 0) != 0);
                            this.alts.add(altRup);
                        }
                    }
                    ++numToRemove;
                }
                break;
            }
        }
    }
}

