/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.faultSurface.FaultSection;

public interface RuptureTreeNavigator {
    public FaultSubsectionCluster getPredecessor(FaultSubsectionCluster var1);

    public Collection<FaultSubsectionCluster> getDescendants(FaultSubsectionCluster var1);

    default public Collection<FaultSubsectionCluster> getNeighbors(FaultSubsectionCluster cluster) {
        FaultSubsectionCluster predecessor = this.getPredecessor(cluster);
        Collection<FaultSubsectionCluster> descendants = this.getDescendants(cluster);
        if (descendants.isEmpty()) {
            if (predecessor == null) {
                return List.of();
            }
            return List.of(predecessor);
        }
        if (predecessor == null) {
            return descendants;
        }
        ArrayList<FaultSubsectionCluster> ret = new ArrayList<FaultSubsectionCluster>(1 + descendants.size());
        ret.add(predecessor);
        ret.addAll(descendants);
        return ret;
    }

    public Jump getJump(FaultSubsectionCluster var1, FaultSubsectionCluster var2);

    public boolean hasJump(FaultSubsectionCluster var1, FaultSubsectionCluster var2);

    public FaultSubsectionCluster locateCluster(FaultSection var1);

    public Jump getJumpTo(FaultSubsectionCluster var1);

    public Jump getJump(FaultSection var1, FaultSection var2);

    public boolean hasJump(FaultSection var1, FaultSection var2);

    public FaultSection getPredecessor(FaultSection var1);

    public Collection<FaultSection> getDescendants(FaultSection var1);

    default public Collection<FaultSection> getNeighbors(FaultSection sect) {
        FaultSection predecessor = this.getPredecessor(sect);
        Collection<FaultSection> descendants = this.getDescendants(sect);
        if (descendants.isEmpty()) {
            if (predecessor == null) {
                return List.of();
            }
            return List.of(predecessor);
        }
        if (predecessor == null) {
            return descendants;
        }
        ArrayList<FaultSection> ret = new ArrayList<FaultSection>(1 + descendants.size());
        ret.add(predecessor);
        ret.addAll(descendants);
        return ret;
    }
}

