/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.util;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class SectIDRange
implements Comparable<SectIDRange> {
    private static final Map<SectIDRange, SectIDRange> cache = new ConcurrentHashMap<SectIDRange, SectIDRange>();

    public static SectIDRange build(int startID, int endID) {
        SectIDRange range = SectIDRange.construct(startID, endID);
        SectIDRange cached = cache.get(range);
        if (cached == null) {
            cached = cache.putIfAbsent(range, range);
        }
        return cached == null ? range : cached;
    }

    private static SectIDRange construct(int startID, int endID) {
        if (endID < Short.MAX_VALUE) {
            if (startID == endID) {
                return new ShortSingleID(endID);
            }
            return new ShortIDRange(startID, endID);
        }
        if (startID == endID) {
            return new SingleID(endID);
        }
        return new IntIDRange(startID, endID);
    }

    private SectIDRange(int startID, int endID) {
        Preconditions.checkArgument((startID >= 0 ? 1 : 0) != 0, (String)"startID=%s must be >= 0", (int)startID);
        Preconditions.checkArgument((endID >= startID ? 1 : 0) != 0, (String)"startID=%s must be >= endID=%s", (int)startID, (int)endID);
    }

    abstract int getStartID();

    abstract int getEndID();

    public int size() {
        return 1 + this.getEndID() - this.getStartID();
    }

    public boolean contains(int id) {
        return id >= this.getStartID() && id <= this.getEndID();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getEndID();
        result = 31 * result + this.getStartID();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SectIDRange other = (SectIDRange)obj;
        if (this.getEndID() != other.getEndID()) {
            return false;
        }
        return this.getStartID() == other.getStartID();
    }

    @Override
    public int compareTo(SectIDRange o) {
        int cmp = Integer.compare(this.getStartID(), o.getStartID());
        if (cmp != 0) {
            return cmp;
        }
        return Integer.compare(this.getEndID(), o.getEndID());
    }

    public String toString() {
        return "[" + this.getStartID() + "," + this.getEndID() + "]";
    }

    private static class ShortSingleID
    extends SectIDRange {
        private final short id;

        private ShortSingleID(int id) {
            super(id, id);
            this.id = (short)id;
        }

        @Override
        int getStartID() {
            return this.id;
        }

        @Override
        int getEndID() {
            return this.id;
        }
    }

    private static class ShortIDRange
    extends SectIDRange {
        private final short startID;
        private final short endID;

        private ShortIDRange(int startID, int endID) {
            super(startID, endID);
            this.startID = (short)startID;
            this.endID = (short)endID;
        }

        @Override
        int getStartID() {
            return this.startID;
        }

        @Override
        int getEndID() {
            return this.endID;
        }
    }

    private static class SingleID
    extends SectIDRange {
        private int id;

        private SingleID(int id) {
            super(id, id);
            this.id = id;
        }

        @Override
        int getStartID() {
            return this.id;
        }

        @Override
        int getEndID() {
            return this.id;
        }
    }

    private static class IntIDRange
    extends SectIDRange {
        private final int startID;
        private final int endID;

        private IntIDRange(int startID, int endID) {
            super(startID, endID);
            this.startID = startID;
            this.endID = endID;
        }

        @Override
        int getStartID() {
            return this.startID;
        }

        @Override
        int getEndID() {
            return this.endID;
        }
    }
}

