/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.treeCombiners;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.LightFixedXFunc;
import org.opensha.commons.data.xyz.ArbDiscrGeoDataSet;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.logicTree.treeCombiner.AbstractLogicTreeCombiner;
import org.opensha.commons.logicTree.treeCombiner.LogicTreeCombinationProcessor;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.sha.earthquake.faultSysSolution.hazard.LogicTreeCurveAverager;
import org.opensha.sha.earthquake.faultSysSolution.hazard.LogicTreeHazardCompare;
import org.opensha.sha.earthquake.faultSysSolution.hazard.mpj.MPJ_LogicTreeHazardCalc;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.faultSysSolution.util.SolHazardMapCalc;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;

public class HazardMapCombinationProcessor
implements LogicTreeCombinationProcessor {
    private MapCurveLoader outerHazardMapLoader;
    private final IncludeBackgroundOption outerBGOp;
    private MapCurveLoader innerHazardMapLoader;
    private final IncludeBackgroundOption innerBGOp;
    private final File outputHazardFile;
    private final GriddedRegion gridReg;
    private double[] periods;
    private final SolHazardMapCalc.ReturnPeriods[] rps;
    private boolean preloadInnerCurves = true;
    private Map<LogicTreeBranch<?>, BranchCurves> innerCurvesMap = null;
    private File hazardZipOutFinal = null;
    private File hazardOutDir;
    private CompletableFuture<Void> writeFuture = null;
    private LogicTreeCurveAverager[] meanCurves = null;
    private String outerHazardSubDirName = null;
    private String innerHazardSubDirName = null;
    private String outputHazardSubDirName = null;
    private int readDequeSize;
    private LogicTreeBranch<?> prevOuter;
    private DiscretizedFunc[][] prevOuterCurves = null;
    private ArrayDeque<Future<BranchCurves>> outerCurveLoadFutures = null;
    private ArrayDeque<Integer> outerCurveLoadIndexes = null;
    private ArrayDeque<Future<BranchCurves>> innerCurveLoadFutures = null;
    private ArrayDeque<Integer> innerCurveLoadCombinedIndexes = null;
    private List<Future<?>> curveWriteFutures;
    private List<CompletableFuture<Void>> perAvgFutures = null;
    private int outerCurveLoadIndex = -1;
    private AbstractLogicTreeCombiner.LogicTreeCombinationContext treeCombination;
    private ExecutorService exec;
    private ExecutorService ioExec;
    private ArchiveOutput hazardOutZip;
    private WriteCounter writeCounter;
    private Stopwatch combineWatch;
    private Stopwatch mapStringWatch;
    private Stopwatch blockingZipIOWatch;
    private Stopwatch curveReadWatch;
    private Stopwatch curveWriteWatch;
    private Stopwatch blockingAvgWatch;

    public HazardMapCombinationProcessor(File outerHazardMapDir, IncludeBackgroundOption outerBGOp, File innerHazardMapDir, IncludeBackgroundOption innerBGOp, File outputHazardFile, GriddedRegion gridReg) {
        this(HazardMapCombinationProcessor.defaultMapCurveLoader(outerHazardMapDir), outerBGOp, HazardMapCombinationProcessor.defaultMapCurveLoader(innerHazardMapDir), innerBGOp, outputHazardFile, gridReg);
    }

    public HazardMapCombinationProcessor(MapCurveLoader outerHazardMapLoader, IncludeBackgroundOption outerBGOp, MapCurveLoader innerHazardMapLoader, IncludeBackgroundOption innerBGOp, File outputHazardFile, GriddedRegion gridReg) {
        this(outerHazardMapLoader, outerBGOp, innerHazardMapLoader, innerBGOp, outputHazardFile, gridReg, null, SolHazardMapCalc.MAP_RPS);
    }

    public HazardMapCombinationProcessor(MapCurveLoader outerHazardMapLoader, IncludeBackgroundOption outerBGOp, MapCurveLoader innerHazardMapLoader, IncludeBackgroundOption innerBGOp, File outputHazardFile, GriddedRegion gridReg, double[] periods, SolHazardMapCalc.ReturnPeriods[] rps) {
        this.outerHazardMapLoader = outerHazardMapLoader;
        this.outerBGOp = outerBGOp;
        this.innerHazardMapLoader = innerHazardMapLoader;
        this.innerBGOp = innerBGOp;
        this.outputHazardFile = outputHazardFile;
        this.gridReg = gridReg;
        this.periods = periods;
        this.rps = rps;
    }

    @Override
    public String getName() {
        return "Hazard maps";
    }

    public void setPreloadInnerCurves(boolean preloadInnerCurves) {
        this.preloadInnerCurves = preloadInnerCurves;
    }

    @Override
    public void init(AbstractLogicTreeCombiner.LogicTreeCombinationContext treeCombination, ExecutorService exec, ExecutorService ioExec) throws IOException {
        int i;
        this.treeCombination = treeCombination;
        this.exec = exec;
        this.ioExec = ioExec;
        this.outerHazardSubDirName = this.getHazardDirName(this.gridReg.getSpacing(), this.outerBGOp);
        this.innerHazardSubDirName = this.getHazardDirName(this.gridReg.getSpacing(), this.innerBGOp);
        IncludeBackgroundOption outBGOp = this.outerBGOp;
        if (this.innerBGOp == IncludeBackgroundOption.INCLUDE) {
            outBGOp = IncludeBackgroundOption.INCLUDE;
        } else if (this.innerBGOp == IncludeBackgroundOption.EXCLUDE && outBGOp == IncludeBackgroundOption.ONLY) {
            outBGOp = IncludeBackgroundOption.INCLUDE;
        } else if (this.outerBGOp == IncludeBackgroundOption.EXCLUDE && this.innerBGOp == IncludeBackgroundOption.ONLY) {
            outBGOp = IncludeBackgroundOption.INCLUDE;
        }
        this.outputHazardSubDirName = this.getHazardDirName(this.gridReg.getSpacing(), outBGOp);
        if (this.outerHazardMapLoader instanceof FileBasedCurveLoader && this.innerHazardMapLoader instanceof FileBasedCurveLoader) {
            ArchiveInput innerInput = ArchiveInput.getDefaultInput(((FileBasedCurveLoader)this.innerHazardMapLoader).hazardDir);
            ArchiveInput outerInput = ArchiveInput.getDefaultInput(((FileBasedCurveLoader)this.outerHazardMapLoader).hazardDir);
            if (this.periods == null) {
                this.periods = LogicTreeHazardCompare.detectHazardPeriods(this.rps, innerInput, outerInput);
            }
            innerInput.close();
            outerInput.close();
        }
        if (this.periods == null) {
            this.periods = MPJ_LogicTreeHazardCalc.PERIODS_DEFAULT;
        }
        if (this.preloadInnerCurves && treeCombination.numPairwiseSamples < 1) {
            System.out.println("Pre-loading inner curves");
            this.innerCurvesMap = new HashMap(treeCombination.innerTree.size());
            for (int b = 0; b < treeCombination.innerTree.size(); ++b) {
                LogicTreeBranch<?> innerBranch = treeCombination.innerTree.getBranch(b);
                System.out.println("Pre-loading curves for inner branch " + b + "/" + treeCombination.innerTree.size() + ": " + String.valueOf(innerBranch));
                this.innerCurvesMap.put(innerBranch, HazardMapCombinationProcessor.curveLoadFuture(this.innerHazardMapLoader, this.innerHazardSubDirName, innerBranch, this.periods).join());
            }
        }
        if (!this.outputHazardFile.getName().toLowerCase().endsWith(".zip")) {
            this.hazardZipOutFinal = new File(this.outputHazardFile.getAbsolutePath() + ".zip");
            this.hazardOutDir = this.outputHazardFile;
            Preconditions.checkState((this.hazardOutDir.exists() && this.hazardOutDir.isDirectory() || this.hazardOutDir.mkdir() ? 1 : 0) != 0);
        } else {
            this.hazardOutDir = null;
            this.hazardZipOutFinal = this.outputHazardFile;
        }
        this.meanCurves = new LogicTreeCurveAverager[this.periods.length];
        HashSet<LogicTreeNode> variableNodes = new HashSet<LogicTreeNode>();
        HashMap nodeLevels = new HashMap();
        LogicTreeCurveAverager.populateVariableNodes(treeCombination.outerTree, variableNodes, nodeLevels, treeCombination.outerLevelRemaps, treeCombination.outerNodeRemaps);
        LogicTreeCurveAverager.populateVariableNodes(treeCombination.innerTree, variableNodes, nodeLevels, treeCombination.innerLevelRemaps, treeCombination.innerNodeRemaps);
        for (int p = 0; p < this.periods.length; ++p) {
            this.meanCurves[p] = new LogicTreeCurveAverager(this.gridReg.getNodeList(), variableNodes, nodeLevels);
        }
        this.readDequeSize = Integer.max(5, Integer.min(20, FaultSysTools.defaultNumThreads()));
        if (!treeCombination.averageAcrossLevels.isEmpty()) {
            if (treeCombination.preAveragingInnerTree != treeCombination.innerTree) {
                this.innerHazardMapLoader = new AveragedMapCurveLoader(treeCombination.preAveragingInnerTree, this.innerHazardMapLoader, ioExec);
            }
            if (treeCombination.preAveragingOuterTree != treeCombination.outerTree) {
                this.outerHazardMapLoader = new AveragedMapCurveLoader(treeCombination.preAveragingOuterTree, this.outerHazardMapLoader, ioExec);
            }
            this.readDequeSize = 2;
        }
        this.outerCurveLoadFutures = new ArrayDeque(this.readDequeSize);
        this.outerCurveLoadIndexes = new ArrayDeque(this.readDequeSize);
        for (i = 0; i < treeCombination.combBranchesOuterIndexes.size() && this.outerCurveLoadFutures.size() < this.readDequeSize; ++i) {
            int prevOutlerIndex;
            int outerIndex = treeCombination.combBranchesOuterIndexes.get(i);
            this.outerCurveLoadIndex = i;
            int n = prevOutlerIndex = this.outerCurveLoadIndexes.isEmpty() ? -1 : this.outerCurveLoadIndexes.getLast();
            if (prevOutlerIndex >= 0 && (prevOutlerIndex == outerIndex || treeCombination.outerTree.getBranch(prevOutlerIndex).equals(treeCombination.outerTree.getBranch(outerIndex)))) continue;
            this.outerCurveLoadFutures.add(HazardMapCombinationProcessor.curveLoadFuture(this.outerHazardMapLoader, this.outerHazardSubDirName, treeCombination.outerTree.getBranch(outerIndex), this.periods, ioExec));
            this.outerCurveLoadIndexes.add(outerIndex);
            System.out.println("Adding outer read future for " + outerIndex);
        }
        if (this.innerCurvesMap == null) {
            this.innerCurveLoadFutures = new ArrayDeque(this.readDequeSize);
            this.innerCurveLoadCombinedIndexes = new ArrayDeque(this.readDequeSize);
            for (i = 0; i < this.readDequeSize && i < treeCombination.combTree.size(); ++i) {
                this.innerCurveLoadFutures.add(HazardMapCombinationProcessor.curveLoadFuture(this.innerHazardMapLoader, this.innerHazardSubDirName, treeCombination.combBranchesInnerPortion.get(i), this.periods, ioExec));
                this.innerCurveLoadCombinedIndexes.add(i);
            }
        }
        int writeThreads = Integer.max(2, Integer.min(16, FaultSysTools.defaultNumThreads()));
        this.hazardOutZip = new ArchiveOutput.ParallelZipFileOutput(this.hazardZipOutFinal, writeThreads, false);
        this.writeCounter = new WriteCounter();
        this.combineWatch = Stopwatch.createUnstarted();
        this.mapStringWatch = Stopwatch.createUnstarted();
        this.blockingZipIOWatch = Stopwatch.createUnstarted();
        this.curveReadWatch = Stopwatch.createUnstarted();
        this.curveWriteWatch = this.hazardOutDir != null ? Stopwatch.createUnstarted() : null;
        this.blockingAvgWatch = Stopwatch.createUnstarted();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processBranch(final LogicTreeBranch<?> combBranch, int combBranchIndex, final double combBranchWeight, LogicTreeBranch<?> outerBranch, int outerBranchIndex, LogicTreeBranch<?> innerBranch, int innerBranchIndex) throws IOException {
        int writable;
        File branchHazardOutDir;
        BranchCurves innerBranchCurves;
        DiscretizedFunc[][] outerCurves;
        if (this.prevOuter == null || !outerBranch.equals(this.prevOuter)) {
            this.curveReadWatch.start();
            System.out.println("Reading outer curves for branch " + combBranchIndex + ", outerIndex=" + outerBranchIndex);
            int nextOuterIndex = this.outerCurveLoadIndexes.removeFirst();
            Preconditions.checkState((nextOuterIndex == outerBranchIndex ? 1 : 0) != 0, (String)"Future outerIndex=%s, we need %s", (int)nextOuterIndex, (int)outerBranchIndex);
            try {
                BranchCurves outerBranchCurves = this.outerCurveLoadFutures.removeFirst().get();
                Preconditions.checkState((boolean)outerBranch.equals(outerBranchCurves.branch), (String)"Curve load mismatch for outer %s; expected %s, was %s", (Object)outerBranchIndex, outerBranch, outerBranchCurves.branch);
                outerCurves = outerBranchCurves.curves;
            }
            catch (InterruptedException | ExecutionException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            for (int i = this.outerCurveLoadIndex + 1; i < this.treeCombination.combBranchesOuterIndexes.size() && this.outerCurveLoadFutures.size() < this.readDequeSize; ++i) {
                int prevOutlerIndex;
                int n = this.treeCombination.combBranchesOuterIndexes.get(i);
                this.outerCurveLoadIndex = i;
                int n2 = prevOutlerIndex = this.outerCurveLoadIndexes.isEmpty() ? -1 : this.outerCurveLoadIndexes.getLast();
                if (prevOutlerIndex >= 0 && (prevOutlerIndex == n || this.treeCombination.outerTree.getBranch(prevOutlerIndex).equals(this.treeCombination.outerTree.getBranch(n)))) continue;
                System.out.println("Adding outer read future for " + n);
                this.outerCurveLoadFutures.add(HazardMapCombinationProcessor.curveLoadFuture(this.outerHazardMapLoader, this.outerHazardSubDirName, this.treeCombination.outerTree.getBranch(n), this.periods, this.ioExec));
                this.outerCurveLoadIndexes.add(n);
            }
            this.curveReadWatch.stop();
            if (this.perAvgFutures != null && !this.perAvgFutures.isEmpty()) {
                System.out.println("Waiting on " + this.perAvgFutures.size() + " curve averaging futures...");
                this.blockingAvgWatch.start();
                for (CompletableFuture<Void> completableFuture : this.perAvgFutures) {
                    completableFuture.join();
                }
                this.blockingAvgWatch.stop();
                if (this.curveWriteFutures != null) {
                    System.out.println("Waiting on " + this.curveWriteFutures.size() + " curve write futures");
                    this.curveWriteWatch.start();
                    for (Future<Void> future : this.curveWriteFutures) {
                        try {
                            future.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            ExceptionUtils.throwAsRuntimeException(e);
                        }
                    }
                    this.curveWriteWatch.stop();
                }
            }
            this.perAvgFutures = new ArrayList<CompletableFuture<Void>>();
            if (this.hazardOutDir != null) {
                this.curveWriteFutures = new ArrayList();
            }
            this.prevOuter = outerBranch;
            this.prevOuterCurves = outerCurves;
        } else {
            outerCurves = this.prevOuterCurves;
        }
        if (this.innerCurvesMap != null) {
            innerBranchCurves = this.innerCurvesMap.get(innerBranch);
        } else {
            this.curveReadWatch.start();
            try {
                int loadInnerIndex = this.innerCurveLoadCombinedIndexes.removeFirst();
                Preconditions.checkState((loadInnerIndex == combBranchIndex ? 1 : 0) != 0, (String)"Load inner index was %s but I'm on branch %s", (int)loadInnerIndex, (int)combBranchIndex);
                innerBranchCurves = this.innerCurveLoadFutures.removeFirst().get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            this.curveReadWatch.stop();
            if (this.innerCurveLoadCombinedIndexes.isEmpty()) {
                Preconditions.checkState((outerBranchIndex == this.treeCombination.combTree.size() - 1 ? 1 : 0) != 0, (String)"No load indexes left, but not on last branch: %s", (int)outerBranchIndex);
            } else {
                void var12_22;
                int lastRunningInnerIndex = this.innerCurveLoadCombinedIndexes.getLast();
                int n = lastRunningInnerIndex + 1;
                while (var12_22 < this.treeCombination.combTree.size() && this.innerCurveLoadFutures.size() < this.readDequeSize) {
                    this.innerCurveLoadFutures.add(HazardMapCombinationProcessor.curveLoadFuture(this.innerHazardMapLoader, this.innerHazardSubDirName, this.treeCombination.combBranchesInnerPortion.get((int)var12_22), this.periods, this.ioExec));
                    this.innerCurveLoadCombinedIndexes.add((int)var12_22);
                    ++var12_22;
                }
            }
        }
        Preconditions.checkState((boolean)innerBranch.equals(innerBranchCurves.branch), (String)"Curve load mismatch for inner %s; expected %s, was %s", (Object)innerBranchIndex, innerBranch, innerBranchCurves.branch);
        DiscretizedFunc[][] innerCurves = innerBranchCurves.curves;
        HashMap<CallSite, GriddedGeoDataSet> hashMap = new HashMap<CallSite, GriddedGeoDataSet>(this.gridReg.getNodeCount() * this.periods.length);
        if (this.hazardOutDir == null) {
            branchHazardOutDir = null;
        } else {
            File subDir = combBranch.getBranchDirectory(this.hazardOutDir, true);
            branchHazardOutDir = new File(subDir, this.outputHazardSubDirName);
            Preconditions.checkState((branchHazardOutDir.exists() || branchHazardOutDir.mkdir() ? 1 : 0) != 0, (String)"Directory doesn't exist and couldn't be created: %s", (Object)subDir.getAbsolutePath());
        }
        this.combineWatch.start();
        for (int p = 0; p < this.periods.length; ++p) {
            void var20_46;
            Preconditions.checkState((outerCurves[p].length == this.gridReg.getNodeCount() ? 1 : 0) != 0, (String)"Expected %s locations but have %s", (int)this.gridReg.getNodeCount(), (int)outerCurves[p].length);
            Preconditions.checkState((outerCurves[p].length == innerCurves[p].length ? 1 : 0) != 0, (String)"Outer curves have %s locs but inner curves have %s", (int)outerCurves[p].length, (int)innerCurves[p].length);
            Object xVals = new double[outerCurves[p][0].size()];
            for (int i = 0; i < ((Object)xVals).length; ++i) {
                xVals[i] = outerCurves[p][0].getX(i);
            }
            ArrayList<Future<CurveCombineResult>> futures = new ArrayList<Future<CurveCombineResult>>();
            for (int i = 0; i < outerCurves[p].length; ++i) {
                futures.add(this.exec.submit(new CurveCombineCallable(i, (double[])xVals, outerCurves[p][i], innerCurves[p][i], this.rps)));
            }
            final DiscretizedFunc[] combCurves = new DiscretizedFunc[innerCurves[p].length];
            GriddedGeoDataSet[] xyzs = new GriddedGeoDataSet[this.rps.length];
            for (int r = 0; r < this.rps.length; ++r) {
                xyzs[r] = new GriddedGeoDataSet(this.gridReg, false);
            }
            try {
                for (Future future : futures) {
                    CurveCombineResult result = (CurveCombineResult)future.get();
                    combCurves[result.index] = result.combCurve;
                    for (int r = 0; r < this.rps.length; ++r) {
                        xyzs[r].set(result.index, result.mapVals[r]);
                    }
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            String combZipPrefix = combBranch.getBranchZipPath();
            boolean bl = false;
            while (var20_46 < this.rps.length) {
                String mapFileName = MPJ_LogicTreeHazardCalc.mapPrefix(this.periods[p], this.rps[var20_46]) + ".txt";
                String entryName = combZipPrefix + "/" + mapFileName;
                Preconditions.checkState((hashMap.put((CallSite)((Object)entryName), xyzs[var20_46]) == null ? 1 : 0) != 0, (String)"Duplicate entry? %s", (Object)entryName);
                ++var20_46;
            }
            if (this.hazardOutDir != null) {
                String string = SolHazardMapCalc.getCSV_FileName("curves", this.periods[p]);
                final File csvFile = new File(branchHazardOutDir, string + ".gz");
                this.curveWriteFutures.add(this.ioExec.submit(new Runnable(){
                    final /* synthetic */ HazardMapCombinationProcessor this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        try {
                            SolHazardMapCalc.writeCurvesCSV(csvFile, combCurves, this.this$0.gridReg.getNodeList());
                        }
                        catch (IOException e) {
                            throw ExceptionUtils.asRuntimeException(e);
                        }
                    }
                }));
            }
            final LogicTreeCurveAverager logicTreeCurveAverager = this.meanCurves[p];
            this.perAvgFutures.add(CompletableFuture.runAsync(new Runnable(){
                final /* synthetic */ HazardMapCombinationProcessor this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    logicTreeCurveAverager.processBranchCurves(combBranch, combBranchWeight, combCurves);
                }
            }, this.exec));
        }
        this.combineWatch.stop();
        this.mapStringWatch.start();
        HashMap<String, Future<byte[]>> mapStringByteFutures = new HashMap<String, Future<byte[]>>(hashMap.size());
        for (Object entryName : hashMap.keySet()) {
            final GriddedGeoDataSet xyz = (GriddedGeoDataSet)hashMap.get(entryName);
            mapStringByteFutures.put((String)entryName, this.exec.submit(new Callable<byte[]>(){
                final /* synthetic */ HazardMapCombinationProcessor this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public byte[] call() throws Exception {
                    int size = Integer.max(1000, xyz.size() * 12);
                    StringWriter stringWriter = new StringWriter(size);
                    ArbDiscrGeoDataSet.writeXYZWriter(xyz, stringWriter);
                    stringWriter.flush();
                    return stringWriter.toString().getBytes();
                }
            }));
        }
        final HashMap<String, byte[]> mapStringBytes = new HashMap<String, byte[]>(hashMap.size());
        try {
            for (String entryName : hashMap.keySet()) {
                mapStringBytes.put(entryName, (byte[])((Future)mapStringByteFutures.get(entryName)).get());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
        this.mapStringWatch.stop();
        if (this.writeFuture != null) {
            this.blockingZipIOWatch.start();
            this.writeFuture.join();
            this.blockingZipIOWatch.stop();
            System.out.println("\tDone writing branch " + combBranchIndex);
        }
        Preconditions.checkState(((writable = this.writeCounter.getWritable()) == 0 ? 1 : 0) != 0, (String)"Have %s writable maps after join? written=%s", (int)writable, (int)this.writeCounter.getWritten());
        int expected = this.periods.length * this.rps.length;
        Preconditions.checkState((hashMap.size() == expected ? 1 : 0) != 0, (String)"Expected %s writable maps, have %s", (int)expected, (int)hashMap.size());
        this.writeCounter.incrementWritable(expected);
        System.out.println("Writing combined branch " + combBranchIndex + "/" + this.treeCombination.combBranches.size() + ": " + String.valueOf(combBranch));
        System.out.println("\tWriting " + this.writeCounter.getWritable() + " new maps, " + this.writeCounter.getWritten() + " written so far");
        this.writeFuture = CompletableFuture.runAsync(new Runnable(){
            final /* synthetic */ HazardMapCombinationProcessor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    for (String entryName : mapStringBytes.keySet()) {
                        byte[] mapBytes = (byte[])mapStringBytes.get(entryName);
                        this.this$0.hazardOutZip.putNextEntry(entryName);
                        OutputStream out = this.this$0.hazardOutZip.getOutputStream();
                        out.write(mapBytes);
                        this.this$0.hazardOutZip.closeEntry();
                        if (this.this$0.hazardOutDir != null) {
                            File outFile = new File(branchHazardOutDir, entryName.substring(entryName.lastIndexOf(47)));
                            FileUtils.writeByteArrayToFile((File)outFile, (byte[])mapBytes);
                        }
                        this.this$0.writeCounter.incrementWritten();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
        }, this.ioExec);
    }

    @Override
    public void close() throws IOException {
        System.out.println("Finalizing hazard map zip file");
        this.blockingAvgWatch.start();
        for (CompletableFuture<Void> completableFuture : this.perAvgFutures) {
            completableFuture.join();
        }
        this.blockingAvgWatch.stop();
        if (this.curveWriteFutures != null) {
            System.out.println("Waiting on " + this.curveWriteFutures.size() + " curve write futures");
            this.blockingZipIOWatch.start();
            this.curveWriteWatch.start();
            for (Future<Void> future : this.curveWriteFutures) {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    ExceptionUtils.throwAsRuntimeException(e);
                }
            }
            this.blockingZipIOWatch.stop();
            this.curveWriteWatch.stop();
        }
        this.blockingZipIOWatch.start();
        MPJ_LogicTreeHazardCalc.writeMeanCurvesAndMaps(this.hazardOutZip, this.meanCurves, this.gridReg, this.periods, this.rps);
        this.hazardOutZip.putNextEntry("gridded_region.geojson");
        Feature gridFeature = this.gridReg.toFeature();
        Feature.write(gridFeature, new OutputStreamWriter(this.hazardOutZip.getOutputStream()));
        this.hazardOutZip.closeEntry();
        this.treeCombination.combTree.writeToArchive(this.hazardOutZip, null);
        this.hazardOutZip.close();
        this.blockingZipIOWatch.stop();
        System.out.println("Wrote " + this.writeCounter.getWritten() + " maps in total");
    }

    protected String getHazardDirName(double gridSpacing, IncludeBackgroundOption bgOp) {
        return "hazard_" + (float)gridSpacing + "deg_grid_seis_" + bgOp.name();
    }

    private static DiscretizedFunc[][] loadCurves(File hazardDir, double[] periods, GriddedRegion region) throws IOException {
        DiscretizedFunc[][] curves = new DiscretizedFunc[periods.length][];
        for (int p = 0; p < periods.length; ++p) {
            String fileName = SolHazardMapCalc.getCSV_FileName("curves", periods[p]);
            File csvFile = new File(hazardDir, fileName);
            if (!csvFile.exists()) {
                csvFile = new File(hazardDir, fileName + ".gz");
            }
            Preconditions.checkState((boolean)csvFile.exists(), (String)"Curves CSV file not found: %s", (Object)csvFile.getAbsolutePath());
            try {
                CSVFile<String> csv = CSVFile.readFile(csvFile, true);
                curves[p] = SolHazardMapCalc.loadCurvesCSV(csv, region);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load curves from " + csvFile.getAbsolutePath(), e);
            }
        }
        return curves;
    }

    protected static MapCurveLoader defaultMapCurveLoader(File dir) {
        if (dir == null) {
            return null;
        }
        return new FileBasedCurveLoader(dir);
    }

    private static CompletableFuture<BranchCurves> curveLoadFuture(final MapCurveLoader loader, final String hazardSubDirName, final LogicTreeBranch<?> branch, final double[] periods) {
        return CompletableFuture.supplyAsync(new Supplier<BranchCurves>(){

            @Override
            public BranchCurves get() {
                try {
                    return loader.getCurveBranchResult(hazardSubDirName, branch, periods);
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
        });
    }

    private static Future<BranchCurves> curveLoadFuture(final MapCurveLoader loader, final String hazardSubDirName, final LogicTreeBranch<?> branch, final double[] periods, ExecutorService exec) {
        return exec.submit(new Callable<BranchCurves>(){

            @Override
            public BranchCurves call() {
                try {
                    return loader.getCurveBranchResult(hazardSubDirName, branch, periods);
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
        });
    }

    @Override
    public String getTimeBreakdownString(Stopwatch overallWatch) {
        String ret = "Combining:\t" + AbstractLogicTreeCombiner.blockingTimePrint(this.combineWatch, overallWatch);
        ret = ret + ";\tMap bytes:\t" + AbstractLogicTreeCombiner.blockingTimePrint(this.mapStringWatch, overallWatch);
        ret = ret + ";\tBlocking curve read I/O:\t" + AbstractLogicTreeCombiner.blockingTimePrint(this.curveReadWatch, overallWatch);
        if (this.curveWriteWatch != null) {
            ret = ret + ";\tBlocking curve write I/O:\t" + AbstractLogicTreeCombiner.blockingTimePrint(this.curveWriteWatch, overallWatch);
        }
        ret = ret + ";\tBlocking Zip I/O:\t" + AbstractLogicTreeCombiner.blockingTimePrint(this.blockingZipIOWatch, overallWatch);
        ret = ret + ";\tBlocking Averaging:\t" + AbstractLogicTreeCombiner.blockingTimePrint(this.blockingAvgWatch, overallWatch);
        return ret;
    }

    public static interface MapCurveLoader {
        public DiscretizedFunc[][] loadCurves(String var1, LogicTreeBranch<?> var2, double[] var3) throws IOException;

        default public BranchCurves getCurveBranchResult(String hazardSubDirName, LogicTreeBranch<?> branch, double[] periods) throws IOException {
            return new BranchCurves(this.loadCurves(hazardSubDirName, branch, periods), branch);
        }
    }

    public static class FileBasedCurveLoader
    implements MapCurveLoader {
        private File hazardDir;

        public FileBasedCurveLoader(File hazardDir) {
            this.hazardDir = hazardDir;
        }

        @Override
        public DiscretizedFunc[][] loadCurves(String hazardSubDirName, LogicTreeBranch<?> branch, double[] periods) throws IOException {
            File branchResultsDir = branch.getBranchDirectory(this.hazardDir, true);
            File branchHazardDir = new File(branchResultsDir, hazardSubDirName);
            Preconditions.checkState((boolean)branchHazardDir.exists(), (String)"%s doesn't exist", (Object)branchHazardDir.getAbsolutePath());
            return HazardMapCombinationProcessor.loadCurves(branchHazardDir, periods, null);
        }
    }

    private static class BranchCurves {
        public final DiscretizedFunc[][] curves;
        public final LogicTreeBranch<?> branch;

        private BranchCurves(DiscretizedFunc[][] curves, LogicTreeBranch<?> branch) {
            this.curves = curves;
            this.branch = branch;
        }
    }

    private static class AveragedMapCurveLoader
    implements MapCurveLoader {
        private LogicTree<?> origTree;
        private MapCurveLoader origLoader;
        private ExecutorService exec;

        public AveragedMapCurveLoader(LogicTree<?> origTree, MapCurveLoader origLoader, ExecutorService exec) {
            this.origTree = origTree;
            this.origLoader = origLoader;
            this.exec = exec;
        }

        @Override
        public DiscretizedFunc[][] loadCurves(String hazardSubDirName, LogicTreeBranch<?> branch, double[] periods) throws IOException {
            double sumWeight = 0.0;
            ArrayList<Future<BranchCurves>> loadFutures = new ArrayList<Future<BranchCurves>>();
            ArrayList<Double> weights = new ArrayList<Double>();
            for (LogicTreeBranch<?> origBranch : this.origTree) {
                boolean match = true;
                for (LogicTreeNode node : branch) {
                    if (origBranch.hasValue(node)) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                double weight = this.origTree.getBranchWeight(origBranch);
                sumWeight += weight;
                weights.add(weight);
                loadFutures.add(HazardMapCombinationProcessor.curveLoadFuture(this.origLoader, hazardSubDirName, origBranch, periods, this.exec));
            }
            System.out.println("Waiting on " + loadFutures.size() + " load futures to average curves for " + String.valueOf(branch));
            DiscretizedFunc[][] avgCurves = null;
            for (int i = 0; i < loadFutures.size(); ++i) {
                DiscretizedFunc[][] curves;
                try {
                    curves = ((BranchCurves)((Future)loadFutures.get((int)i)).get()).curves;
                }
                catch (InterruptedException | ExecutionException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
                double weight = (Double)weights.get(i) / sumWeight;
                if (avgCurves == null) {
                    avgCurves = new DiscretizedFunc[curves.length][];
                } else {
                    Preconditions.checkState((curves.length == avgCurves.length ? 1 : 0) != 0);
                }
                for (int j = 0; j < curves.length; ++j) {
                    if (avgCurves[j] == null) {
                        avgCurves[j] = new DiscretizedFunc[curves[j].length];
                    } else {
                        Preconditions.checkState((curves[j].length == avgCurves[j].length ? 1 : 0) != 0);
                    }
                    for (int k = 0; k < curves[j].length; ++k) {
                        if (avgCurves[j][k] == null) {
                            double[] xVals = new double[curves[j][k].size()];
                            for (int l = 0; l < xVals.length; ++l) {
                                xVals[l] = curves[j][k].getX(l);
                            }
                            avgCurves[j][k] = new LightFixedXFunc(xVals, new double[xVals.length]);
                        } else {
                            Preconditions.checkState((avgCurves[j][k].size() == curves[j][k].size() ? 1 : 0) != 0);
                        }
                        for (int l = 0; l < avgCurves[j][k].size(); ++l) {
                            avgCurves[j][k].set(l, avgCurves[j][k].getY(l) + weight * curves[j][k].getY(l));
                        }
                    }
                }
            }
            return avgCurves;
        }
    }

    private static class WriteCounter {
        private int writable = 0;
        private int written = 0;

        private WriteCounter() {
        }

        public synchronized void incrementWritable(int num) {
            this.writable += num;
        }

        public synchronized void incrementWritable() {
            ++this.writable;
        }

        public synchronized void incrementWritten() {
            ++this.written;
            --this.writable;
        }

        public synchronized int getWritable() {
            return this.writable;
        }

        public synchronized int getWritten() {
            return this.written;
        }
    }

    public static class CurveCombineCallable
    implements Callable<CurveCombineResult> {
        private int gridIndex;
        private double[] xVals;
        private DiscretizedFunc outerCurve;
        private DiscretizedFunc innerCurve;
        private SolHazardMapCalc.ReturnPeriods[] rps;

        public CurveCombineCallable(int gridIndex, double[] xVals, DiscretizedFunc outerCurve, DiscretizedFunc innerCurve, SolHazardMapCalc.ReturnPeriods[] rps) {
            this.gridIndex = gridIndex;
            this.xVals = xVals;
            this.outerCurve = outerCurve;
            this.innerCurve = innerCurve;
            this.rps = rps;
        }

        @Override
        public CurveCombineResult call() throws Exception {
            double[] mapVals;
            Preconditions.checkState((this.outerCurve.size() == this.xVals.length ? 1 : 0) != 0);
            Preconditions.checkState((this.innerCurve.size() == this.xVals.length ? 1 : 0) != 0);
            double[] yVals = new double[this.xVals.length];
            for (int j = 0; j < this.outerCurve.size(); ++j) {
                double x = this.outerCurve.getX(j);
                Preconditions.checkState(((float)x == (float)this.innerCurve.getX(j) ? 1 : 0) != 0);
                double y1 = this.outerCurve.getY(j);
                double y2 = this.innerCurve.getY(j);
                double y = y1 == 0.0 ? y2 : (y2 == 0.0 ? y1 : 1.0 - (1.0 - y1) * (1.0 - y2));
                yVals[j] = y;
            }
            LightFixedXFunc combCurve = new LightFixedXFunc(this.xVals, yVals);
            if (this.rps != null) {
                mapVals = new double[this.rps.length];
                for (int r = 0; r < this.rps.length; ++r) {
                    double curveLevel = this.rps[r].oneYearProb;
                    double val = curveLevel > combCurve.getMaxY() ? 0.0 : (curveLevel < combCurve.getMinY() ? combCurve.getMaxX() : combCurve.getFirstInterpolatedX_inLogXLogYDomain(curveLevel));
                    mapVals[r] = val;
                }
            } else {
                mapVals = new double[]{};
            }
            return new CurveCombineResult(this.gridIndex, combCurve, mapVals);
        }
    }

    public static class CurveCombineResult {
        public final int index;
        public final DiscretizedFunc combCurve;
        public final double[] mapVals;

        public CurveCombineResult(int index, DiscretizedFunc combCurve, double[] mapVals) {
            this.index = index;
            this.combCurve = combCurve;
            this.mapVals = mapVals;
        }
    }
}

