/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.util;

import com.google.common.base.Preconditions;
import java.util.List;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.sha.faultSurface.FaultSection;

public class FaultSectionUtils {
    public static int findParentSectionID(List<? extends FaultSection> subSects, String ... nameParts) {
        FaultSection sect = FaultSectionUtils.findSection(subSects, true, nameParts);
        if (sect == null) {
            return -1;
        }
        return sect.getParentSectionId();
    }

    public static int findSectionID(List<? extends FaultSection> sects, String ... nameParts) {
        FaultSection sect = FaultSectionUtils.findSection(sects, false, nameParts);
        if (sect == null) {
            return -1;
        }
        return sect.getSectionId();
    }

    public static FaultSection findSection(List<? extends FaultSection> subSects, String ... nameParts) {
        return FaultSectionUtils.findSection(subSects, false, nameParts);
    }

    private static FaultSection findSection(List<? extends FaultSection> subSects, boolean parent, String ... nameParts) {
        Preconditions.checkState((nameParts.length > 0 ? 1 : 0) != 0);
        FaultSection matchSect = null;
        Object partDebugStr = "[";
        for (int i = 0; i < nameParts.length; ++i) {
            String string = nameParts[i];
            if (i > 0) {
                partDebugStr = (String)partDebugStr + ", ";
            }
            partDebugStr = (String)partDebugStr + "'" + string + "'";
            nameParts[i] = string.toLowerCase();
        }
        partDebugStr = (String)partDebugStr + "]";
        for (FaultSection faultSection : subSects) {
            int myID;
            String myName;
            if (parent) {
                myName = faultSection.getParentSectionName();
                Preconditions.checkNotNull((Object)myName, (Object)"Parent section names not set");
                myID = faultSection.getParentSectionId();
            } else {
                myName = faultSection.getSectionName();
                Preconditions.checkNotNull((Object)myName, (Object)"Section names not set");
                myID = faultSection.getSectionId();
            }
            Preconditions.checkState((myID >= 0 ? 1 : 0) != 0, (Object)"IDs not set");
            myName = myName.toLowerCase();
            if (parent && matchSect != null && matchSect.getParentSectionId() == faultSection.getParentSectionId()) continue;
            boolean match = true;
            for (String part : nameParts) {
                if (myName.contains(part)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            if (matchSect != null) {
                String prevName = parent ? matchSect.getParentSectionName() : matchSect.getSectionName();
                int prevID = parent ? matchSect.getParentSectionId() : matchSect.getSectionId();
                throw new IllegalStateException("Multiple matches for " + (String)partDebugStr + ": " + prevID + "='" + prevName + "' and " + myID + "='" + myName + "'");
            }
            matchSect = faultSection;
        }
        return matchSect;
    }

    public static boolean anySectInRegion(Region region, List<? extends FaultSection> sects, boolean traceOnly) {
        for (FaultSection faultSection : sects) {
            if (!FaultSectionUtils.sectInRegion(region, faultSection, traceOnly)) continue;
            return true;
        }
        return false;
    }

    public static boolean sectInRegion(Region region, FaultSection sect, boolean traceOnly) {
        for (Location loc : sect.getFaultTrace()) {
            if (!region.contains(loc)) continue;
            return true;
        }
        if (!traceOnly) {
            for (Location loc : sect.getFaultSurface(1.0).getEvenlyDiscritizedListOfLocsOnSurface()) {
                if (!region.contains(loc)) continue;
                return true;
            }
        }
        return false;
    }

    public static Integer getCommonParentID(List<? extends FaultSection> sects) {
        Integer parent = null;
        for (FaultSection faultSection : sects) {
            int parentID = faultSection.getParentSectionId();
            Preconditions.checkState((parentID >= 0 ? 1 : 0) != 0, (String)"Sect doesn't have parent info: %s. %s", (int)faultSection.getSectionId(), (Object)faultSection.getSectionName());
            if (parent == null) {
                parent = parentID;
                continue;
            }
            if (parentID == parent) continue;
            return null;
        }
        return parent;
    }
}

