/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.util;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opensha.commons.data.CSVFile;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;

public class RuptureJumpDistanceWriter {
    public static void main(String[] args) throws IOException {
        FaultSystemRupSet rupSet;
        ClusterRuptures cRups;
        if (args.length != 2) {
            System.err.println("USAGE: <rupture-set.zip> <output-file.csv>");
            System.exit(1);
        }
        if ((cRups = (rupSet = FaultSystemRupSet.load(new File(args[0]))).getModule(ClusterRuptures.class)) == null) {
            System.out.println("Building rupture representation assuming single-stranded ruptures (no splays)");
            cRups = ClusterRuptures.singleStranged(rupSet);
        }
        CSVFile<String> csv = new CSVFile<String>(false);
        csv.addLine("Rupture Index", "Jump Count", "Cumulative Jump Distance (km)", "Maximum Jump Distance (km)", "Jump 1 (km)", "...", "Jump N (km)");
        for (int r = 0; r < cRups.size(); ++r) {
            ClusterRupture rup = cRups.get(r);
            ArrayList<CallSite> line = new ArrayList<CallSite>();
            line.add((CallSite)((Object)("" + r)));
            double cmlDist = 0.0;
            double maxDist = 0.0;
            ArrayList<Double> dists = new ArrayList<Double>();
            for (Jump jump : rup.getJumpsIterable()) {
                maxDist = Math.max(maxDist, jump.distance);
                cmlDist += jump.distance;
                dists.add(jump.distance);
            }
            line.add((CallSite)((Object)("" + dists.size())));
            line.add((CallSite)((Object)("" + (float)cmlDist)));
            line.add((CallSite)((Object)("" + (float)maxDist)));
            Iterator<Jump> iterator = dists.iterator();
            while (iterator.hasNext()) {
                double dist = (Double)((Object)iterator.next());
                line.add((CallSite)((Object)("" + (float)dist)));
            }
            csv.addLine((List<String>)line);
        }
        File outputFile = new File(args[1]);
        System.out.println("Writing CSV: " + outputFile.getAbsolutePath());
        csv.writeToFile(outputFile);
    }
}

