/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.sha.earthquake.faultSysSolution.RupSetDeformationModel;
import org.opensha.sha.earthquake.faultSysSolution.RupSetFaultModel;
import org.opensha.sha.earthquake.faultSysSolution.RupSetSubsectioningModel;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.GeoJSONFaultReader;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_DeformationModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_FaultModels;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;

public class SubSectionBuilder {
    static final double DOWN_DIP_FRACT_DEFAULT = 0.5;
    static final double MAX_LEN_DEFAULT = Double.NaN;
    static final int MIN_SUB_SECTS_PER_FAULT_DEFAULT = 2;
    public static final RupSetSubsectioningModel DEAFULT_BUILDER = SubSectionBuilder.getModel(2, 0.5, Double.NaN);

    public static final RupSetSubsectioningModel getModel(final int minPerFault, final double ddwFract, final double fixedLen) {
        return new RupSetSubsectioningModel(){

            @Override
            public String getName() {
                return "Default Subsectioning Model";
            }

            @Override
            public String getShortName() {
                return "Default";
            }

            @Override
            public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
                return 1.0;
            }

            @Override
            public String getFilePrefix() {
                return this.getShortName();
            }

            @Override
            public List<? extends FaultSection> buildSubSects(RupSetFaultModel faultModel, List<? extends FaultSection> fullSections) {
                return SubSectionBuilder.buildSubSects(fullSections, minPerFault, ddwFract, fixedLen);
            }
        };
    }

    public static List<FaultSection> buildSubSects(List<? extends FaultSection> sects) {
        return SubSectionBuilder.buildSubSects(sects, 2, 0.5, Double.NaN);
    }

    public static List<FaultSection> buildSubSects(List<? extends FaultSection> sects, int minPerFault, double ddwFract, double fixedLen) {
        Preconditions.checkState((ddwFract > 0.0 || fixedLen > 0.0 ? 1 : 0) != 0, (Object)"Must give either ddwFract or fixedLen >0");
        sects = new ArrayList<FaultSection>(sects);
        Collections.sort(sects, new Comparator<FaultSection>(){

            @Override
            public int compare(FaultSection o1, FaultSection o2) {
                return o1.getSectionName().compareTo(o2.getSectionName());
            }
        });
        ArrayList<FaultSection> subSects = new ArrayList<FaultSection>();
        for (FaultSection faultSection : sects) {
            double maxLen;
            double d = maxLen = fixedLen > 0.0 ? fixedLen : Double.POSITIVE_INFINITY;
            if (ddwFract > 0.0) {
                maxLen = Double.min(maxLen, ddwFract * faultSection.getOrigDownDipWidth());
            }
            subSects.addAll(faultSection.getSubSectionsList(maxLen, subSects.size(), minPerFault));
        }
        System.out.println("Built " + subSects.size() + " subsections");
        return subSects;
    }

    public static void validateSubSects(List<? extends FaultSection> subSects) throws IllegalStateException {
        for (int s = 0; s < subSects.size(); ++s) {
            FaultSection subSect = subSects.get(s);
            Preconditions.checkState((subSect.getSectionId() == s ? 1 : 0) != 0, (String)"Subsection ID mismatch; subsections must be indexed starting with 0 with no holes. Subsection at index=%s does not match ID=%s.", (int)s, (int)subSect.getSectionId());
        }
    }

    private static Options createOptions(Models model) {
        Options ops = new Options();
        ops.addOption(FaultSysTools.helpOption());
        ops.addOption("if", "input-file", true, "Path to a file containing fault sections. This should either be a GeoJSON file, or a legacy OpenSHA fault sections XML file. See https://opensha.org/Geospatial-File-Formats for more information.");
        ops.addRequiredOption("of", "output-file", true, "Path to output GeoJSON file where subsections should be written.");
        for (Models m : Models.values()) {
            ops.addOption(null, m.argName, false, m.argDescription);
        }
        if (model != null) {
            model.addExtraOptions(ops);
        }
        Object fmDesc = "Fault Model, used to fetch fault sections as an alternative to --input-file. Must supply a model flag, e.g. --ucerf3 or --nshm23.";
        Object dmDesc = "Deformation Model, used to in conjunction with --fault-model to override properties including slip rates (and often rakes) in accordance with the chosen deformation model.";
        if (model == null) {
            fmDesc = (String)fmDesc + " To see available options, supply a model flag and --help to print this message with options listed.";
            dmDesc = (String)dmDesc + " To see available options, supply a model flag and --help to print this message with options listed.";
        } else {
            fmDesc = (String)fmDesc + " Options: " + model.fmOptionsStr();
            dmDesc = (String)dmDesc + " Options: " + model.dmOptionsStr();
        }
        ops.addOption("f", "fault-model", true, (String)fmDesc);
        ops.addOption("dm", "deformation-model", true, (String)dmDesc);
        ops.addOption("ddf", "down-dip-fraction", true, "Fault sections are divided into equal length subsections; those lengths are determined as a function of the down-dip width of the fault. If not supplied, the default fraction of 0.5 will be used.");
        ops.addOption("fl", "fixed-length", true, "Fault sections are divided into equal length subsections; those lengths are usually determined as a function of the down-dip width of the fault (see --down-dip-fraction), but can instead be of a fixed length through this option. If supplied, each subsection will be no longer than the given length (in kilometers).");
        ops.addOption("mpf", "min-per-fault", true, "Minimum number of subsections per fault, regaurdless of fault length. Default is 2.");
        return ops;
    }

    public static void main(String[] args) {
        Models model = null;
        block2: for (String arg : args) {
            arg = arg.trim();
            while (arg.startsWith("-")) {
                arg = arg.substring(1);
            }
            for (Models testModel : Models.values()) {
                if (!arg.equals(testModel.argName)) continue;
                Preconditions.checkArgument((model == null ? 1 : 0) != 0, (String)"Can't specify multiple models (both %s and %s specified)", model, (Object)((Object)testModel));
                model = testModel;
                continue block2;
            }
        }
        Options options = SubSectionBuilder.createOptions(model);
        CommandLine cmd = FaultSysTools.parseOptions(options, args, SubSectionBuilder.class);
        FaultSysTools.checkPrintHelp(options, cmd, SubSectionBuilder.class);
        RupSetFaultModel fm = null;
        RupSetDeformationModel dm = null;
        try {
            List<? extends FaultSection> sects;
            int minPerFault;
            double fixedLen;
            double ddwFract;
            if (cmd.hasOption("down-dip-fraction") || cmd.hasOption("fixed-length")) {
                ddwFract = cmd.hasOption("down-dip-fraction") ? Double.parseDouble(cmd.getOptionValue("down-dip-fraction")) : Double.NaN;
                fixedLen = cmd.hasOption("fixed-length") ? Double.parseDouble(cmd.getOptionValue("fixed-length")) : Double.NaN;
            } else {
                ddwFract = 0.5;
                fixedLen = Double.NaN;
            }
            int n = minPerFault = cmd.hasOption("min-per-fault") ? Integer.parseInt(cmd.getOptionValue("min-per-fault")) : 2;
            if (cmd.hasOption("input-file")) {
                Preconditions.checkArgument((!cmd.hasOption("fault-model") ? 1 : 0) != 0, (Object)"Shouldn't supply both --input-file and --fault-model");
                Preconditions.checkArgument((!cmd.hasOption("deformation-model") ? 1 : 0) != 0, (Object)"Shouldn't supply both --input-file and --deformation-model");
                File inputFile = new File(cmd.getOptionValue("input-file"));
                Preconditions.checkState((boolean)inputFile.exists(), (String)"Input file doesn't exist: %s", (Object)inputFile.getAbsolutePath());
                String fName = inputFile.getName().trim().toLowerCase();
                if (fName.endsWith(".xml")) {
                    sects = FaultModels.loadStoredFaultSections(inputFile);
                } else {
                    if (!fName.endsWith(".json") && !fName.endsWith(".geojson")) {
                        System.err.println("Warning: expected a GeoJSON file, but input file has an unexpected extension: " + inputFile.getName() + "\nWill attemp to parse as GeoJSON anyway. See file format details at https://opensha.org/Geospatial-File-Formats");
                    }
                    sects = GeoJSONFaultReader.readFaultSections(inputFile);
                }
                if (cmd.hasOption("deformation-model")) {
                    System.err.println("WARNING: you are applying a deformation model to an externally supplied fault model. Unexpected behaviour may occur if the fault model does not match what the deformation model expects. Pay close attention to any warning messages and validate the output files.");
                    Preconditions.checkArgument((model != null ? 1 : 0) != 0, (Object)"Can't use --deformation-model without first choosing a model (e.g., with --ucerf3 or --nshm23)");
                    String dmStr = cmd.getOptionValue("fault-model");
                    dm = model.getDM(cmd.getOptionValue("deformation-model"));
                    Preconditions.checkNotNull((Object)dm, (String)"Unknown deformation model: %s", (Object)dmStr);
                }
            } else {
                Preconditions.checkArgument((boolean)cmd.hasOption("fault-model"), (Object)"Must supply either --input-file or --fault-model");
                Preconditions.checkArgument((model != null ? 1 : 0) != 0, (Object)"Can't use --fault-model without first choosing a model (e.g., with --ucerf3 or --nshm23)");
                String fmStr = cmd.getOptionValue("fault-model");
                fm = model.getFM(fmStr);
                Preconditions.checkNotNull((Object)fm, (String)"Unknown fault model: %s", (Object)fmStr);
                sects = fm.getFaultSections();
                if (cmd.hasOption("deformation-model")) {
                    String dmStr = cmd.getOptionValue("deformation-model");
                    dm = model.getDM(dmStr);
                    Preconditions.checkNotNull((Object)fm, (String)"Unknown fault model: %s", (Object)dmStr);
                    if (!dm.isApplicableTo(fm)) {
                        System.err.println("WARNING: The chosen deformation model (" + dm.getShortName() + ") does not think it is applicable to the chosen fault model (" + fm.getShortName() + "); will try to proceed anyway.");
                    }
                }
            }
            System.out.println("Loaded " + sects.size() + " fault sections.");
            Preconditions.checkState((!sects.isEmpty() ? 1 : 0) != 0, (Object)"Loaded fault sections are empty");
            if (model != null) {
                model.processOptionsFullSects(cmd, sects);
            }
            List<FaultSection> subSects = SubSectionBuilder.buildSubSects(sects, minPerFault, ddwFract, fixedLen);
            System.out.println("Built " + subSects.size() + " subsections");
            if (dm != null) {
                System.out.println("Applying deformation model: " + String.valueOf(dm));
                subSects = dm.apply(fm, null, sects, subSects);
            }
            if (model != null) {
                model.processOptionsSubSects(cmd, subSects);
            }
            File outputFile = new File(cmd.getOptionValue("output-file"));
            System.out.println("Writing sections to " + outputFile.getAbsolutePath());
            GeoJSONFaultReader.writeFaultSections(outputFile, subSects);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static enum Models {
        UCERF3("ucerf3", "Flag to enable UCERF3 fault and deformation models via --fault-model and --deformation-model."){

            @Override
            public RupSetFaultModel getDefaultFM() {
                return FaultModels.FM3_1;
            }

            @Override
            public RupSetFaultModel getFM(String name) {
                return FaultModels.valueOf(name);
            }

            @Override
            public String fmOptionsStr() {
                return FaultSysTools.enumOptions(FaultModels.class);
            }

            @Override
            public RupSetDeformationModel getDM(String name) {
                return DeformationModels.valueOf(name);
            }

            @Override
            public String dmOptionsStr() {
                return FaultSysTools.enumOptions(DeformationModels.class);
            }
        }
        ,
        NSHM23("nshm23", "Flag to enable NSHM23 fault and deformation models via --fault-model and --deformation-model, as well as the --apply-std-dev-defaults option to apply NSHM23 uncertainty limits and defaults to externally supplied fault sections."){

            @Override
            public RupSetFaultModel getDefaultFM() {
                return NSHM23_FaultModels.WUS_FM_v2;
            }

            @Override
            public RupSetFaultModel getFM(String name) {
                return NSHM23_FaultModels.valueOf(name);
            }

            @Override
            public String fmOptionsStr() {
                return FaultSysTools.enumOptions(NSHM23_FaultModels.class);
            }

            @Override
            public RupSetDeformationModel getDM(String name) {
                return NSHM23_DeformationModels.valueOf(name);
            }

            @Override
            public String dmOptionsStr() {
                return FaultSysTools.enumOptions(NSHM23_DeformationModels.class);
            }

            @Override
            public void addExtraOptions(Options ops) {
                ops.addOption(null, "apply-std-dev-defaults", false, "NSHM23 specific option to apply default NSHM23 slip rate standard deviation treatment.");
            }

            @Override
            public void processOptionsSubSects(CommandLine cmd, List<? extends FaultSection> subSects) {
                if (cmd.hasOption("apply-std-dev-defaults")) {
                    NSHM23_DeformationModels.applyStdDevDefaults(subSects);
                }
            }
        };

        private String argName;
        private String argDescription;

        private Models(String argName, String argDescription) {
            this.argName = argName;
            this.argDescription = argDescription;
        }

        public abstract RupSetFaultModel getDefaultFM();

        public abstract RupSetFaultModel getFM(String var1);

        public abstract String fmOptionsStr();

        public abstract RupSetDeformationModel getDM(String var1);

        public abstract String dmOptionsStr();

        public void addExtraOptions(Options ops) {
        }

        public void processOptionsFullSects(CommandLine cmd, List<? extends FaultSection> sects) {
        }

        public void processOptionsSubSects(CommandLine cmd, List<? extends FaultSection> subSects) {
        }
    }
}

