/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.util.minisections;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.earthquake.faultSysSolution.util.minisections.AbstractMinisectionDataRecord;
import org.opensha.sha.earthquake.faultSysSolution.util.minisections.MinisectionSlipRecord;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;

public class MinisectionMappings {
    private List<? extends FaultSection> subSects;
    private Map<Integer, FaultSection> sectsByID;
    private int[] subSectMinisectionAssociationNum;
    private boolean[][] subSectMinisectionAssociations;
    private double[][] subSectMinisectionLengths;
    private double[][] subSectMinisectionFracts;
    private double[] subSectLengths;
    private static final double GEODETIC_LOC_WARN_TOL = 0.1;
    private static final double GEODETIC_LOC_ERR_TOL = 1.0;
    private static DecimalFormat pDF = new DecimalFormat("0.00%");

    public MinisectionMappings(List<? extends FaultSection> fullSects, List<? extends FaultSection> subSects) {
        this.subSects = subSects;
        this.sectsByID = new HashMap<Integer, FaultSection>();
        for (FaultSection faultSection : fullSects) {
            Preconditions.checkState((!this.sectsByID.containsKey(faultSection.getSectionId()) ? 1 : 0) != 0);
            this.sectsByID.put(faultSection.getSectionId(), faultSection);
        }
        this.subSectMinisectionAssociationNum = new int[subSects.size()];
        this.subSectMinisectionAssociations = new boolean[subSects.size()][];
        this.subSectMinisectionLengths = new double[subSects.size()][];
        this.subSectMinisectionFracts = new double[subSects.size()][];
        this.subSectLengths = new double[subSects.size()];
        for (int s = 0; s < subSects.size(); ++s) {
            int i;
            FaultSection faultSection = subSects.get(s);
            int parentID = faultSection.getParentSectionId();
            FaultSection parentSect = this.sectsByID.get(parentID);
            Preconditions.checkNotNull((Object)parentSect, (String)"Parent sect is null? ParentID=%s, SubSect: %s. %s", (Object)parentID, (Object)s, (Object)faultSection.getSectionName());
            FaultTrace subTrace = faultSection.getFaultTrace();
            Preconditions.checkState((subTrace.size() > 1 ? 1 : 0) != 0, (Object)"sub section trace only has one point!!!!");
            Location subStart = (Location)subTrace.get(0);
            Location subEnd = (Location)subTrace.get(subTrace.size() - 1);
            FaultTrace trace = parentSect.getFaultTrace();
            int traceIndexBefore = -1;
            int traceIndexAfter = -1;
            for (int i2 = 0; i2 < trace.size(); ++i2) {
                Location tracePt = (Location)trace.get(i2);
                if (MinisectionMappings.isBefore(subStart, subEnd, tracePt)) {
                    traceIndexBefore = i2;
                    continue;
                }
                if (!MinisectionMappings.isAfter(subStart, subEnd, tracePt)) continue;
                traceIndexAfter = i2;
                break;
            }
            Preconditions.checkState((traceIndexBefore >= 0 ? 1 : 0) != 0, (Object)"trace index before not found!");
            Preconditions.checkState((traceIndexAfter > traceIndexBefore ? 1 : 0) != 0, (Object)"trace index after not found!");
            int numMinisections = trace.size() - 1;
            this.subSectMinisectionAssociations[s] = new boolean[numMinisections];
            this.subSectMinisectionLengths[s] = new double[numMinisections];
            for (i = traceIndexBefore; i < traceIndexAfter; ++i) {
                this.subSectMinisectionAssociations[s][i] = true;
                Location start = i == traceIndexBefore ? subStart : (Location)trace.get(i);
                Location end = i == traceIndexAfter - 1 ? subEnd : (Location)trace.get(i + 1);
                this.subSectMinisectionLengths[s][i] = LocationUtils.horzDistanceFast(start, end);
                int n = s;
                this.subSectLengths[n] = this.subSectLengths[n] + this.subSectMinisectionLengths[s][i];
                int n2 = s;
                this.subSectMinisectionAssociationNum[n2] = this.subSectMinisectionAssociationNum[n2] + 1;
            }
            this.subSectMinisectionFracts[s] = new double[numMinisections];
            for (i = 0; i < this.subSectMinisectionFracts[s].length; ++i) {
                if (!this.subSectMinisectionAssociations[s][i]) continue;
                this.subSectMinisectionFracts[s][i] = this.subSectMinisectionLengths[s][i] / this.subSectLengths[s];
            }
        }
    }

    private static boolean isBefore(Location start, Location end, Location pt) {
        if (start.equals(pt) || LocationUtils.areSimilar(start, pt)) {
            return true;
        }
        double pt_start_dist = LocationUtils.horzDistanceFast(pt, start);
        if (pt_start_dist == 0.0) {
            return true;
        }
        double pt_end_dist = LocationUtils.horzDistanceFast(pt, end);
        double start_end_dist = LocationUtils.horzDistanceFast(start, end);
        return pt_start_dist < pt_end_dist && pt_end_dist > start_end_dist;
    }

    private static boolean isAfter(Location start, Location end, Location pt) {
        if (end.equals(pt) || LocationUtils.areSimilar(end, pt)) {
            return true;
        }
        double pt_end_dist = LocationUtils.horzDistanceFast(pt, end);
        if (pt_end_dist == 0.0) {
            return true;
        }
        double pt_start_dist = LocationUtils.horzDistanceFast(pt, start);
        double start_end_dist = LocationUtils.horzDistanceFast(start, end);
        return pt_end_dist < pt_start_dist && pt_start_dist > start_end_dist;
    }

    public boolean hasParent(int parentID) {
        return this.sectsByID.containsKey(parentID);
    }

    public int getNumMinisectionsForParent(int parentID) {
        return this.sectsByID.get(parentID).getFaultTrace().size() - 1;
    }

    public int getNumAssociatedMinisections(int subSectIndex) {
        return this.subSectMinisectionAssociationNum[subSectIndex];
    }

    private int getFirstAssociatedMinisection(int subSectIndex) {
        for (int i = 0; i < this.subSectMinisectionAssociations[subSectIndex].length; ++i) {
            if (!this.subSectMinisectionAssociations[subSectIndex][i]) continue;
            return i;
        }
        throw new IllegalStateException("No assiciated minisections for subsection " + subSectIndex);
    }

    public boolean[] getMinisectionAssociations(int subSectIndex) {
        return this.subSectMinisectionAssociations[subSectIndex];
    }

    public double[] getMinisectionLengths(int subSectIndex) {
        return this.subSectMinisectionLengths[subSectIndex];
    }

    public double[] getMinisectionFracts(int subSectIndex) {
        return this.subSectMinisectionLengths[subSectIndex];
    }

    public boolean isAssociated(int subSectIndex, int minisectionIndex) {
        return this.subSectMinisectionAssociations[subSectIndex][minisectionIndex];
    }

    public double getFractAssociated(int subSectIndex, int minisectionIndex) {
        return this.subSectMinisectionFracts[subSectIndex][minisectionIndex];
    }

    public double getAssociationScaledAverage(int subSectIndex, double[] values) {
        return this.getAssociationScaledAverage(subSectIndex, Doubles.asList((double[])values));
    }

    public double getAssociationScaledAverage(int subSectIndex, List<Double> values) {
        Preconditions.checkState((values.size() == this.subSectMinisectionLengths[subSectIndex].length ? 1 : 0) != 0, (String)"Given %s values but should have %s minisections (based on full section trace size) for subsection %s", (Object)values.size(), (Object)this.subSectMinisectionLengths[subSectIndex].length, (Object)subSectIndex);
        int numAssociations = this.getNumAssociatedMinisections(subSectIndex);
        Preconditions.checkState((numAssociations >= 1 ? 1 : 0) != 0, (String)"No associations found for subsection %s", (int)subSectIndex);
        if (numAssociations == 1 || this.areAllAssociatedEqual(values, subSectIndex)) {
            return values.get(this.getFirstAssociatedMinisection(subSectIndex));
        }
        double scaledAvg = 0.0;
        for (int i = 0; i < values.size(); ++i) {
            scaledAvg += values.get(i) * this.subSectMinisectionLengths[subSectIndex][i] / this.subSectLengths[subSectIndex];
        }
        return scaledAvg;
    }

    private boolean areAllAssociatedEqual(List<Double> values, int subSectIndex) {
        int first = this.getFirstAssociatedMinisection(subSectIndex);
        double firstVal = values.get(first);
        for (int i = first + 1; i < values.size(); ++i) {
            double val;
            if (!this.subSectMinisectionAssociations[subSectIndex][i] || (float)(val = values.get(i).doubleValue()) == (float)firstVal) continue;
            return false;
        }
        return true;
    }

    public double getAssociationScaledAngleAverage(int subSectIndex, double[] values) {
        return this.getAssociationScaledAngleAverage(subSectIndex, Doubles.asList((double[])values));
    }

    public double getAssociationScaledAngleAverage(int subSectIndex, List<Double> values) {
        Preconditions.checkState((values.size() == this.subSectMinisectionLengths[subSectIndex].length ? 1 : 0) != 0, (String)"Given %s values but have %s minisections for subsection %s", (Object)values.size(), (Object)this.subSectMinisectionLengths[subSectIndex].length, (Object)subSectIndex);
        int numAssociations = this.getNumAssociatedMinisections(subSectIndex);
        Preconditions.checkState((numAssociations >= 1 ? 1 : 0) != 0, (String)"No associations found for subsection %s", (int)subSectIndex);
        if (numAssociations == 1 || this.areAllAssociatedEqual(values, subSectIndex)) {
            return values.get(this.getFirstAssociatedMinisection(subSectIndex));
        }
        FaultUtils.AngleAverager avg = new FaultUtils.AngleAverager();
        for (int i = 0; i < values.size(); ++i) {
            if (!this.subSectMinisectionAssociations[subSectIndex][i]) continue;
            avg.add(values.get(i), this.subSectMinisectionLengths[subSectIndex][i]);
        }
        return avg.getAverage();
    }

    public boolean areMinisectionDataForParentValid(int parentID, List<? extends AbstractMinisectionDataRecord> records, boolean verbose) {
        return this.checkMinisectionDataForParentValid(parentID, records, verbose, false);
    }

    public void assertMinisectionDataForParentValid(int parentID, List<? extends AbstractMinisectionDataRecord> records) {
        this.checkMinisectionDataForParentValid(parentID, records, false, true);
    }

    private boolean checkMinisectionDataForParentValid(int parentID, List<? extends AbstractMinisectionDataRecord> records, boolean verbose, boolean failOnInvalid) {
        FaultSection sect = this.sectsByID.get(parentID);
        if (sect == null) {
            String error = "Minisection data references fault with ID=" + parentID + ", which was not found in fault model";
            if (failOnInvalid) {
                throw new IllegalStateException(error);
            }
            if (verbose) {
                System.err.println("WARNING: " + error);
            }
            return false;
        }
        String name = sect.getSectionName();
        int id = sect.getSectionId();
        FaultTrace trace = sect.getFaultTrace();
        if (trace.size() != records.size() + 1) {
            String error = id + ". " + name + ". Trace has " + trace.size() + " locations which means " + (trace.size() - 1) + " minisections, but have " + records.size() + " minisections";
            if (failOnInvalid) {
                throw new IllegalStateException(error);
            }
            if (verbose) {
                System.err.println("WARNING: " + error);
            }
            return false;
        }
        boolean ret = true;
        for (AbstractMinisectionDataRecord abstractMinisectionDataRecord : records) {
            ret = this.checkMinisectionDataValid(abstractMinisectionDataRecord, verbose, failOnInvalid) && ret;
        }
        return ret;
    }

    public boolean isMinisectionDataValid(AbstractMinisectionDataRecord record, boolean verbose) {
        return this.checkMinisectionDataValid(record, verbose, false);
    }

    public void assertMinisectionDataValid(AbstractMinisectionDataRecord record) {
        this.checkMinisectionDataValid(record, false, true);
    }

    private boolean checkMinisectionDataValid(AbstractMinisectionDataRecord record, boolean verbose, boolean failOnInvalid) {
        FaultSection sect = this.sectsByID.get(record.parentID);
        if (sect == null) {
            String error = "Minisection data references fault with ID=" + record.parentID + ", which was not found in fault model";
            if (failOnInvalid) {
                throw new IllegalStateException(error);
            }
            if (verbose) {
                System.err.println("WARNING: " + error);
            }
            return false;
        }
        String name = sect.getSectionName();
        int id = sect.getSectionId();
        FaultTrace trace = sect.getFaultTrace();
        if (record.minisectionID >= trace.size() - 1) {
            String error = id + ". " + name + ". Trace has " + trace.size() + " locations which means " + (trace.size() - 1) + " minisections, but encountered minisection with ID=" + record.minisectionID;
            if (failOnInvalid) {
                throw new IllegalStateException(error);
            }
            if (verbose) {
                System.err.println("WARNING: " + error);
            }
            return false;
        }
        if (record.startLoc != null || record.endLoc != null) {
            double dist2;
            Location traceLoc1 = (Location)trace.get(record.minisectionID);
            Location traceLoc2 = (Location)trace.get(record.minisectionID + 1);
            double dist1 = record.startLoc == null ? Double.NaN : LocationUtils.horzDistanceFast(traceLoc1, record.startLoc);
            double d = dist2 = record.endLoc == null ? Double.NaN : LocationUtils.horzDistanceFast(traceLoc2, record.endLoc);
            if (dist1 > 0.1 || dist2 > 0.1) {
                String error = id + ". " + name + ". Trace/minisection location mismatch for minisection " + record.minisectionID + ":";
                error = error + "\n\tStart loc: [" + (float)traceLoc1.getLatitude() + ", " + (float)traceLoc1.getLongitude() + "] vs [" + (float)record.startLoc.getLatitude() + ", " + (float)record.startLoc.getLongitude() + "], dist=" + (float)dist1 + " km";
                error = error + "\n\tEnd loc: [" + (float)traceLoc2.getLatitude() + ", " + (float)traceLoc2.getLongitude() + "] vs [" + (float)record.endLoc.getLatitude() + ", " + (float)record.endLoc.getLongitude() + "], dist=" + (float)dist2 + " km";
                if (dist1 > 1.0 || dist2 > 1.0) {
                    if (failOnInvalid) {
                        throw new IllegalStateException(error);
                    }
                    if (verbose) {
                        System.err.println("WARNING: " + error);
                    }
                    return false;
                }
                if (verbose) {
                    System.err.println("WARNING: " + error);
                }
            }
        }
        return true;
    }

    public void mapDefModelMinisToSubSects(Map<Integer, List<MinisectionSlipRecord>> dmRecords) {
        int numRakesSkipped = 0;
        for (FaultSection faultSection : this.subSects) {
            double avgSlipStdDev;
            int subSectID = faultSection.getSectionId();
            int parentID = faultSection.getParentSectionId();
            List<MinisectionSlipRecord> records = dmRecords.get(parentID);
            if (records == null) {
                faultSection.setAveSlipRate(0.0);
                faultSection.setSlipRateStdDev(0.0);
                continue;
            }
            ArrayList<Double> recSlips = new ArrayList<Double>(records.size());
            ArrayList<Double> recSlipStdDevs = new ArrayList<Double>(records.size());
            ArrayList<Double> recRakes = new ArrayList<Double>(records.size());
            for (MinisectionSlipRecord record : records) {
                recSlips.add(record.slipRate);
                if (Double.isNaN(record.slipRateStdDev)) {
                    recSlipStdDevs = null;
                } else {
                    recSlipStdDevs.add(record.slipRateStdDev);
                }
                recRakes.add(record.rake);
            }
            double avgSlip = this.getAssociationScaledAverage(subSectID, recSlips);
            Preconditions.checkState((Double.isFinite(avgSlip) && avgSlip >= 0.0 ? 1 : 0) != 0, (String)"Bad slip rate for subSect=%, parentID=%: %s", (Object)faultSection.getSectionId(), (Object)parentID, (Object)avgSlip);
            if (recSlipStdDevs == null) {
                avgSlipStdDev = Double.NaN;
            } else {
                avgSlipStdDev = this.getAssociationScaledAverage(subSectID, recSlipStdDevs);
                Preconditions.checkState((boolean)Double.isFinite(avgSlipStdDev), (String)"Bad slip rate standard deviation for subSect=%, parentID=%: %s", (Object)faultSection.getSectionId(), (Object)parentID, (Object)avgSlipStdDev);
                if (avgSlipStdDev == 0.0 && avgSlip > 0.0) {
                    System.err.println("WARNING: slipRateStdDev=0 for " + faultSection.getSectionId() + ". " + faultSection.getSectionName() + ", with slipRate=" + avgSlip);
                }
            }
            double avgRake = FaultUtils.getInRakeRange(this.getAssociationScaledAngleAverage(subSectID, recRakes));
            Preconditions.checkState((boolean)Double.isFinite(avgRake), (String)"Bad rake for subSect=%, parentID=%: %s", (Object)faultSection.getSectionId(), (Object)parentID, (Object)avgRake);
            if ((float)avgSlip == 0.0f && (float)avgRake == 0.0f && (float)(avgRake = this.sectsByID.get(parentID).getAveRake()) != 0.0f) {
                ++numRakesSkipped;
            }
            faultSection.setAveSlipRate(avgSlip);
            faultSection.setSlipRateStdDev(avgSlipStdDev);
            faultSection.setAveRake(avgRake);
        }
        if (numRakesSkipped > 0) {
            System.err.println("WARNING: Ignored rakes set to zero with zero slip rates for " + numRakesSkipped + "/" + this.subSects.size() + " (" + pDF.format((double)numRakesSkipped / (double)this.subSects.size()) + ") subsections, keeping geologic rakes to avoid placeholder");
        }
    }
}

