/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.observedEarthquake;

import com.google.common.base.Preconditions;
import java.util.Collections;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.earthquake.util.EqkRuptureMagComparator;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class ObsEqkRupListCalc {
    public static double getMeanMag(ObsEqkRupList obsEqkEvents) {
        int size = obsEqkEvents.size();
        double mag = 0.0;
        for (int i = 0; i < size; ++i) {
            mag += ((ObsEqkRupture)obsEqkEvents.get(i)).getMag();
        }
        return mag / (double)size;
    }

    public static double getMinMag(ObsEqkRupList obsEqkEvents) {
        Double minMag = ((ObsEqkRupture)Collections.min(obsEqkEvents, new EqkRuptureMagComparator())).getMag();
        return minMag;
    }

    public static double getMaxMag(ObsEqkRupList obsEqkEvents) {
        Double maxMag = ((ObsEqkRupture)Collections.max(obsEqkEvents, new EqkRuptureMagComparator())).getMag();
        return maxMag;
    }

    public static long[] getInterEventTimes(ObsEqkRupList obsEqkEvents) {
        obsEqkEvents.sortByOriginTime();
        int size = obsEqkEvents.size();
        long[] interEventTimes = new long[size - 1];
        for (int i = 0; i < size - 1; ++i) {
            long time;
            interEventTimes[i] = time = ((ObsEqkRupture)obsEqkEvents.get(i + 1)).getOriginTime() - ((ObsEqkRupture)obsEqkEvents.get(i)).getOriginTime();
        }
        return interEventTimes;
    }

    public static IncrementalMagFreqDist getMagFreqDist(ObsEqkRupList obsEqkEvents) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public static IncrementalMagFreqDist getMagNumDist(ObsEqkRupList obsEqkEvents, double minMag, int numMag, double deltaMag) {
        IncrementalMagFreqDist mfd = new IncrementalMagFreqDist(minMag, numMag, deltaMag);
        double min = mfd.getMinX() - 0.5 * mfd.getDelta();
        double max = mfd.getMaxX() + 0.5 * mfd.getDelta();
        int numBelow = 0;
        int numAbove = 0;
        for (ObsEqkRupture rup : obsEqkEvents) {
            double mag = rup.getMag();
            if (mag < min) {
                ++numBelow;
                continue;
            }
            if (mag > max) {
                ++numAbove;
                continue;
            }
            mfd.add(mfd.getClosestXIndex(mag), 1.0);
        }
        if (numBelow > 0) {
            System.out.println("Skipped " + numBelow + " events in MFD below M=" + (float)min);
        }
        Preconditions.checkState((numAbove == 0 ? 1 : 0) != 0, (Object)"MFD max mag too small!");
        return mfd;
    }
}

