/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.observedEarthquake.magComplete;

import com.google.common.collect.Lists;
import java.util.List;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.earthquake.observedEarthquake.magComplete.TimeDepMagComplete;

public class Helmstetter2006_TimeDepMc
implements TimeDepMagComplete {
    private static final double MILLISEC_PER_DAY = 8.64E7;
    private List<? extends ObsEqkRupture> mainshocks;
    private double minMag;

    public Helmstetter2006_TimeDepMc(ObsEqkRupture mainshock, double minMag) {
        this(Lists.newArrayList((Object[])new ObsEqkRupture[]{mainshock}), minMag);
    }

    public Helmstetter2006_TimeDepMc(List<? extends ObsEqkRupture> mainshocks, double minMag) {
        this.mainshocks = mainshocks;
        this.minMag = minMag;
    }

    public double getMinMagThreshold() {
        return this.minMag;
    }

    public List<? extends ObsEqkRupture> getMainshocksList() {
        return this.mainshocks;
    }

    @Override
    public double calcTimeDepMc(ObsEqkRupture rup) {
        return this.calcTimeDepMc(rup.getOriginTime());
    }

    @Override
    public double calcTimeDepMc(long time) {
        return Helmstetter2006_TimeDepMc.calcTimeDepMc(this.mainshocks, time, this.minMag);
    }

    @Override
    public boolean isAboveTimeDepMc(ObsEqkRupture rup) {
        return rup.getMag() >= this.calcTimeDepMc(rup);
    }

    @Override
    public ObsEqkRupList getFiltered(List<? extends ObsEqkRupture> rups) {
        ObsEqkRupList filtered = new ObsEqkRupList();
        for (ObsEqkRupture obsEqkRupture : rups) {
            if (!this.isAboveTimeDepMc(obsEqkRupture)) continue;
            filtered.add(obsEqkRupture);
        }
        return filtered;
    }

    public static double calcTimeDepMc(List<? extends ObsEqkRupture> mainshocks, long time, double minMag) {
        double maxMc = minMag;
        for (ObsEqkRupture obsEqkRupture : mainshocks) {
            double myMc = Helmstetter2006_TimeDepMc.calcTimeDepMc(obsEqkRupture, time, minMag);
            if (!Double.isFinite(myMc)) continue;
            maxMc = Math.max(maxMc, myMc);
        }
        return maxMc;
    }

    public static double calcTimeDepMc(ObsEqkRupture mainshock, long time, double minMag) {
        if (time <= mainshock.getOriginTime()) {
            return Double.NaN;
        }
        double daysSinceMainshock = (double)(time - mainshock.getOriginTime()) / 8.64E7;
        return Helmstetter2006_TimeDepMc.calcTimeDepMc(mainshock.getMag(), daysSinceMainshock, minMag);
    }

    public static double calcTimeDepMc(double mainshockMag, double daysSinceMainshock, double minMag) {
        return Math.max(minMag, mainshockMag - 4.5 - 0.75 * Math.log10(daysSinceMainshock));
    }
}

