/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.observedEarthquake.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.geo.Location;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;

public class UCERF3_CatalogParser {
    public static ObsEqkRupList loadCatalog(File file) throws IOException {
        ObsEqkRupList rups = new ObsEqkRupList();
        BufferedReader in = new BufferedReader(new FileReader(file));
        int startID = 1;
        while (in.ready()) {
            String line = in.readLine();
            line = line.trim();
            line = line.replaceAll("\t", " ");
            while (line.contains("  ")) {
                line = line.replaceAll("  ", " ");
            }
            String[] split = line.split(" ");
            int year = Integer.parseInt(split[0]);
            int month = Integer.parseInt(split[1]);
            int date = Integer.parseInt(split[2]);
            int hourOfDay = Integer.parseInt(split[3]);
            int minute = Integer.parseInt(split[4]);
            int second = (int)Double.parseDouble(split[5]);
            double latitude = Double.parseDouble(split[6]);
            double longitude = Double.parseDouble(split[7]);
            double depth = Double.parseDouble(split[8]);
            if (Double.isNaN(depth) || depth < 0.0) {
                depth = 0.0;
            }
            double mag = Double.parseDouble(split[9]);
            int eventID = split.length < 15 ? startID++ : (int)Double.parseDouble(split[14]);
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT-0:00"));
            cal.clear();
            cal.set(year, month - 1, date, hourOfDay, minute, second);
            Location hypoLoc = new Location(latitude, longitude, depth);
            rups.add(new ObsEqkRupture("" + eventID, cal.getTimeInMillis(), hypoLoc, mag));
        }
        in.close();
        return rups;
    }

    public static ObsEqkRupList loadCatalogGardnerKnopoffFiltered(File file) throws IOException {
        ObsEqkRupList rups = new ObsEqkRupList();
        BufferedReader in = new BufferedReader(new FileReader(file));
        int startID = 1;
        while (in.ready()) {
            int eventID;
            String line = in.readLine();
            line = line.trim();
            line = line.replaceAll("\t", " ");
            while (line.contains("  ")) {
                line = line.replaceAll("  ", " ");
            }
            String[] split = line.split(" ");
            int year = Integer.parseInt(split[0]);
            int month = Integer.parseInt(split[1]);
            int date = Integer.parseInt(split[2]);
            int hourOfDay = Integer.parseInt(split[3]);
            int minute = Integer.parseInt(split[4]);
            int second = (int)Double.parseDouble(split[5]);
            double latitude = Double.parseDouble(split[6]);
            double longitude = Double.parseDouble(split[7]);
            double depth = Double.parseDouble(split[8]);
            if (Double.isNaN(depth) || depth < 0.0) {
                depth = 0.0;
            }
            double mag = Double.parseDouble(split[9]);
            int gkAftershock = 0;
            int gkForeshock = 0;
            if (split.length < 15) {
                eventID = startID++;
            } else {
                eventID = (int)Double.parseDouble(split[14]);
                gkAftershock = (int)Double.parseDouble(split[15]);
                gkForeshock = (int)Double.parseDouble(split[16]);
            }
            if (gkAftershock == 1 || gkForeshock == 1) continue;
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT-0:00"));
            cal.set(year, month - 1, date, hourOfDay, minute, second);
            Location hypoLoc = new Location(latitude, longitude, depth);
            rups.add(new ObsEqkRupture("" + eventID, cal.getTimeInMillis(), hypoLoc, mag));
        }
        in.close();
        return rups;
    }

    public static void main(String[] args) throws IOException {
        File file = new File("/home/kevin/OpenSHA/UCERF3/UCERF3CatalogVersion1.txt");
        double momPast100 = 0.0;
        CaliforniaRegions.RELM_SOCAL reg = new CaliforniaRegions.RELM_SOCAL();
        int numAbove = 0;
        for (ObsEqkRupture rup : UCERF3_CatalogParser.loadCatalog(file)) {
            int year = rup.getOriginTimeCal().get(1);
            if (year > 1912 && reg.contains(rup.getHypocenterLocation())) {
                momPast100 += MagUtils.magToMoment(rup.getMag());
            }
            if (!(rup.getMag() >= 6.5)) continue;
            ++numAbove;
        }
        System.out.println(numAbove + " above 6.5");
        System.out.println("Total Moment Past 100 yr: " + momPast100);
        System.out.println("As rate: " + momPast100 / 100.0);
    }
}

