/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.observedEarthquake.parsers.ngaWest;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.opensha.commons.geo.Location;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;

public class NGAWestEqkRupture
extends ObsEqkRupture {
    private static final long serialVersionUID = 1L;
    private int id;
    private String name;
    private GregorianCalendar date;
    private String magType;
    private double magUncertaintyKegan;
    private double magUncertaintyStatistical;
    private double magUncertaintyStudyClass;
    private int magSampleSize;
    private double mo;
    private FocalMechanism focalMech;
    private int mechBasedOnRakeAngle;
    private double pPlungeDegrees;
    private double pTrendDegrees;
    private double tPlungeDegrees;
    private double tTrendDegrees;
    private CoseismicSurfaceRupture coseismicSurfaceRupture;
    private String surfaceRuptureInferrenceBasis;
    private boolean finiteRuptureModel;
    private double depthToTopOfFiniteRupture;
    private double finiteFaultRuptureLength;
    private double finiteFaultRuptureWidth;

    private static GregorianCalendar parseDate(int year, String monthDayStr, String hourMinStr) {
        int min;
        int hour;
        int day;
        int month;
        if (monthDayStr.length() == 3) {
            month = Integer.parseInt(monthDayStr.substring(0, 1));
            day = Integer.parseInt(monthDayStr.substring(1));
        } else {
            month = Integer.parseInt(monthDayStr.substring(0, 2));
            day = Integer.parseInt(monthDayStr.substring(2));
        }
        if (hourMinStr == null) {
            hourMinStr = "";
        }
        if (hourMinStr.length() <= 2) {
            hour = 0;
            min = hourMinStr.isEmpty() ? 0 : Integer.parseInt(hourMinStr);
        } else if (hourMinStr.length() == 3) {
            hour = Integer.parseInt(hourMinStr.substring(0, 1));
            min = Integer.parseInt(hourMinStr.substring(1));
        } else if (hourMinStr.length() == 4) {
            hour = Integer.parseInt(hourMinStr.substring(0, 2));
            min = Integer.parseInt(hourMinStr.substring(2));
        } else {
            throw new RuntimeException("invalid hour/min string: " + hourMinStr);
        }
        GregorianCalendar cal = new GregorianCalendar(year, month - 1, day, hour, min);
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        return cal;
    }

    public NGAWestEqkRupture(HSSFRow row, String dataSource) {
        Object hourMinStr;
        Object monthDayStr;
        this.id = (int)row.getCell(0).getNumericCellValue();
        this.name = row.getCell(1).getStringCellValue().trim();
        int year = (int)row.getCell(2).getNumericCellValue();
        try {
            monthDayStr = row.getCell(3).getStringCellValue();
        }
        catch (Exception e) {
            monthDayStr = "" + (int)row.getCell(3).getNumericCellValue();
        }
        try {
            hourMinStr = row.getCell(4).getStringCellValue();
        }
        catch (Exception e) {
            try {
                hourMinStr = "" + (int)row.getCell(4).getNumericCellValue();
            }
            catch (NullPointerException npe) {
                hourMinStr = "";
            }
        }
        this.date = NGAWestEqkRupture.parseDate(year, (String)monthDayStr, (String)hourMinStr);
        this.mag = row.getCell(5).getNumericCellValue();
        this.magType = row.getCell(6).getStringCellValue();
        try {
            this.magUncertaintyKegan = row.getCell(7).getNumericCellValue();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.magUncertaintyStatistical = row.getCell(8).getNumericCellValue();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.magUncertaintyStudyClass = row.getCell(10).getNumericCellValue();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.magSampleSize = (int)row.getCell(9).getNumericCellValue();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.mo = row.getCell(11).getNumericCellValue();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.aveRake = row.getCell(14).getNumericCellValue();
            double strike = row.getCell(12).getNumericCellValue();
            double dip = row.getCell(13).getNumericCellValue();
            this.focalMech = new FocalMechanism(strike, dip, this.aveRake);
        }
        catch (NullPointerException strike) {
            // empty catch block
        }
        try {
            this.mechBasedOnRakeAngle = (int)row.getCell(15).getNumericCellValue();
        }
        catch (NullPointerException strike) {
            // empty catch block
        }
        try {
            this.pPlungeDegrees = row.getCell(16).getNumericCellValue();
        }
        catch (NullPointerException strike) {
            // empty catch block
        }
        try {
            this.pTrendDegrees = row.getCell(17).getNumericCellValue();
        }
        catch (NullPointerException strike) {
            // empty catch block
        }
        try {
            this.tPlungeDegrees = row.getCell(18).getNumericCellValue();
        }
        catch (NullPointerException strike) {
            // empty catch block
        }
        try {
            this.tTrendDegrees = row.getCell(19).getNumericCellValue();
        }
        catch (NullPointerException strike) {
            // empty catch block
        }
        try {
            double dep;
            double lat = row.getCell(20).getNumericCellValue();
            double lon = row.getCell(21).getNumericCellValue();
            try {
                dep = row.getCell(22).getNumericCellValue();
            }
            catch (NullPointerException e) {
                dep = 0.0;
            }
            this.hypocenterLocation = new Location(lat, lon, dep);
        }
        catch (NullPointerException lat) {
            // empty catch block
        }
        try {
            int csr = (int)row.getCell(23).getNumericCellValue();
            this.coseismicSurfaceRupture = csr == 0 ? CoseismicSurfaceRupture.NO_KNOWN : CoseismicSurfaceRupture.YES_KNOWN;
        }
        catch (NullPointerException e) {
            try {
                int csr = (int)row.getCell(24).getNumericCellValue();
                this.coseismicSurfaceRupture = csr == 0 ? CoseismicSurfaceRupture.NO_INFERRED : CoseismicSurfaceRupture.YES_INFERRED;
            }
            catch (NullPointerException e2) {
                this.coseismicSurfaceRupture = CoseismicSurfaceRupture.UNKNOWN;
            }
        }
        try {
            this.surfaceRuptureInferrenceBasis = row.getCell(25).getStringCellValue();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.finiteRuptureModel = (int)row.getCell(26).getNumericCellValue() == 1;
        }
        catch (NullPointerException e) {
            this.finiteRuptureModel = false;
        }
        try {
            this.depthToTopOfFiniteRupture = row.getCell(27).getNumericCellValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.finiteFaultRuptureLength = row.getCell(28).getNumericCellValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.finiteFaultRuptureWidth = row.getCell(29).getNumericCellValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.setEventId("" + this.id);
        this.setOriginTimeCal(this.date);
        this.setRuptureSurface(this.ruptureSurface);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public GregorianCalendar getDate() {
        return this.date;
    }

    @Override
    public double getMag() {
        return this.mag;
    }

    public String getMagType() {
        return this.magType;
    }

    public double getMagUncertaintyKegan() {
        return this.magUncertaintyKegan;
    }

    public double getMagUncertaintyStatistical() {
        return this.magUncertaintyStatistical;
    }

    public double getMagUncertaintyStudyClass() {
        return this.magUncertaintyStudyClass;
    }

    public int getMagSampleSize() {
        return this.magSampleSize;
    }

    public double getMo() {
        return this.mo;
    }

    public FocalMechanism getFocalMech() {
        return this.focalMech;
    }

    public int getMechBasedOnRakeAngle() {
        return this.mechBasedOnRakeAngle;
    }

    public double getpPlungeDegrees() {
        return this.pPlungeDegrees;
    }

    public double getpTrendDegrees() {
        return this.pTrendDegrees;
    }

    public double gettPlungeDegrees() {
        return this.tPlungeDegrees;
    }

    public double gettTrendDegrees() {
        return this.tTrendDegrees;
    }

    public CoseismicSurfaceRupture getCoseismicSurfaceRupture() {
        return this.coseismicSurfaceRupture;
    }

    public String getSurfaceRuptureInferrenceBasis() {
        return this.surfaceRuptureInferrenceBasis;
    }

    public boolean isFiniteRuptureModel() {
        return this.finiteRuptureModel;
    }

    public double getDepthToTopOfFiniteRupture() {
        return this.depthToTopOfFiniteRupture;
    }

    public double getFiniteFaultRuptureLength() {
        return this.finiteFaultRuptureLength;
    }

    public double getFiniteFaultRuptureWidth() {
        return this.finiteFaultRuptureWidth;
    }

    public String toString() {
        return "NGAWestEqkRupture [id=" + this.id + "\tname=" + this.name + "\tdate=" + String.valueOf(this.date) + "\tmag=" + this.mag + "\tmagType=" + this.magType + "\tmagUncertaintyKegan=" + this.magUncertaintyKegan + "\tmagUncertaintyStatistical=" + this.magUncertaintyStatistical + "\tmagUncertaintyStudyClass=" + this.magUncertaintyStudyClass + "\tmagSampleSize=" + this.magSampleSize + "\tmo=" + this.mo + "\tfocalMech=" + String.valueOf(this.focalMech) + "\tmechBasedOnRakeAngle=" + this.mechBasedOnRakeAngle + "\tpPlungeDegrees=" + this.pPlungeDegrees + "\tpTrendDegrees=" + this.pTrendDegrees + "\ttPlungeDegrees=" + this.tPlungeDegrees + "\ttTrendDegrees=" + this.tTrendDegrees + "\thypocenter=" + String.valueOf(this.hypocenterLocation) + "\tcoseismicSurfaceRupture=" + String.valueOf((Object)this.coseismicSurfaceRupture) + "\tsurfaceRuptureInferrenceBasis=" + this.surfaceRuptureInferrenceBasis + "\tfiniteRuptureModel=" + this.finiteRuptureModel + "\tdepthToTopOfFiniteRupture=" + this.depthToTopOfFiniteRupture + "\tfiniteFaultRuptureLength=" + this.finiteFaultRuptureLength + "\tfiniteFaultRuptureWidth=" + this.finiteFaultRuptureWidth + "\tfiniteRuptureSurfaces=" + String.valueOf(this.ruptureSurface) + "]";
    }

    private static enum CoseismicSurfaceRupture {
        YES_KNOWN,
        YES_INFERRED,
        NO_KNOWN,
        NO_INFERRED,
        UNKNOWN;

    }
}

