/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.Frankel02;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.opensha.commons.calc.magScalingRelations.MagLengthRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WC1994_MagLengthRelationship;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.earthquake.PointSource;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.FrankelGriddedSurface;
import org.opensha.sha.faultSurface.GriddedSubsetSurface;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class Point2Vert_SS_FaultPoisSource
extends PointSource.PoissonPointSource
implements Serializable {
    private static String C = new String("Point2Vert_SS_FaultPoisSource");
    private boolean D = false;
    private IncrementalMagFreqDist magFreqDist;
    private static final double aveDip = 90.0;
    private static final double aveRake = 0.0;
    private MagLengthRelationship magLengthRelationship;
    private double magCutOff;
    private PointSurface ptSurface;
    private FrankelGriddedSurface finiteFault;

    public Point2Vert_SS_FaultPoisSource(Location loc, IncrementalMagFreqDist magFreqDist, MagLengthRelationship magLengthRelationship, double strike, double duration, double magCutOff) {
        super(loc, TECTONIC_REGION_TYPE_DEFAULT, duration, null, null);
        this.magCutOff = magCutOff;
        if (this.D) {
            System.out.println("magCutOff=" + magCutOff);
            System.out.println("num pts in magFreqDist=" + magFreqDist.size());
        }
        this.setAll(magFreqDist, magLengthRelationship, strike);
    }

    public Point2Vert_SS_FaultPoisSource(Location loc, IncrementalMagFreqDist magFreqDist, MagLengthRelationship magLengthRelationship, double duration, double magCutOff) {
        super(loc, TECTONIC_REGION_TYPE_DEFAULT, duration, null, null);
        this.magCutOff = magCutOff;
        this.setAll(magFreqDist, magLengthRelationship);
    }

    public void setAll(IncrementalMagFreqDist magFreqDist, MagLengthRelationship magLengthRelationship) {
        double strike = (Math.random() - 0.5) * 180.0;
        if (strike < 0.0) {
            strike += 360.0;
        }
        this.setAll(magFreqDist, magLengthRelationship, strike);
    }

    public void setAll(IncrementalMagFreqDist magFreqDist, MagLengthRelationship magLengthRelationship, double strike) {
        Location loc = this.getLocation();
        double duration = this.getDuration();
        this.magFreqDist = magFreqDist;
        this.magLengthRelationship = magLengthRelationship;
        if (this.D) {
            System.out.println("duration=" + duration);
        }
        if (this.D) {
            System.out.println("strike=" + strike);
        }
        this.ptSurface = new PointSurface(loc);
        this.ptSurface.setAveDip(90.0);
        this.ptSurface.setAveStrike(strike);
        double maxMag = magFreqDist.getX(magFreqDist.size() - 1);
        if (maxMag > this.magCutOff) {
            double halfLength = magLengthRelationship.getMedianLength(maxMag) / 2.0;
            Location loc1 = LocationUtils.location(loc, new LocationVector(strike, halfLength, 0.0));
            LocationVector dir = LocationUtils.vector(loc1, loc);
            dir.setHorzDistance(dir.getHorzDistance() * 2.0);
            Location loc2 = LocationUtils.location(loc1, dir);
            FaultTrace fault = new FaultTrace("");
            fault.add(loc1);
            fault.add(loc2);
            this.finiteFault = new FrankelGriddedSurface(fault, 90.0, loc.getDepth(), loc.getDepth(), 1.0);
        }
        SurfaceGenerator surfGen = new SurfaceGenerator();
        this.setData(Point2Vert_SS_FaultPoisSource.dataForMFD(loc, magFreqDist, new FocalMechanism(strike, 90.0, 0.0), surfGen));
    }

    @Override
    public LocationList getAllSourceLocs() {
        if (this.finiteFault != null) {
            return this.finiteFault.getEvenlyDiscritizedListOfLocsOnSurface();
        }
        return this.ptSurface.getEvenlyDiscritizedListOfLocsOnSurface();
    }

    @Override
    public RuptureSurface getSourceSurface() {
        if (this.finiteFault != null) {
            return this.finiteFault;
        }
        return this.ptSurface;
    }

    @Override
    public String getName() {
        return C;
    }

    public static void main(String[] args) {
        Location loc = new Location(34.0, -118.0, 0.0);
        GutenbergRichterMagFreqDist dist = new GutenbergRichterMagFreqDist(5.0, 16, 0.2, 1.0E17, 0.9);
        WC1994_MagLengthRelationship wc_rel = new WC1994_MagLengthRelationship();
        Point2Vert_SS_FaultPoisSource src = new Point2Vert_SS_FaultPoisSource(loc, dist, wc_rel, 1.0, 6.0);
        System.out.println("num rups =" + src.getNumRuptures());
        System.out.println("Rupture mags and end locs:");
        for (int r = 0; r < src.getNumRuptures(); ++r) {
            ProbEqkRupture rup = src.getRupture(r);
            Location loc1 = rup.getRuptureSurface().getFirstLocOnUpperEdge();
            Location loc2 = rup.getRuptureSurface().getLastLocOnUpperEdge();
            double length = LocationUtils.horzDistance(loc1, loc2);
            double aveLat = (loc1.getLatitude() + loc2.getLatitude()) / 2.0;
            double aveLon = (loc1.getLongitude() + loc2.getLongitude()) / 2.0;
            System.out.println("\t" + (float)rup.getMag() + "\tlen1=" + (float)wc_rel.getMedianLength(rup.getMag()) + "\tlen2=" + (float)length + "\taveLat=" + (float)aveLat + "\taveLon=" + (float)aveLon);
        }
    }

    private class SurfaceGenerator
    implements PointSource.RuptureSurfaceBuilder {
        private SurfaceGenerator() {
        }

        @Override
        public int getNumSurfaces(double magnitude, FocalMechanism mech) {
            return 1;
        }

        @Override
        public RuptureSurface getSurface(Location sourceLoc, double magnitude, FocalMechanism mech, int surfaceIndex) {
            if (magnitude <= Point2Vert_SS_FaultPoisSource.this.magCutOff) {
                return Point2Vert_SS_FaultPoisSource.this.ptSurface;
            }
            if (magnitude == Point2Vert_SS_FaultPoisSource.this.magFreqDist.getMaxX()) {
                return Point2Vert_SS_FaultPoisSource.this.finiteFault;
            }
            double rupLen = Point2Vert_SS_FaultPoisSource.this.magLengthRelationship.getMedianLength(magnitude);
            double startPoint = (double)Point2Vert_SS_FaultPoisSource.this.finiteFault.getNumCols() / 2.0 - 0.5 - rupLen / 2.0;
            return new GriddedSubsetSurface(1, Math.round((float)rupLen + 1.0f), 0, Math.round((float)startPoint), Point2Vert_SS_FaultPoisSource.this.finiteFault);
        }

        @Override
        public double getSurfaceWeight(double magnitude, FocalMechanism mech, int surfaceIndex) {
            Preconditions.checkState((surfaceIndex == 0 ? 1 : 0) != 0);
            return 1.0;
        }

        @Override
        public boolean isSurfaceFinite(double magnitude, FocalMechanism mech, int surfaceIndex) {
            return magnitude > Point2Vert_SS_FaultPoisSource.this.magCutOff;
        }

        @Override
        public Location getHypocenter(Location sourceLoc, RuptureSurface rupSurface) {
            return null;
        }
    }
}

