/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.NSHMP_CEUS08;

import java.util.ArrayList;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.NSHMP_CEUS08.NSHMP_CEUS_SourceGenerator;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;

@Deprecated
public class NSHMP08_CEUS_ERF
extends AbstractERF {
    private static String C = new String("NSHMP08_CEUS_ERF");
    private boolean D = false;
    public static final String NAME = new String("USGS NSHMP (2008) CEUS ERF (unverified)");
    NSHMP_CEUS_SourceGenerator sourceGen;
    public static final String BACK_SEIS_RUP_NAME = new String("Treat Background Seismicity As");
    public static final String BACK_SEIS_RUP_POINT = new String("Point Sources");
    public static final String BACK_SEIS_RUP_RAND_STRIKE = new String("One Random Strike Fault");
    public static final String BACK_SEIS_RUP_CROSSHAIR;
    public static final String BACK_SEIS_RUP_DEFAULT;
    private StringParameter backSeisRupParam;
    int backSeisSourceType;
    double duration = 50.0;
    ArrayList<ProbEqkSource> charlestonSources;

    public NSHMP08_CEUS_ERF() {
        try {
            this.sourceGen = new NSHMP_CEUS_SourceGenerator();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.timeSpan = new TimeSpan("None", "Years");
        this.timeSpan.addParameterChangeListener(this);
        this.timeSpan.setDuration(this.duration);
        this.initAdjParams();
        this.backSeisRupParam.addParameterChangeListener(this);
        this.charlestonSources = new ArrayList();
    }

    private void initAdjParams() {
        ArrayList<String> backSeisRupStrings = new ArrayList<String>();
        backSeisRupStrings.add(BACK_SEIS_RUP_POINT);
        backSeisRupStrings.add(BACK_SEIS_RUP_RAND_STRIKE);
        backSeisRupStrings.add(BACK_SEIS_RUP_CROSSHAIR);
        this.backSeisRupParam = new StringParameter(BACK_SEIS_RUP_NAME, backSeisRupStrings, UCERF2.BACK_SEIS_RUP_DEFAULT);
        this.adjustableParams.addParameter(this.backSeisRupParam);
    }

    @Override
    public int getNumSources() {
        return this.sourceGen.getNumSources() + this.charlestonSources.size();
    }

    public ArrayList getSourceList() {
        ArrayList<ProbEqkSource> sources = new ArrayList<ProbEqkSource>();
        for (int i = 0; i < this.getNumSources(); ++i) {
            sources.add(this.getSource(i));
        }
        return sources;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void updateForecast() {
        if (this.parameterChangeFlag) {
            String srcType = (String)this.backSeisRupParam.getValue();
            if (srcType.equals(BACK_SEIS_RUP_POINT)) {
                this.backSeisSourceType = 0;
            }
            this.backSeisSourceType = srcType.equals(BACK_SEIS_RUP_CROSSHAIR) ? 1 : 2;
            this.duration = this.timeSpan.getDuration();
            this.parameterChangeFlag = false;
        }
        this.charlestonSources = this.sourceGen.getCharlestonSourceList(this.duration, this.backSeisSourceType);
    }

    @Override
    public ProbEqkSource getSource(int iSource) {
        if (iSource < this.sourceGen.getNumSources()) {
            if (this.backSeisSourceType == 0) {
                return this.sourceGen.getPointGriddedSource(iSource, this.duration);
            }
            if (this.backSeisSourceType == 1) {
                return this.sourceGen.getCrosshairGriddedSource(iSource, this.duration);
            }
            return this.sourceGen.getRandomStrikeGriddedSource(iSource, this.duration);
        }
        return this.charlestonSources.get(iSource - this.sourceGen.getNumSources());
    }

    public static void main(String[] args) {
        NSHMP08_CEUS_ERF erf = new NSHMP08_CEUS_ERF();
        erf.updateForecast();
        System.out.println(erf.getNumSources());
    }

    static {
        BACK_SEIS_RUP_DEFAULT = BACK_SEIS_RUP_CROSSHAIR = new String("Two perpendicular faults");
    }
}

